/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Blob;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.SoundManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public final class MMAPISoundImp {
    public Blob mDataBlob;
    public String mSoundFormat = new String();
    public Player mPlayer;

    public MMAPISoundImp() {
        this.mDataBlob = new Blob();
    }

    public final void OnSerialize(Package package_) {
        this.mDataBlob = this.mDataBlob.OnSerialize(package_);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void Prefetch() {
        if (this.mPlayer == null && !this.CreatePlayer()) {
            return;
        }
        SoundManager soundManager = SoundManager.Get();
        boolean bl = true;
        boolean bl2 = false;
        while (!bl2) {
            try {
                synchronized (soundManager) {
                    if (this.mPlayer.getState() == 300) return;
                    int n = soundManager.mImplementor.DeallocateOldestPrefetchedSound(bl, this.mSoundFormat);
                    if (n == -1) {
                        return;
                    }
                    this.mPlayer.prefetch();
                    soundManager.mImplementor.RegisterAsPrefetchedSound(this, n);
                }
            }
            catch (Throwable throwable) {
                bl = false;
                continue;
            }
            break;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void Deallocate() {
        try {
            SoundManager soundManager = SoundManager.Get();
            synchronized (soundManager) {
                SoundManager.Get().mImplementor.UnRegisterAsPrefetchedSound(this);
                this.mPlayer.deallocate();
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void Close() {
        if (this.mPlayer == null) {
            return;
        }
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            SoundManager.Get().mImplementor.UnRegisterAsPrefetchedSound(this);
            try {
                this.mPlayer.close();
            }
            catch (Exception exception) {}
            this.mPlayer = null;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int GetPlayerState() {
        int n = 0;
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            if (this.mPlayer == null) return n;
            return this.mPlayer.getState();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void ResetSoundPlayer() {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            this.Close();
            this.CreatePlayer();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean CreatePlayer() {
        try {
            SoundManager soundManager = SoundManager.Get();
            synchronized (soundManager) {
                this.mPlayer = Manager.createPlayer((InputStream)new ByteArrayInputStream(this.mDataBlob.mData), (String)this.mSoundFormat);
                this.mPlayer.realize();
                return this.mPlayer != null;
            }
        }
        catch (Throwable throwable) {
            if (this.mPlayer != null) {
                this.mPlayer.close();
            }
            this.mPlayer = null;
        }
        return this.mPlayer != null;
    }

    public final boolean EvaluateSoundFormatSpec(byte by) {
        if (by == 1) {
            this.mSoundFormat.equals("audio/x-wav");
            this.mSoundFormat.equals("audio/midi");
            if (this.mSoundFormat.equals("audio/amr")) {
                // empty if block
            }
        } else if (by == 0) {
            this.mSoundFormat.equals("audio/x-wav");
            this.mSoundFormat.equals("audio/midi");
            this.mSoundFormat.equals("audio/amr");
        }
        return false;
    }
}

