/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseTipState;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.FileSegmentStream;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GameApp;

public final class GameTipState
extends BaseTipState {
    public int[] mState = new int[7];
    public int mCurrentPredicate = 6;

    public GameTipState() {
        for (int i = 0; i < this.mState.length; ++i) {
            this.mState[i] = -1;
        }
        this.Init();
    }

    private void Init() {
        this.mState[0] = 1;
        this.mState[1] = 1;
        this.mState[2] = 1;
        this.mState[3] = 1;
        this.mState[4] = 1;
        this.mState[5] = 1;
        this.mState[6] = -1;
        this.mCurrentPredicate = 6;
    }

    public final void Read(FileSegmentStream fileSegmentStream) {
        for (int i = 0; i < 7; ++i) {
            this.mState[i] = fileSegmentStream.ReadByte();
        }
        this.mCurrentPredicate = fileSegmentStream.ReadByte();
    }

    public final void Write(FileSegmentStream fileSegmentStream) {
        for (int i = 0; i < 7; ++i) {
            fileSegmentStream.WriteByte((byte)this.mState[i]);
        }
        fileSegmentStream.WriteByte((byte)this.mCurrentPredicate);
    }

    public final void OnFilesView() {
        this.SetPredicate(5);
    }

    public final void OnEnterRoom$13462e() {
        this.SetPredicate(4);
    }

    public final FlString GetNotification() {
        return ClueUtils.GetStringForGameTip(this.mCurrentPredicate, this.mState[this.mCurrentPredicate]);
    }

    public final void OnSearching$13462e() {
        this.SetPredicate(2);
    }

    public final boolean HasNotification() {
        return this.mCurrentPredicate != 6 && GameApp.Get().GetSettings().mIsGameTipsEnabled;
    }

    public final int GetId() {
        return 1;
    }

    public final void OnDisplayed() {
        if (this.mState[this.mCurrentPredicate] > 0) {
            int n;
            int n2 = this.mCurrentPredicate;
            this.mState[n2] = n = this.mState[n2] - 1;
        }
        this.mCurrentPredicate = 6;
    }

    public final void OnTalking$13462e() {
        this.SetPredicate(1);
    }

    public final void OnTravelling() {
        this.SetPredicate(3);
    }

    public final void OnCalling() {
        this.SetPredicate(0);
    }

    private void SetPredicate(int n) {
        if (this.mState[n] > 0) {
            this.mCurrentPredicate = n;
            return;
        }
        this.mCurrentPredicate = 6;
    }
}

