/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.FlBitmapMap;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_GameEntity;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.IndexedSprite;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Sprite;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public final class GE_NavTab
extends GE_GameEntity {
    public int mGrowingTimeAccumulator;
    public int mNavTabState = 2;
    public boolean[] mNavTabsLock = new boolean[3];
    public int mSelectedTab = 4;
    public boolean mActive = true;

    public final void Load() {
        super.Load();
        this.mPackage = GameLibrary.GetPackage(360459);
    }

    public final void Unload() {
        this.UnRegisterInGlobalTime();
        this.mNavTabsLock = null;
        super.Unload();
        GameLibrary.ReleasePackage(this.mPackage);
    }

    public final boolean IsLoaded() {
        return this.mPackage.IsLoaded();
    }

    public final void LockAccess() {
        this.SetAllTabsLock(true);
    }

    public final void OnTime(int n, int n2) {
        if (this.mNavTabState == 0 || this.mNavTabState == 1) {
            this.mGrowingTimeAccumulator += n2;
            n2 = this.mGrowingTimeAccumulator;
            if (this.mNavTabState == 1) {
                n2 = 300 - n2;
            }
            if (this.mGrowingTimeAccumulator > 300) {
                n2 = this.mNavTabState == 1 ? 0 : 300;
                this.UnRegisterInGlobalTime();
                this.mNavTabState = 2;
            }
            n = Constants.navTabMinimizedViewportHeightFct();
            n2 = n + n2 * (Constants.navTabMaximizedViewportHeightFct() - n) / 300;
            n = (short)(Constants.navTabMinimizedViewportTopFct() - (n2 - n));
            this.mComponentViewport.SetTopLeft(this.mComponentViewport.mRect_left, (short)n);
            this.mComponentViewport.SetSize(this.mComponentViewport.mRect_width, (short)n2);
            n = this.mComponentViewport.mRect_width;
            this.mComponentViewport.GetChild(0).SetRect((short)0, (short)0, (short)n, (short)n2);
        }
    }

    public final void SetVisible(boolean bl) {
        this.mComponentViewport.SetVisible(bl);
        this.SetActive(bl);
    }

    public final void BringToFront() {
        this.mComponentViewport.BringToFront();
    }

    public final void Init(Viewport viewport, int n) {
        super.Init(viewport);
        this.SelectNavTab(n);
        n = n != 4 ? 1 : 0;
        this.UpdatePositionAndSize(n != 0);
    }

    public final void StartMaximizingAnimation() {
        this.mNavTabState = 0;
        this.mGrowingTimeAccumulator = 0;
        this.RegisterInGlobalTime();
    }

    public final boolean IsMaximizingAnimationEnded() {
        return this.mNavTabState == 2;
    }

    public final void StartMinimizingAnimation() {
        this.mNavTabState = 1;
        this.mGrowingTimeAccumulator = 0;
        this.RegisterInGlobalTime();
    }

    public GE_NavTab(BaseScene baseScene) {
        super(baseScene);
        for (int i = 0; i < this.mNavTabsLock.length; ++i) {
            this.mNavTabsLock[i] = false;
        }
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        this.mComponentViewport = Viewport.Cast$7c352e71(this.mPackage.mPackage.GetEntryPoint(0));
    }

    public final boolean IsMinimizingAnimationEnded() {
        return this.mNavTabState == 2;
    }

    public final void SelectNavTab(int n) {
        this.mSelectedTab = n;
        this.SetAllTabsBitmapsAndCommand(n);
    }

    public final void SetTabLock(int n, boolean bl) {
        this.mNavTabsLock[n] = bl;
        this.SetTabLockProperties(n);
    }

    private Selection GetSelectionForTab(int n) {
        return (Selection)((Viewport)this.mComponentViewport.GetChild(1)).GetChild(GE_NavTab.GetTabIndex(n));
    }

    private void UpdatePositionAndSize(boolean bl) {
        if (bl) {
            this.mComponentViewport.SetTopLeft(this.mComponentViewport.mRect_left, (short)Constants.navTabMaximizedViewportTopFct());
            this.mComponentViewport.SetSize(this.mComponentViewport.mRect_width, (short)Constants.navTabMaximizedViewportHeightFct());
            return;
        }
        this.mComponentViewport.SetTopLeft(this.mComponentViewport.mRect_left, (short)Constants.navTabMinimizedViewportTopFct());
        this.mComponentViewport.SetSize(this.mComponentViewport.mRect_width, (short)Constants.navTabMinimizedViewportHeightFct());
    }

    private void SetAllTabsLock(boolean bl) {
        for (int i = 0; i < 3; ++i) {
            this.SetTabLock(i, bl);
        }
    }

    private void SetTabLockProperties(int n) {
        this.SetTabBitmaps(n, this.mSelectedTab);
        Selection selection = (Selection)((Viewport)this.mComponentViewport.GetChild(1)).GetChild(GE_NavTab.GetTabIndex(n));
        selection.mPassThrough = this.mNavTabsLock[n];
        int n2 = 0;
        if (n == 0) {
            n2 = -1;
        } else if (n == 2) {
            n2 = -1;
        }
        Text text = (Text)selection.GetChild(3 + n2);
        Object object = (Sprite)selection.GetChild(3 + n2 + 1);
        boolean bl = !this.mNavTabsLock[n];
        ((Component)object).SetVisible(bl);
        object = new FlString();
        if (this.mNavTabsLock[n]) {
            ((FlString)object).Assign(StringUtils.CreateString("?"));
        } else {
            ((FlString)object).Assign(StringUtils.CreateString(" "));
        }
        Utilities.Trunc(text, (FlString)object, Vector2_short.GetX_(text.GetSize()));
    }

    public final void SetActive(boolean bl) {
        this.mActive = bl;
        for (int i = 0; i < 3; ++i) {
            this.GetSelectionForTab(i).SetEnabledState(bl);
        }
    }

    private void SetTabBitmaps(int n, int n2) {
        int n3 = 3;
        if (!this.mNavTabsLock[n]) {
            if (n2 == 4) {
                n3 = 1;
            } else if (n == n2) {
                n3 = 2;
            }
        }
        FlBitmapMap flBitmapMap = FlBitmapMap.Cast$4864501b(this.mPackage.mPackage.GetEntryPoint(n3));
        Selection selection = this.GetSelectionForTab(n);
        n2 = n == 1 ? 3 : 2;
        for (n = 0; n < n2; ++n) {
            ((IndexedSprite)selection.GetChild(n)).SetBitmapMap(flBitmapMap);
        }
    }

    public final boolean OnKeyUp(int n) {
        if (this.mActive) {
            switch (n) {
                case 49: 
                case 50: 
                case 51: {
                    if (!this.mNavTabsLock[n -= 49]) {
                        this.mBaseScene.OnCommand(this.GetSelectionForTab((int)n).mCommand);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private void SetAllTabsBitmapsAndCommand(int n) {
        for (int i = 0; i < 3; ++i) {
            this.SetTabBitmaps(i, n);
            this.SetTabsCommand(i, n);
        }
    }

    private void SetTabsCommand(int n, int n2) {
        n2 = n != n2 ? (n2 == 4 ? (n == 0 ? 18 : (n == 1 ? 19 : 20)) : (n == 0 ? 22 : (n == 1 ? 23 : 24))) : -60;
        this.GetSelectionForTab((int)n).mCommand = (byte)n2;
    }

    private static int GetTabIndex(int n) {
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
            }
        }
        return n2;
    }
}

