/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.Color888;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.FlBitmap;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_Map;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.KeyFrameController;
import ca.jamdat.flight.Mansion;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.ScenarioContext;
import ca.jamdat.flight.Shape;
import ca.jamdat.flight.Sprite;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Viewport;

public final class GE_MapMovement
extends GE_Map {
    public FlBitmap mBitmapTravelMapUnvisited;
    public Sprite[] mArrows = null;
    public Text mTextRoom;
    public Text mTextMoveTo;
    public Sprite mSpriteInfoSuspect;
    public int mValidSelectedRoomID = -1;
    public FlFont mFontTextRoomUnknown;
    public Viewport[] mViewportRoom = null;
    public Shape[] mShapeWay = null;
    public Sprite mSpriteBubble;
    public FlFont mFontTextRoomCross;
    public short[] mColorVisitedRoomSelected;
    public int mNumberShapeWay;
    public Viewport mViewportCropSuspect;
    public Sprite mSpriteNoEntry;
    public TimeSystem mSuspectSpeechBubbleTimeSystem;
    public Shape mShapeSuspect;
    public TimeSystem mMapAnimationTimeSystem;
    public Viewport mViewportInfo;
    public Text[] mTextInfoRoom = null;
    public FlBitmap mBitmapTravelMapUnvisitedCursor;
    public MetaPackage mFontPackage;
    public Sprite[] mSpriteRoom = null;
    public Viewport mViewportAnimationSuspect;

    public final void EndOpeningAnims() {
        this.UpdateInformation();
        this.mMapViewport.SetVisible(true);
        this.mTextMoveTo.SetVisible(true);
        this.BlinkSpeechBubble(GameApp.Get().GetScenarioContext().CanTalk(this.mCurrentSelectedRoom));
        Utilities.StopTimeSystem(this.mMapAnimationTimeSystem);
    }

    public final boolean IsSelectedRoomIDValid() {
        return this.mValidSelectedRoomID == this.mCurrentSelectedRoom;
    }

    private static short GetMapPartingHallSize() {
        return (short)Constants.geMapPartingHallSmallSizeFct();
    }

    private static short GetMapSelectorSize() {
        return (short)Constants.geMapSelectorSmallSizeFct();
    }

    private void GetInformationRoom() {
        this.mViewportInfo = Viewport.Cast$7c352e71(this.mPackage.mPackage.GetEntryPoint(17));
        this.mTextMoveTo = Text.Cast$21bacd23(this.mPackage.mPackage.GetEntryPoint(18));
        this.mTextRoom = Text.Cast$21bacd23(this.mPackage.mPackage.GetEntryPoint(19));
        this.mShapeSuspect = Shape.Cast$2392dbe5(this.mPackage.mPackage.GetEntryPoint(20));
        this.mViewportCropSuspect = Viewport.Cast$7c352e71(this.mPackage.mPackage.GetEntryPoint(21));
        this.mViewportAnimationSuspect = Viewport.Cast$7c352e71(this.mPackage.mPackage.GetEntryPoint(22));
        this.mSpriteBubble = Sprite.Cast$46e644cd(this.mPackage.mPackage.GetEntryPoint(23));
    }

    private void DrawArrow(int n, int n2, int n3, int n4) {
        int n5 = 1;
        short s = 0;
        short s2 = 0;
        if (n3 == n) {
            if (n4 < n2) {
                n5 = 1;
                s2 = -this.GetTileHeight();
            } else {
                n5 = 3;
                s2 = this.GetTileHeight();
            }
        } else if (n4 == n2) {
            if (n3 < n) {
                n5 = 0;
                s = -this.GetTileWidth();
            } else {
                n5 = 2;
                s = this.GetTileWidth();
            }
        }
        this.mArrows[n5].SetViewport(this.mViewportCompleteMap);
        this.mArrows[n5].SetTopLeft((short)(n3 * this.GetTileWidth() + this.mOffsetX + (this.GetTileWidth() - this.mArrows[n5].mRect_width + s) / 2 - this.mArrows[n5].mRect_width % 2), (short)(n4 * this.GetTileHeight() + this.mOffsetY + (this.GetTileHeight() - this.mArrows[n5].mRect_height + s2) / 2 - this.mArrows[n5].mRect_height % 2));
    }

    private void CreatePath(int n, int n2, int n3, int n4) {
        this.mShapeWay[this.mNumberShapeWay] = new Shape();
        this.mShapeWay[this.mNumberShapeWay].SetViewport(this.mViewportCompleteMap);
        int n5 = Constants.geMapArrowWidthFct();
        int n6 = Constants.geMapArrowHeightFct();
        if (n == n3) {
            Shape shape = this.mShapeWay[this.mNumberShapeWay];
            n = (short)(n * this.GetTileWidth() + this.mOffsetX + (this.GetTileWidth() - n5) / 2);
            int n7 = n2 < n4 ? n2 : n4;
            shape.SetTopLeft((short)n, (short)(n7 * this.GetTileHeight() + this.mOffsetY + (this.GetTileHeight() - n6) / 2));
            this.mShapeWay[this.mNumberShapeWay].SetSize((short)n5, (short)(FlMath.Absolute(n4 - n2) * this.GetTileHeight() + n6));
        } else if (n2 == n4) {
            Shape shape = this.mShapeWay[this.mNumberShapeWay];
            n4 = n < n3 ? n : n3;
            shape.SetTopLeft((short)(n4 * this.GetTileWidth() + this.mOffsetX + (this.GetTileWidth() - n5) / 2), (short)(n2 * this.GetTileHeight() + this.mOffsetY + (this.GetTileHeight() - n6) / 2));
            this.mShapeWay[this.mNumberShapeWay].SetSize((short)(FlMath.Absolute(n3 - n) * this.GetTileWidth() + n5), (short)n6);
        }
        this.mShapeWay[this.mNumberShapeWay].SetColor(Color888.c_init_iii(0, 0, 0));
        ++this.mNumberShapeWay;
    }

    private void ResetShapeWay() {
        int n;
        if (this.mShapeWay != null) {
            for (n = 0; n < this.mCurrentMansion.mWidth * this.mCurrentMansion.mHeight; ++n) {
                if (this.mShapeWay[n] != null) {
                    this.mShapeWay[n].SetViewport(null);
                    this.mShapeWay[n] = null;
                }
                this.mNumberShapeWay = 0;
            }
        }
        if (this.mArrows != null) {
            for (n = 0; n < 4; ++n) {
                if (this.mArrows[n] == null) continue;
                this.mArrows[n].SetViewport(null);
            }
        }
    }

    public GE_MapMovement(BaseScene baseScene, Mansion mansion) {
        super(baseScene, mansion);
    }

    private void UpdateInformation() {
        if (this.mCurrentSelectedRoom > -1 && this.mCurrentSelectedRoom < 12) {
            FlString flString = new FlString(ClueUtils.GetStringForRoom(this.mCurrentSelectedRoom));
            Utilities.Trunc(flString, this.mTextRoom.m_pViewport.mRect_width, this.mTextRoom.mFont);
            this.mTextRoom.SetCaption(flString);
            this.UpdateItemsList(GameApp.Get().GetScenarioContext().IsRoomVisited(this.mCurrentSelectedRoom));
            this.mTextMoveTo.SetVisible(true);
            if (GameApp.Get().GetScenarioContext().IsRoomVisited(this.mCurrentSelectedRoom)) {
                int n = GameApp.Get().GetScenarioContext().GetSuspectInRoom(this.mCurrentSelectedRoom);
                if (n != -1 && n != 6) {
                    short[] sArray = Color888.Cast$4e210a13(this.mPackage.mPackage.GetEntryPoint(25 + n));
                    this.mShapeSuspect.SetVisible(true);
                    this.mShapeSuspect.SetColor(sArray);
                    this.mSpriteInfoSuspect.SetBitmap(this.mCharactersIcons.GetCharacterBitmap(n, 0));
                    this.mSpriteInfoSuspect.SetVisible(true);
                    this.mSpriteInfoSuspect.SetTopLeft((short)(this.mViewportAnimationSuspect.mRect_left - this.mViewportCropSuspect.mRect_left + (this.mViewportAnimationSuspect.mRect_width - this.mSpriteInfoSuspect.mRect_width) / 2), (short)(this.mViewportAnimationSuspect.mRect_top - this.mViewportCropSuspect.mRect_top));
                    this.BlinkSpeechBubble(GameApp.Get().GetScenarioContext().CanTalk(this.mCurrentSelectedRoom));
                    return;
                }
                this.mSpriteInfoSuspect.SetVisible(false);
                this.mShapeSuspect.SetVisible(false);
                this.BlinkSpeechBubble(false);
                return;
            }
            if (!this.IsSelectedRoomIDValid()) {
                this.mTextMoveTo.SetVisible(false);
            }
            this.mSpriteInfoSuspect.SetVisible(false);
            this.mShapeSuspect.SetVisible(false);
            this.BlinkSpeechBubble(false);
        }
    }

    private void UpdateItemsList(boolean bl) {
        for (int i = 0; i < 5; ++i) {
            FlString flString = new FlString();
            if (bl) {
                flString = GameApp.Get().GetScenarioContext().GetStringItemRoom(this.mCurrentSelectedRoom, i);
            }
            Text text = Text.Cast$21bacd23(this.mPackage.mPackage.GetEntryPoint(12 + i));
            int n = 47;
            if (GameApp.Get().GetScenarioContext().IsItemInSelectedRoomSearched(this.mCurrentSelectedRoom, i)) {
                n = 48;
            }
            text.SetFont(FlFont.Cast$be01453(this.mPackage.mPackage.GetEntryPoint(n)));
            FlString flString2 = new FlString(flString);
            short s = text.m_pViewport.mRect_width;
            Utilities.Trunc(flString2, s, text.mFont);
            text.SetCaption(flString2);
        }
    }

    private void BlinkSpeechBubble(boolean bl) {
        if (bl) {
            KeyFrameController.Cast$62806029(this.mPackage.mPackage.GetEntryPoint(46)).SetControllee(this.mSpriteBubble);
            Utilities.StartTimeSystem(this.mSuspectSpeechBubbleTimeSystem);
            return;
        }
        this.mSuspectSpeechBubbleTimeSystem.mTotalTime = 0;
        Utilities.StopTimeSystem(this.mSuspectSpeechBubbleTimeSystem);
        this.mSpriteBubble.SetVisible(false);
    }

    public final void SetVisible(boolean bl) {
        super.SetVisible(bl);
        this.mViewportInfo.SetVisible(bl);
    }

    public final void SelectRoom(int n) {
        super.SelectRoom(n);
        this.ResetShapeWay();
        int n2 = 0;
        if (this.mSpriteNoEntry != null) {
            this.mSpriteNoEntry.SetViewport(null);
        }
        if (GameApp.Get().GetScenarioContext().GetCurrentRoom().mRoomId != n) {
            int[] nArray = this.mCurrentMansion.FindShortestPath(GameApp.Get().GetScenarioContext().GetCurrentRoom().mRoomId, n);
            while (nArray[n2] != 1000) {
                ++n2;
            }
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = n2;
            ScenarioContext scenarioContext = GameApp.Get().GetScenarioContext();
            this.mValidSelectedRoomID = nArray[n2 - 1];
            do {
                int n8 = --n7 == 0 ? n : nArray[n7 - 1];
                n2 = n8;
                n8 = nArray[n7];
                if (this.mValidSelectedRoomID == n8 && (!this.IsViewportRoomExists(n8) || scenarioContext.IsRoomVisited(n8))) {
                    this.mValidSelectedRoomID = !this.IsViewportRoomExists(n2) || n2 == this.mCurrentSelectedRoom || scenarioContext.IsRoomVisited(n2) ? n2 : n8;
                }
                int n9 = n3;
                int n10 = n4;
                n3 = this.mCurrentMansion.GetDoorCoordinateX(n8, n2);
                n4 = this.mCurrentMansion.GetDoorCoordinateY(n8, n2);
                if ((n3 != n5 || n4 != n6) && n3 != -1 && n4 != -1 && n5 != -1 && n6 != -1) {
                    if (n3 != n5 && n4 != n6) {
                        if (n9 == n5 && n10 > n6 || n9 == n5 && n10 < n6) {
                            this.CreatePath(n3, n4, n5, n4);
                            this.CreatePath(n5, n6, n5, n4);
                        } else {
                            this.CreatePath(n3, n4, n3, n6);
                            this.CreatePath(n5, n6, n3, n6);
                        }
                    } else if (n3 != n5 || n4 != n6) {
                        this.CreatePath(n3, n4, n5, n6);
                    }
                }
                n5 = this.mCurrentMansion.GetDoorCoordinateX(n2, n8);
                n6 = this.mCurrentMansion.GetDoorCoordinateY(n2, n8);
                this.CreatePath(n3, n4, n5, n6);
                if (n7 != 0) continue;
                this.DrawArrow(n3, n4, n5, n6);
            } while (n7 > 0);
            if (this.IsSelectedRoomIDValid()) {
                this.mSpriteNoEntry.SetViewport(null);
            } else {
                this.mSpriteNoEntry.SetViewport(this.mViewportRoom[this.mCurrentSelectedRoom]);
                this.mSpriteNoEntry.SetVisible(true);
                this.mSpriteNoEntry.SetTopLeft((short)((this.mViewportRoom[this.mCurrentSelectedRoom].mRect_width - this.mSpriteNoEntry.mRect_width) / 2), (short)((this.mViewportRoom[this.mCurrentSelectedRoom].mRect_height - this.mSpriteNoEntry.mRect_height) / 2));
            }
        }
        this.UpdateInformation();
    }

    public final void OnSelectedRoom() {
        this.mBaseScene.OnCommand(37);
    }

    public final short GetMapDoorsLength() {
        return (short)Constants.geMapDoorsLengthSmallFct();
    }

    public final short GetMapDoorsLarge() {
        return (short)Constants.geMapDoorsLargeSmallFct();
    }

    public final short GetMapWallSize() {
        return (short)Constants.geMapWallSmallSizeFct();
    }

    public final short GetMapSelectorInternalSize() {
        return (short)Constants.geMapSelectorInternalSmallSizeFct();
    }

    public final short GetTileWidth() {
        return (short)Constants.geMapTileSmallSizeXFct();
    }

    public final short GetTileHeight() {
        return (short)Constants.geMapTileSmallSizeYFct();
    }

    public final short GetMapMarginWidth() {
        return 0;
    }

    public final boolean IsViewportRoomExists(int n) {
        return n >= 0 && this.mViewportRoom[n] != null;
    }

    public final void InitViewportRoom(int n) {
        this.mViewportRoom[n] = new Viewport();
        this.mViewportRoom[n].SetViewport(this.mViewportCompleteMap);
    }

    public final void CreateViewportRoom(int n, int n2, int n3, int n4, int n5) {
        if (this.IsViewportRoomExists(n)) {
            this.mViewportRoom[n].SetTopLeft((short)(n2 * this.GetTileWidth() + this.mOffsetX), (short)(n3 * this.GetTileHeight() + this.mOffsetY));
            this.mViewportRoom[n].SetSize((short)((n4 - n2 + 1) * this.GetTileWidth()), (short)((n5 - n3 + 1) * this.GetTileHeight()));
            if (!GameApp.Get().GetScenarioContext().IsRoomVisited(n) || n == GameApp.Get().GetScenarioContext().GetCurrentRoom().mRoomId) {
                FlString flString;
                this.mTextInfoRoom[n] = new Text();
                this.mTextInfoRoom[n].SetViewport(this.mViewportRoom[n]);
                if (n == GameApp.Get().GetScenarioContext().GetCurrentRoom().mRoomId) {
                    this.mTextInfoRoom[n].SetFont(this.mFontTextRoomCross);
                    flString = ClueUtils.GetGameString(139);
                    this.mCurrentMansion.UnLockRoom(n);
                } else {
                    this.mTextInfoRoom[n].SetFont(this.mFontTextRoomUnknown);
                    flString = StringUtils.CreateStringPtr("?");
                    this.mCurrentMansion.LockRoom(n);
                }
                n5 = this.mFontTextRoomUnknown.GetLineWidth(flString);
                this.mTextInfoRoom[n].SetCaption(flString);
                this.mTextInfoRoom[n].SetTopLeft((short)((this.mViewportRoom[n].mRect_width - n5) / 2), (short)((this.mViewportRoom[n].mRect_height - this.mFontTextRoomUnknown.GetLineHeight()) / 2));
                this.mTextInfoRoom[n].SetSize((short)n5, (short)this.mFontTextRoomUnknown.GetLineHeight());
                return;
            }
            this.mCurrentMansion.UnLockRoom(n);
        }
    }

    public final void BringToFrontViewportRoom() {
        for (int i = 0; i < 12; ++i) {
            if (!this.IsViewportRoomExists(i)) continue;
            this.mViewportRoom[i].BringToFront();
        }
    }

    public final void SelectionFill(int n) {
        for (int i = 0; i < this.mCurrentMansion.mHeight; ++i) {
            for (int j = 0; j < this.mCurrentMansion.mWidth; ++j) {
                if (!this.IsViewportRoomExists(this.mCurrentMansion.GetRoomId(j, i))) continue;
                int n2 = j + this.mCurrentMansion.mWidth * i;
                if (this.IsSameRoom(j, i, n)) {
                    if (!GameApp.Get().GetScenarioContext().IsRoomVisited(n)) {
                        this.mSpriteRoom[n2].SetBitmap(this.mBitmapTravelMapUnvisitedCursor);
                        this.mSpriteRoom[n2].SetVisible(true);
                        this.mMapRooms[n2].SetVisible(false);
                        continue;
                    }
                    this.mSpriteRoom[n2].SetVisible(false);
                    this.mMapRooms[n2].SetColor(this.mColorVisitedRoomSelected);
                    this.mMapRooms[n2].SetVisible(true);
                    continue;
                }
                if (!GameApp.Get().GetScenarioContext().IsRoomVisited(this.mCurrentMansion.GetRoomId(j, i))) {
                    this.mSpriteRoom[n2].SetBitmap(this.mBitmapTravelMapUnvisited);
                    this.mSpriteRoom[n2].SetVisible(true);
                    this.mMapRooms[n2].SetVisible(false);
                    continue;
                }
                this.mSpriteRoom[n2].SetVisible(false);
                this.mMapRooms[n2].SetColor(Color888.c_init_iii(255, 255, 255));
                this.mMapRooms[n2].SetVisible(true);
            }
        }
    }

    public final void SelectionUnderline(int n, int n2, int n3) {
        switch (n3) {
            case 2: {
                this.CreateSelectedShape(this.mViewportCompleteMap, (short)(n * this.GetTileWidth() + this.mOffsetX - GE_MapMovement.GetMapSelectorSize() / 2), (short)(n2 * this.GetTileHeight() + this.mOffsetY - GE_MapMovement.GetMapSelectorSize() / 2), GE_MapMovement.GetMapSelectorSize(), (short)(this.GetTileHeight() + GE_MapMovement.GetMapSelectorSize()), Color888.c_init_iii(0, 0, 0));
                return;
            }
            case 3: {
                this.CreateSelectedShape(this.mViewportCompleteMap, (short)(n * this.GetTileWidth() + this.mOffsetX + this.GetTileWidth() - GE_MapMovement.GetMapSelectorSize() / 2), (short)(n2 * this.GetTileHeight() + this.mOffsetY - GE_MapMovement.GetMapSelectorSize() / 2), GE_MapMovement.GetMapSelectorSize(), (short)(this.GetTileHeight() + GE_MapMovement.GetMapSelectorSize()), Color888.c_init_iii(0, 0, 0));
                return;
            }
            case 0: {
                this.CreateSelectedShape(this.mViewportCompleteMap, (short)(n * this.GetTileWidth() + this.mOffsetX - GE_MapMovement.GetMapSelectorSize() / 2), (short)(n2 * this.GetTileHeight() + this.mOffsetY - GE_MapMovement.GetMapSelectorSize() / 2), (short)(this.GetTileWidth() + GE_MapMovement.GetMapSelectorSize()), GE_MapMovement.GetMapSelectorSize(), Color888.c_init_iii(0, 0, 0));
                return;
            }
            case 1: {
                this.CreateSelectedShape(this.mViewportCompleteMap, (short)(n * this.GetTileWidth() + this.mOffsetX - GE_MapMovement.GetMapSelectorSize() / 2), (short)(n2 * this.GetTileHeight() + this.mOffsetY + this.GetTileHeight() - GE_MapMovement.GetMapSelectorSize() / 2), (short)(this.GetTileWidth() + GE_MapMovement.GetMapSelectorSize()), GE_MapMovement.GetMapSelectorSize(), Color888.c_init_iii(0, 0, 0));
            }
        }
    }

    public final void SelectionBringToFront(int n) {
        for (n = 1; n < this.mCurrentSelectedShape; n += 2) {
            this.mMapSelectedRooms[n].BringToFront();
        }
    }

    public final void CreateRoomTile(int n, int n2, int n3) {
        int n4 = n + this.mCurrentMansion.mWidth * n2;
        this.CreateRoomShape(n, n2);
        if (!this.mCurrentMansion.IsInHall(n, n2)) {
            this.mMapRooms[n4].SetColor(Color888.c_init_iii(255, 255, 255));
            this.mSpriteRoom[n4] = new Sprite();
            this.mSpriteRoom[n4].SetViewport(this.mViewportCompleteMap);
            this.mSpriteRoom[n4].SetTopLeft((short)(n * this.GetTileWidth() + this.mOffsetX), (short)(n2 * this.GetTileHeight() + this.mOffsetY));
            this.mSpriteRoom[n4].SetSize(this.GetTileWidth(), this.GetTileHeight());
            this.mSpriteRoom[n4].SetTileableXY(true);
            this.mSpriteRoom[n4].SetBitmap(this.mBitmapTravelMapUnvisited);
            return;
        }
        this.mMapRooms[n4].SetColor(this.mRooms[n3].mColor);
    }

    public final void CreateHallSeparationHorizontal(int n, int n2, int n3) {
        if (n2 < this.mCurrentMansion.mHeight && this.mCurrentMansion.IsInHall(n, n2) && this.mCurrentMansion.IsInHall(n, n2 - 1) && !this.IsSameRoom(n, n2 - 1, n3)) {
            this.mMapBorderRooms[this.mCurrentBorderRooms] = new Shape();
            this.mMapBorderRooms[this.mCurrentBorderRooms].SetViewport(this.mViewportCompleteMap);
            this.mMapBorderRooms[this.mCurrentBorderRooms].SetTopLeft((short)(n * this.GetTileWidth() - GE_MapMovement.GetMapPartingHallSize() / 2 + this.mOffsetX), (short)(n2 * this.GetTileHeight() - GE_MapMovement.GetMapPartingHallSize() / 2 + this.mOffsetY));
            this.mMapBorderRooms[this.mCurrentBorderRooms].SetSize((short)(this.GetTileWidth() + GE_MapMovement.GetMapPartingHallSize()), GE_MapMovement.GetMapPartingHallSize());
            this.mMapBorderRooms[this.mCurrentBorderRooms].SetColor(Color888.c_init_iii(64, 64, 64));
            ++this.mCurrentBorderRooms;
        }
    }

    public final void CreateHallSeparationVertical(int n, int n2, int n3) {
        if (n2 < this.mCurrentMansion.mHeight && n + 1 < this.mCurrentMansion.mWidth && this.mCurrentMansion.IsInHall(n, n2) && this.mCurrentMansion.IsInHall(n + 1, n2) && !this.IsSameRoom(n + 1, n2, n3)) {
            this.mMapBorderRooms[this.mCurrentBorderRooms] = new Shape();
            this.mMapBorderRooms[this.mCurrentBorderRooms].SetViewport(this.mViewportCompleteMap);
            this.mMapBorderRooms[this.mCurrentBorderRooms].SetTopLeft((short)((n + 1) * this.GetTileWidth() - GE_MapMovement.GetMapPartingHallSize() / 2 + this.mOffsetX), (short)(n2 * this.GetTileHeight() + GE_MapMovement.GetMapPartingHallSize() / 2 + GE_MapMovement.GetMapPartingHallSize() % 2 + this.mOffsetY));
            this.mMapBorderRooms[this.mCurrentBorderRooms].SetSize(GE_MapMovement.GetMapPartingHallSize(), (short)(this.GetTileHeight() + GE_MapMovement.GetMapPartingHallSize()));
            this.mMapBorderRooms[this.mCurrentBorderRooms].SetColor(Color888.c_init_iii(64, 64, 64));
            ++this.mCurrentBorderRooms;
        }
    }

    public final void Load() {
        int n;
        super.Load();
        this.mFontPackage = GameLibrary.GetPackage(5472423);
        int n2 = this.mCurrentMansion.mWidth * this.mCurrentMansion.mHeight;
        this.mMapRooms = new Shape[n2];
        for (n = 0; n < this.mMapRooms.length; ++n) {
            this.mMapRooms[n] = null;
        }
        this.mViewportRoom = new Viewport[12];
        for (n = 0; n < this.mViewportRoom.length; ++n) {
            this.mViewportRoom[n] = null;
        }
        this.mTextInfoRoom = new Text[12];
        for (n = 0; n < this.mTextInfoRoom.length; ++n) {
            this.mTextInfoRoom[n] = null;
        }
        this.mSpriteRoom = new Sprite[n2];
        for (n = 0; n < this.mSpriteRoom.length; ++n) {
            this.mSpriteRoom[n] = null;
        }
        this.mShapeWay = new Shape[n2];
        for (n = 0; n < this.mShapeWay.length; ++n) {
            this.mShapeWay[n] = null;
        }
        this.mArrows = new Sprite[4];
        for (n = 0; n < this.mArrows.length; ++n) {
            this.mArrows[n] = null;
        }
    }

    public final void Unload() {
        int n;
        Utilities.StopTimeSystem(this.mMapAnimationTimeSystem);
        Utilities.StopTimeSystem(this.mSuspectSpeechBubbleTimeSystem);
        if (this.mSpriteInfoSuspect != null) {
            this.mSpriteInfoSuspect.SetViewport(null);
            this.mSpriteInfoSuspect = null;
        }
        if (this.mViewportInfo != null) {
            this.mViewportInfo.SetViewport(null);
            this.mViewportInfo = null;
        }
        if (this.mSpriteNoEntry != null) {
            this.mSpriteNoEntry.SetViewport(null);
            this.mSpriteNoEntry = null;
        }
        for (n = 0; n < this.mCurrentMansion.mWidth * this.mCurrentMansion.mHeight; ++n) {
            if (this.mMapRooms != null && this.mMapRooms[n] != null) {
                this.mMapRooms[n].SetViewport(null);
                this.mMapRooms[n] = null;
            }
            if (this.mSpriteRoom == null || this.mSpriteRoom[n] == null) continue;
            this.mSpriteRoom[n].SetViewport(null);
            this.mSpriteRoom[n].SetBitmap(null);
            this.mSpriteRoom[n] = null;
        }
        if (this.mShapeWay != null) {
            for (n = 0; n < this.mCurrentMansion.mWidth * this.mCurrentMansion.mHeight; ++n) {
                if (this.mShapeWay[n] != null) {
                    this.mShapeWay[n].SetViewport(null);
                    this.mShapeWay[n] = null;
                }
                this.mNumberShapeWay = 0;
            }
        }
        if (this.mArrows != null) {
            for (n = 0; n < 4; ++n) {
                if (this.mArrows[n] == null) continue;
                this.mArrows[n].SetViewport(null);
                this.mArrows[n] = null;
            }
            this.mArrows = null;
        }
        for (n = 0; n < 12; ++n) {
            if (this.mTextInfoRoom != null && this.mTextInfoRoom[n] != null) {
                this.mTextInfoRoom[n].SetViewport(null);
                this.mTextInfoRoom[n] = null;
            }
            if (this.mViewportRoom == null || this.mViewportRoom[n] == null) continue;
            this.mViewportRoom[n].SetViewport(null);
            this.mViewportRoom[n] = null;
        }
        for (n = 0; n < 5; ++n) {
            Text.Cast$21bacd23(this.mPackage.mPackage.GetEntryPoint(12 + n)).SetFont(FlFont.Cast$be01453(this.mPackage.mPackage.GetEntryPoint(48)));
        }
        this.mMapRooms = null;
        this.mSpriteRoom = null;
        this.mShapeWay = null;
        this.mTextInfoRoom = null;
        this.mViewportRoom = null;
        if (this.mMapViewport != null) {
            this.mMapViewport.SetViewport(null);
        }
        GameLibrary.ReleasePackage(this.mFontPackage);
        super.Unload();
    }

    public final boolean OnPenUp(byte by, short[] sArray) {
        boolean bl = false;
        if (this.mMapAnimationTimeSystem.IsPaused()) {
            bl = super.OnPenUp(by, sArray);
        }
        return bl;
    }

    public final void OnTime(int n, int n2) {
        if (!this.mMapAnimationTimeSystem.IsPaused()) {
            this.mSpriteInfoSuspect.SetTopLeft((short)(this.mViewportAnimationSuspect.mRect_left - this.mViewportCropSuspect.mRect_left + (this.mViewportAnimationSuspect.mRect_width - this.mSpriteInfoSuspect.mRect_width) / 2), (short)(this.mViewportAnimationSuspect.mRect_top - this.mViewportCropSuspect.mRect_top));
            return;
        }
        super.OnTime(n, n2);
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        for (int i = 0; i < 4; ++i) {
            this.mArrows[i] = Sprite.Cast$46e644cd(this.mPackage.mPackage.GetEntryPoint(6 + i));
        }
        this.mSpriteNoEntry = Sprite.Cast$46e644cd(this.mPackage.mPackage.GetEntryPoint(24));
        this.mBitmapTravelMapUnvisited = FlBitmap.Cast$5822fcd3(this.mPackage.mPackage.GetEntryPoint(10));
        this.mBitmapTravelMapUnvisitedCursor = FlBitmap.Cast$5822fcd3(this.mPackage.mPackage.GetEntryPoint(11));
        this.mColorVisitedRoomSelected = Color888.Cast$4e210a13(this.mPackage.mPackage.GetEntryPoint(4));
        this.mMapAnimationTimeSystem = TimeSystem.Cast$3b277f7b(this.mPackage.mPackage.GetEntryPoint(44));
        this.mSuspectSpeechBubbleTimeSystem = TimeSystem.Cast$3b277f7b(this.mPackage.mPackage.GetEntryPoint(45));
        this.GetInformationRoom();
        this.mFontTextRoomUnknown = FlFont.Cast$be01453(this.mFontPackage.mPackage.GetEntryPoint(22));
        this.mFontTextRoomCross = FlFont.Cast$be01453(this.mFontPackage.mPackage.GetEntryPoint(21));
    }

    public final void Init(Viewport viewport) {
        this.mComponentViewport.SetTopLeft((short)Constants.geMapContainerOffsetXFct(), (short)Constants.geMapContainerOffsetYFct());
        this.mComponentViewport.SetSize((short)Constants.travelMapViewportWidthFct(), (short)Constants.geMapContainerHeightFct());
        Viewport viewport2 = Viewport.Cast$7c352e71((Object)this.mPackage.mPackage.GetEntryPoint((int)5)).m_pViewport;
        this.mMapViewport.SetViewport(viewport2);
        this.mMapViewport.SetSize(viewport2.mRect_width, viewport2.mRect_height);
        super.Init(viewport);
        this.mViewportInfo.SetViewport(this.mComponentViewport);
        this.mViewportInfo.SetVisible(false);
        this.mSpriteInfoSuspect = new Sprite();
        this.mSpriteInfoSuspect.SetViewport(this.mViewportCropSuspect);
        this.mShapeSuspect.SetColor(Color888.c_init_iii(0, 0, 0));
        this.BlinkSpeechBubble(false);
    }

    public final void StartOpeningAnims() {
        this.mMapViewport.SetVisible(false);
        this.mViewportInfo.SetVisible(true);
        this.mTextMoveTo.SetVisible(false);
        Utilities.StartTimeSystem(this.mMapAnimationTimeSystem);
    }

    public final boolean IsOpeningAnimsEnded() {
        return !this.mMapAnimationTimeSystem.IsRegisteredInGlobalTime() || this.mMapAnimationTimeSystem.mTotalTime >= 916;
    }

    public final void StartClosingAnims() {
        this.mMapViewport.SetVisible(false);
        this.mTextMoveTo.SetVisible(false);
        Utilities.StartTimeSystemInverse(this.mMapAnimationTimeSystem, 916);
    }

    public final boolean IsClosingAnimsEnded() {
        return this.mMapAnimationTimeSystem.mTotalTime <= 0;
    }
}

