/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FileSegmentStream;
import ca.jamdat.flight.FlMath;

public final class CO_Suspect {
    public int mGossipGroupId = -1;
    public int[] mConfrontAnswers = new int[3];
    public int[] mConfrontChoices = new int[3];
    public int mIntroSpeech = 0;
    public int mFinalSpeech = -1;
    public int mSpeechState = 0;
    public int mLastAnswer = -1;
    public int mGossipSpeech = -1;
    public int[] mStringsId = null;
    public int mConfrontGroupId = -1;
    public int mConfrontSpeech = -1;
    public int mSuspectId = -1;

    public CO_Suspect() {
        this.ClearAnswers();
        this.InitConfrontChoice();
        this.mStringsId = new int[4];
        for (int i = 0; i < this.mStringsId.length; ++i) {
            this.mStringsId[i] = -1;
        }
    }

    public final void OnDelete() {
        this.mConfrontAnswers = null;
        this.mConfrontChoices = null;
        this.mStringsId = null;
    }

    public final int GetConfrontChoice(int n) {
        return this.mConfrontChoices[n];
    }

    private void InitConfrontChoice() {
        for (int i = 0; i < 3; ++i) {
            this.mConfrontChoices[i] = i;
        }
        CO_Suspect.ShuffleConfrontChoices(this.mConfrontChoices);
    }

    private static void ShuffleConfrontChoices(int[] nArray) {
        for (int i = 0; i < 3; ++i) {
            int n = nArray[i];
            int n2 = FlMath.Rand() % 3;
            nArray[i] = nArray[n2];
            nArray[n2] = n;
        }
    }

    public final void Read(FileSegmentStream fileSegmentStream) {
        this.mSpeechState = fileSegmentStream.ReadByte();
        this.mIntroSpeech = fileSegmentStream.ReadByte();
        this.mGossipSpeech = fileSegmentStream.ReadByte();
        this.mConfrontSpeech = fileSegmentStream.ReadByte();
        this.mFinalSpeech = fileSegmentStream.ReadByte();
        this.mLastAnswer = fileSegmentStream.ReadByte();
        this.mConfrontGroupId = fileSegmentStream.ReadByte();
        this.mGossipGroupId = fileSegmentStream.ReadByte();
        for (int i = 0; i < 3; ++i) {
            this.mConfrontAnswers[i] = fileSegmentStream.ReadByte();
        }
    }

    public final void Write(FileSegmentStream fileSegmentStream) {
        fileSegmentStream.WriteByte((byte)this.mSpeechState);
        fileSegmentStream.WriteByte((byte)this.mIntroSpeech);
        fileSegmentStream.WriteByte((byte)this.mGossipSpeech);
        fileSegmentStream.WriteByte((byte)this.mConfrontSpeech);
        fileSegmentStream.WriteByte((byte)this.mFinalSpeech);
        fileSegmentStream.WriteByte((byte)this.mLastAnswer);
        fileSegmentStream.WriteByte((byte)this.mConfrontGroupId);
        fileSegmentStream.WriteByte((byte)this.mGossipGroupId);
        for (int i = 0; i < 3; ++i) {
            fileSegmentStream.WriteByte((byte)this.mConfrontAnswers[i]);
        }
    }

    public final void SetAnswer(int n) {
        this.mLastAnswer = n;
        this.mConfrontAnswers[n] = 5;
    }

    public final void ClearAnswers() {
        for (int i = 0; i < 3; ++i) {
            this.mConfrontAnswers[i] = 4;
        }
        this.mLastAnswer = -1;
    }

    public final boolean IsAnswerUsed(int n) {
        return this.mConfrontAnswers[n] == 5;
    }

    public final int GetStringId(int n) {
        return this.mStringsId[n];
    }

    public final void SetStringId(int n, int n2) {
        this.mStringsId[n2] = n;
    }
}

