/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ClueBaseScene;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.GE_TutorialTicker;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.TutorialSteps;

public final class TutorialController {
    public GE_TutorialTicker mTicker;
    public ClueBaseScene mClueScene;

    public final void UpdateNotifier() {
        if (GameApp.Get().GetScenarioContext().GetNotifier() != -1) {
            this.mClueScene.ShowNotification(GameApp.Get().GetScenarioContext().GetNotifier());
            this.mClueScene.TakeFocus();
        }
    }

    public final void Update() {
        this.mClueScene.LockAccess();
        TutorialSteps tutorialSteps = GameApp.Get().GetScenarioContext().mTutorialSteps;
        tutorialSteps.Refresh();
        while (tutorialSteps.HasMoreActions()) {
            int n = tutorialSteps.NextAction();
            if (n == -125) {
                n = tutorialSteps.NextEnabledEntity();
                int n2 = tutorialSteps.NextEnabledValue();
                this.mClueScene.Unlock(n, n2);
                continue;
            }
            if (n != -126) continue;
            this.mTicker.StopTutorialTicker();
            this.mTicker.SetTutorialMessage(ClueUtils.GetGameString(tutorialSteps.NextTickerStringId()));
        }
    }

    public TutorialController(ClueBaseScene clueBaseScene, GE_TutorialTicker gE_TutorialTicker) {
        this.mClueScene = clueBaseScene;
        this.mTicker = gE_TutorialTicker;
    }
}

