/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.FlBitmapMap;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.IndexedSprite;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Shape;
import ca.jamdat.flight.Sprite;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public final class SubtypeHandler {
    private static void UpdateSelectionArrowsPosition(Selection selection) {
        MetaPackage metaPackage = GameLibrary.GetPackage(65538);
        int n = Constants.menuNormalSelectionOffsetYFct();
        Viewport viewport = Utilities.GetSceneViewportFromChild(selection);
        Viewport viewport2 = Viewport.Cast$7c352e71(metaPackage.mPackage.GetEntryPoint(27));
        viewport2.SetVisible(true);
        viewport2.SetTopLeft((short)(selection.mRect_left + selection.mRect_width - Constants.menuVerticalSelectorArrowsWFct()), (short)(selection.GetAbsoluteTop() + n));
        viewport2.SetVisible(selection.DescendentOrSelfHasFocus());
        viewport2.SetViewport(viewport);
        Utilities.UpdateArrowsVisualState(selection, viewport2);
        GameLibrary.ReleasePackage(metaPackage);
    }

    private static void UpdateTouchArrowsVisual$65ecd4a6(Selection selection) {
        Component component = selection.GetChild(0);
        Component component2 = selection.GetChild(1);
        if (selection.mEnabled) {
            boolean bl = !selection.mPushed;
            component.SetVisible(bl);
            component2.SetVisible(selection.mPushed);
            return;
        }
        component.SetVisible(true);
        component2.SetVisible(false);
    }

    private static void UpdateMenuSelectionVisual(Selection selection) {
        SubtypeHandler.UpdateMenuSelectionVisual(selection, false);
    }

    private static void UpdateTextColorAndPosition(Text text, boolean bl, boolean bl2) {
        SubtypeHandler.UpdateTextColorAndPosition(text, bl, bl2, false);
    }

    private static void UpdateTextColorAndPosition(Text text, boolean bl, boolean bl2, boolean bl3) {
        SubtypeHandler.UpdateTextColorAndPosition(text, bl, bl2, bl3, false);
    }

    public static void OnSubtype$44fe7cd6(Component component, int n, int n2) {
        if (component instanceof Selection) {
            Selection selection = (Selection)component;
            n = selection.mSubtype;
            if (n == -1) {
                return;
            }
            if (n == -5) {
                SubtypeHandler.UpdateMenuSelectionVisual(selection, true);
                return;
            }
            if (n == -4) {
                SubtypeHandler.UpdateMenuSelectionVisual(selection);
                return;
            }
            if (n == -6) {
                SubtypeHandler.UpdateMenuCheckboxVisual(selection);
                return;
            }
            if (n == -10) {
                SubtypeHandler.UpdateSuspicionsSelectionItemVisual(selection);
                return;
            }
            if (n == -14) {
                SubtypeHandler.UpdateTouchArrowsVisual$65ecd4a6(selection);
                return;
            }
            if (n == -7) {
                SubtypeHandler.UpdateToolSceneArrowVisual(selection);
                return;
            }
            if (n == -8 || n == -9) {
                SubtypeHandler.UpdateDialogBoxArrowVisual(selection);
                return;
            }
            if (n == -11) {
                SubtypeHandler.UpdateMenuSelectionScenarioVisual(selection);
            }
        }
    }

    private static void UpdateToolSceneArrowVisual(Selection selection) {
        selection.SetVisible(selection.mEnabled);
    }

    private static void UpdateDialogBoxArrowVisual(Selection selection) {
        IndexedSprite indexedSprite = (IndexedSprite)selection.GetChild(0);
        byte by = selection.mSubtype;
        if (selection.mEnabled) {
            if (selection.mPushed) {
                if (by == Constants.subtypeDialogBoxScrollUpArrowFct()) {
                    indexedSprite.SetCurrentFrame(Constants.dialogBoxScrollUpArrowHighLightFrameIndexFct());
                } else {
                    indexedSprite.SetCurrentFrame(Constants.dialogBoxScrollDownArrowHighLightFrameIndexFct());
                }
            } else if (by == Constants.subtypeDialogBoxScrollUpArrowFct()) {
                indexedSprite.SetCurrentFrame(Constants.dialogBoxScrollUpArrowFrameIndexFct());
            } else {
                indexedSprite.SetCurrentFrame(Constants.dialogBoxScrollDownArrowFrameIndexFct());
            }
        }
        selection.SetVisible(selection.mEnabled);
    }

    private static void UpdateMenuSelectionVisual(Selection selection, boolean bl) {
        if (selection.mEnabled) {
            boolean bl2 = selection.mSelected;
            int n = bl2 ? Constants.menuSelectionExtendedWFct() : Constants.menuSelectionBaseWFct();
            selection.SetSize((short)n, Vector2_short.GetY_(selection.GetSize()));
            SubtypeHandler.UpdateMenuSelectionBackgroundAndState(selection, n, Constants.menuSelectionItemBackgroundViewportIdxFct(), false, true);
            Text text = (Text)selection.GetChild(Constants.menuSelectionItemCaptionIdxFct());
            bl = bl && !bl2;
            SubtypeHandler.UpdateTextColorAndPosition(text, bl2, false, false, bl);
            SubtypeHandler.UpdateSelectionArrowsPosition(selection);
        }
    }

    private static void UpdateMenuSelectionScenarioVisual(Selection selection) {
        if (selection.mEnabled) {
            boolean bl = selection.mSelected;
            int n = bl ? Constants.menuSelectionScenarioExtendedWFct() : Constants.menuSelectionScenarioBaseWFct();
            int n2 = n;
            Text text = (Text)selection.GetChild(Constants.menuSelectionItemCaptionIdxFct());
            int n3 = 0;
            n = 0;
            if (selection.mCommand == Constants.cmdChooseLockedScenarioFct()) {
                n3 = 1;
                n = 1;
            }
            SubtypeHandler.UpdateMenuSelectionBackgroundAndState(selection, n2, Constants.menuSelectionItemBackgroundViewportIdxFct(), n3 != 0, false);
            SubtypeHandler.UpdateTextColorAndPosition(text, bl, false, n != 0);
            Viewport viewport = (Viewport)selection.GetChild(Constants.menuSelectionItemCaptionIdxFct() + 1);
            n3 = bl ? 1 : 0;
            for (int i = 0; i < viewport.GetChildCount(); ++i) {
                ((IndexedSprite)viewport.GetChild(i)).SetCurrentFrame(n3);
            }
            MetaPackage metaPackage = GameLibrary.GetPackage(65538);
            Viewport.Cast$7c352e71(metaPackage.mPackage.GetEntryPoint(27)).SetVisible(false);
            GameLibrary.ReleasePackage(metaPackage);
        }
    }

    private static void UpdateMenuCheckboxVisual(Selection selection) {
        if (selection.mEnabled) {
            boolean bl = selection.mSelected;
            int n = bl ? Constants.menuCheckboxExtendedWFct() : Constants.menuCheckboxBaseWFct();
            SubtypeHandler.UpdateMenuSelectionBackgroundAndState(selection, n, Constants.menuCheckboxSelectionBackgroundViewportIdxFct(), false, true);
            SubtypeHandler.UpdateTextColorAndPosition((Text)selection.GetChild(Constants.menuCheckboxSelectionCaptionIdxFct()), bl, false);
            SubtypeHandler.UpdateSelectionArrowsPosition(selection);
        }
    }

    private static void UpdateSuspicionsSelectionItemVisual(Selection selection) {
        if (selection.mEnabled) {
            boolean bl = selection.mSelected;
            boolean bl2 = Utilities.IsSelectionChecked(selection);
            int n = bl ? Constants.suspicionSceneSelectionExtendedWidthFct() : Constants.suspicionSceneSelectionStandardWidthFct();
            selection.SetSize((short)Constants.suspicionSceneSelectionExtendedWidthFct(), Vector2_short.GetY_(selection.GetSize()));
            SubtypeHandler.UpdateMenuSelectionBackgroundAndState(selection, n, Constants.suspicionsSceneSelectionTabComponentViewportIndexFct(), bl2, false);
            SubtypeHandler.UpdateTextColorAndPosition((Text)selection.GetChild(Constants.suspicionsSceneSelectionTextIndexFct()), bl, bl2);
        }
    }

    private static void UpdateMenuSelectionBackgroundAndState(Selection selection, int n, int n2, boolean bl, boolean bl2) {
        MetaPackage metaPackage = GameLibrary.GetPackage(65538);
        Package package_ = metaPackage.mPackage;
        Viewport viewport = (Viewport)selection.GetChild(n2);
        boolean bl3 = selection.mSelected;
        FlBitmapMap flBitmapMap = FlBitmapMap.Cast$4864501b(package_.GetEntryPoint(12));
        if (!selection.mEnabled) {
            flBitmapMap = FlBitmapMap.Cast$4864501b(package_.GetEntryPoint(13));
        } else if (bl3) {
            flBitmapMap = FlBitmapMap.Cast$4864501b(package_.GetEntryPoint(11));
        } else if (bl) {
            flBitmapMap = FlBitmapMap.Cast$4864501b(package_.GetEntryPoint(13));
        }
        if (bl3 && bl2) {
            Shape shape = Shape.Cast$2392dbe5(package_.GetEntryPoint(15));
            shape.SetViewport(Utilities.GetSceneViewportFromChild(selection));
            shape.SetTopLeft((short)0, (short)(selection.GetAbsoluteTop() - Constants.menuSubtypeSeparatorShapeHFct()));
        }
        ClueUtils.UpdateTab(viewport, n, Constants.menuTabUpperLeftISpriteIdxFct(), flBitmapMap);
        Sprite sprite = (Sprite)viewport.GetChild(Constants.menuSeparatorSpriteIdxFct());
        short s = Vector2_short.GetY_(sprite.GetSize());
        sprite.SetSize((short)n, s);
        GameLibrary.ReleasePackage(metaPackage);
    }

    private static void UpdateTextColorAndPosition(Text text, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        MetaPackage metaPackage = GameLibrary.GetPackage(5472423);
        Object object = metaPackage.mPackage;
        FlFont flFont = FlFont.Cast$be01453(((Package)object).GetEntryPoint(0));
        FlFont flFont2 = FlFont.Cast$be01453(((Package)object).GetEntryPoint(4));
        FlFont flFont3 = FlFont.Cast$be01453(((Package)object).GetEntryPoint(5));
        object = FlFont.Cast$be01453(((Package)object).GetEntryPoint(3));
        if (bl) {
            text.SetFont(flFont);
        } else if (bl3) {
            text.SetFont(flFont3);
        } else {
            text.SetFont(flFont2);
        }
        if (bl2) {
            text.SetFont(flFont);
        }
        if (bl4) {
            text.SetFont((FlFont)object);
        }
        int n = bl ? Constants.menuSelectionSelectedTextXFct() : Constants.menuSelectionTextXFct();
        text.SetTopLeft((short)n, text.mRect_top);
        GameLibrary.ReleasePackage(metaPackage);
    }
}

