/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.CO_Room;
import ca.jamdat.flight.CO_Time;
import ca.jamdat.flight.FileSegmentStream;
import ca.jamdat.flight.Mansion;
import ca.jamdat.flight.SA_Array_CO_Room;
import ca.jamdat.flight.SA_Array_CO_SpeechGroup;
import ca.jamdat.flight.SA_Array_Suspect;
import ca.jamdat.flight.Suspect;

public final class Scenario {
    public SA_Array_CO_SpeechGroup mGroups;
    public CO_Time mTime;
    public int mBackStoryID = -1;
    public Mansion mMansion;
    public SA_Array_CO_Room mRooms = new SA_Array_CO_Room();
    public int mMurderRoom = -1;
    public SA_Array_Suspect mSuspects = new SA_Array_Suspect();
    public int mInspectorRoom = 8;

    public Scenario() {
        this.mGroups = new SA_Array_CO_SpeechGroup(2);
    }

    public final void OnDelete() {
        int n;
        this.mTime = null;
        for (n = 0; n < this.mRooms.Size(); ++n) {
            this.mRooms.Get(n).OnDelete();
        }
        this.mRooms.Clear();
        for (n = 0; n < this.mSuspects.Size(); ++n) {
            this.mSuspects.Get(n);
        }
        this.mSuspects.Clear();
        for (n = 0; n < this.mGroups.Size(); ++n) {
            this.mGroups.Get(n).OnDelete();
        }
        this.mGroups.Clear();
        this.mGroups = null;
        this.mMansion.OnDelete();
        this.mMansion = null;
    }

    public final void Read(FileSegmentStream fileSegmentStream) {
        int n;
        this.mInspectorRoom = fileSegmentStream.ReadByte();
        for (n = 0; n < this.mRooms.Size(); ++n) {
            this.mRooms.Get(n).Read(fileSegmentStream);
        }
        for (n = 0; n < this.mSuspects.Size(); ++n) {
            this.mSuspects.Get(n).Read(fileSegmentStream);
        }
    }

    public final void Write(FileSegmentStream fileSegmentStream) {
        int n;
        fileSegmentStream.WriteByte((byte)this.mInspectorRoom);
        for (n = 0; n < this.mRooms.Size(); ++n) {
            this.mRooms.Get(n).Write(fileSegmentStream);
        }
        for (n = 0; n < this.mSuspects.Size(); ++n) {
            this.mSuspects.Get(n).Write(fileSegmentStream);
        }
    }

    public final CO_Room GetRoom(int n) {
        CO_Room cO_Room = null;
        for (int i = 0; i < this.mRooms.Size(); ++i) {
            if (this.mRooms.Get((int)i).mRoomId != n) continue;
            cO_Room = this.mRooms.Get(i);
        }
        return cO_Room;
    }

    public final CO_Room GetInspectorRoom() {
        return this.GetRoom(this.mInspectorRoom);
    }

    public final void SetInspectorRoom(int n) {
        this.mInspectorRoom = n;
        this.GetInspectorRoom();
    }

    public final CO_Room GetMurderRoom() {
        return this.GetRoom(this.mMurderRoom);
    }

    public final Suspect GetSuspect(int n) {
        Suspect suspect = null;
        for (int i = 0; i < this.mSuspects.Size(); ++i) {
            if (this.mSuspects.Get(i).GetSuspectId() != n) continue;
            suspect = this.mSuspects.Get(i);
            break;
        }
        return suspect;
    }

    public final Suspect GetSuspect() {
        int n = this.GetInspectorRoom().mSuspectId;
        if (n == 6) {
            return null;
        }
        return this.GetSuspect(n);
    }
}

