/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_ActionWheel;
import ca.jamdat.flight.GE_Clock;
import ca.jamdat.flight.GE_DialogBox;
import ca.jamdat.flight.GE_Editor;
import ca.jamdat.flight.GE_NavTab;
import ca.jamdat.flight.GE_Room;
import ca.jamdat.flight.GE_Ticker;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.RTActionScene;
import ca.jamdat.flight.RTActionSceneState;
import ca.jamdat.flight.Vector2_short;

public final class RTA_FreeRoamingState
extends RTActionSceneState {
    public GE_Clock mClock;
    public GE_Editor mEditor;
    public GE_ActionWheel mActionWheel;

    public final void Init() {
        super.Init();
        FlString flString = new FlString(RTActionSceneState.GetStringFromRTActionScenePackage(12));
        ClueUtils.ReplaceAllRoomIDInString(flString, GameApp.Get().GetScenarioContext().GetCurrentRoom().mRoomId);
        this.mTicker.SetTickerMessage(flString);
        this.mNavTab.SetActive(true);
    }

    public final void StartClosingAnims(int n) {
        this.mActionWheel.StartClosingAnims();
        super.StartClosingAnims(n);
    }

    public final boolean OnCommand(int n) {
        boolean bl = true;
        switch (n) {
            case 14: {
                if (!this.mActionWheel.IsAnimsEnded()) break;
                if (this.mActionWheel.IsVisible()) {
                    this.mRoom.SetState(1);
                    this.mActionWheel.StartClosingAnims();
                    this.UpdateSoftkeys(0, 14, 8, -14);
                    break;
                }
                this.mRoom.SetState(2);
                this.mActionWheel.StartOpeningAnims();
                this.UpdateSoftkeys(3, 14, 8, -14);
                break;
            }
            case 12: {
                this.StartClosingAnims(2);
                break;
            }
            case 9: {
                if (!this.mActionWheel.IsAnimsEnded()) break;
                int n2 = GameApp.Get().GetScenarioContext().GetSuspect().GetSpeechState() == 1 ? 5 : 10;
                this.StartClosingAnims(n2);
                break;
            }
            case 10: {
                if (!this.mActionWheel.IsAnimsEnded()) break;
                this.StartClosingAnims(9);
                break;
            }
            case 8: {
                if (!this.mActionWheel.IsAnimsEnded()) break;
                this.StartClosingAnims(11);
                break;
            }
            case 7: {
                if (!this.mActionWheel.IsAnimsEnded()) break;
                this.StartClosingAnims(1);
                break;
            }
            case 34: {
                this.mRoom.MoveTo(2);
                break;
            }
            case 33: {
                this.mRoom.MoveTo(1);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl || super.OnCommand(n);
    }

    public final boolean HasClosingAnims() {
        return !this.mActionWheel.IsInvisible();
    }

    public final void Leave() {
        this.mActionWheel.UpdateVisibility();
        this.mTicker.StopTicker();
        super.Leave();
    }

    public final void SetDefaultSoftkeys() {
        if (!this.mDialogBox.mIsActive) {
            this.UpdateSoftkeys(0, 14, 8, -14);
        }
    }

    public final void ShowEditor() {
        GameApp.Get().GetMediaPlayer().PlayMusic(21);
        this.mRoom.SetCharacterVisible(false);
        this.mRoom.SetState(4);
        this.mEditor.SetVisible(true);
    }

    public final boolean IsClosingAnimsEnded() {
        return this.mActionWheel.IsAnimsEnded();
    }

    public final boolean OnKeyDown(int n) {
        if (this.mActionWheel.IsInvisible()) {
            switch (n) {
                case 4: {
                    this.OnCommand(34);
                    return true;
                }
                case 3: {
                    this.OnCommand(33);
                    return true;
                }
            }
        }
        return super.OnKeyDown(n);
    }

    public final boolean OnKeyUp(int n) {
        if (this.mActionWheel.IsInvisible()) {
            switch (n) {
                case 3: 
                case 4: {
                    this.mRoom.MoveTo(0);
                }
            }
        }
        return this.mActionWheel.OnKeyUp(n) || super.OnKeyUp(n);
    }

    public final boolean OnPenUp(byte by, short[] sArray) {
        boolean bl = false;
        if (this.mActionWheel.IsAnimsEnded()) {
            bl = this.mRoom.OnPenUp(by, sArray);
        }
        return bl;
    }

    public final void OnHideNotification() {
        this.mEditor.SetVisible(false);
        this.mRoom.SetCharacterVisible(true);
        this.mRoom.SetState(1);
        super.OnHideNotification();
        this.mClock.Update();
        if (!GameApp.Get().GetScenarioContext().HasMoreTime()) {
            this.mRTActionScene.OnCommand(2);
        }
    }

    public RTA_FreeRoamingState(RTActionScene rTActionScene, GE_DialogBox gE_DialogBox, GE_Room gE_Room, GE_Ticker gE_Ticker, GE_Clock gE_Clock, GE_ActionWheel gE_ActionWheel, GE_NavTab gE_NavTab, GE_Editor gE_Editor) {
        super(rTActionScene, gE_DialogBox, gE_Room, gE_Ticker, gE_NavTab);
        this.mClock = gE_Clock;
        this.mActionWheel = gE_ActionWheel;
        this.mEditor = gE_Editor;
        GameApp.Get().GetScenarioContext().OnEvent(12);
        this.mClock.Update();
        if (this.mEditor.IsVisible()) {
            this.mRoom.SetState(4);
            return;
        }
        this.mRoom.SetState(1);
    }

    public final boolean OnPenDown(byte by, short[] sArray) {
        boolean bl = false;
        if (this.mActionWheel.IsInvisible() && this.mActionWheel.IsAnimsEnded()) {
            bl = this.mRoom.OnPenDown(by, sArray);
        }
        return bl;
    }

    public final boolean OnPenMove(byte by, short[] sArray, short[] sArray2, short[] sArray3) {
        int n = 0;
        if (this.mActionWheel.IsInvisible() && this.mActionWheel.IsAnimsEnded()) {
            n = Vector2_short.GetX_(sArray) - Vector2_short.GetX_(sArray2);
            this.mRoom.Move(n);
            n = 1;
        }
        return n != 0;
    }
}

