/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.Color888;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.FlBitmap;
import ca.jamdat.flight.GE_CharactersIcons;
import ca.jamdat.flight.GE_CrimeRoomContents;
import ca.jamdat.flight.GE_Map;
import ca.jamdat.flight.GE_Shadow;
import ca.jamdat.flight.GE_Weapons;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.Mansion;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.Shape;
import ca.jamdat.flight.Sprite;
import ca.jamdat.flight.SuspectVisibility;
import ca.jamdat.flight.Viewport;
import ca.jamdat.flight.WeaponVisibility;

public class GE_MapAnnotation
extends GE_Map {
    public GE_Weapons mWeapons;
    public FlBitmap mBitmapBackgroundRoomCleared;
    public Shape mShapeRedUp;
    public boolean mRoomLocked;
    public Shape mShapeRedDown;
    public int mAnimState = 2;
    public Sprite mSpriteWindrose;
    public GE_Shadow mShadow;
    public MetaPackage mPackageSmallArrows;
    public boolean mSuspicionsEnabled;
    public FlBitmap mBitmapBackgroundRoom;
    public Shape mSelectedRoomShape;
    public FlBitmap mBitmapBackgroundCorridor;
    public Sprite mSpriteBackgroundOutside;
    public int mTimeToOpen;
    public GE_CrimeRoomContents[] mCrimeRoomContents = null;
    public Sprite[] mSpriteMapRooms = null;
    public Sprite[] mSpriteSmallArrows = null;
    public MetaPackage mCrimeMapPackage;

    public GE_MapAnnotation(BaseScene baseScene, Mansion mansion) {
        super(baseScene, mansion);
    }

    public short GetMansionHeight() {
        return (short)(this.mMansionHeight + Constants.crimeSceneSelectionWithItemHintsDiffYFct());
    }

    public final short[] GetSelectionColor() {
        return Color888.Cast$4e210a13(this.mCrimeMapPackage.mPackage.GetEntryPoint(0));
    }

    public int GetSuspectIdForSuspicions(int n) {
        return GameApp.Get().GetScenarioContext().GetSuspectAnnotationsRoom(n, 0);
    }

    public int GetWeaponIdForSuspicions(int n) {
        return GameApp.Get().GetScenarioContext().GetWeaponAnnotationsRoom(n, 0);
    }

    public void InitMainViewport() {
        this.mMapViewport.SetViewport(this.mComponentViewport);
        this.mComponentViewport.SetTopLeft(this.GetRectLeftMainViewport(), this.GetRectTopMainViewport());
        this.mComponentViewport.SetSize(this.GetRectWidthMainViewport(), this.GetRectHeightMainViewport());
        this.mMapViewport.SetTopLeft((short)0, (short)0);
        this.mMapViewport.SetSize(this.GetRectWidthMainViewport(), this.GetRectHeightMainViewport());
        this.mSpriteBackgroundOutside.SetViewport(this.mComponentViewport);
        this.mSpriteBackgroundOutside.SetTopLeft((short)Constants.geMapBigViewportOffsetXFct(), (short)Constants.geMapBigViewportOffsetYFct());
        this.mSelectedRoomShape.SetViewport(this.mViewportCompleteMap);
        this.mShapeRedUp.SetViewport(this.mComponentViewport.m_pViewport);
        this.mShapeRedUp.SetTopLeft(GE_MapAnnotation.GetRectLeftSurfaceAnimOpen(), GE_MapAnnotation.GetRectTopSurfaceAnimOpen());
        this.mShapeRedUp.SetSize(GE_MapAnnotation.GetRectWidthSurfaceAnimOpen(), (short)(GE_MapAnnotation.GetRectHeightSurfaceAnimOpen() / 2));
        this.mShapeRedUp.SetColor(this.GetSelectionColor());
        this.mShapeRedUp.SetVisible(false);
        this.mShapeRedDown.SetViewport(this.mComponentViewport.m_pViewport);
        this.mShapeRedDown.SetTopLeft(GE_MapAnnotation.GetRectLeftSurfaceAnimOpen(), (short)(GE_MapAnnotation.GetRectTopSurfaceAnimOpen() + GE_MapAnnotation.GetRectHeightSurfaceAnimOpen() / 2));
        this.mShapeRedDown.SetSize(GE_MapAnnotation.GetRectWidthSurfaceAnimOpen(), (short)(GE_MapAnnotation.GetRectHeightSurfaceAnimOpen() / 2 + GE_MapAnnotation.GetRectHeightSurfaceAnimOpen() % 2));
        this.mShapeRedDown.SetColor(this.GetSelectionColor());
        this.mShapeRedDown.SetVisible(false);
        this.mComponentViewport.BringComponentToFront(this.mMapViewport);
        this.mShadow.Init(this.mViewportCompleteMap, 2);
        this.mSpriteWindrose.SetViewport(this.mComponentViewport);
        this.mSpriteWindrose.SetTopLeft((short)(this.mComponentViewport.mRect_width - this.mSpriteWindrose.mRect_width - Constants.crimeSceneWindRoseOffsetXFct()), (short)(this.mComponentViewport.mRect_height - this.mSpriteWindrose.mRect_height - Constants.crimeSceneWindRoseOffsetYFct()));
    }

    public short GetRectLeftMainViewport() {
        return (short)Constants.geMapBigViewportOffsetXFct();
    }

    public short GetRectTopMainViewport() {
        return (short)Constants.geMapBigViewportOffsetYFct();
    }

    public short GetRectWidthMainViewport() {
        return (short)Constants.geMapBigViewportWidthFct();
    }

    public short GetRectHeightMainViewport() {
        return (short)Constants.geMapBigViewportHeightFct();
    }

    public final void OnSelectedRoom() {
        this.mBaseScene.OnCommand(80);
    }

    public final void SelectRoom(int n) {
        if (this.mCurrentSelectedRoom != n) {
            GameApp.Get().GetScenarioContext().mCurrentRoomIndex = (byte)n;
        }
        super.SelectRoom(n);
    }

    public final void UnselectRoom() {
        super.UnselectRoom();
    }

    public final boolean Move(int n, boolean bl) {
        if (this.mRoomLocked) {
            return false;
        }
        return super.Move(n, bl);
    }

    public final short GetMapDoorsLength() {
        return (short)Constants.geMapDoorsLengthFct();
    }

    public final short GetMapDoorsLarge() {
        return (short)Constants.geMapDoorsLargeFct();
    }

    public final short GetMapWallSize() {
        return (short)Constants.geMapWallSizeFct();
    }

    public final short GetMapSelectorInternalSize() {
        return (short)Constants.geMapSelectorInternalSizeFct();
    }

    public final short GetTileWidth() {
        return (short)Constants.geMapTileSizeXFct();
    }

    public final short GetTileHeight() {
        return (short)Constants.geMapTileSizeYFct();
    }

    public final short GetMapMarginWidth() {
        return (short)Constants.crimeSceneSelectionDiffXFct();
    }

    public final short GetRoomMarginHeight() {
        return (short)Constants.crimeSceneSelectionWithItemHintsDiffYFct();
    }

    public final boolean IsViewportRoomExists(int n) {
        return this.mCrimeRoomContents[n].mActive;
    }

    public final void InitViewportRoom(int n) {
        this.mCrimeRoomContents[n].Init(this.mViewportCompleteMap);
    }

    public final void CreateViewportRoom(int n, int n2, int n3, int n4, int n5) {
        if (this.IsViewportRoomExists(n)) {
            this.mCrimeRoomContents[n].SetSize((short)(n2 * this.GetTileWidth() + this.mOffsetX - Constants.geCrimeMapMarginWidthFct()), (short)(n3 * this.GetTileHeight() + this.mOffsetY - Constants.geCrimeMapMarginHeightFct()), (short)((n4 - n2 + 1) * this.GetTileWidth() + 2 * Constants.geCrimeMapMarginWidthFct()), (short)((n5 - n3 + 1) * this.GetTileHeight() + Constants.geCrimeMapMarginHeightFct()));
            this.UpdateSuspicions(n);
            this.UpdateVisualsContent(n);
            this.mCrimeRoomContents[n].SetTitle(ClueUtils.GetStringForRoom(n));
        }
    }

    public final short GetMansionWidth() {
        return this.mMansionWidth;
    }

    public final void ChangeMapPosition(int n) {
        super.ChangeMapPosition(n);
        this.mSpriteBackgroundOutside.SetTopLeft((short)(-(this.GetTileWidth() - this.mViewportCompleteMap.mRect_left % this.GetTileWidth())), (short)(-(this.GetTileHeight() - this.mViewportCompleteMap.mRect_top % this.GetTileHeight())));
    }

    public final void SelectionFill(int n) {
        if (!this.mRoomLocked) {
            for (int i = 0; i < this.mCurrentMansion.mHeight; ++i) {
                for (int j = 0; j < this.mCurrentMansion.mWidth; ++j) {
                    if (!this.IsSameRoom(j, i, n)) continue;
                    this.CreateSelectedShape(this.mViewportCompleteMap, (short)(j * this.GetTileWidth() + this.mOffsetX), (short)(i * this.GetTileHeight() + this.mOffsetY), this.GetTileWidth(), this.GetTileHeight(), this.GetSelectionColor());
                }
            }
        }
    }

    public final void SelectionCreateDoor(int n, int n2, int n3) {
        if (this.mCurrentMansion.IsDoorInRoom(n, n2)) {
            boolean bl;
            int n4;
            if (this.mCurrentMansion.IsDoorInRoom(n, n2 + 1) && !this.IsSameRoom(n, n2 + 1, n3)) {
                n3 = 0;
                n4 = this.GetTileHeight();
                bl = true;
            } else if (this.mCurrentMansion.IsDoorInRoom(n, n2 - 1) && !this.IsSameRoom(n, n2 - 1, n3)) {
                n3 = 0;
                n4 = 0;
                bl = true;
            } else if (this.mCurrentMansion.IsDoorInRoom(n - 1, n2) && !this.IsSameRoom(n - 1, n2, n3)) {
                bl = false;
                n3 = 0;
                n4 = this.GetMapSelectorInternalSize() / 2;
            } else if (this.mCurrentMansion.IsDoorInRoom(n + 1, n2) && !this.IsSameRoom(n + 1, n2, n3)) {
                bl = false;
                n3 = this.GetTileWidth();
                n4 = this.GetMapSelectorInternalSize() / 2;
            } else {
                return;
            }
            Viewport viewport = this.mViewportCompleteMap;
            short s = n * this.GetTileWidth() + this.mOffsetX + n3;
            short s2 = bl ? this.GetMapSelectorInternalSize() : -this.GetMapDoorsLength();
            s2 = (short)(s + s2 / 2);
            s = n2 * this.GetTileHeight() + this.mOffsetY + n4;
            short s3 = bl ? this.GetMapDoorsLength() : (short)0;
            s3 = (short)(s - s3 / 2);
            s = bl ? (short)this.GetMapDoorsLarge() : (short)this.GetMapDoorsLength();
            short s4 = bl ? this.GetMapDoorsLength() : this.GetMapDoorsLarge();
            this.CreateSelectedShape(viewport, s2, s3, s, s4, Color888.c_init_iii(255, 255, 255));
            Viewport viewport2 = this.mViewportCompleteMap;
            s3 = bl ? (short)1 : 0;
            s3 = (n + s3) * this.GetTileWidth() + this.mOffsetX + n3;
            s2 = bl ? this.GetMapSelectorInternalSize() : this.GetMapDoorsLength();
            s3 = (short)(s3 - s2 / 2);
            s2 = bl ? (short)0 : 1;
            s2 = (short)((n2 + s2) * this.GetTileHeight() + this.mOffsetY + n4 - this.GetMapDoorsLength() / 2);
            s = bl ? this.GetMapDoorsLarge() : this.GetMapDoorsLength();
            short s5 = bl ? this.GetMapDoorsLength() : this.GetMapDoorsLarge();
            this.CreateSelectedShape(viewport2, s3, s2, s, s5, Color888.c_init_iii(255, 255, 255));
            viewport2 = this.mViewportCompleteMap;
            s3 = (short)(n * this.GetTileWidth() + this.mOffsetX + n3);
            s2 = (short)(n2 * this.GetTileHeight() + this.mOffsetY + n4);
            s = bl ? this.GetTileWidth() : (short)1;
            s5 = bl ? (short)1 : this.GetTileHeight();
            this.CreateSelectedShape(viewport2, s3, s2, s, s5, Color888.c_init_iii(255, 255, 255));
        }
    }

    public final void SelectionBringToFront(int n) {
        int n2;
        super.SelectionBringToFront(n);
        n = this.mCurrentMansion.mWidth;
        int n3 = 0;
        int n4 = this.mCurrentMansion.mHeight;
        int n5 = 0;
        this.BringToFrontWalls();
        this.BringToFrontDoors();
        for (n2 = 0; n2 < 12; ++n2) {
            if (!this.mCrimeRoomContents[n2].mActive) continue;
            this.mCrimeRoomContents[n2].BringToFront();
        }
        this.UseShadowOnTheMap();
        int n6 = this.mCurrentMansion.mWidth;
        for (n2 = 0; n2 < this.mCurrentMansion.mHeight; ++n2) {
            for (int i = 0; i < this.mCurrentMansion.mWidth; ++i) {
                if (!this.IsSameRoom(i, n2, this.mCurrentSelectedRoom)) continue;
                if (i < n) {
                    n = i;
                }
                if (n2 < n4) {
                    n4 = n2;
                }
                if (i > n3) {
                    n3 = i;
                }
                if (n2 > n5) {
                    n5 = n2;
                }
                this.mSpriteMapRooms[i + n6 * n2].BringToFront();
            }
        }
        for (n6 = 0; n6 < this.mCurrentSelectedShape; ++n6) {
            this.mMapSelectedRooms[n6].BringToFront();
        }
        if (this.mCrimeRoomContents[this.mCurrentSelectedRoom].mActive) {
            this.mCrimeRoomContents[this.mCurrentSelectedRoom].BringToFront();
        }
        this.DrawArrowsOnMap(n, n4, n3, n5);
    }

    public final void CreateRoomTile(int n, int n2, int n3) {
        int n4 = n + this.mCurrentMansion.mWidth * n2;
        this.mSpriteMapRooms[n4] = new Sprite();
        this.mSpriteMapRooms[n4].SetViewport(this.mViewportCompleteMap);
        this.mSpriteMapRooms[n4].SetTopLeft((short)(n * this.GetTileWidth() + this.mOffsetX), (short)(n2 * this.GetTileHeight() + this.mOffsetY));
        this.mSpriteMapRooms[n4].SetSize(this.GetTileWidth(), this.GetTileHeight());
        this.mSpriteMapRooms[n4].SetTileableXY(true);
        FlBitmap flBitmap = this.mCurrentMansion.IsInHall(n, n2) ? this.mBitmapBackgroundCorridor : this.GetBitmapRoomTile(n3);
        this.mSpriteMapRooms[n4].SetBitmap(flBitmap);
    }

    public final void Load() {
        int n;
        super.Load();
        this.mCrimeMapPackage = GameLibrary.GetPackage(327690);
        this.mCrimeRoomContents = new GE_CrimeRoomContents[12];
        for (n = 0; n < this.mCrimeRoomContents.length; ++n) {
            this.mCrimeRoomContents[n] = null;
        }
        for (n = 0; n < 12; ++n) {
            this.mCrimeRoomContents[n] = new GE_CrimeRoomContents(this.mScene);
            this.mCrimeRoomContents[n].Load();
        }
        this.mWeapons = new GE_Weapons(this.mScene);
        this.mWeapons.Load();
        this.mShadow = new GE_Shadow(this.mScene);
        this.mShadow.Load();
        this.mSpriteMapRooms = new Sprite[this.mCurrentMansion.mWidth * this.mCurrentMansion.mHeight];
        for (n = 0; n < this.mSpriteMapRooms.length; ++n) {
            this.mSpriteMapRooms[n] = null;
        }
        this.mSelectedRoomShape = new Shape();
        this.mShapeRedUp = new Shape();
        this.mShapeRedDown = new Shape();
        this.mPackageSmallArrows = GameLibrary.GetPackage(557073);
        this.mSpriteSmallArrows = new Sprite[4];
        for (n = 0; n < this.mSpriteSmallArrows.length; ++n) {
            this.mSpriteSmallArrows[n] = null;
        }
    }

    public final void Unload() {
        int n;
        for (n = 0; n < 4; ++n) {
            this.mSpriteSmallArrows[n].SetViewport(null);
        }
        this.mSpriteSmallArrows = null;
        GameLibrary.ReleasePackage(this.mPackageSmallArrows);
        if (this.mShapeRedUp != null) {
            this.mShapeRedUp.SetViewport(null);
            this.mShapeRedUp = null;
        }
        if (this.mShapeRedDown != null) {
            this.mShapeRedDown.SetViewport(null);
            this.mShapeRedDown = null;
        }
        this.mBitmapBackgroundCorridor = null;
        this.mBitmapBackgroundRoom = null;
        if (this.mSelectedRoomShape != null) {
            this.mSelectedRoomShape.SetViewport(null);
            this.mSelectedRoomShape = null;
        }
        this.mBitmapBackgroundRoomCleared = null;
        this.mSpriteBackgroundOutside.SetViewport(null);
        this.mSpriteBackgroundOutside = null;
        if (this.mSpriteWindrose != null) {
            this.mSpriteWindrose.SetViewport(null);
            this.mSpriteWindrose = null;
        }
        for (n = 0; n < 12; ++n) {
            if (this.mCrimeRoomContents[n] == null) continue;
            this.mCrimeRoomContents[n].Unload();
            this.mCrimeRoomContents[n] = null;
        }
        this.mCrimeRoomContents = null;
        if (this.mWeapons != null) {
            this.mWeapons.Unload();
            this.mWeapons = null;
        }
        for (n = 0; n < this.mCurrentMansion.mWidth * this.mCurrentMansion.mHeight; ++n) {
            if (this.mSpriteMapRooms == null || this.mSpriteMapRooms[n] == null) continue;
            this.mSpriteMapRooms[n].SetBitmap(null);
            this.mSpriteMapRooms[n].SetViewport(null);
            this.mSpriteMapRooms[n] = null;
        }
        this.mSpriteMapRooms = null;
        if (this.mShadow != null) {
            this.mShadow.Unload();
            this.mShadow = null;
        }
        if (this.mMapViewport != null) {
            this.mMapViewport.SetViewport(null);
        }
        GameLibrary.ReleasePackage(this.mCrimeMapPackage);
        super.Unload();
    }

    public final boolean IsLoaded() {
        return super.IsLoaded() && this.mWeapons.IsLoaded() && this.mShadow.IsLoaded() && this.mCrimeMapPackage.IsLoaded();
    }

    public final boolean IsRoomContentsAnimationFinished() {
        return this.mCrimeRoomContents[this.mCurrentSelectedRoom].IsAnimationFinished();
    }

    public final void LockCurrentRoom(boolean bl) {
        boolean bl2 = !bl;
        this.SetSuspicionsVisibility(bl2);
        this.mRoomLocked = bl;
        if (this.mRoomLocked) {
            this.SetVisibleArrowsDirection(false);
            this.SelectRoom(this.mCurrentSelectedRoom);
            this.SelectionBringToFront(this.mCurrentSelectedRoom);
            this.mCrimeRoomContents[this.mCurrentSelectedRoom].SetActive(1);
            return;
        }
        this.BringToFrontWalls();
        this.SelectRoom(this.mCurrentSelectedRoom);
        this.UpdateSuspicions(this.mCurrentSelectedRoom);
        this.UpdateVisualsContent(this.mCurrentSelectedRoom);
        this.mCrimeRoomContents[this.mCurrentSelectedRoom].SetActive(0);
    }

    public final void OnUnselectedRoom() {
        this.mBaseScene.OnCommand(81);
    }

    public final boolean HasSuspectSelected() {
        return this.mRoomLocked && this.mCrimeRoomContents[this.mCurrentSelectedRoom].mItemSelection == 1;
    }

    public final int GetSuspectIDSelected() {
        return this.mCrimeRoomContents[this.mCurrentSelectedRoom].GetSuspect();
    }

    public final boolean HasWeaponSelected() {
        return this.mRoomLocked && this.mCrimeRoomContents[this.mCurrentSelectedRoom].mItemSelection == 2;
    }

    public final int GetWeaponIDSelected() {
        return this.mCrimeRoomContents[this.mCurrentSelectedRoom].GetWeapon();
    }

    public final void UpdateAllSuspicions(boolean bl) {
        this.SetSuspicionsVisibility(bl);
        this.SelectionBringToFront(this.mCurrentSelectedRoom);
    }

    public final void SaveAnnotations() {
        for (int i = 0; i < 12; ++i) {
            if (!GameApp.Get().GetScenarioContext().IsRoomExist(i)) continue;
            GE_MapAnnotation.SaveAnnotation(i, this.mCrimeRoomContents[i].GetSuspect(), this.mCrimeRoomContents[i].GetWeapon());
        }
    }

    public final void BringToFrontShadow() {
        this.mShadow.BringToFront();
    }

    public final void SetAnnotation(int n) {
        this.mCrimeRoomContents[this.mCurrentSelectedRoom].SetActive(n);
    }

    public final void UpdateCharacter(int n, int n2) {
        SuspectVisibility suspectVisibility = GameApp.Get().GetScenarioContext().mSuspectVisibility;
        if (n2 != -1 && n2 < 6) {
            GE_CrimeRoomContents gE_CrimeRoomContents = this.mCrimeRoomContents[n];
            GE_CharactersIcons gE_CharactersIcons = this.mCharactersIcons;
            int n3 = suspectVisibility.GetSuspectVisibility(n2) || !this.mSuspicionsEnabled ? 0 : 1;
            gE_CrimeRoomContents.SetAnnotationBitmap(1, gE_CharactersIcons.GetCharacterBitmap(n2, n3));
            return;
        }
        this.mCrimeRoomContents[n].SetAnnotationBitmap(1, null);
    }

    public final void UpdateWeapon(int n, int n2) {
        WeaponVisibility weaponVisibility = GameApp.Get().GetScenarioContext().mWeaponVisibility;
        if (n2 != -1 && n2 < 9) {
            GE_CrimeRoomContents gE_CrimeRoomContents = this.mCrimeRoomContents[n];
            GE_Weapons gE_Weapons = this.mWeapons;
            int n3 = weaponVisibility.GetWeaponVisibility(n2) || !this.mSuspicionsEnabled ? 1 : 0;
            gE_CrimeRoomContents.SetAnnotationBitmap(2, gE_Weapons.GetWeaponBitmap(n2, n3));
            return;
        }
        this.mCrimeRoomContents[n].SetAnnotationBitmap(2, null);
    }

    public final void UseShadowOnTheMap() {
        this.ActiveShadow(true);
    }

    public final void DrawArrowsOnMap(int n, int n2, int n3, int n4) {
        if (!this.mRoomLocked) {
            this.DrawArrowsDirection(n, n2, n3, n4);
            this.mSpriteSmallArrows[0].BringToFront();
            this.mSpriteSmallArrows[1].BringToFront();
            this.mSpriteSmallArrows[2].BringToFront();
            this.mSpriteSmallArrows[3].BringToFront();
        }
    }

    public final void OnTime(int n, int n2) {
        super.OnTime(n, n2);
        if (this.mAnimState == 0 || this.mAnimState == 1) {
            if (this.mTimeToOpen + n2 < 500) {
                this.mTimeToOpen += n2;
            } else {
                this.mTimeToOpen = 500;
                if (this.mAnimState == 0) {
                    this.mShapeRedUp.SetVisible(false);
                    this.mShapeRedDown.SetVisible(false);
                }
            }
            if (this.mAnimState == 0) {
                this.mShapeRedUp.SetSize(GE_MapAnnotation.GetRectWidthSurfaceAnimOpen(), (short)(GE_MapAnnotation.GetRectHeightSurfaceAnimOpen() / 2 - this.mTimeToOpen * GE_MapAnnotation.GetRectHeightSurfaceAnimOpen() / 2 / 500));
                this.mShapeRedDown.SetTopLeft(GE_MapAnnotation.GetRectLeftSurfaceAnimOpen(), (short)(GE_MapAnnotation.GetRectTopSurfaceAnimOpen() + GE_MapAnnotation.GetRectHeightSurfaceAnimOpen() / 2 + this.mTimeToOpen * GE_MapAnnotation.GetRectHeightSurfaceAnimOpen() / 2 / 500));
                this.mShapeRedDown.SetSize(GE_MapAnnotation.GetRectWidthSurfaceAnimOpen(), (short)(GE_MapAnnotation.GetRectHeightSurfaceAnimOpen() % 2 + GE_MapAnnotation.GetRectHeightSurfaceAnimOpen() / 2 - this.mTimeToOpen * GE_MapAnnotation.GetRectHeightSurfaceAnimOpen() / 2 / 500));
            } else if (this.mAnimState == 1) {
                this.mShapeRedUp.SetSize(GE_MapAnnotation.GetRectWidthSurfaceAnimOpen(), (short)(this.mTimeToOpen * GE_MapAnnotation.GetRectHeightSurfaceAnimOpen() / 2 / 500 + GE_MapAnnotation.GetRectHeightSurfaceAnimOpen() % 2));
                this.mShapeRedDown.SetTopLeft(GE_MapAnnotation.GetRectLeftSurfaceAnimOpen(), (short)(GE_MapAnnotation.GetRectTopSurfaceAnimOpen() + GE_MapAnnotation.GetRectHeightSurfaceAnimOpen() - this.mTimeToOpen * GE_MapAnnotation.GetRectHeightSurfaceAnimOpen() / 2 / 500));
                this.mShapeRedDown.SetSize(GE_MapAnnotation.GetRectWidthSurfaceAnimOpen(), (short)(GE_MapAnnotation.GetRectHeightSurfaceAnimOpen() % 2 + this.mTimeToOpen * GE_MapAnnotation.GetRectHeightSurfaceAnimOpen() / 2 / 500));
            }
            if (this.mTimeToOpen == 500) {
                this.mAnimState = 2;
            }
        }
    }

    public static void SaveAnnotation(int n, int n2, int n3) {
        GameApp.Get().GetScenarioContext().ModifyAnnotationsRoom(n, n2, n3);
    }

    public final void UpdateSuspicions(int n) {
        this.mCrimeRoomContents[n].SetAnnotations(this.GetSuspectIdForSuspicions(n), this.GetWeaponIdForSuspicions(n));
    }

    public final void ActiveShadow(boolean bl) {
        this.mShadow.SetVisible(bl);
        if (bl) {
            this.mShadow.UpdateSimpleShadow();
            this.mShadow.BringToFront();
        }
    }

    public final void DrawArrowsDirection(int n, int n2, int n3, int n4) {
        this.SetVisibleArrowsDirection(false);
        for (int i = 0; i < 4; ++i) {
            int n5 = Constants.publishSceneMapArrowsOffsetYFct();
            if (!this.Move(i, false)) continue;
            this.mSpriteSmallArrows[i].SetViewport(this.mViewportCompleteMap);
            int n6 = Constants.publishSceneMapArrowsOffsetXFct();
            switch (i) {
                case 0: {
                    this.mSpriteSmallArrows[i].SetTopLeft((short)(((n3 + n + 1) * this.GetTileWidth() - this.mSpriteSmallArrows[i].mRect_width) / 2 + this.mOffsetX), (short)(n2 * this.GetTileHeight() + this.mOffsetY - this.mSpriteSmallArrows[i].mRect_height - n5));
                    break;
                }
                case 1: {
                    this.mSpriteSmallArrows[i].SetTopLeft((short)(((n3 + n + 1) * this.GetTileWidth() - this.mSpriteSmallArrows[i].mRect_width) / 2 + this.mOffsetX), (short)((n4 + 1) * this.GetTileHeight() + this.mOffsetY + 0 + n5));
                    break;
                }
                case 2: {
                    this.mSpriteSmallArrows[i].SetTopLeft((short)(n * this.GetTileWidth() + this.mOffsetX - this.mSpriteSmallArrows[i].mRect_width - n6), (short)(((n4 + n2 + 1) * this.GetTileHeight() - this.mSpriteSmallArrows[i].mRect_height) / 2 + this.mOffsetY));
                    break;
                }
                case 3: {
                    this.mSpriteSmallArrows[i].SetTopLeft((short)((n3 + 1) * this.GetTileWidth() + this.mOffsetX + n6), (short)(((n4 + n2 + 1) * this.GetTileHeight() - this.mSpriteSmallArrows[i].mRect_height) / 2 + this.mOffsetY));
                }
            }
            this.mSpriteSmallArrows[i].SetVisible(true);
            this.mSpriteSmallArrows[i].BringToFront();
        }
    }

    public final void SetVisibleArrowsDirection(boolean bl) {
        this.mSpriteSmallArrows[0].SetVisible(bl);
        this.mSpriteSmallArrows[1].SetVisible(bl);
        this.mSpriteSmallArrows[2].SetVisible(bl);
        this.mSpriteSmallArrows[3].SetVisible(bl);
    }

    public final void SetSuspicionsVisibility(boolean bl) {
        int n;
        this.mSuspicionsEnabled = bl;
        int n2 = this.mCurrentMansion.mWidth;
        for (int i = 0; i < this.mCurrentMansion.mHeight; ++i) {
            for (int j = 0; j < this.mCurrentMansion.mWidth; ++j) {
                n = this.mCurrentMansion.GetRoomId(j, i);
                if (n <= -1 || this.mCurrentMansion.IsInHall(j, i)) continue;
                this.mSpriteMapRooms[j + n2 * i].SetBitmap(this.GetBitmapRoomTile(n));
            }
        }
        for (n = 0; n < 12; ++n) {
            if (!GameApp.Get().GetScenarioContext().IsRoomExist(n)) continue;
            this.UpdateSuspicions(n);
            this.UpdateVisualsContent(n);
            this.mCrimeRoomContents[n].BringToFront();
        }
    }

    public static short GetRectLeftSurfaceAnimOpen() {
        return (short)Constants.geMapBigViewportOffsetXFct();
    }

    public static short GetRectTopSurfaceAnimOpen() {
        return (short)(Constants.geMapBigViewportOffsetYFct() - Constants.geMapBigBlackLineHeightFct());
    }

    public static short GetRectWidthSurfaceAnimOpen() {
        return (short)Constants.geMapBigViewportWidthFct();
    }

    public static short GetRectHeightSurfaceAnimOpen() {
        return (short)(Constants.geMapBigViewportHeightFct() + 2 * Constants.geMapBigBlackLineHeightFct());
    }

    public final void UpdateVisualsContent(int n) {
        this.UpdateCharacter(n, this.mCrimeRoomContents[n].GetSuspect());
        this.UpdateWeapon(n, this.mCrimeRoomContents[n].GetWeapon());
    }

    public final FlBitmap GetBitmapRoomTile(int n) {
        FlBitmap flBitmap = GameApp.Get().GetScenarioContext().mRoomVisibility.GetRoomVisibility(n) || !this.mSuspicionsEnabled ? this.mBitmapBackgroundRoom : this.mBitmapBackgroundRoomCleared;
        return flBitmap;
    }

    public final boolean Move(int n) {
        return this.Move(n, true);
    }

    public final boolean OnPenUp(byte by, short[] sArray) {
        boolean bl = false;
        if (this.Contains(sArray)) {
            if (this.mRoomLocked && !(bl = this.mCrimeRoomContents[this.mCurrentSelectedRoom].OnPenUp(by, sArray)) && this.GetRoomIdUnderThePen(sArray) == this.mCurrentSelectedRoom) {
                this.OnUnselectedRoom();
                bl = true;
            }
            if (!bl && !this.mRoomLocked) {
                bl = true;
                if (ClueUtils.Contains(this.mSpriteSmallArrows[0], sArray)) {
                    this.Move(0);
                } else if (ClueUtils.Contains(this.mSpriteSmallArrows[1], sArray)) {
                    this.Move(1);
                } else if (ClueUtils.Contains(this.mSpriteSmallArrows[2], sArray)) {
                    this.Move(2);
                } else if (ClueUtils.Contains(this.mSpriteSmallArrows[3], sArray)) {
                    this.Move(3);
                } else {
                    bl = false;
                }
            }
        }
        return bl || !this.mRoomLocked && super.OnPenUp(by, sArray);
    }

    public final void GetEntryPoints() {
        int n;
        super.GetEntryPoints();
        this.mBitmapBackgroundCorridor = FlBitmap.Cast$5822fcd3(this.mCrimeMapPackage.mPackage.GetEntryPoint(3));
        this.mBitmapBackgroundRoom = FlBitmap.Cast$5822fcd3(this.mCrimeMapPackage.mPackage.GetEntryPoint(4));
        this.mBitmapBackgroundRoomCleared = FlBitmap.Cast$5822fcd3(this.mCrimeMapPackage.mPackage.GetEntryPoint(5));
        this.mSpriteBackgroundOutside = Sprite.Cast$46e644cd(this.mCrimeMapPackage.mPackage.GetEntryPoint(6));
        this.mSelectedRoomShape.SetColor(this.GetSelectionColor());
        this.mSelectedRoomShape.SetVisible(false);
        this.mSpriteWindrose = Sprite.Cast$46e644cd(this.mCrimeMapPackage.mPackage.GetEntryPoint(1));
        for (n = 0; n < 12; ++n) {
            this.mCrimeRoomContents[n].GetEntryPoints();
        }
        this.mWeapons.GetEntryPoints();
        this.mShadow.GetEntryPoints();
        for (n = 0; n < 4; ++n) {
            this.mSpriteSmallArrows[n] = Sprite.Cast$46e644cd(this.mPackageSmallArrows.mPackage.GetEntryPoint(n));
        }
    }

    public final void Init(Viewport viewport) {
        super.Init(viewport);
        for (int i = 0; i < 4; ++i) {
            this.mSpriteSmallArrows[i].SetViewport(this.mViewportCompleteMap);
            this.mSpriteSmallArrows[i].SetVisible(false);
            this.mSpriteSmallArrows[i].mPassThrough = false;
        }
        this.SetVisible(false);
    }

    public final void StartOpeningAnims() {
        this.mShapeRedUp.SetVisible(true);
        this.mShapeRedDown.SetVisible(true);
        this.mTimeToOpen = 0;
        this.mAnimState = 0;
    }

    public final boolean IsOpeningAnimsEnded() {
        return this.mAnimState == 2;
    }

    public final void StartClosingAnims() {
        this.mShapeRedUp.SetVisible(true);
        this.mShapeRedDown.SetVisible(true);
        this.mTimeToOpen = 0;
        this.mAnimState = 1;
    }

    public final boolean IsClosingAnimsEnded() {
        return this.mAnimState == 2;
    }

    public final boolean OnKeyDownOrRepeat(int n) {
        if (this.mRoomLocked && this.mCrimeRoomContents[this.mCurrentSelectedRoom].IsAnimationFinished()) {
            switch (n) {
                case 1: {
                    this.mCrimeRoomContents[this.mCurrentSelectedRoom].SelectAnnotations(false);
                    this.UpdateVisualsContent(this.mCurrentSelectedRoom);
                    return true;
                }
                case 3: {
                    this.mCrimeRoomContents[this.mCurrentSelectedRoom].SetActive(1);
                    this.UpdateVisualsContent(this.mCurrentSelectedRoom);
                    return true;
                }
                case 4: {
                    this.mCrimeRoomContents[this.mCurrentSelectedRoom].SetActive(2);
                    this.UpdateVisualsContent(this.mCurrentSelectedRoom);
                    return true;
                }
            }
        }
        return super.OnKeyDownOrRepeat(n);
    }
}

