/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_GameEntity;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.Sprite;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Viewport;

public final class GE_Clock
extends GE_GameEntity {
    public TimeSystem mClockAnimationTimeSystem;
    public Sprite mSpriteClock;
    public int mCurrentTime = -1;
    public Text mTextSmallClock;
    public int mCurrentAnimation = 0;
    public int mTimeAnimation;
    public int mPreviousTime = -1;
    public Text mTextBigClock;
    public Viewport mClockAnimationViewport;

    public final void Load() {
        super.Load();
        this.mPackage = GameLibrary.GetPackage(196614);
    }

    public final void BringToFront() {
        this.mClockAnimationViewport.BringToFront();
        this.mComponentViewport.BringToFront();
    }

    public final void Unload() {
        this.mSpriteClock = null;
        this.mTextSmallClock = null;
        this.mTextBigClock = null;
        if (this.mClockAnimationViewport != null) {
            this.mClockAnimationViewport.SetViewport(null);
            this.mClockAnimationViewport = null;
        }
        Utilities.StopTimeSystem(this.mClockAnimationTimeSystem);
        this.mClockAnimationTimeSystem = null;
        this.UnRegisterInGlobalTime();
        super.Unload();
        GameLibrary.ReleasePackage(this.mPackage);
    }

    public final boolean IsLoaded() {
        return this.mPackage.IsLoaded();
    }

    public GE_Clock(BaseScene baseScene) {
        super(baseScene);
    }

    public final void Init(Viewport viewport) {
        this.mClockAnimationViewport.SetViewport(viewport);
        this.mClockAnimationViewport.SetVisible(false);
        super.Init(viewport);
        this.Update();
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        this.mComponentViewport = Viewport.Cast$7c352e71(this.mPackage.mPackage.GetEntryPoint(0));
        this.mSpriteClock = Sprite.Cast$46e644cd(this.mPackage.mPackage.GetEntryPoint(1));
        this.mTextSmallClock = Text.Cast$21bacd23(this.mPackage.mPackage.GetEntryPoint(2));
        this.mTextBigClock = Text.Cast$21bacd23(this.mPackage.mPackage.GetEntryPoint(3));
        this.mClockAnimationTimeSystem = TimeSystem.Cast$3b277f7b(this.mPackage.mPackage.GetEntryPoint(4));
        this.mClockAnimationViewport = Viewport.Cast$7c352e71(this.mPackage.mPackage.GetEntryPoint(5));
    }

    public final boolean IsAnimsEnded() {
        return this.mCurrentAnimation == 0;
    }

    public final void Hide() {
        this.mClockAnimationViewport.SetVisible(false);
        this.mTextBigClock.SetVisible(false);
        this.mSpriteClock.SetVisible(false);
        this.mTextSmallClock.SetVisible(false);
    }

    public final void ShowStatic() {
        this.mSpriteClock.SetVisible(true);
        this.mTextSmallClock.SetVisible(true);
    }

    private void SetCaptionTime(Text text, int n, int n2) {
        Object object = new FlString(n);
        ((FlString)object).AddAssign(StringUtils.CreateStringPtr(":"));
        if (n2 < 10) {
            ((FlString)object).AddAssign(new FlString(0));
        }
        ((FlString)object).AddAssign(new FlString(n2));
        Utilities.SetCaption(text, (FlString)object);
    }

    public final void Update() {
        this.mPreviousTime = this.mCurrentTime;
        this.mCurrentTime = GameApp.Get().GetScenarioContext().GetCurrentTime();
        if (this.mPreviousTime == -1 || this.mPreviousTime <= this.mCurrentTime) {
            this.mTextBigClock.SetVisible(false);
            this.SetCaptionTime(this.mTextSmallClock, this.mCurrentTime, 0);
            return;
        }
        --this.mPreviousTime;
        this.mClockAnimationViewport.SetVisible(true);
        this.mSpriteClock.SetVisible(false);
        this.mCurrentAnimation = 1;
        Utilities.StartTimeSystem(this.mClockAnimationTimeSystem);
        this.mTimeAnimation = 0;
        this.RegisterInGlobalTime();
    }

    public final void OnTime(int n, int n2) {
        Text text = null;
        int n3 = 0;
        if (this.mCurrentAnimation == 1) {
            text = this.mTextSmallClock;
            this.mTextBigClock.SetVisible(false);
            if (this.mClockAnimationTimeSystem.mTotalTime >= Constants.clockUpdateEndTimeFct()) {
                Utilities.StopTimeSystem(this.mClockAnimationTimeSystem);
                this.mCurrentAnimation = 2;
            }
            n3 = 59;
        } else if (this.mCurrentAnimation == 2) {
            text = this.mTextBigClock;
            this.mTextSmallClock.SetVisible(false);
            this.mTextBigClock.SetVisible(true);
            this.mTimeAnimation += n2;
            if (this.mTimeAnimation + n2 > Constants.clockTextTimeCountdownFct()) {
                n3 = this.mTimeAnimation / Constants.clockTextTimeCountdownFct();
                this.mTimeAnimation %= Constants.clockTextTimeCountdownFct();
                this.mPreviousTime -= n3;
                if (this.mPreviousTime <= this.mCurrentTime) {
                    this.mPreviousTime = this.mCurrentTime;
                    this.mCurrentAnimation = 3;
                    Utilities.StartTimeSystemInverse(this.mClockAnimationTimeSystem, Constants.clockUpdateEndTimeFct());
                }
            }
            n3 = (Constants.clockTextTimeCountdownFct() - this.mTimeAnimation) * 59 / Constants.clockTextTimeCountdownFct();
        } else if (this.mCurrentAnimation == 3) {
            text = this.mTextSmallClock;
            this.mTextSmallClock.SetVisible(true);
            this.mTextBigClock.SetVisible(false);
            if (this.mClockAnimationTimeSystem.mTotalTime < 0) {
                Utilities.StopTimeSystem(this.mClockAnimationTimeSystem);
                this.mCurrentAnimation = 0;
                this.UnRegisterInGlobalTime();
                this.mClockAnimationViewport.SetVisible(false);
                this.mSpriteClock.SetVisible(true);
            }
        }
        this.SetCaptionTime(text, this.mPreviousTime, n3);
    }
}

