/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FrameworkGlobals;
import ca.jamdat.flight.SpecConstants;

public final class FlKeyManager {
    public boolean mFlightAltLock;
    public boolean mShiftEnabled;
    public boolean mGameAltLock;

    private static int FlightKeyToUpper(int n) {
        int n2 = n;
        if (n >= 97 && n <= 122) {
            n2 = n & 0xFFFFFFDF;
        }
        return n2;
    }

    private static int AsciiToFlightKey(int n) {
        if (n >= 32 && n <= 126) {
            return n;
        }
        switch (n) {
            case 8: {
                return 10;
            }
            case 9: {
                return 32;
            }
            case 13: {
                return 31;
            }
            case 128: {
                return 15;
            }
            case 163: {
                return 16;
            }
            case 165: {
                return 17;
            }
            case 192: {
                return 18;
            }
            case 194: {
                return 19;
            }
            case 196: {
                return 29;
            }
            case 199: {
                return 20;
            }
            case 200: {
                return 21;
            }
            case 201: {
                return 22;
            }
            case 202: {
                return 23;
            }
            case 203: {
                return 24;
            }
            case 206: {
                return 25;
            }
            case 207: {
                return 26;
            }
            case 209: {
                return 30;
            }
            case 212: {
                return 27;
            }
            case 214: {
                return 28;
            }
            case 220: {
                return 127;
            }
            case 224: {
                return 128;
            }
            case 226: {
                return 129;
            }
            case 228: {
                return 130;
            }
            case 231: {
                return 132;
            }
            case 232: {
                return 131;
            }
            case 233: {
                return 133;
            }
            case 234: {
                return 134;
            }
            case 235: {
                return 135;
            }
            case 238: {
                return 136;
            }
            case 239: {
                return 137;
            }
            case 241: {
                return 140;
            }
            case 244: {
                return 138;
            }
            case 246: {
                return 139;
            }
            case 252: {
                return 141;
            }
            case 8364: {
                return 15;
            }
        }
        return 0;
    }

    private boolean GetKeyAltMode() {
        return this.mGameAltLock || this.mFlightAltLock;
    }

    private void ManageCapsMode(int n, boolean bl) {
        if (n == 0) {
            return;
        }
        if (145 == n && !bl) {
            this.ToggleKeyShiftMode();
        }
    }

    private void ManageSymbolsMode(int n, boolean bl) {
        if (n == 0) {
            return;
        }
        if (144 == n && !bl) {
            this.ToggleKeyAltMode();
        }
    }

    private void ToggleKeyShiftMode() {
        boolean bl = !this.mShiftEnabled;
        this.mShiftEnabled = bl;
    }

    private void ToggleKeyAltMode() {
        boolean bl = !this.mFlightAltLock;
        this.mFlightAltLock = bl;
    }

    public final int ToFlightKey(int n, boolean bl) {
        int n2 = this.KeyLayoutToFlightKey(n);
        this.ManageSymbolsMode(n2, bl);
        this.ManageCapsMode(n2, bl);
        n2 = this.KeyLayoutToFlightKey(n);
        if (this.mShiftEnabled) {
            return FlKeyManager.FlightKeyToUpper(n2);
        }
        return n2;
    }

    public FlKeyManager() {
        FlApplication.GetInstance().MapKey(7, 5);
        FlApplication.GetInstance().MapKey(13, 5);
        FlApplication.GetInstance().MapKey(9, 6);
        FlApplication.GetInstance().MapKey(10, 6);
        FlApplication.GetInstance().MapKey(14, 6);
        FlApplication.GetInstance().MapKey(31, 5);
    }

    private int KeyLayoutToFlightKey(int n) {
        if (this.GetKeyAltMode()) {
            int n2 = n;
            if (n >= 65 && n <= 90) {
                n2 = n - 65 + 97;
            }
            switch (n2) {
                case 98: {
                    return 56;
                }
                case 101: {
                    return 41;
                }
                case 102: {
                    return 52;
                }
                case 103: {
                    return 53;
                }
                case 104: {
                    return 54;
                }
                case 105: {
                    return 43;
                }
                case 106: {
                    return 35;
                }
                case 107: {
                    return 45;
                }
                case 108: {
                    return 39;
                }
                case 109: {
                    return 48;
                }
                case 110: {
                    return 57;
                }
                case 111: {
                    return 61;
                }
                case 113: {
                    return 34;
                }
                case 114: {
                    return 49;
                }
                case 116: {
                    return 50;
                }
                case 117: {
                    return 42;
                }
                case 118: {
                    return 55;
                }
                case 119: {
                    return 40;
                }
                case 121: {
                    return 51;
                }
                case 44: {
                    return 59;
                }
                case 46: {
                    return 58;
                }
                case 64: {
                    return 47;
                }
                case 63: {
                    return 33;
                }
            }
        }
        if (n == SpecConstants.GetKeyCodeEnter()) {
            return 31;
        }
        if (n == SpecConstants.GetKeyCodeAlt()) {
            return 144;
        }
        if (n == SpecConstants.GetKeyCodeCaps()) {
            return 145;
        }
        if (n == SpecConstants.GetKeyCodeShift()) {
            return 145;
        }
        if (n == SpecConstants.GetKeyCodeMenu()) {
            return 8;
        }
        if (n == SpecConstants.GetKeyCodeSpace()) {
            return 32;
        }
        if (n == SpecConstants.GetKeyCodePound()) {
            return 35;
        }
        if (n == SpecConstants.GetKeyCodeStar()) {
            return 42;
        }
        return FlKeyManager.ConstToFlightKey(n);
    }

    public static FlKeyManager GetInstance() {
        FrameworkGlobals frameworkGlobals = FrameworkGlobals.GetInstance();
        if (frameworkGlobals.mFlKeyManager == null) {
            frameworkGlobals.mFlKeyManager = new FlKeyManager();
        }
        return frameworkGlobals.mFlKeyManager;
    }

    private static int ConstToFlightKey(int n) {
        if (n >= 48 && n <= 57) {
            return n - 48 + 48;
        }
        switch (n) {
            case 42: {
                return 42;
            }
            case 35: {
                return 35;
            }
            case 0: {
                return 0;
            }
        }
        int n2 = FlKeyManager.AsciiToFlightKey(n);
        if (n2 != 0) {
            return n2;
        }
        try {
            switch (clue.GetCurrentScene().getGameAction(n)) {
                case 1: {
                    n2 = 1;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 4;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
                case 8: {
                    n2 = 7;
                }
            }
        }
        catch (Exception exception) {}
        return n2;
    }
}

