/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlString;
import ca.jamdat.flight.JavaBasicFileStream;
import ca.jamdat.flight.Memory;
import ca.jamdat.flight.Stream;

public final class FileStream
extends Stream {
    public byte mFileMode;
    public int mDataEndPos;
    public int mBufferSize;
    public int mCurrentPos;
    public int mNativeFileSize;
    public byte[] mBuffer;
    public boolean mIsCRCValid;
    public FlString mFileName;
    public byte[] mTmpArray = new byte[4];

    public static boolean FileExists(FlString flString) {
        return JavaBasicFileStream.FileExists(flString);
    }

    private FileStream(FlString flString, byte by, int n, boolean bl) {
        this.mFileMode = by;
        this.mNativeFileSize = -1;
        this.mFileName = new FlString(flString);
        switch (this.mFileMode) {
            case 0: {
                this.InitReadMode$13462e();
                return;
            }
            case 1: 
            case 2: {
                int n2 = this.GetHeaderSize();
                this.mBufferSize = n + n2;
                this.mBuffer = new byte[this.mBufferSize];
                this.mNativeFileSize = n2;
                this.mCurrentPos = n2;
                this.mDataEndPos = n2;
                this.mIsCRCValid = true;
            }
        }
    }

    public final int Read(byte[] byArray, int n) {
        System.arraycopy(this.mBuffer, this.mCurrentPos, byArray, 0, n);
        this.mCurrentPos += n;
        return n;
    }

    public final int Write(byte[] byArray, int n) {
        System.arraycopy(byArray, 0, this.mBuffer, this.mCurrentPos, n);
        this.mCurrentPos += n;
        if (this.mCurrentPos > this.mDataEndPos) {
            this.mDataEndPos = this.mCurrentPos;
            this.mNativeFileSize = this.mCurrentPos;
        }
        return n;
    }

    public final void WriteLong(int n) {
        byte[] byArray = this.mTmpArray;
        byArray[0] = (byte)(0xFF & n >> 24);
        byArray[1] = (byte)(0xFF & n >> 16);
        byArray[2] = (byte)(0xFF & n >> 8);
        byArray[3] = (byte)(0xFF & n);
        this.Write(byArray, 4);
    }

    private void InitReadMode$13462e() {
        this.GetNativeFileSize();
        this.mBufferSize = this.mNativeFileSize;
        if (this.mBufferSize > 0) {
            this.mBuffer = new byte[this.mBufferSize];
        }
        if (this.mBuffer == null || this.RefreshBuffer$134621() == -1) {
            this.mIsCRCValid = false;
            return;
        }
        this.mIsCRCValid = this.VerifyCRC();
    }

    private boolean VerifyCRC() {
        if (this.mNativeFileSize > this.GetHeaderSize()) {
            this.mCurrentPos = 0;
            this.mCurrentPos = this.GetHeaderSize();
            return (int)Memory.CalculateCRC(this.mBuffer, this.GetHeaderSize(), this.mDataEndPos - this.GetHeaderSize()) == this.ReadLong();
        }
        return false;
    }

    private void AssignCRC() {
        this.mCurrentPos = 0;
        this.WriteLong((int)Memory.CalculateCRC(this.mBuffer, this.GetHeaderSize(), this.mDataEndPos - this.GetHeaderSize()));
    }

    private int RefreshBuffer$134621() {
        int n;
        this.mBuffer = JavaBasicFileStream.ReadFile(this.mFileName);
        if (this.mBuffer == null) {
            return -1;
        }
        this.mNativeFileSize = this.mBufferSize = this.mBuffer.length;
        this.mDataEndPos = n = this.mBufferSize;
        this.mCurrentPos = this.GetHeaderSize();
        return n;
    }

    private int GetNativeFileSize() {
        int n;
        if (this.mNativeFileSize < 0 && (n = JavaBasicFileStream.GetFileSize(this.mFileName)) > 0) {
            this.mNativeFileSize = n;
        }
        return this.mNativeFileSize;
    }

    public final int ReadLong() {
        byte[] byArray = this.mBuffer;
        int n = this.mCurrentPos;
        this.mCurrentPos += 4;
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static int GetCRCSize() {
        return 4;
    }

    private int GetHeaderSize() {
        return FileStream.GetCRCSize();
    }

    public final void Close() {
        if (this.mFileMode != 0) {
            this.AssignCRC();
            JavaBasicFileStream.WriteFile$53e38fa(this.mFileName, this.mBuffer, this.mDataEndPos);
        }
        this.mBuffer = null;
        this.mFileName = null;
    }

    public FileStream(FlString flString, byte by, int n) {
        this(flString, by, n, true);
    }
}

