/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FileSegmentStream;
import ca.jamdat.flight.FileStream;
import ca.jamdat.flight.FlString;

public final class FileHandler {
    public FlString mPathname;
    public int mWritingCount;
    public int mSegmentCount;
    public FileSegmentStream[] mSegmentStreams = null;

    private boolean OnReadSync() {
        if (FileStream.FileExists(this.mPathname)) {
            FileStream fileStream = new FileStream(this.mPathname, 0, this.GetSize());
            this.ReadFromFileStream(fileStream);
            fileStream.Close();
        }
        return true;
    }

    private boolean OnWriteSync() {
        if (this.AreSegmentsModified()) {
            FileStream fileStream = new FileStream(this.mPathname, 1, this.GetSize());
            this.WriteToFileStream(fileStream);
            fileStream.Close();
        }
        return true;
    }

    private int GetSize() {
        int n = 8;
        for (int i = 0; i < this.mSegmentCount; ++i) {
            n += this.mSegmentStreams[i].GetSize();
        }
        return n;
    }

    public FileHandler(FlString flString, FileSegmentStream[] fileSegmentStreamArray, int n) {
        this.mPathname = new FlString(flString);
        this.mSegmentCount = n;
        this.mSegmentStreams = fileSegmentStreamArray;
    }

    public final void SetPathname(FlString flString) {
        this.mPathname.Assign(flString);
    }

    public final boolean OnSerialize(int n) {
        n = n == 0 ? (int)(this.OnReadSync() ? 1 : 0) : (int)(this.OnWriteSync() ? 1 : 0);
        return n != 0;
    }

    public final FileSegmentStream GetSegmentStream$6cc0491b(int n) {
        FileSegmentStream fileSegmentStream = this.mSegmentStreams[n];
        fileSegmentStream.SetMode$13462e();
        return fileSegmentStream;
    }

    private void ReadFromFileStream(FileStream fileStream) {
        this.ResetSerializableData();
        if (fileStream.mIsCRCValid && fileStream.ReadLong() == 809029632) {
            this.mWritingCount = fileStream.ReadLong();
            for (int i = 0; i < this.mSegmentCount; ++i) {
                this.mSegmentStreams[i].Read(fileStream);
            }
        }
    }

    private void WriteToFileStream(FileStream fileStream) {
        int n;
        fileStream.WriteLong(809029632);
        this.mWritingCount = n = this.mWritingCount + 1;
        fileStream.WriteLong(n);
        for (n = 0; n < this.mSegmentCount; ++n) {
            this.mSegmentStreams[n].Write(fileStream);
        }
    }

    public final void ResetSerializableData() {
        for (int i = 0; i < this.mSegmentCount; ++i) {
            this.mSegmentStreams[i].SetValidDataFlag(false);
        }
    }

    private boolean AreSegmentsModified() {
        for (int i = 0; i < this.mSegmentCount; ++i) {
            if (!this.mSegmentStreams[i].mModified) continue;
            return true;
        }
        return false;
    }
}

