/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_MapAnnotation;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.ToolScene;

public final class CrimeScene
extends ToolScene {
    public GE_MapAnnotation mMap;

    public CrimeScene() {
        super(30, 2916441);
        this.AddType(4);
        GameApp.Get().GetScenarioContext().OnEvent(8);
    }

    public final void Initialize() {
        super.Initialize();
        this.mMap.Init(this.mViewport);
        this.mMap.SetVisible(true);
        int n = GameApp.Get().GetScenarioContext().mCurrentRoomIndex;
        if (n == -1) {
            n = GameApp.Get().GetScenarioContext().GetCurrentRoom().mRoomId;
        }
        this.mMap.SelectRoom(n);
        this.mMap.UpdateAllSuspicions(true);
        this.mNavTab.Init(this.mViewport, 0);
        this.mTicker.Init(this.mViewport);
        this.mDialogBox.Init(this.mViewport);
        this.UpdateTicker();
        this.Refresh();
    }

    public final void Load() {
        super.Load();
        this.mMap = new GE_MapAnnotation(this, GameApp.Get().GetScenarioContext().GetMansion());
        this.mMap.Load();
    }

    public final boolean OnCommand(int n) {
        boolean bl = false;
        if (n == 80) {
            this.mMap.LockCurrentRoom(true);
            this.UpdateSoftkeys(7, 81, 3, 82);
            bl = true;
            this.UpdateTicker();
        } else if (n == 81 || n == 82) {
            this.SetDefaultSoftkeys();
            if (n == 81) {
                this.mMap.SaveAnnotations();
                GameApp.Get().GetScenarioContext().OnEvent(32, this.mMap.mCurrentSelectedRoom);
                this.Refresh();
                this.RefreshNotifier();
            }
            this.mMap.LockCurrentRoom(false);
            bl = true;
            this.UpdateTicker();
        } else if (n == -83) {
            this.mMap.SetAnnotation(1);
            this.TakeFocus();
        } else if (n == -84) {
            this.mMap.SetAnnotation(2);
            this.TakeFocus();
        } else if (n == 101) {
            this.OnKeyDownOrRepeat(1);
            this.TakeFocus();
        }
        return bl || super.OnCommand(n);
    }

    public final void Unload() {
        if (this.mMap != null) {
            this.mMap.Unload();
            this.mMap = null;
        }
        super.Unload();
    }

    public final boolean IsLoaded() {
        return this.mMap.IsLoaded() && super.IsLoaded();
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        this.mMap.GetEntryPoints();
    }

    public final void SetDefaultSoftkeys() {
        this.UpdateSoftkeys(10, 80, 1, -60);
    }

    public final void StartOpeningAnims() {
        super.StartOpeningAnims();
        this.mMap.StartOpeningAnims();
    }

    public final boolean IsOpeningAnimsEnded() {
        return this.mMap.IsOpeningAnimsEnded();
    }

    public final void StartClosingAnims() {
        super.StartClosingAnims();
        this.mMap.StartClosingAnims();
    }

    public final boolean IsClosingAnimsEnded() {
        return this.mMap.IsClosingAnimsEnded();
    }

    public final void SetComponentFocus() {
    }

    private void UpdateTicker() {
        this.mTicker.StopTicker();
        if (!this.mMap.mRoomLocked) {
            this.SetSelectRoomTickerMsg();
            return;
        }
        if (this.mMap.HasSuspectSelected()) {
            int n = this.mMap.GetSuspectIDSelected();
            if (n != -1) {
                FlString flString = new FlString(FlString.Cast$50263e8f(this.mPackage.GetEntryPoint(15)));
                ClueUtils.ReplaceAllSuspectIDInString(flString, n);
                this.mTicker.SetTickerMessage(flString);
                return;
            }
            FlString flString = new FlString(FlString.Cast$50263e8f(this.mPackage.GetEntryPoint(18)));
            ClueUtils.ReplaceAllRoomIDInString(flString, this.mMap.mCurrentSelectedRoom);
            this.mTicker.SetTickerMessage(flString);
            return;
        }
        if (this.mMap.HasWeaponSelected()) {
            int n = this.mMap.GetWeaponIDSelected();
            if (n != -1) {
                FlString flString = new FlString(FlString.Cast$50263e8f(this.mPackage.GetEntryPoint(16)));
                ClueUtils.ReplaceAllWeaponIDInString(flString, n);
                this.mTicker.SetTickerMessage(flString);
                return;
            }
            FlString flString = new FlString(FlString.Cast$50263e8f(this.mPackage.GetEntryPoint(19)));
            ClueUtils.ReplaceAllRoomIDInString(flString, this.mMap.mCurrentSelectedRoom);
            this.mTicker.SetTickerMessage(flString);
        }
    }

    private void SetSelectRoomTickerMsg() {
        FlString flString = new FlString(FlString.Cast$50263e8f(this.mPackage.GetEntryPoint(17)));
        ClueUtils.ReplaceAllRoomIDInString(flString, this.mMap.mCurrentSelectedRoom);
        if (GameApp.Get().GetScenarioContext().IsRoomVisited(this.mMap.mCurrentSelectedRoom)) {
            flString.AddAssign(StringUtils.CreateStringPtr(" "));
            flString.AddAssign(ClueUtils.GetStringForRoomItems(this.mMap.mCurrentSelectedRoom));
        }
        this.mTicker.SetTickerMessage(flString);
    }

    public final boolean OnKeyDownOrRepeat(int n) {
        boolean bl = false;
        if (!this.mMap.mRoomLocked && !this.mDialogBox.mIsActive && this.mMap.IsRoomContentsAnimationFinished()) {
            switch (n) {
                case 4: {
                    this.mMap.Move(3);
                    bl = true;
                    break;
                }
                case 3: {
                    this.mMap.Move(2);
                    bl = true;
                    break;
                }
                case 1: {
                    this.mMap.Move(0);
                    bl = true;
                    break;
                }
                case 2: {
                    this.mMap.Move(1);
                    bl = true;
                }
            }
        }
        if (!bl) {
            bl = this.mDialogBox.OnKeyDownOrRepeat(n);
        }
        if (!bl) {
            bl = this.mMap.OnKeyDownOrRepeat(n);
        }
        if (bl) {
            this.UpdateTicker();
        }
        return bl || super.OnKeyDownOrRepeat(n);
    }

    public final boolean OnPenUp(byte by, short[] sArray) {
        boolean bl = false;
        if (!this.mDialogBox.mIsActive && this.mMap.IsRoomContentsAnimationFinished()) {
            bl = this.mMap.OnPenUp(by, sArray);
        }
        return bl || super.OnPenUp(by, sArray);
    }

    public final boolean OnPenDown(byte by, short[] sArray) {
        boolean bl = false;
        if (!this.mDialogBox.mIsActive) {
            bl = this.mMap.OnPenDown(by, sArray);
        }
        return bl || super.OnPenDown(by, sArray);
    }
}

