/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ClueLogger;
import ca.jamdat.flight.ClueMemento;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.FileSegmentStream;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.I_Notifier;
import ca.jamdat.flight.SA_CircularQueue_ClueMemento;
import ca.jamdat.flight.StringUtils;

public final class ClueMementoState
extends I_Notifier {
    public FlString mNotification;
    public boolean mHasNotification;
    public SA_CircularQueue_ClueMemento mMementoQueue = new SA_CircularQueue_ClueMemento(3);

    public ClueMementoState() {
        this.mNotification = StringUtils.CreateStringPtr("");
    }

    public final void OnDelete() {
        while (!this.mMementoQueue.IsEmpty()) {
            this.mMementoQueue.Dequeue().OnDelete();
        }
        this.mMementoQueue.OnDelete();
        this.mMementoQueue = null;
        this.mNotification = null;
    }

    public final void OnEvent(int n, int n2, int n3) {
        if (n == 24) {
            this.OnStartGame();
            return;
        }
        if (n == 5) {
            this.OnConfronted(n2);
            return;
        }
        if (n == 10) {
            this.OnExtensionTimeEnd();
            return;
        }
        if (n == 13) {
            this.OnDualGossip(n2, n3);
            return;
        }
        if (n == 14) {
            this.OnSingleGossip(n2);
            return;
        }
        if (n == 21) {
            this.OnRegularTimeEnd();
            return;
        }
        if (n == 22) {
            this.OnSearched(n2);
            return;
        }
        if (n == 28) {
            this.OnTalked(n2);
        }
    }

    private boolean HasMementoInfo() {
        if (this.mMementoQueue.IsEmpty()) {
            return false;
        }
        return this.mMementoQueue.Peek().GetType() != 7;
    }

    private ClueMemento GetMemento() {
        Object object;
        if (!((ClueMementoState)object).mMementoQueue.IsFull()) {
            object = new ClueMemento();
        } else {
            object = ((ClueMementoState)object).mMementoQueue.Dequeue();
            ((ClueMemento)object).Clear();
        }
        return object;
    }

    public final void Read(FileSegmentStream fileSegmentStream) {
        int n = fileSegmentStream.ReadByte();
        for (int i = 0; i < n; ++i) {
            ClueMemento clueMemento = new ClueMemento();
            clueMemento.Read(fileSegmentStream);
            this.mMementoQueue.Enqueue(clueMemento);
        }
    }

    public final void Write(FileSegmentStream fileSegmentStream) {
        int n = this.mMementoQueue.mCount;
        fileSegmentStream.WriteByte((byte)n);
        for (int i = 0; i < n; ++i) {
            ClueMemento clueMemento = this.mMementoQueue.Dequeue();
            clueMemento.Write(fileSegmentStream);
            this.mMementoQueue.Enqueue(clueMemento);
        }
    }

    private void OnTalked(int n) {
        ClueMemento clueMemento = this.GetMemento();
        clueMemento.SetType(0);
        clueMemento.SetFirstSuspectId(n);
        this.mMementoQueue.Enqueue(clueMemento);
        ClueLogger.Log(clueMemento);
    }

    private void OnConfronted(int n) {
        ClueMemento clueMemento = this.GetMemento();
        clueMemento.SetType(1);
        clueMemento.SetFirstSuspectId(n);
        this.mMementoQueue.Enqueue(clueMemento);
        ClueLogger.Log(clueMemento);
    }

    private void OnDualGossip(int n, int n2) {
        ClueMemento clueMemento = this.GetMemento();
        clueMemento.SetType(4);
        clueMemento.SetFirstSuspectId(n);
        clueMemento.SetSecondSuspectId(n2);
        this.mMementoQueue.Enqueue(clueMemento);
        ClueLogger.Log(clueMemento);
    }

    private void OnSingleGossip(int n) {
        ClueMemento clueMemento = this.GetMemento();
        clueMemento.SetType(3);
        clueMemento.SetFirstSuspectId(n);
        this.mMementoQueue.Enqueue(clueMemento);
        ClueLogger.Log(clueMemento);
    }

    private void OnExtensionTimeEnd() {
        ClueMemento clueMemento = this.GetMemento();
        clueMemento.SetType(6);
        this.mMementoQueue.Enqueue(clueMemento);
        ClueLogger.Log(clueMemento);
    }

    private void OnRegularTimeEnd() {
        ClueMemento clueMemento = this.GetMemento();
        clueMemento.SetType(5);
        this.mMementoQueue.Enqueue(clueMemento);
        ClueLogger.Log(clueMemento);
    }

    private void OnSearched(int n) {
        ClueMemento clueMemento = this.GetMemento();
        clueMemento.SetType(2);
        clueMemento.SetItemId(n);
        this.mMementoQueue.Enqueue(clueMemento);
        ClueLogger.Log(clueMemento);
    }

    private void OnStartGame() {
        if (this.HasMementoInfo()) {
            this.mHasNotification = true;
        }
    }

    public final FlString GetNotification() {
        SA_CircularQueue_ClueMemento sA_CircularQueue_ClueMemento = new SA_CircularQueue_ClueMemento(3);
        FlString flString = new FlString(StringUtils.CreateString("\n"));
        FlString flString2 = new FlString(StringUtils.CreateString(""));
        while (!this.mMementoQueue.IsEmpty()) {
            Object object = this.mMementoQueue.Dequeue();
            sA_CircularQueue_ClueMemento.Enqueue((ClueMemento)object);
            object = ClueUtils.GetStringFromMemento((ClueMemento)object);
            if (!flString2.IsEmpty()) {
                ((FlString)object).AddAssign(flString);
            }
            ((FlString)object).AddAssign(flString2);
            flString2.Assign((FlString)object);
        }
        this.mNotification.Assign(flString2);
        while (!sA_CircularQueue_ClueMemento.IsEmpty()) {
            this.mMementoQueue.Enqueue(sA_CircularQueue_ClueMemento.Dequeue());
        }
        sA_CircularQueue_ClueMemento.OnDelete();
        return this.mNotification;
    }

    public final boolean HasNotification() {
        return this.mHasNotification;
    }

    public final int GetId() {
        return 0;
    }

    public final void OnDisplayed() {
        this.mHasNotification = false;
    }
}

