/*
 * Decompiled with CFR 0.152.
 */
import ca.jamdat.flight.ApplicationStarter;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.DisplayManager;
import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FlPenManager;
import ca.jamdat.flight.FrameworkGlobals;
import ca.jamdat.flight.J2MEScene;
import ca.jamdat.flight.PackageLoader;
import ca.jamdat.flight.SoundManager;
import ca.jamdat.flight.SpecConstants;
import ca.jamdat.flight.VibrationManager;
import ca.jamdat.flight.VideoMode;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class clue
extends MIDlet
implements Runnable {
    private long mTotalTimePaused = FlApplication.GetRealTime();
    public static FlApplication mApplication;
    private long[] mEvtQueue = new long[8];
    public Thread mMainLoop;
    public static Object paintLock;
    public static FrameworkGlobals mFrameworkGlobals;
    public boolean mDoublePaint;
    public String mExitURI = "";
    private volatile boolean mIsPaused;
    private boolean mForceRepaintBeforeNextEvent;
    private int mEvtCount;
    public boolean mLaunchBrowserOnExit;
    private long mLastResumeTimeStamp = FlApplication.GetRealTime();
    public boolean mResumeNextIsShown;
    public static clue instance;
    private long mStopTimeStamp = -1L;
    public volatile boolean mMustQuit;
    public static J2MEScene mScene;
    private boolean mFirstTime = true;
    private boolean mIsSoundManagerMuted;
    private volatile boolean mPauseInQueue;

    public clue() {
        instance = this;
        J2MEScene.mApp = this;
    }

    public final boolean callPlatformRequest(String string) {
        return this.platformRequest(string);
    }

    public void startApp() {
        this.start();
    }

    public final void start() {
        this.StartTime();
        if (this.mMainLoop == null && this.mFirstTime) {
            this.mMainLoop = new Thread(this);
            this.InitializeFrameworkApplication();
            this.mMainLoop.start();
            return;
        }
        if (this.mPauseInQueue || this.mIsPaused) {
            this.AddEvent((short)6);
        }
    }

    public void pauseApp() {
        this.pause();
    }

    public final void pause() {
        this.StopTime();
        if (!(this.mPauseInQueue || this.mIsPaused || this.mFirstTime || this.mMustQuit)) {
            this.AddEvent((short)5);
        }
    }

    public void destroyApp(boolean bl) {
        if (!this.mMustQuit) {
            this.mMustQuit = true;
            mApplication.SaveGame();
        }
    }

    public final void OSExit() {
        this.mMustQuit = true;
        mApplication.SaveGame();
        SoundManager.Get().StopAllSoundPlayers();
        System.gc();
        if (this.mLaunchBrowserOnExit) {
            try {
                this.callPlatformRequest(this.mExitURI);
            }
            catch (Exception exception) {}
        }
        this.notifyDestroyed();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        mScene = new J2MEScene();
        J2MEScene.repaintScene = false;
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)mScene);
        this.mFirstTime = false;
        while (!this.mMustQuit) {
            long l = FlApplication.GetRealTime();
            try {
                Thread.sleep(SpecConstants.GetMainLoopSleepTime());
            }
            catch (Exception exception) {}
            this.ProcessEvents();
            if (this.mIsPaused) {
                if (this.mResumeNextIsShown && mScene.isShown()) {
                    this.mResumeNextIsShown = false;
                    this.start();
                }
                try {
                    Thread.sleep(SpecConstants.GetMainLoopPausedSleepTime());
                }
                catch (Exception exception) {}
                continue;
            }
            Object object = paintLock;
            // MONITORENTER : object
            mScene.onTime(this.GetGameTime());
            // MONITOREXIT : object
            if (this.mMustQuit) {
                return;
            }
            if (l - this.mLastResumeTimeStamp < 2000L) {
                J2MEScene.repaintScene = true;
                FlApplication.GetInstance().Invalidate();
            }
            if (J2MEScene.repaintScene && DisplayManager.GetMainDisplayContext().HasDirtyRects()) {
                mScene.repaint();
                try {
                    mScene.serviceRepaints();
                }
                catch (Exception exception) {}
            }
            object = paintLock;
            // MONITORENTER : object
            PackageLoader.LoadQueuedPackages_(FrameworkGlobals.GetInstance().mPackageLoader);
            // MONITOREXIT : object
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void ProcessEvents() {
        Object object = paintLock;
        synchronized (object) {
            while (this.mEvtCount > 0 && !this.mForceRepaintBeforeNextEvent) {
                short s;
                short s2;
                int n;
                short s3;
                long[] lArray = this.mEvtQueue;
                synchronized (lArray) {
                    long[] lArray2 = this.mEvtQueue;
                    s3 = (short)(lArray2[0] >>> 48);
                    n = (int)((lArray2[0] & 0xFFFFFFFF0000L) >>> 16);
                    s2 = (short)((lArray2[0] & 0xFFFF00000000L) >>> 32);
                    s = (short)((lArray2[0] & 0xFFFF0000L) >>> 16);
                    if (this.mEvtCount > 1) {
                        for (int i = 0; i < 7; ++i) {
                            lArray2[i] = lArray2[i + 1];
                        }
                    }
                    --this.mEvtCount;
                }
                switch (s3) {
                    case 1: {
                        mScene.OnKeyPressed(n);
                        break;
                    }
                    case 2: {
                        mScene.OnKeyReleased(n);
                        break;
                    }
                    case 3: {
                        J2MEScene.OnFlightKeyPressed(n);
                        break;
                    }
                    case 4: {
                        J2MEScene.OnFlightKeyReleased(n);
                        break;
                    }
                    case 5: {
                        this.mPauseInQueue = false;
                        this.mIsPaused = true;
                        clue.mFrameworkGlobals.application.OnFocusLostFromOS();
                        clue.mFrameworkGlobals.application.OnSuspendFromOS();
                        break;
                    }
                    case 6: {
                        this.mLastResumeTimeStamp = FlApplication.GetRealTime();
                        if (!this.mIsPaused) break;
                        clue.mFrameworkGlobals.application.OnFocusGainedFromOS();
                        clue.mFrameworkGlobals.application.OnResumeFromOS();
                        SoundManager.Get().SetMuted(this.mIsSoundManagerMuted);
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                        this.mIsPaused = false;
                        this.mDoublePaint = true;
                        break;
                    }
                    case 7: {
                        J2MEScene.repaintScene = true;
                        FlApplication.GetInstance().Invalidate();
                        break;
                    }
                    case 8: {
                        FlApplication.Exit();
                        break;
                    }
                    case 10: {
                        FlPenManager.Get().OnPenDrag(s2, s);
                        break;
                    }
                    case 9: {
                        FlPenManager.Get().OnPenDown(s2, s);
                        break;
                    }
                    case 11: {
                        FlPenManager.Get().OnPenUp(s2, s);
                        break;
                    }
                }
            }
            this.mForceRepaintBeforeNextEvent = false;
            return;
        }
    }

    public final void AddEvent(short s) {
        this.AddEvent(s, (short)0, (short)0, (short)0);
    }

    public final void AddEvent(short s, int n) {
        this.AddEvent(s, (short)(n >>> 16), (short)(n & 0xFFFF), (short)0);
    }

    public final void AddEvent(short s, short s2, short s3) {
        this.AddEvent(s, s2, s3, (short)0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void AddEvent(short s, short s2, short s3, short s4) {
        if ((this.mPauseInQueue || this.mIsPaused) && s != 6) {
            return;
        }
        switch (s) {
            case 5: {
                this.mPauseInQueue = true;
                this.PauseSoundsOnInterrupts();
                long[] lArray = this.mEvtQueue;
                synchronized (lArray) {
                    this.mEvtCount = 0;
                    break;
                }
            }
            case 6: {
                clue.ResumeSoundsOnInterrupts();
                break;
            }
        }
        int n = 1;
        long[] lArray = this.mEvtQueue;
        synchronized (lArray) {
            switch (s) {
                case 1: 
                case 9: {
                    if (this.mEvtCount < 5) break;
                    return;
                }
                case 5: 
                case 6: {
                    if (this.mEvtCount < 8) break;
                    return;
                }
                default: {
                    if (this.mEvtCount < 6) break;
                    return;
                }
            }
            if (n == 0) return;
            int n2 = this.mEvtCount;
            this.mEvtCount = n = n2 + 1;
            this.mEvtQueue[n2] = (long)s << 48 | (long)s2 << 32 & 0xFFFF00000000L | (long)s3 << 16 & 0xFFFF0000L | (long)s4 & 0xFFFFL;
            return;
        }
    }

    private final void PauseSoundsOnInterrupts() {
        this.mIsSoundManagerMuted = SoundManager.Get().IsMuted();
        if (SoundManager.Get().mIsPauseSoundsOnInterrupt) {
            SoundManager.Get().PauseAllSoundPlayers();
        } else {
            SoundManager.Get().SetMuted(true);
        }
        VibrationManager.Get().Stop();
    }

    private static void ResumeSoundsOnInterrupts() {
        if (SoundManager.Get().mIsPauseSoundsOnInterrupt) {
            SoundManager.Get().ResumeAllSoundPlayers();
        }
        SoundManager.Get().SetMuted(false);
    }

    public final void StartTime() {
        if (this.mStopTimeStamp != -1L) {
            this.mTotalTimePaused += FlApplication.GetRealTime() - this.mStopTimeStamp;
            this.mStopTimeStamp = -1L;
        }
    }

    public final void StopTime() {
        this.StopTime(FlApplication.GetRealTime());
    }

    public final void StopTime(long l) {
        if (this.mStopTimeStamp == -1L) {
            this.mStopTimeStamp = l;
        }
    }

    public final int GetGameTime() {
        if (this.mStopTimeStamp == -1L) {
            return (int)(FlApplication.GetRealTime() - this.mTotalTimePaused);
        }
        return (int)(this.mStopTimeStamp - this.mTotalTimePaused);
    }

    public static J2MEScene GetCurrentScene() {
        return mScene;
    }

    public final void InitializeFrameworkApplication() {
        mFrameworkGlobals = new FrameworkGlobals();
        FrameworkGlobals.GetInstance().j2meApp = this;
        DisplayManager.Initialize$1c8e946b(VideoMode.c_init_iii(SpecConstants.GetUsedWidth(), SpecConstants.GetUsedHeight(), Constants.ScreenColorDepth()));
        mApplication = ApplicationStarter.NewFlightApp();
    }

    static {
        paintLock = new Object();
    }
}

