/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Array_int;
import ca.jamdat.flight.Characters;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.DisplayContext;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Package;

public final class Text
extends Component {
    public FlString mpCaption = new FlString();
    public short mCurrentLine;
    public byte[] mSegmentFonts = null;
    public FlFont mFont;
    public short[] mSegmentIndexes = null;
    public FlString mHiddenCaption;
    public int mCaptionLength;
    public FlFont[] mMultipleFonts = null;
    public short mLineCount = 1;
    public short[] mLinesWidth;
    public boolean mIsHidden;
    public short mPreviousWidth;
    public boolean mKeepTrailingWhiteSpaces;
    public byte mAlignment = 0;
    public boolean mIsMultiline;
    public int[] mLines;

    private void WrapText() {
        if (!this.mIsMultiline) {
            this.mLineCount = 1;
            this.ComputeLineWidth();
            return;
        }
        short s = this.mRect_width;
        FlFont flFont = this.mFont;
        if (this.mSegmentFonts != null && this.mMultipleFonts == null) {
            return;
        }
        if (s != 0 && flFont != null) {
            int n;
            Array_int array_int = new Array_int(192, 192);
            int n2 = this.WrapString(flFont, s, array_int);
            int[] nArray = new int[n2 + 1];
            for (int i = 0; i <= n2; ++i) {
                nArray[i] = nArray[i] & 0xFFFF0000 | (short)Text.WrapDataLineStart(array_int, i);
                nArray[i] = n = nArray[i] & 0xFFFF | Text.WrapDataLineEnd(array_int, i) << 16;
                nArray[i] = n;
            }
            short[] sArray = new short[n2];
            for (n = 0; n < n2; ++n) {
                sArray[n] = (short)Text.WrapDataLineWidth(array_int, n);
            }
            this.mLines = nArray;
            this.mLinesWidth = sArray;
            this.mPreviousWidth = s;
            this.mLineCount = (short)n2;
            this.SetSize(s, (short)(n2 * this.GetLineHeight() - this.GetLeading()));
        }
    }

    private static void WrapDataEnsureSize(Array_int array_int, int n) {
        int n2 = array_int.GetCapacity();
        if (n2 <= (n *= 3)) {
            n2 = n;
        }
        array_int.SetSize(n2);
    }

    private static int WrapDataArrayPosition(int n, byte by) {
        return n * 3 + by;
    }

    private static int WrapDataLineStart(Array_int array_int, int n) {
        return array_int.GetAt(Text.WrapDataArrayPosition(n, (byte)0));
    }

    private static void WrapDataSetLineStart(Array_int array_int, int n, int n2) {
        array_int.SetAt(n2, Text.WrapDataArrayPosition(n, (byte)0));
    }

    private static int WrapDataLineEnd(Array_int array_int, int n) {
        return array_int.GetAt(Text.WrapDataArrayPosition(n, (byte)1));
    }

    private static void WrapDataSetLineEnd(Array_int array_int, int n, int n2) {
        array_int.SetAt(n2, Text.WrapDataArrayPosition(n, (byte)1));
    }

    private static int WrapDataLineWidth(Array_int array_int, int n) {
        return array_int.GetAt(Text.WrapDataArrayPosition(n, (byte)2));
    }

    private static void WrapDataSetLineWidth(Array_int array_int, int n, int n2) {
        array_int.SetAt(n2, Text.WrapDataArrayPosition(n, (byte)2));
    }

    private int WrapString(FlFont object, int n, Array_int array_int) {
        object = this.mpCaption;
        int n2 = 1;
        int n3 = 4;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        int n7 = 0;
        Text.WrapDataEnsureSize(array_int, 2);
        Text.WrapDataSetLineStart(array_int, 0, 0);
        int n8 = 0;
        byte by = ((FlString)object).GetCharAt(0);
        FlFont flFont = this.GetSegmentFontAtIndex((short)0);
        int n9 = Characters.GetCharType(by);
        if (by == 0) {
            Text.WrapDataSetLineEnd(array_int, 0, 0);
            Text.WrapDataSetLineStart(array_int, 1, 1);
            n2 = 2;
        }
        while (by != 0) {
            byte by2 = by;
            int n10 = n9;
            by = ((FlString)object).GetCharAt(n8 + 1);
            n9 = Characters.GetCharType(by);
            FlFont flFont2 = flFont;
            flFont = this.GetSegmentFontAtIndex((short)(n8 + 1));
            int n11 = 1;
            int n12 = n5 == 0 ? 1 : 0;
            if ((n12 = n5 + flFont2.GetCharWidth(by2, n12 != 0, true)) > n) {
                n11 = 0;
            } else if (n12 == n) {
                n11 = Characters.IsWordSeparator(n9);
            }
            n12 = n5 == 0 ? 1 : 0;
            n5 += flFont2.GetCharWidth(by2, n12 != 0, false);
            n12 = 0;
            if (by2 == 13 && by == 10) {
                bl = true;
            } else {
                if (Characters.IsLineSeparator(n10)) {
                    n12 = bl ? 1 : 0;
                    n12 = (short)(1 + n12);
                    n7 = n3 == 1 && n4 == n8 - n12 ? (int)((short)(n7 + n12)) : n12;
                    n3 = 0;
                    n12 = 1;
                } else if (n3 >= 1 && Characters.IsWordSeparator(n10)) {
                    if (by2 != -83 || n11 != 0) {
                        n12 = 1;
                        if (by2 == -83) {
                            n12 = 0;
                        }
                        n7 = n3 == 1 && n4 == n8 - 1 ? (int)((short)(n7 + n12)) : n12;
                        n3 = 1;
                        n12 = 1;
                    }
                } else if (n3 >= 3 && Characters.IsOptionalWordBreak(n10)) {
                    n3 = 3;
                    n7 = 1;
                    n12 = 1;
                }
                if (n11 != 0) {
                    if (n3 >= 2 && Characters.CanWrapAfter(n10) && Characters.CanWrapBefore(n9)) {
                        n3 = 2;
                        n7 = 0;
                        n12 = 1;
                    }
                    if (n3 != 0 && by == 0) {
                        n3 = 0;
                        if (n12 == 0) {
                            n7 = 0;
                        }
                        n12 = 1;
                    }
                } else if (n3 == 4) {
                    n4 = (short)(n8 - 1);
                    n10 = n5;
                    n6 = n5 == 0 ? 1 : 0;
                    n6 = n10 - flFont2.GetCharWidth(by2, n6 != 0, false);
                }
                if (n12 != 0) {
                    n4 = n8;
                    n6 = n5;
                }
                if (n3 == 0 || n11 == 0) {
                    n8 = n4;
                    byte by3 = ((FlString)object).GetCharAt(n4);
                    FlFont flFont3 = this.GetSegmentFontAtIndex((short)n4);
                    while (n8 - n7 < n4) {
                        n11 = n6;
                        FlFont flFont4 = flFont3;
                        by2 = by3;
                        n9 = n6 == 0 ? 1 : 0;
                        n6 = n11 - flFont4.GetCharWidth(by2, n9 != 0, false);
                        if ((n4 = (short)(n4 - 1)) < 0) continue;
                        by3 = ((FlString)object).GetCharAt(n4);
                        flFont3 = this.GetSegmentFontAtIndex((short)n4);
                    }
                    if (n4 > Text.WrapDataLineStart(array_int, n2 - 1)) {
                        n11 = n6;
                        FlFont flFont5 = flFont3;
                        by2 = by3;
                        n9 = n6 == 0 ? 1 : 0;
                        boolean bl2 = (n11 -= flFont5.GetCharWidth(by2, n9 != 0, false)) == 0;
                        n6 = n11 + flFont3.GetCharWidth(by3, bl2, true);
                    }
                    Text.WrapDataEnsureSize(array_int, n2 + 1);
                    Text.WrapDataSetLineWidth(array_int, n2 - 1, n6);
                    Text.WrapDataSetLineEnd(array_int, n2 - 1, n4);
                    Text.WrapDataSetLineStart(array_int, n2, n8 + 1);
                    n2 = (short)(n2 + 1);
                    by = ((FlString)object).GetCharAt(n8 + 1);
                    flFont = this.GetSegmentFontAtIndex((short)(n8 + 1));
                    n9 = Characters.GetCharType(by);
                    n4 = -1;
                    n5 = 0;
                    bl = false;
                    n3 = 4;
                    n7 = 0;
                }
            }
            n8 = (short)(n8 + 1);
        }
        Text.WrapDataEnsureSize(array_int, n2 + 1);
        Text.WrapDataSetLineStart(array_int, n2, n8);
        Text.WrapDataSetLineEnd(array_int, n2, -1);
        return n2 - 1;
    }

    private short GetMultiFontLineWidth(FlString flString, int n, int n2, boolean bl) {
        if (this.mMultipleFonts == null || n2 == 0) {
            return 0;
        }
        int n3 = 0;
        n2 = n + n2 - 1;
        int n4 = this.GetSegmentIncluding((short)n);
        byte by = this.GetFontID(n4);
        FlFont flFont = this.mMultipleFonts[by];
        int n5 = n4 + 1;
        n4 = this.mSegmentIndexes[n5];
        for (int i = n; i <= n2; ++i) {
            if (i >= n4) {
                byte by2 = this.GetFontID(n5);
                flFont = this.mMultipleFonts[by2];
                n4 = this.mSegmentIndexes[++n5];
            }
            FlFont flFont2 = flFont;
            byte by3 = flString.GetCharAt(i);
            boolean bl2 = i == n;
            boolean bl3 = i == n2;
            n3 += flFont2.GetCharWidth(by3, bl2, bl3, bl);
        }
        return (short)n3;
    }

    private void CreateSegments() {
        int n;
        if (this.mSegmentFonts != null) {
            this.mSegmentFonts = null;
        }
        if (this.mSegmentIndexes != null) {
            this.mSegmentIndexes = null;
        }
        if ((n = this.mCaptionLength) > 3) {
            int n2 = (n >> 2) + 2;
            byte[] byArray = new byte[n2];
            short[] sArray = new short[n2];
            Object object = new FlString(this.mpCaption);
            int n3 = ((FlString)object).ParseTaggedString(sArray, byArray, n2);
            this.mpCaption = object;
            this.mCaptionLength = this.mpCaption.GetLength();
            if (n3 > 2) {
                object = new byte[n3];
                short[] sArray2 = new short[n3];
                while (--n3 >= 0) {
                    object[n3] = byArray[n3];
                    sArray2[n3] = sArray[n3];
                }
                this.mSegmentFonts = (byte[])object;
                this.mSegmentIndexes = sArray2;
            }
        }
    }

    private int GetSegmentIncluding(short s) {
        int n = 0;
        while (s >= this.mSegmentIndexes[n + 1]) {
            ++n;
        }
        return n;
    }

    private FlFont GetSegmentFontAtIndex(short s) {
        FlFont flFont = this.mFont;
        if (this.mSegmentFonts != null) {
            flFont = this.mMultipleFonts[this.GetFontID(this.GetSegmentIncluding(s))];
        }
        return flFont;
    }

    private void HideText() {
        if (this.mIsHidden && this.mpCaption != null) {
            this.mHiddenCaption = this.mpCaption;
            FlString flString = new FlString();
            FlString flString2 = FlString.FromChar((byte)42);
            for (int i = 0; i < this.mCaptionLength; ++i) {
                flString.AddAssign(flString2);
            }
            this.mpCaption = flString;
        }
    }

    public final void SetCaption(FlString flString) {
        this.SetCaption(flString, true);
    }

    public final short GetLineWidth() {
        return this.GetLineWidth(0);
    }

    private void ComputeLineWidth() {
        this.ComputeLineWidth(true);
    }

    private byte GetLeading() {
        if (this.mSegmentFonts != null) {
            return 0;
        }
        return this.mFont.GetLeading();
    }

    public static Text Cast$21bacd23(Object object) {
        return (Text)object;
    }

    private void SetCaption(FlString flString, boolean bl) {
        this.mpCaption = flString;
        this.mCaptionLength = this.mpCaption.GetLength();
        this.HideText();
        if (bl) {
            this.CreateSegments();
        }
        this.WrapText();
        this.SetCurrentLine(0);
    }

    public final void OnDraw(DisplayContext displayContext) {
        FlString flString = this.mpCaption;
        FlFont flFont = this.mFont;
        if (flString.IsEmpty() || flFont == null) {
            return;
        }
        if (this.mIsMultiline && this.mLineCount > 1) {
            if (this.mSegmentFonts != null) {
                this.OnDrawLinesMultiFont(displayContext);
                return;
            }
            displayContext.DrawMultilineString(flString, this.mLines, this.mLineCount, this.mRect_left, this.mRect_top, this.mRect_width, this.mRect_height, this.mCurrentLine, flFont, this.mAlignment, this.mLinesWidth);
            return;
        }
        if (this.mSegmentFonts != null) {
            this.OnDrawMultiFont$57b49ceb(displayContext, flString, 0, this.mCaptionLength, this.mRect_left, this.mRect_top, this.mRect_width, 0, 0, this.mLinesWidth[0]);
            return;
        }
        displayContext.DrawString(flString, this.mRect_left, this.mRect_top, this.mRect_width, this.mRect_height, flFont, this.mAlignment, 0, this.mCaptionLength, this.mLinesWidth[0]);
    }

    public final FlString GetCaption() {
        if (this.mIsHidden) {
            return this.mHiddenCaption;
        }
        return this.mpCaption;
    }

    public final void SetFont(FlFont flFont) {
        if (this.mFont != flFont) {
            this.mFont = flFont;
            if (flFont == null) {
                return;
            }
            this.WrapText();
            this.Invalidate();
            if (this.mMultipleFonts == null) {
                return;
            }
            this.mMultipleFonts[0] = this.mFont;
        }
    }

    public final void SetMultiline(boolean bl) {
        if (bl != this.mIsMultiline) {
            this.mIsMultiline = bl;
            if (this.mIsMultiline) {
                this.WrapText();
            }
            this.Invalidate();
        }
    }

    private void SetCurrentLine(int n) {
        n = n < 0 ? 0 : (n >= this.mLineCount && this.mLineCount > 0 ? (int)((short)(this.mLineCount - 1)) : (int)((short)n));
        this.mCurrentLine = (short)n;
        this.Invalidate();
    }

    public final short GetLineHeight() {
        return (short)this.mFont.GetLineHeight();
    }

    public final void OnRectChange() {
        if (this.mIsMultiline && this.mPreviousWidth != this.mRect_width) {
            this.WrapText();
        }
    }

    public final void OnVisibilityChange() {
        if (this.mVisible && this.mIsMultiline) {
            this.Invalidate();
        }
        super.OnVisibilityChange();
    }

    public final void OnSerialize(Package package_) {
        super.OnSerialize(package_);
        this.mpCaption = null;
        this.mpCaption = FlString.Cast$50263e8f(package_.SerializePointer((byte)35, false, false));
        this.mCaptionLength = this.mpCaption.GetLength();
        this.mFont = FlFont.Cast$be01453(package_.SerializePointer((byte)36, false, false));
        this.mAlignment = package_.SerializeIntrinsic$132bd3();
        int n = package_.SerializeIntrinsic$136bb5();
        if (n > 1) {
            this.mMultipleFonts = new FlFont[n];
            this.mMultipleFonts[0] = this.mFont;
            for (int i = 1; i < n; ++i) {
                this.mMultipleFonts[i] = FlFont.Cast$be01453(package_.SerializePointer((byte)36, false, false));
            }
            this.CreateSegments();
        }
        this.mIsHidden = package_.SerializeIntrinsic$138603();
        if (this.mIsHidden) {
            this.HideText();
        }
        package_.SerializeIntrinsic$136bb5();
        this.mIsMultiline = package_.SerializeIntrinsic$138603();
        this.WrapText();
    }

    private short GetLineWidth(int n) {
        return this.mLinesWidth[n];
    }

    public final void SetMultipleFonts(FlFont[] flFontArray, short n) {
        if (this.mMultipleFonts != null) {
            this.mMultipleFonts = null;
        }
        if (flFontArray != null && n > 0) {
            this.mFont = flFontArray[0];
            FlFont[] flFontArray2 = new FlFont[n];
            for (int i = 0; i < n; ++i) {
                flFontArray2[i] = flFontArray[i];
            }
            this.mMultipleFonts = flFontArray2;
        }
        this.WrapText();
        this.Invalidate();
    }

    private byte GetFontID(int n) {
        return this.mSegmentFonts[n];
    }

    public final void SetFont(FlFont flFont, int n) {
        if (this.mMultipleFonts[n] == flFont) {
            return;
        }
        this.mMultipleFonts[n] = flFont;
        this.WrapText();
        this.Invalidate();
    }

    private void OnDrawLinesMultiFont(DisplayContext displayContext) {
        int[] nArray = this.mLines;
        FlString flString = this.mpCaption;
        int n = this.mCaptionLength;
        int n2 = this.mCurrentLine;
        short s = (short)(nArray[n2] & 0xFFFF);
        short s2 = this.GetLineHeight();
        short s3 = this.mRect_left;
        short s4 = this.mRect_top;
        short s5 = this.mRect_width;
        do {
            this.OnDrawMultiFont$57b49ceb(displayContext, flString, s, (nArray[n2] >> 16) - s + 1, s3, s4, s5, s, this.GetSegmentIncluding(s), this.mLinesWidth[n2]);
            s4 = (short)(s4 + s2);
        } while ((s = (short)(nArray[++n2] & 0xFFFF)) < n);
    }

    private int OnDrawMultiFont$57b49ceb(DisplayContext displayContext, FlString flString, int n, int n2, short s, short s2, short s3, int n3, int n4, short s4) {
        n2 = n + n2;
        byte by = this.GetFontID(n4);
        FlFont flFont = this.mMultipleFonts[by];
        short s5 = (short)(s + DisplayContext.GetAlignmentOffsetX(this.mAlignment, s3, s4));
        s4 = 1;
        while (n < n2) {
            int s6;
            s3 = (short)(this.mSegmentIndexes[n4 + 1] - n3);
            if (s3 > 0) {
                s = (short)(this.mFont.GetAscent() - flFont.GetAscent());
                if (n + s3 > n2) {
                    s3 = (short)(n2 - n);
                }
                FlFont flFont2 = flFont;
                int n5 = n;
                int n6 = s3;
                s6 = n + s3 >= n2 ? (int)1 : 0;
                s6 = flFont2.GetLineWidth(flString, n5, n6, s6 != 0, s4 != 0);
                n6 = 0;
                if (s4 == 0) {
                    FlFont flFont3 = flFont;
                    byte by2 = flString.GetCharAt(n);
                    n6 = n == n2 - 1 ? 1 : 0;
                    n6 = flFont3.GetCharRecede(by2, n6 != 0);
                }
                displayContext.DrawString(flString, s5, (short)(s2 + s), (short)s6, (short)flFont.GetLineHeight(), flFont, this.mAlignment, n, s3, (short)(s6 - n6));
                s5 = (short)(s5 + s6);
                s4 = 0;
                n += s3;
            }
            if (n >= n2) continue;
            n3 = this.mSegmentIndexes[++n4];
            s6 = this.GetFontID(n4);
            flFont = this.mMultipleFonts[s6];
        }
        return n4;
    }

    private void ComputeLineWidth(boolean bl) {
        int n;
        FlString flString = this.mpCaption;
        if (flString == null || this.mFont == null) {
            if (flString == null) {
                this.mCaptionLength = 0;
            }
            return;
        }
        if (!this.mKeepTrailingWhiteSpaces) {
            for (n = this.mCaptionLength; n > 0 && (flString.GetCharAt(n - 1) == 32 || flString.GetCharAt(n - 1) == 29); --n) {
            }
            this.mCaptionLength = n;
        }
        short[] sArray = new short[]{this.mSegmentFonts != null ? this.GetMultiFontLineWidth(flString, 0, n, bl) : (short)this.mFont.GetLineWidth(flString, 0, n, bl)};
        this.mLinesWidth = sArray;
    }
}

