/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.F32;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public class Scroller
extends Viewport {
    public short mSmoothScrolling;
    public Viewport mScrollerViewport;
    public Component[] mElements;
    public boolean mArrowBehaviorCameFromScroller;
    public boolean mIsVertical = true;
    public boolean mIsViewportCentered;
    public Selection mNextArrow;
    public Selection mPreviousArrow;
    public int mMaxNumElements;
    public int mNumElements;

    public final void ResetScroller() {
        if (this.mNumElements > 0) {
            Component component = this.GetFirstElement();
            Component component2 = this.GetLastElement();
            Viewport viewport = this.mScrollerViewport;
            boolean bl = this.mIsVertical ? this.GetVerticalTotalScrollingSize() > viewport.mRect_height : this.GetHorizontalTotalScrollingSize() > viewport.mRect_width;
            short s = viewport.mOffsetX;
            short s2 = viewport.mOffsetY;
            if (this.mIsViewportCentered && !bl) {
                if (this.mIsVertical) {
                    s2 = (short)(-(viewport.mRect_height + component.mRect_top - component2.GetBottom()) / 2);
                } else {
                    s = (short)(-(viewport.mRect_width + component.mRect_left - component2.GetRight()) / 2);
                }
            } else if (this.mIsVertical) {
                s2 = component.mRect_top;
            } else {
                s = component.mRect_left;
            }
            viewport.OffsetTo(s, s2);
        }
        this.UpdateScroller();
    }

    public final Component[] AllocComponentTable() {
        return new Component[this.mMaxNumElements];
    }

    public void UpdateArrowsEnabledState() {
        if (this.mNextArrow != null && this.mNumElements > 0) {
            short[] sArray = Vector2_short.c_init_();
            this.mScrollerViewport.GetRequiredOffsetChange(sArray, this.GetFirstElement(), false);
            Selection selection = this.mPreviousArrow;
            boolean bl = Vector2_short.GetY_(sArray) < 0;
            selection.SetEnabledState(bl);
            this.mScrollerViewport.GetRequiredOffsetChange(sArray, this.GetLastElement(), true);
            Selection selection2 = this.mNextArrow;
            boolean bl2 = Vector2_short.GetY_(sArray) > 0;
            selection2.SetEnabledState(bl2);
        }
    }

    public final void CheckIfArrowsAreNeeded() {
        if (this.mNextArrow != null) {
            boolean bl = false;
            if (this.mNumElements > 0) {
                short[] sArray = Vector2_short.c_init_();
                this.mScrollerViewport.GetRequiredOffsetChange(sArray, this.GetFirstElement(), false);
                boolean bl2 = Vector2_short.GetX_(sArray) == 0;
                bl = bl2;
                bl2 = Vector2_short.GetY_(sArray) == 0;
                boolean bl3 = bl2;
                this.mScrollerViewport.GetRequiredOffsetChange(sArray, this.GetLastElement(), true);
                bl2 = Vector2_short.GetX_(sArray) == 0;
                boolean bl4 = Vector2_short.GetY_(sArray) == 0;
                bl4 = !bl || !bl3 || !bl2 || !bl4;
                bl = bl4;
            }
            this.mNextArrow.SetVisible(bl);
            this.mPreviousArrow.SetVisible(bl);
        }
    }

    public void OnScrollEvent(int n, boolean n2) {
        short s;
        n2 = -1;
        short[] sArray = Vector2_short.c_init_();
        Component[] componentArray = this.mElements;
        if (n == 1) {
            for (s = 0; s < this.mNumElements; ++s) {
                this.mScrollerViewport.GetRequiredOffsetChange(sArray, componentArray[s], true);
                if ((!this.mIsVertical || Vector2_short.GetY_(sArray) <= 0) && (this.mIsVertical || Vector2_short.GetX_(sArray) <= 0) || !componentArray[s].mVisible) continue;
                n2 = s;
                break;
            }
        } else {
            for (s = this.mNumElements - 1; s >= 0; --s) {
                this.mScrollerViewport.GetRequiredOffsetChange(sArray, componentArray[s], false);
                if ((!this.mIsVertical || Vector2_short.GetY_(sArray) >= 0) && (this.mIsVertical || Vector2_short.GetX_(sArray) >= 0) || !componentArray[s].mVisible) continue;
                n2 = s;
                break;
            }
        }
        if (n2 >= 0) {
            short s2 = this.mSmoothScrolling;
            s = n < 0 ? (short)this.GetScrollingPosition() : (short)((short)(this.GetTotalScrollingSize() - (this.GetScrollingPosition() + this.GetVisibleWindowSize())));
            if (s2 > 0) {
                if (s2 > s) {
                    s2 = s;
                }
                s2 = (short)(s2 * n);
                if (this.mIsVertical) {
                    this.mScrollerViewport.OffsetBy((short)0, s2);
                } else {
                    this.mScrollerViewport.OffsetBy(s2, (short)0);
                }
            } else if (componentArray[n2] instanceof Text) {
                s2 = ((Text)componentArray[n2]).GetLineHeight();
                if (s2 > s) {
                    s2 = s;
                }
                this.mScrollerViewport.OffsetBy((short)0, (short)(n * s2));
            } else {
                Viewport viewport = this.mScrollerViewport;
                Component component = componentArray[n2];
                boolean bl = n == 1;
                viewport.ChangeOffsetToShow(component, bl);
            }
            this.UpdateArrowsEnabledState();
            this.SendMsg(this, -105, 0);
        }
    }

    public boolean IsAppropriateHotkey(int n, int n2) {
        return false;
    }

    public final Component GetFirstElement() {
        Component[] componentArray = this.mElements;
        for (int i = 0; i < this.mNumElements; ++i) {
            if (!componentArray[i].mVisible || !this.mScrollerViewport.IsSelfOrAncestorOf(componentArray[i].m_pViewport)) continue;
            return componentArray[i];
        }
        return componentArray[0];
    }

    public final Component GetLastElement() {
        Component[] componentArray = this.mElements;
        for (int i = this.mNumElements - 1; i >= 0; --i) {
            if (!componentArray[i].mVisible || !this.mScrollerViewport.IsSelfOrAncestorOf(componentArray[i].m_pViewport)) continue;
            return componentArray[i];
        }
        Component[] componentArray2 = this.mElements;
        int n = this.mNumElements > 0 ? this.mNumElements - 1 : 0;
        return componentArray2[n];
    }

    public final short GetVerticalTotalScrollingSize() {
        Component component = this.GetLastElement();
        short s = component.GetAbsoluteTop();
        return (short)(component.mRect_height + s - this.GetFirstElement().GetAbsoluteTop());
    }

    public final short GetHorizontalTotalScrollingSize() {
        Component component = this.GetLastElement();
        short s = component.GetAbsoluteLeft();
        return (short)(component.mRect_width + s - this.GetFirstElement().GetAbsoluteLeft());
    }

    public void OnScrollEvent(int n) {
        this.OnScrollEvent(n, true);
    }

    public final int GetScrollbarRatio() {
        Component component = this.GetFirstElement();
        short[] sArray = Vector2_short.c_init_();
        this.mScrollerViewport.GetRequiredOffsetChange(sArray, component, false);
        if (this.mIsVertical) {
            short s = this.GetVerticalTotalScrollingSize();
            if (this.mScrollerViewport.mRect_height >= s) {
                return F32.Zero$134621();
            }
            int n = F32.c_init_ii$255f288(-Vector2_short.GetY_(sArray));
            return F32.Div_F32i(F32.c_init_ii$255f288(s - this.mScrollerViewport.mRect_height), 16, n);
        }
        short s = this.GetHorizontalTotalScrollingSize();
        if (this.mScrollerViewport.mRect_width >= s) {
            return F32.Zero$134621();
        }
        int n = F32.c_init_ii$255f288(-Vector2_short.GetX_(sArray));
        return F32.Div_F32i(F32.c_init_ii$255f288(s - this.mScrollerViewport.mRect_width), 16, n);
    }

    public boolean OnDefaultMsg(Component component, int n, int n2) {
        if (n == -108) {
            this.ResetScroller();
            return true;
        }
        if (n == -128) {
            this.FocusGained(n2);
            return false;
        }
        if (n == -125) {
            boolean bl = this.mNextArrow != null && this.mNextArrow.IsSelfOrAncestorOf(component);
            boolean bl2 = bl;
            bl = this.mPreviousArrow != null && this.mPreviousArrow.IsSelfOrAncestorOf(component);
            if ((n2 == 0 || 3 == n2) && (bl2 || bl)) {
                this.SendMsg(this, -105, 1);
            } else if (!(1 != n2 && 2 != n2 || this.mArrowBehaviorCameFromScroller)) {
                if (bl2) {
                    this.OnScrollEvent(1);
                } else if (bl) {
                    this.OnScrollEvent(-1);
                }
            }
        } else if (n == -121 || n == -120 || n == -119) {
            int n3 = 0;
            if (this.mIsVertical) {
                if (n2 == 1) {
                    n3 = -1;
                } else if (n2 == 2) {
                    n3 = 1;
                }
            } else if (n2 == 3) {
                n3 = -1;
            } else if (n2 == 4) {
                n3 = 1;
            }
            if (n3 != 0) {
                if (this.mNumElements <= 0) {
                    return true;
                }
                if (this.mNextArrow != null) {
                    Selection selection = n3 == 1 ? this.mNextArrow : this.mPreviousArrow;
                    n2 = -121 != n ? 1 : 0;
                    this.mArrowBehaviorCameFromScroller = n2;
                    selection.SetPushedState(n2 != 0);
                } else if (-121 == n) {
                    this.SendMsg(this, -105, 1);
                }
                if (n == -119) {
                    this.OnScrollEvent(n3);
                }
                return true;
            }
            if (this.IsAppropriateHotkey(n, n2)) {
                return true;
            }
        }
        return super.OnDefaultMsg(component, n, n2);
    }

    public static Scroller Cast$53993db7(Object object) {
        return (Scroller)object;
    }

    public final void SetMaxNumElements(int n) {
        this.mMaxNumElements = n;
        Component[] componentArray = this.AllocComponentTable();
        int n2 = this.mMaxNumElements < this.mNumElements ? this.mMaxNumElements : this.mNumElements;
        int n3 = n2;
        for (n2 = 0; n2 < n3; ++n2) {
            componentArray[n2] = this.mElements[n2];
        }
        this.mElements = componentArray;
    }

    public final void SetElementAt(int n, Component component) {
        this.mElements[n] = component;
    }

    public final Component GetElementAt(int n) {
        return this.mElements[n];
    }

    public final short GetVisibleWindowSize() {
        if (this.mIsVertical) {
            return this.mScrollerViewport.mRect_height;
        }
        return this.mScrollerViewport.mRect_width;
    }

    public final short GetTotalScrollingSize() {
        if (this.mIsVertical) {
            return this.GetVerticalTotalScrollingSize();
        }
        return this.GetHorizontalTotalScrollingSize();
    }

    public void OnSerialize(Package package_) {
        super.OnSerialize(package_);
        this.mNextArrow = Selection.Cast$2754fb85(package_.SerializePointer((byte)97, true, false));
        this.mPreviousArrow = Selection.Cast$2754fb85(package_.SerializePointer((byte)97, true, false));
        this.mScrollerViewport = Viewport.Cast$7c352e71(package_.SerializePointer((byte)68, true, false));
        this.mIsVertical = package_.SerializeIntrinsic$138603();
        this.mIsViewportCentered = package_.SerializeIntrinsic$138603();
        this.mNumElements = package_.SerializeIntrinsic$134621();
        this.mMaxNumElements = package_.SerializeIntrinsic$134621();
        this.mSmoothScrolling = package_.SerializeIntrinsic$136bb5();
        this.mElements = this.AllocComponentTable();
        for (int i = 0; i < this.mNumElements; ++i) {
            Component component;
            this.mElements[i] = component = Component.Cast$202d8de5(package_.SerializePointer((byte)67, true, false));
        }
        if (Package.IsReading()) {
            this.ResetScroller();
        }
    }

    public final void FocusGained(int n) {
        if (this.mNextArrow != null) {
            n = n != 0 ? 1 : 0;
            this.mNextArrow.SetSelectedState(n != 0);
            this.mPreviousArrow.SetSelectedState(n != 0);
        }
    }

    public final void UpdateScroller() {
        this.CheckIfArrowsAreNeeded();
        this.UpdateArrowsEnabledState();
    }

    public final short GetScrollingPosition() {
        if (this.mIsVertical) {
            return this.mScrollerViewport.mOffsetY;
        }
        return this.mScrollerViewport.mOffsetX;
    }
}

