/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_DialogBox;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.ScenarioMediator;
import ca.jamdat.flight.ScenarioProgress;
import ca.jamdat.flight.Scrollbar;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.SelectorMenu;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.SubtypeHandler;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Viewport;

public final class ScenarioSelectMenu
extends SelectorMenu {
    public GE_DialogBox mDialogBox;
    public ScenarioMediator mMediator;
    public Scrollbar mScrollbar;

    public final void Load() {
        super.Load();
        this.mDialogBox = new GE_DialogBox(this);
        this.mDialogBox.Load();
    }

    public final void Unload() {
        this.mDialogBox.Unload();
        this.mDialogBox = null;
        this.mScrollbar = null;
        super.Unload();
    }

    public final boolean IsLoaded() {
        return this.mDialogBox.IsLoaded() && super.IsLoaded();
    }

    public final boolean OnMsg(Component component, int n, int n2) {
        if (n == -105) {
            this.mScrollbar.UpdateKnobPosition();
        }
        return super.OnMsg(component, n, n2);
    }

    public final boolean OnPenUp(byte by, short[] sArray) {
        return this.mDialogBox.OnPenUp(by, this.mPenDownCoord) || super.OnPenUp(by, sArray);
    }

    public final boolean OnPenMove(byte by, short[] sArray, short[] sArray2) {
        return this.mDialogBox.OnPenMove(by, this.mPenDownCoord, sArray, sArray2) || super.OnPenMove(by, sArray, sArray2);
    }

    public final boolean OnPenDown(byte by, short[] sArray) {
        return this.mDialogBox.OnPenDown(by, this.mPenDownCoord) || super.OnPenDown(by, sArray);
    }

    public ScenarioSelectMenu(ScenarioMediator scenarioMediator) {
        super(29, 2818134);
        this.mMediator = scenarioMediator;
        this.AddType(2);
    }

    private void SetSelectionsPassThrough(boolean bl) {
        this.mSelector.mPreviousArrow.mPassThrough = bl;
        this.mSelector.mNextArrow.mPassThrough = bl;
        int n = this.mSelector.GetNumSelections();
        for (int i = 0; i < n; ++i) {
            this.mSelector.GetSelectionAt((int)i).mPassThrough = bl;
        }
    }

    private static int GetIdFromCommand(int n) {
        int n2 = -1;
        switch (n) {
            case 41: {
                n2 = 0;
                break;
            }
            case 42: {
                n2 = 1;
                break;
            }
            case 43: {
                n2 = 2;
                break;
            }
            case 44: {
                n2 = 3;
                break;
            }
            case 45: {
                n2 = 4;
                break;
            }
            case 46: {
                n2 = 5;
                break;
            }
            case 47: {
                n2 = 6;
                break;
            }
            case 48: {
                n2 = 7;
                break;
            }
            case 49: {
                n2 = 8;
                break;
            }
            case 50: {
                n2 = 9;
                break;
            }
            case 51: {
                n2 = 10;
                break;
            }
            case 52: {
                n2 = 11;
            }
        }
        return n2;
    }

    private void UpdateSelections() {
        int n = 4;
        for (int i = 0; i < 12; ++i) {
            this.mMediator.SetCurrentElement(i);
            int n2 = !this.mMediator.IsLocked() ? 1 : 0;
            Selection selection = this.mSelector.GetSelectionAt(i);
            if (n2 != 0) {
                Object object = (Viewport)selection.GetChild(2);
                int n3 = this.mMediator.GetScenarioStars();
                if (n3 < n) {
                    this.mFocusedSelectionIndex = i;
                    n = n3;
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    ((Viewport)object).GetChild(n2).SetVisible(true);
                }
                Text text = (Text)selection.GetChild(1);
                FlString flString = new FlString(FlString.Cast$50263e8f(this.mPackage.GetEntryPoint(7 + i)));
                n2 = (short)(((Component)object).mRect_left - Constants.menuSelectionSelectedTextXFct() - Constants.menuSelectionTextXFct());
                object = text.mFont;
                Utilities.Trunc(flString, n2, (FlFont)object);
                text.SetCaption(flString);
                continue;
            }
            Text text = (Text)selection.GetChild(1);
            FlString flString = StringUtils.CreateStringPtr(FlString.Cast$50263e8f((Object)this.mPackage.GetEntryPoint((int)6)).mData);
            flString.AddAssign(new FlString(i - 2 + 1));
            text.SetCaption(flString);
            selection.mCommand = (short)55;
            SubtypeHandler.OnSubtype$44fe7cd6(selection, -11, 0);
        }
        this.mSelector.SetSingleSelection(this.mFocusedSelectionIndex);
        this.mSelector.UpdateScroller();
    }

    private void UpdateArrowsPositionForFirstIndex() {
        Selection selection = ((SelectorMenu)((Object)metaPackage)).mSelector.GetSelectionAt(0);
        MetaPackage metaPackage = GameLibrary.GetPackage(65538);
        Viewport viewport = Viewport.Cast$7c352e71(metaPackage.mPackage.GetEntryPoint(27));
        short s = viewport.mRect_left;
        short s2 = (short)(selection.GetAbsoluteTop() + 41);
        viewport.SetTopLeft(s, s2);
        GameLibrary.ReleasePackage(metaPackage);
        Utilities.UpdateArrowsVisualState(selection, viewport);
    }

    private void ShowNotification() {
        this.TakeFocus();
        this.UpdateSoftkeys(7, 39, 1, 39);
        FlString flString = new FlString(FlString.Cast$50263e8f(this.mPackage.GetEntryPoint(5)));
        this.mMediator.SetCurrentElement(this.mSelector.mCurrentSelectionIndex);
        ClueUtils.ReplaceAllNumbersInStringIntoDigits(flString, ScenarioProgress.GetRequiredStars(this.mMediator.GetScenarioTier()));
        this.mDialogBox.Show(flString, 0);
        this.mDialogBox.BringToFront();
        this.SetSelectionsPassThrough(true);
    }

    private void HideNotification() {
        this.SetSelectionsPassThrough(false);
        this.mDialogBox.Hide();
        this.UpdateSoftkeys(7, -2, 1, 54);
        this.mSelector.GetSelectionAt(this.mSelector.mCurrentSelectionIndex).TakeFocus();
    }

    public final void Initialize() {
        super.Initialize();
        this.UpdateSelections();
        this.mScrollbar.SetScroller(this.mSelector);
        this.mSelector.BringToFront();
        this.mDialogBox.Init(this.mViewport);
    }

    public final boolean OnCommand(int n) {
        boolean bl = false;
        if (n == 55) {
            this.ShowNotification();
            bl = true;
        } else if (n == 39) {
            this.HideNotification();
            bl = true;
        } else if (this.mDialogBox.mIsActive) {
            if (n == 100) {
                this.HideNotification();
            }
            bl = true;
        } else {
            int n2 = n == -2 ? ScenarioSelectMenu.GetIdFromCommand(this.GetCommandFromCurrentSelection(n)) : ScenarioSelectMenu.GetIdFromCommand(n);
            if (n2 != -1) {
                this.mMediator.SetCurrentElement(n2);
                if (!this.mMediator.IsLocked()) {
                    GameApp.Get().GetScenarioProcess().Step(2);
                    n = 4;
                }
                bl = true;
            }
        }
        return super.OnCommand(n) || bl;
    }

    public final void OnSubtype(Component component, int n, int n2) {
        super.OnSubtype(component, n, n2);
        if (this.mSelector.mCurrentSelectionIndex == 0) {
            this.UpdateArrowsPositionForFirstIndex();
        }
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        this.mDialogBox.GetEntryPoints();
        this.mScrollbar = new Scrollbar((Viewport)this.mSelector.GetChild(2));
        this.mScrollbar.GetEntryPoints();
    }

    public final boolean SaveFiles(int n) {
        if (n == 1) {
            return GameApp.Get().GetFileManager().OnSave();
        }
        return super.SaveFiles(n);
    }

    public final void SerializeObjects() {
        GameApp.Get().GetFileManager().WriteObject(0);
        GameApp.Get().GetFileManager().WriteObject(1);
        GameApp.Get().GetFileManager().WriteObject(3);
    }

    public final boolean OnKeyDown(int n) {
        return this.mDialogBox.OnKeyDown(n) || super.OnKeyDown(n);
    }

    public final boolean OnKeyUp(int n) {
        return this.mDialogBox.OnKeyUp(n) || super.OnKeyUp(n);
    }

    public final boolean OnKeyDownOrRepeat(int n) {
        return this.mDialogBox.OnKeyDownOrRepeat(n) || super.OnKeyDownOrRepeat(n);
    }
}

