/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_Clock;
import ca.jamdat.flight.GE_DialogBox;
import ca.jamdat.flight.GE_MapMovement;
import ca.jamdat.flight.GE_NavTab;
import ca.jamdat.flight.GE_Room;
import ca.jamdat.flight.GE_Ticker;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.RTActionScene;
import ca.jamdat.flight.RTActionSceneState;

public final class RTA_TravellingState
extends RTActionSceneState {
    public GE_Clock mClock;
    public GE_MapMovement mMap;

    public final void OnDelete() {
        super.OnDelete();
    }

    public final void Init() {
        this.mMap.SetVisible(true);
        this.mMap.SelectRoom(GameApp.Get().GetScenarioContext().GetCurrentRoom().mRoomId);
        this.UpdateTickerMessage();
        this.mMap.SetVisible(false);
        super.Init();
    }

    public final boolean HasOpeningAnims() {
        return true;
    }

    public RTA_TravellingState(RTActionScene rTActionScene, GE_DialogBox gE_DialogBox, GE_Room gE_Room, GE_Ticker gE_Ticker, GE_MapMovement gE_MapMovement, GE_Clock gE_Clock, GE_NavTab gE_NavTab) {
        super(rTActionScene, gE_DialogBox, gE_Room, gE_Ticker, gE_NavTab);
        this.mMap = gE_MapMovement;
        this.mClock = gE_Clock;
        GameApp.Get().GetScenarioContext().OnEvent(30);
        this.mRoom.SetState(9);
    }

    public final void StartClosingAnims(int n) {
        super.StartClosingAnims(n);
        this.mMap.StartClosingAnims();
    }

    public final boolean OnCommand(int n) {
        boolean bl = true;
        switch (n) {
            case 11: {
                this.ReturnToFreeRoaming();
                break;
            }
            case 37: {
                if (this.mMap.IsSelectedRoomIDValid()) {
                    GameApp.Get().GetScenarioContext().OnEvent(31, this.mRoom.mBackgroundID, this.mMap.mCurrentSelectedRoom);
                    GameApp.Get().GetScenarioContext().OnEvent(9, this.mMap.mCurrentSelectedRoom);
                    GameApp.Get().GetScenarioContext().OnEvent(12);
                    this.StartClosingAnims();
                    break;
                }
                if (GameApp.Get().GetScenarioContext().GetCurrentRoom().mRoomId == this.mMap.mCurrentSelectedRoom) {
                    this.ReturnToFreeRoaming();
                    break;
                }
                FlString flString = ClueUtils.GetGameString(140);
                this.mDialogBox.Show(flString, 3, 6, 2);
                this.UpdateSoftkeys(7, 38, 8, -14);
                break;
            }
            case 38: {
                this.mDialogBox.Hide();
                this.SetDefaultSoftkeys();
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl || super.OnCommand(n);
    }

    public final boolean HasClosingAnims() {
        return true;
    }

    public final void Leave() {
        if (this.mMap.IsSelectedRoomIDValid() && this.mNextState != 4) {
            this.mRoom.SetState(0);
            this.mRTActionScene.OnCommand(-13);
        }
        this.mMap.SetVisible(false);
        if (Constants.geMapContainerOffsetYFct() < Constants.clockViewportHeightFct()) {
            this.mClock.ShowStatic();
        }
        super.Leave();
    }

    private void UpdateTickerMessage() {
        FlString flString = new FlString(RTActionSceneState.GetStringFromRTActionScenePackage(12));
        ClueUtils.ReplaceAllRoomIDInString(flString, GameApp.Get().GetScenarioContext().GetCurrentRoom().mRoomId);
        this.mTicker.SetTickerMessage(flString);
    }

    public final void SetDefaultSoftkeys() {
        if (this.IsOpeningAnimsEnded()) {
            this.UpdateSoftkeys(6, 37, 1, 11);
            return;
        }
        this.UpdateSoftkeys(4, 0, 8, -14);
    }

    public final void StartOpeningAnims() {
        this.mMap.SetVisible(true);
        super.StartOpeningAnims();
        this.mMap.StartOpeningAnims();
        if (Constants.geMapContainerOffsetYFct() < Constants.clockViewportHeightFct()) {
            this.mClock.Hide();
        }
    }

    public final boolean IsOpeningAnimsEnded() {
        return this.mMap.IsOpeningAnimsEnded();
    }

    public final void EndOpeningAnims() {
        this.mMap.EndOpeningAnims();
        super.EndOpeningAnims();
    }

    public final void StartClosingAnims() {
        super.StartClosingAnims();
        this.mMap.StartClosingAnims();
        this.mClock.Update();
    }

    public final boolean IsClosingAnimsEnded() {
        return this.mMap.IsClosingAnimsEnded() && this.mClock.IsAnimsEnded();
    }

    private void ReturnToFreeRoaming() {
        this.mRoom.SetState(1);
        this.mRoom.MoveTo(5);
        this.StartClosingAnims(4);
    }

    public final boolean OnPenUp(byte by, short[] sArray) {
        boolean bl = false;
        if (this.mRoom.mRoomCurrentState != 0) {
            bl = this.mMap.OnPenUp(by, sArray);
        }
        return bl || super.OnPenUp(by, sArray);
    }

    public final boolean OnKeyDownOrRepeat(int n) {
        if (!this.mDialogBox.mIsActive) {
            switch (n) {
                case 4: {
                    this.mMap.Move(3);
                    this.UpdateTickerMessage();
                    return true;
                }
                case 3: {
                    this.mMap.Move(2);
                    this.UpdateTickerMessage();
                    return true;
                }
                case 1: {
                    this.mMap.Move(0);
                    this.UpdateTickerMessage();
                    return true;
                }
                case 2: {
                    this.mMap.Move(1);
                    this.UpdateTickerMessage();
                    return true;
                }
            }
        }
        return super.OnKeyDownOrRepeat(n);
    }

    public final boolean OnPenDown(byte by, short[] sArray) {
        boolean bl = false;
        if (this.mRoom.mRoomCurrentState != 0) {
            bl = this.mMap.OnPenDown(by, sArray);
        }
        return bl || super.OnPenDown(by, sArray);
    }
}

