/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

public final class PathCalculator {
    public int mCurrentOrigin;
    public int[][] mGraph = null;
    public int mNbVertex;
    public int[] mDistance = null;
    public int[] mPrevious = null;

    public final void OnDelete() {
        this.ReleaseDistance();
        this.ReleasePrevious();
    }

    public PathCalculator(int[][] nArray, int n) {
        this.mGraph = nArray;
        this.mNbVertex = n;
        this.mCurrentOrigin = -1;
        this.mDistance = new int[this.mNbVertex];
        this.mPrevious = new int[this.mNbVertex];
        this.Clear();
    }

    public final int[] GetPath(int n, int n2) {
        if (!this.IsSameOrigin(n)) {
            this.mCurrentOrigin = n;
            this.ComputePaths();
        }
        int[] nArray = new int[this.mNbVertex];
        for (int i = 0; i < this.mNbVertex; ++i) {
            nArray[i] = 1000;
        }
        this.OrderNodes(nArray, n2);
        return nArray;
    }

    public final int GetCost(int n, int n2) {
        if (!this.IsSameOrigin(n)) {
            this.mCurrentOrigin = n;
            this.ComputePaths();
        }
        return this.mDistance[n2];
    }

    private static boolean IsEmpty(int[] nArray, int n) {
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == 1) continue;
            bl = false;
        }
        return bl;
    }

    private boolean IsSameOrigin(int n) {
        return this.mCurrentOrigin == n;
    }

    private void ComputePaths() {
        int n;
        int[] nArray = new int[this.mNbVertex];
        for (n = 0; n < this.mNbVertex; ++n) {
            nArray[n] = 0;
        }
        this.mDistance[this.mCurrentOrigin] = 0;
        while (!PathCalculator.IsEmpty(nArray, this.mNbVertex)) {
            int n2 = this.GetMin(nArray);
            nArray[n2] = 1;
            for (n = 0; n < this.mNbVertex; ++n) {
                int n3;
                if (this.mGraph[n2][n] == -1 || nArray[n] == 1 || (n3 = this.mDistance[n2] + this.mGraph[n2][n]) >= this.mDistance[n]) continue;
                this.mDistance[n] = n3;
                this.mPrevious[n] = n2;
            }
        }
    }

    private int GetMin(int[] nArray) {
        int n = -1;
        int n2 = 1001;
        for (int i = 0; i < this.mNbVertex; ++i) {
            if (nArray[i] == 1 || this.mDistance[i] >= n2) continue;
            n2 = this.mDistance[i];
            n = i;
        }
        return n;
    }

    private void OrderNodes(int[] nArray, int n, int n2) {
        n = this.mPrevious[n];
        int n3 = n2 + 1;
        nArray[n2] = n;
        if (n == 1000) {
            return;
        }
        this.OrderNodes(nArray, n, n3);
    }

    private void ReleaseDistance() {
        if (this.mDistance != null) {
            this.mDistance = null;
        }
    }

    private void ReleasePrevious() {
        if (this.mPrevious != null) {
            this.mPrevious = null;
        }
    }

    private void OrderNodes(int[] nArray, int n) {
        this.OrderNodes(nArray, n, 0);
    }

    private void Clear() {
        int n;
        for (n = 0; n < this.mNbVertex; ++n) {
            this.mDistance[n] = 1000;
        }
        for (n = 0; n < this.mNbVertex; ++n) {
            this.mPrevious[n] = 1000;
        }
    }
}

