/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.FlBitmapMap;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_GameEntity;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.IndexedSprite;
import ca.jamdat.flight.Sprite;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.TimeControlled;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public final class GE_SelectionPopUp
extends GE_GameEntity {
    public FlString mChoice2String;
    public boolean mIsUsedTabPositionUpdated;
    public int[] mTabState = null;
    public boolean mIsActive;
    public boolean mIsInConfrontation;
    public FlString mChoice1String;
    public int[] mCommands = null;
    public FlString mChoice3String;
    public int mSelectedTab = 0;

    public final void IsInConfrontationState(boolean bl) {
        this.mIsInConfrontation = bl;
        if (!bl) {
            this.mIsUsedTabPositionUpdated = false;
        }
    }

    public final void UpdateTabs() {
        this.UpdateSelectionTabVisibility();
        this.UpdateTab(0);
        this.UpdateTab(1);
        this.UpdateTab(2);
        this.mComponentViewport.SetTopLeft(Vector2_short.GetX_(this.mComponentViewport.GetTopLeft()), (short)((Constants.navTabMinimizedViewportTopFct() - Vector2_short.GetY_(this.mComponentViewport.GetSize())) / 2));
        if (this.mTabState[this.mSelectedTab] != 0) {
            this.SetArrowsPosition();
        }
        this.UpdateUpDownArrowVisibility();
    }

    public final void SetSelectionState(int n, int n2) {
        this.mTabState[n] = n2;
    }

    private static boolean IsOneSelectionAtATime() {
        return false;
    }

    private void SetHeader(FlString flString) {
        Component component = (Viewport)this.mComponentViewport.GetChild(0);
        Text text = (Text)((Viewport)component).GetChild(4);
        int n = Utilities.GetComponentIndex(text);
        Viewport viewport = text.m_pViewport;
        text.SetViewport(null);
        text.SetCaption(new FlString(flString));
        int n2 = GE_SelectionPopUp.IsOneSelectionAtATime() ? Constants.selectionPopUpSmallFamilyHeaderNbOfLinesFct() : (int)text.mLineCount;
        short s = Vector2_short.GetY_(component.GetSize());
        n2 = n2 * text.GetLineHeight() + Constants.selectionPopUpUpperPaddingFct() + Constants.selectionPopUpBottomPaddingFct();
        this.UpdateMainViewportHeight(n2, s);
        component.SetSize(Vector2_short.GetX_(component.GetSize()), (short)n2);
        IndexedSprite indexedSprite = (IndexedSprite)((Viewport)component).GetChild(0);
        IndexedSprite indexedSprite2 = (IndexedSprite)((Viewport)component).GetChild(1);
        IndexedSprite indexedSprite3 = (IndexedSprite)((Viewport)component).GetChild(2);
        component = (IndexedSprite)((Viewport)component).GetChild(3);
        short s2 = Vector2_short.GetX_(indexedSprite3.GetSize());
        short s3 = Vector2_short.GetY_(indexedSprite.GetSize());
        indexedSprite3.SetSize(s2, (short)(n2 - s3));
        s3 = Vector2_short.GetX_(indexedSprite3.GetTopLeft());
        s2 = Vector2_short.GetY_(indexedSprite.GetSize());
        indexedSprite3.SetTopLeft(s3, s2);
        component.SetSize(Vector2_short.GetX_(component.GetSize()), (short)(n2 - Vector2_short.GetY_(indexedSprite2.GetSize())));
        text.SetViewport(viewport);
        if (n != -1 && n != viewport.GetChildCount() - 1) {
            viewport.PutComponentInFront(text, viewport.GetChild(n));
        }
        text.SetTopLeft(Vector2_short.GetX_(text.GetTopLeft()), (short)((n2 - Vector2_short.GetY_(text.GetSize())) / 2));
        Sprite sprite = (Sprite)this.mComponentViewport.GetChild(1);
        sprite.SetTopLeft(Vector2_short.GetX_(sprite.GetTopLeft()), (short)n2);
    }

    private void SetTab(int n, FlString flString) {
        n = GE_SelectionPopUp.ConvertSelectionTabToComponentIndex(n);
        Viewport viewport = (Viewport)this.mComponentViewport.GetChild(n);
        Text text = (Text)viewport.GetChild(6);
        int n2 = Utilities.GetComponentIndex(text);
        Viewport viewport2 = text.m_pViewport;
        text.SetViewport(null);
        text.SetCaption(new FlString(flString));
        int n3 = GE_SelectionPopUp.IsOneSelectionAtATime() ? Constants.selectionPopUpSmallFamilyAnswerNbOfLinesFct() : (int)text.mLineCount;
        short s = Vector2_short.GetY_(viewport.GetSize());
        n3 = n3 * text.GetLineHeight() + Constants.selectionPopUpUpperPaddingFct() + Constants.selectionPopUpBottomPaddingFct();
        Sprite sprite = (Sprite)this.mComponentViewport.GetChild(n - 1);
        this.UpdateMainViewportHeight(n3, s);
        viewport.SetSize(Vector2_short.GetX_(viewport.GetSize()), (short)n3);
        if (GE_SelectionPopUp.IsOneSelectionAtATime()) {
            Sprite sprite2 = (Sprite)this.mComponentViewport.GetChild(1);
            short s2 = Vector2_short.GetX_(viewport.GetTopLeft());
            short s3 = Vector2_short.GetY_(sprite2.GetTopLeft());
            s3 = (short)(Vector2_short.GetY_(sprite2.GetSize()) + s3);
            viewport.SetTopLeft(s2, s3);
        } else {
            viewport.SetTopLeft(Vector2_short.GetX_(viewport.GetTopLeft()), (short)(Vector2_short.GetY_(sprite.GetTopLeft()) + Vector2_short.GetY_(sprite.GetSize())));
        }
        IndexedSprite indexedSprite = (IndexedSprite)viewport.GetChild(0);
        sprite = (IndexedSprite)viewport.GetChild(1);
        IndexedSprite indexedSprite2 = (IndexedSprite)viewport.GetChild(2);
        IndexedSprite indexedSprite3 = (IndexedSprite)viewport.GetChild(3);
        IndexedSprite indexedSprite4 = (IndexedSprite)viewport.GetChild(4);
        IndexedSprite indexedSprite5 = (IndexedSprite)viewport.GetChild(5);
        indexedSprite2.SetSize(Vector2_short.GetX_(indexedSprite2.GetSize()), (short)(n3 - (Vector2_short.GetY_(indexedSprite.GetSize()) + Vector2_short.GetY_(indexedSprite4.GetSize()))));
        indexedSprite2.SetTopLeft(Vector2_short.GetX_(indexedSprite2.GetTopLeft()), Vector2_short.GetY_(indexedSprite.GetSize()));
        indexedSprite3.SetSize(Vector2_short.GetX_(indexedSprite3.GetSize()), (short)(n3 - (Vector2_short.GetY_(sprite.GetSize()) + Vector2_short.GetY_(indexedSprite5.GetSize()))));
        indexedSprite3.SetTopLeft(Vector2_short.GetX_(indexedSprite2.GetSize()), Vector2_short.GetY_(sprite.GetSize()));
        indexedSprite4.SetTopLeft(Vector2_short.GetX_(indexedSprite4.GetTopLeft()), (short)(Vector2_short.GetY_(indexedSprite.GetSize()) + Vector2_short.GetY_(indexedSprite2.GetSize())));
        indexedSprite5.SetTopLeft(Vector2_short.GetX_(indexedSprite5.GetTopLeft()), (short)(Vector2_short.GetY_(sprite.GetSize()) + Vector2_short.GetY_(indexedSprite3.GetSize())));
        text.SetViewport(viewport2);
        if (n2 != -1 && n2 != viewport2.GetChildCount() - 1) {
            viewport2.PutComponentInFront(text, viewport2.GetChild(n2));
        }
        text.SetTopLeft(Vector2_short.GetX_(text.GetTopLeft()), (short)((n3 - Vector2_short.GetY_(text.GetSize())) / 2));
        if (!(GE_SelectionPopUp.IsOneSelectionAtATime() || this.GetUsedSelectionTabCount() != 0 && this.mIsUsedTabPositionUpdated)) {
            Sprite sprite3 = (Sprite)this.mComponentViewport.GetChild(n + 1);
            sprite3.SetTopLeft(Vector2_short.GetX_(sprite3.GetTopLeft()), (short)(Vector2_short.GetY_(viewport.GetTopLeft()) + n3));
        }
    }

    private void ChangeSelectedTab(boolean bl) {
        if (!bl && this.mSelectedTab == 0 || this.GetUsedSelectionTabCount() == 2) {
            this.mSelectedTab = 0;
            return;
        }
        if (bl && this.mSelectedTab == 2 || this.GetUsedSelectionTabCount() == 2) {
            this.mSelectedTab = 2;
            return;
        }
        int n = bl ? 1 : -1;
        if (bl && this.GetUsedSelectionTabCount() == 1 && this.mSelectedTab == 1) {
            this.mSelectedTab = 1;
            return;
        }
        this.mSelectedTab = (this.mSelectedTab + n) % 3;
    }

    public final void Load() {
        int n;
        super.Load();
        this.mPackage = GameLibrary.GetPackage(425997);
        this.mTabState = new int[3];
        for (n = 0; n < 3; ++n) {
            this.mTabState[n] = 1;
        }
        this.mCommands = new int[3];
        for (n = 0; n < 3; ++n) {
            this.mCommands[n] = 0;
        }
    }

    private void UpdateMainViewportHeight(int n, int n2) {
        if (GE_SelectionPopUp.IsOneSelectionAtATime()) {
            Sprite sprite = (Sprite)this.mComponentViewport.GetChild(1);
            Viewport viewport = (Viewport)this.mComponentViewport.GetChild(GE_SelectionPopUp.ConvertSelectionTabToComponentIndex(this.mSelectedTab));
            Sprite sprite2 = (Sprite)this.mComponentViewport.GetChild(7);
            Viewport viewport2 = this.mComponentViewport;
            short s = Vector2_short.GetX_(this.mComponentViewport.GetSize());
            short s2 = (short)(Vector2_short.GetY_(((Viewport)this.mComponentViewport.GetChild(0)).GetSize()) + Vector2_short.GetY_(sprite.GetSize()) + Vector2_short.GetY_(viewport.GetSize()) + Vector2_short.GetY_(sprite2.GetSize()));
            viewport2.SetSize(s, s2);
            return;
        }
        Viewport viewport = this.mComponentViewport;
        short s = Vector2_short.GetX_(this.mComponentViewport.GetSize());
        n2 = (short)(n - n2 + Vector2_short.GetY_(this.mComponentViewport.GetSize()));
        viewport.SetSize(s, (short)n2);
    }

    private void SetArrowsPosition() {
        Viewport viewport = (Viewport)((GE_GameEntity)timeControlled).mComponentViewport.GetChild(GE_SelectionPopUp.ConvertSelectionTabToComponentIndex(((GE_SelectionPopUp)timeControlled).mSelectedTab));
        TimeControlled timeControlled = (Viewport)((GE_GameEntity)timeControlled).mComponentViewport.GetChild(8);
        short s = Vector2_short.GetX_(((Component)timeControlled).GetSize());
        short s2 = (short)(Vector2_short.GetY_(viewport.GetSize()) + Constants.selectionPopUpArrowsViewportOverlayFct());
        ((Component)timeControlled).SetSize(s, s2);
        s2 = Vector2_short.GetX_(((Component)timeControlled).GetTopLeft());
        s = (short)(Vector2_short.GetY_(viewport.GetTopLeft()) - Constants.selectionPopUpArrowsViewportOverlayFct() / 2);
        ((Component)timeControlled).SetTopLeft(s2, s);
        Sprite sprite = (Sprite)((Viewport)timeControlled).GetChild(1);
        sprite.SetTopLeft(Vector2_short.GetX_(sprite.GetTopLeft()), (short)(Vector2_short.GetY_(((Component)timeControlled).GetSize()) - Vector2_short.GetY_(sprite.GetSize())));
    }

    public final void Unload() {
        this.mChoice1String = null;
        this.mChoice2String = null;
        this.mChoice3String = null;
        this.mTabState = null;
        this.mCommands = null;
        super.Unload();
        GameLibrary.ReleasePackage(this.mPackage);
    }

    public final boolean IsLoaded() {
        return this.mPackage.IsLoaded();
    }

    private void SetUpDownArrowVisibility(boolean bl, boolean bl2) {
        Viewport viewport = (Viewport)((GE_GameEntity)timeControlled).mComponentViewport.GetChild(8);
        TimeControlled timeControlled = (Sprite)viewport.GetChild(0);
        ((Component)timeControlled).SetVisible(bl);
        ((Sprite)viewport.GetChild(1)).SetVisible(bl2);
    }

    private void UpdateUpDownArrowVisibility() {
        boolean bl = true;
        boolean bl2 = true;
        if (this.mSelectedTab == 0) {
            bl = false;
        } else if (this.mSelectedTab == 2 || this.mSelectedTab == 1 && this.GetUsedSelectionTabCount() == 1) {
            bl2 = false;
        }
        if (this.GetUsedSelectionTabCount() == 2) {
            bl = false;
            bl2 = false;
        }
        this.SetUpDownArrowVisibility(bl, bl2);
    }

    private void UpdateTab(int n) {
        int n2 = GE_SelectionPopUp.ConvertSelectionTabToComponentIndex(n);
        Viewport viewport = (Viewport)this.mComponentViewport.GetChild(n2);
        int n3 = Constants.selectionPopUpViewportBaseWidthFct();
        if (this.mSelectedTab == n && this.mTabState[n] == 1) {
            n3 = Constants.selectionPopUpViewportExtendedWidthFct();
        }
        int n4 = 3;
        int n5 = 5;
        if (this.mTabState[n] == 1) {
            if (this.mSelectedTab == n) {
                n4 = 1;
                n5 = 5;
            } else {
                n4 = 2;
                n5 = 6;
            }
            if (GE_SelectionPopUp.IsOneSelectionAtATime()) {
                boolean bl = this.mSelectedTab == n;
                viewport.SetVisible(bl);
            }
        } else {
            viewport.SetVisible(false);
        }
        FlBitmapMap flBitmapMap = FlBitmapMap.Cast$4864501b(this.mPackage.mPackage.GetEntryPoint(n4));
        FlFont flFont = FlFont.Cast$be01453(this.mPackage.mPackage.GetEntryPoint(n5));
        Text text = (Text)viewport.GetChild(6);
        text.SetFont(flFont);
        if (GE_SelectionPopUp.IsOneSelectionAtATime() && this.mSelectedTab == n) {
            int n6 = Constants.selectionPopUpSmallFamilyAnswerNbOfLinesFct() * text.GetLineHeight() + 2 + 2;
            Sprite sprite = (Sprite)this.mComponentViewport.GetChild(3);
            sprite.SetTopLeft(sprite.mRect_left, (short)(viewport.mRect_top + n6));
            ((Sprite)this.mComponentViewport.GetChild(5)).SetVisible(false);
            Sprite sprite2 = (Sprite)this.mComponentViewport.GetChild(7);
            sprite2.SetTopLeft(sprite2.mRect_left, (short)(viewport.mRect_top + n6));
        }
        ClueUtils.UpdateTab(viewport, n3, 0, flBitmapMap);
        if (!GE_SelectionPopUp.IsOneSelectionAtATime()) {
            if (n - 1 != this.mSelectedTab) {
                Sprite sprite = (Sprite)this.mComponentViewport.GetChild(n2 - 1);
                short s = Vector2_short.GetY_(sprite.GetSize());
                sprite.SetSize((short)n3, s);
            }
            if (this.GetUsedSelectionTabCount() == 0 || this.GetUsedSelectionTabCount() == 1 && n != 2 || this.GetUsedSelectionTabCount() == 2 && n == 0) {
                Sprite sprite = (Sprite)this.mComponentViewport.GetChild(n2 + 1);
                short s = Vector2_short.GetY_(sprite.GetSize());
                sprite.SetSize((short)n3, s);
                Sprite sprite3 = (Sprite)this.mComponentViewport.GetChild(7);
                if (this.GetUsedSelectionTabCount() == 1 && n == 0) {
                    n3 = Constants.selectionPopUpViewportBaseWidthFct();
                }
                sprite3.SetSize((short)n3, sprite3.mRect_height);
            }
            if (this.GetUsedSelectionTabCount() == 2 && n == 0) {
                ((Sprite)this.mComponentViewport.GetChild(5)).SetVisible(false);
            }
        }
    }

    private void UpdateSelectionTabVisibility() {
        if (!GE_SelectionPopUp.IsOneSelectionAtATime()) {
            this.UpdateSelectionTabPosition();
        }
        this.UpdateSelectionTabStateAndString();
    }

    private void UpdateSelectionTabStateAndString() {
        for (int i = 0; i < 3; ++i) {
            FlString flString;
            if (this.GetUsedSelectionTabCount() == 1 && this.mTabState[i] == 0) {
                if (i == 2) continue;
                this.SetSelectionState(2, 0);
                this.SetSelectionState(i, 1);
                this.SetSelectionCommand(2, 0);
                this.SetSelectionCommand(i, 29);
                flString = i == 0 ? this.mChoice1String : this.mChoice2String;
                this.SetTab(2, flString);
                this.SetTab(i, this.mChoice3String);
                if (i == 0) {
                    this.mChoice3String = this.mChoice1String = this.mChoice3String;
                    continue;
                }
                this.mChoice3String = this.mChoice2String = this.mChoice3String;
                continue;
            }
            if (this.GetUsedSelectionTabCount() != 2 || this.mTabState[i] != 1 || i == 0) continue;
            this.SetSelectionState(0, 1);
            this.SetSelectionState(1, 0);
            this.SetSelectionState(2, 0);
            this.SetSelectionCommand(0, 29);
            this.SetSelectionCommand(1, 0);
            this.SetSelectionCommand(2, 0);
            flString = i == 0 ? this.mChoice1String : this.mChoice2String;
            if (i == 2) {
                flString = this.mChoice3String;
            }
            this.SetTab(0, flString);
        }
    }

    private void UpdateSelectionTabPosition() {
        Sprite sprite = (Sprite)this.mComponentViewport.GetChild(7);
        Sprite sprite2 = (Sprite)this.mComponentViewport.GetChild(1);
        Sprite sprite3 = (Sprite)this.mComponentViewport.GetChild(3);
        Sprite sprite4 = (Sprite)this.mComponentViewport.GetChild(5);
        for (int i = 0; i < 3; ++i) {
            if (this.GetUsedSelectionTabCount() == 1 && this.mTabState[i] == 0 && !this.mIsUsedTabPositionUpdated) {
                int n = this.mSelectedTab == 1 ? 2 : 1;
                Viewport viewport = (Viewport)this.mComponentViewport.GetChild(2 * i + 2);
                Viewport viewport2 = (Viewport)this.mComponentViewport.GetChild(2 * n + 2);
                sprite.SetTopLeft(sprite.mRect_left, (short)(sprite.mRect_top - viewport.mRect_height - sprite4.mRect_height));
                viewport.SetTopLeft(viewport.mRect_left, (short)(sprite.mRect_top + sprite.mRect_height));
                sprite3.SetTopLeft(sprite3.mRect_left, (short)(sprite.mRect_top - viewport.mRect_height - sprite3.mRect_height));
                if (i != n) {
                    viewport2.SetTopLeft(viewport2.mRect_left, (short)(sprite.mRect_top - viewport2.mRect_height - sprite2.mRect_height));
                    sprite3.SetTopLeft(sprite3.mRect_left, (short)(viewport2.mRect_top - sprite3.mRect_height));
                    sprite.SetTopLeft(sprite.mRect_left, (short)(sprite.mRect_top - sprite4.mRect_height));
                }
                sprite4.SetVisible(false);
                this.mIsUsedTabPositionUpdated = true;
                continue;
            }
            if (this.GetUsedSelectionTabCount() != 2 || this.mTabState[i] != 1) continue;
            Viewport viewport = (Viewport)this.mComponentViewport.GetChild(2 * i + 2);
            viewport.SetTopLeft(viewport.mRect_left, (short)(sprite2.mRect_top + sprite2.mRect_height));
            sprite3.SetVisible(false);
            sprite.SetTopLeft(sprite.mRect_left, (short)(viewport.mRect_top + viewport.mRect_height));
        }
    }

    private int GetUsedSelectionTabCount() {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            if (this.mTabState[i] != 0) continue;
            ++n;
        }
        return n;
    }

    private static int ConvertSelectionTabToComponentIndex(int n) {
        int n2 = 0;
        if (n == 0) {
            n2 = 2;
        } else if (n == 1) {
            n2 = 4;
        } else if (n == 2) {
            n2 = 6;
        }
        return n2;
    }

    public final void LockAccess() {
        this.SetSelectionState(0, 0);
        this.SetSelectionState(1, 0);
        this.SetSelectionState(2, 0);
    }

    public final boolean OnPenUp(byte by, short[] sArray) {
        by = 0;
        for (int i = 0; i < 3 && by == 0; ++i) {
            by = ClueUtils.Contains((Viewport)this.mComponentViewport.GetChild(GE_SelectionPopUp.ConvertSelectionTabToComponentIndex(i)), sArray) ? 1 : 0;
            if (by == 0) continue;
            this.mSelectedTab = i;
            this.OnCommand(26);
        }
        return by != 0;
    }

    public final boolean OnPenDown(byte by, short[] sArray) {
        by = 0;
        for (int i = 0; i < 3 && by == 0; ++i) {
            by = ClueUtils.Contains((Viewport)this.mComponentViewport.GetChild(GE_SelectionPopUp.ConvertSelectionTabToComponentIndex(i)), sArray) ? 1 : 0;
            if (by == 0) continue;
            this.mSelectedTab = i;
            this.UpdateTabs();
        }
        return by != 0;
    }

    public final boolean OnPenMove(byte by, short[] sArray, short[] sArray2, short[] sArray3) {
        return this.OnPenDown(by, sArray2);
    }

    public final boolean OnCommand(int n) {
        boolean bl = false;
        if (n == 26 && this.mTabState[this.mSelectedTab] == 1) {
            bl = this.mBaseScene.OnCommand(this.mCommands[this.mSelectedTab]);
        }
        return bl;
    }

    public GE_SelectionPopUp(BaseScene baseScene) {
        super(baseScene);
    }

    public final void Init(Viewport viewport) {
        super.Init(viewport);
        this.SetActive(false);
        this.mSelectedTab = 0;
        this.UpdateUpDownArrowVisibility();
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        this.mComponentViewport = Viewport.Cast$7c352e71(this.mPackage.mPackage.GetEntryPoint(0));
    }

    public final void Hide() {
        this.SetActive(false);
        this.mSelectedTab = 0;
    }

    public final void Unlock(int n) {
        this.SetSelectionState(n, 1);
    }

    private void SetActive(boolean bl) {
        this.mIsActive = bl;
        this.mComponentViewport.SetVisible(bl);
    }

    public final boolean OnKeyDownOrRepeat(int n) {
        boolean bl = false;
        switch (n) {
            case 1: 
            case 2: {
                if (!this.mIsActive) break;
                bl = n == 2;
                this.ChangeSelectedTab(bl);
                this.UpdateTabs();
                bl = true;
            }
        }
        return bl;
    }

    public final void Show(FlString flString, FlString flString2, FlString flString3, FlString flString4) {
        this.SetActive(true);
        this.SetHeader(flString);
        this.SetTab(0, flString2);
        this.SetTab(1, flString3);
        this.SetTab(2, flString4);
        if (this.mIsInConfrontation) {
            this.mChoice1String = null;
            this.mChoice2String = null;
            this.mChoice3String = null;
            this.mChoice1String = new FlString(flString2);
            this.mChoice2String = new FlString(flString3);
            this.mChoice3String = new FlString(flString4);
        }
        this.UpdateTabs();
    }

    public final void SetSelectionCommand(int n, int n2) {
        this.mCommands[n] = n2;
    }

    public final void ResetSelectionTabVisiblity() {
        for (int i = 0; i < 3; ++i) {
            ((Viewport)this.mComponentViewport.GetChild(2 * i + 2)).SetVisible(true);
            ((Sprite)this.mComponentViewport.GetChild(2 * i + 1)).SetVisible(true);
        }
    }
}

