/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.GE_GameEntity;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Viewport;

public final class GE_Editor
extends GE_GameEntity {
    public int mAccumulator;
    public int mAnimTimeLimit;
    public boolean mAnimationEnabled;
    public TimeSystem mTimeSystemEditor;

    public final void SetVisible(boolean bl) {
        if (this.mAnimationEnabled) {
            if (this.mComponentViewport.mVisible && !bl) {
                this.StartClosingAnims();
                return;
            }
            if (!this.mComponentViewport.mVisible && bl) {
                this.StartOpeningAnims();
                return;
            }
        } else {
            this.mComponentViewport.SetVisible(bl);
        }
    }

    public final void Load() {
        super.Load();
        this.mPackage = GameLibrary.GetPackage(0x100020);
    }

    public final boolean IsVisible() {
        return this.mComponentViewport.mVisible;
    }

    public final void Unload() {
        this.UnRegisterInGlobalTime();
        Utilities.StopTimeSystem(this.mTimeSystemEditor);
        this.mTimeSystemEditor = null;
        super.Unload();
        GameLibrary.ReleasePackage(this.mPackage);
    }

    public final boolean IsLoaded() {
        return this.mPackage.IsLoaded();
    }

    public GE_Editor(BaseScene baseScene) {
        super(baseScene);
    }

    public final void Init(Viewport viewport) {
        super.Init(viewport);
        this.SetVisible(false);
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        this.mComponentViewport = Viewport.Cast$7c352e71(this.mPackage.mPackage.GetEntryPoint(0));
        this.mTimeSystemEditor = TimeSystem.Cast$3b277f7b(this.mPackage.mPackage.GetEntryPoint(1));
    }

    private void StartOpeningAnims() {
        this.RegisterInGlobalTime();
        Utilities.StartTimeSystem(this.mTimeSystemEditor);
        this.mAccumulator = 0;
        this.mAnimTimeLimit = 250;
        this.mComponentViewport.SetVisible(true);
    }

    private void StartClosingAnims() {
        this.RegisterInGlobalTime();
        Utilities.StartTimeSystemInverse(this.mTimeSystemEditor, 250);
        this.mAccumulator = -250;
        this.mAnimTimeLimit = 0;
    }

    private void OnEditorHidden() {
        this.mComponentViewport.SetVisible(false);
    }

    public final void OnTime(int n, int n2) {
        this.mAccumulator += n2;
        if (this.mAccumulator >= this.mAnimTimeLimit) {
            if (this.mAnimTimeLimit == 0) {
                this.OnEditorHidden();
            }
            this.UnRegisterInGlobalTime();
        }
    }
}

