/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.Color888;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.FlBitmap;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_GameEntity;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.Selector;
import ca.jamdat.flight.Shape;
import ca.jamdat.flight.Sprite;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Viewport;

public final class GE_CrimeRoomContents
extends GE_GameEntity {
    public int mItemSelection = 0;
    public short mProjectedBoxHeight;
    public short mProjectedBoxOffsetY;
    public MetaPackage mCrimePackage;
    public short mProjectedBoxOffsetX;
    public Shape mShapeWeapon;
    public MetaPackage mPackageSmallArrows;
    public Viewport mArrowsWeapon;
    public Text mTextRoomSelection;
    public short mProjectedWeaponOffsetX;
    public int mCurrentSuspect = 0;
    public int mCurrentWeapon = 0;
    public Sprite mRightArrow;
    public Shape mShapeAnimTransition;
    public boolean mActive;
    public short mOriginBoxHeight;
    public Shape mShapeSuspect;
    public int mCurrentTimeAnim;
    public Sprite mSpriteWeapon;
    public Shape mTitleShape;
    public Viewport mViewportChangeItems;
    public short mOriginSuspectOffsetX;
    public boolean mAnimationProgress;
    public Selector mSelectorSuspect;
    public Sprite mLeftArrow;
    public FlFont mTextFont;
    public Text mTextAnimTransition;
    public short mProjectedSuspectOffsetX;
    public Sprite mSpriteCharacter;
    public Selector mSelectorWeapon;
    public short mProjectedBoxWidth;
    public Text mTitle;
    public short mOriginBoxWidth;
    public short mOriginWeaponOffsetX;
    public short mOriginBoxOffsetX;
    public short mOriginBoxOffsetY;
    public Viewport mArrowsSuspect;

    public final void Load() {
        super.Load();
        this.mPackage = GameLibrary.GetPackage(5472423);
        this.mCrimePackage = GameLibrary.GetPackage(2916441);
        this.mPackageSmallArrows = GameLibrary.GetPackage(557073);
        this.mComponentViewport = new Viewport();
        this.mSpriteCharacter = new Sprite();
        this.mSpriteWeapon = new Sprite();
    }

    public final void Unload() {
        this.UnRegisterInGlobalTime();
        if (this.mShapeAnimTransition != null) {
            this.mShapeAnimTransition.SetViewport(null);
            this.mShapeAnimTransition = null;
        }
        if (this.mTextAnimTransition != null) {
            this.mTextAnimTransition.SetViewport(null);
            this.mTextAnimTransition = null;
        }
        if (this.mViewportChangeItems != null) {
            this.mViewportChangeItems.SetViewport(null);
            this.mViewportChangeItems = null;
        }
        if (this.mSpriteCharacter != null) {
            this.mSpriteCharacter.SetViewport(null);
            this.mSpriteCharacter.SetBitmap(null);
            this.mSpriteCharacter = null;
        }
        if (this.mSpriteWeapon != null) {
            this.mSpriteWeapon.SetViewport(null);
            this.mSpriteWeapon.SetBitmap(null);
            this.mSpriteWeapon = null;
        }
        if (this.mTitle != null) {
            this.mTitle.SetViewport(null);
            this.mTitle = null;
        }
        super.Unload();
        GameLibrary.ReleasePackage(this.mPackage);
        GameLibrary.ReleasePackage(this.mCrimePackage);
        GameLibrary.ReleasePackage(this.mPackageSmallArrows);
    }

    public final boolean IsLoaded() {
        return this.mPackage.IsLoaded() && this.mCrimePackage.IsLoaded() && this.mPackageSmallArrows.IsLoaded();
    }

    public final boolean OnPenUp(byte by, short[] sArray) {
        by = 0;
        if (ClueUtils.Contains(this.mSelectorSuspect, sArray) && this.mLeftArrow.mVisible || this.mSpriteCharacter.mVisible && ClueUtils.Contains(this.mSpriteCharacter, sArray) || this.mLeftArrow.mVisible && ClueUtils.Contains(this.mLeftArrow, sArray)) {
            this.SetActive(1);
            by = 1;
        } else if (ClueUtils.Contains(this.mSelectorWeapon, sArray) && this.mRightArrow.mVisible || this.mSpriteWeapon.mVisible && ClueUtils.Contains(this.mSpriteWeapon, sArray) || this.mRightArrow.mVisible && ClueUtils.Contains(this.mRightArrow, sArray)) {
            this.SetActive(2);
            by = 1;
        }
        return by != 0;
    }

    public final void SetSize(short s, short s2, short s3, short s4) {
        this.mComponentViewport.SetTopLeft(s, s2);
        this.mComponentViewport.SetSize(s3, s4);
    }

    public final void SetAnnotationBitmap(int n, FlBitmap flBitmap) {
        Sprite sprite = this.mSpriteCharacter;
        if (n == 2) {
            sprite = this.mSpriteWeapon;
        }
        if (flBitmap != null) {
            sprite.SetBitmap(flBitmap);
            sprite.SetViewport(this.mComponentViewport);
            sprite.SetVisible(true);
            this.UpdateAnnotationPosition(n, sprite);
            return;
        }
        sprite.SetVisible(false);
    }

    public final void SetActive(int n) {
        int n2 = this.mItemSelection;
        this.mItemSelection = n;
        if (this.mItemSelection == 0) {
            this.StartCloseAnimation();
        } else {
            int n3;
            this.mViewportChangeItems.SetViewport(this.mComponentViewport.m_pViewport);
            this.mViewportChangeItems.SetTopLeft((short)(this.mComponentViewport.mRect_left + (this.mComponentViewport.mRect_width - this.mViewportChangeItems.mRect_width) / 2), (short)(this.mComponentViewport.mRect_top + this.mTitleShape.mRect_top - Constants.crimeSceneBlackShapeOffsetYFct()));
            this.mSelectorSuspect.SetSingleSelection(this.mCurrentSuspect);
            if (this.mCurrentSuspect == 0) {
                Selector selector = this.mSelectorSuspect;
                n3 = this.mCurrentSuspect;
                int n4 = this.mItemSelection == 1 ? 1 : 0;
                this.UpdateSelectionText(selector, n3, true, n4);
            }
            this.mSelectorWeapon.SetSingleSelection(this.mCurrentWeapon);
            if (this.mCurrentWeapon == 0) {
                Selector selector = this.mSelectorWeapon;
                n3 = this.mCurrentWeapon;
                n = this.mItemSelection == 1 ? 0 : 1;
                this.UpdateSelectionText(selector, n3, false, n);
            }
            this.StartOpenAnimation(n2);
        }
        if (this.IsAnimationFinished()) {
            this.UpdateAnnotationPosition(2, this.mSpriteWeapon);
            this.UpdateAnnotationPosition(1, this.mSpriteCharacter);
        }
        this.UpdateChangeAnnotations();
    }

    private void UpdateChangeAnnotations() {
        if (this.mItemSelection != 0) {
            this.mViewportChangeItems.BringToFront();
            boolean bl = this.mItemSelection == 2;
            this.SetWeaponSelectionEnabled(bl);
            bl = this.mItemSelection == 1;
            this.SetSuspectSelectionEnabled(bl);
            FlString flString = new FlString(this.mTitle.GetCaption());
            this.mTextRoomSelection.SetCaption(flString);
            this.mTitle.SetVisible(false);
            this.mTitleShape.SetVisible(false);
            if (!this.mLeftArrow.mVisible && !this.mRightArrow.mVisible) {
                this.mLeftArrow.SetViewport(this.mViewportChangeItems);
                this.mRightArrow.SetViewport(this.mViewportChangeItems);
            }
            if (this.mLeftArrow.m_pViewport == this.mViewportChangeItems && this.mRightArrow.m_pViewport == this.mViewportChangeItems) {
                this.SetLeftRightArrowsState(true);
                this.mLeftArrow.SetTopLeft((short)((this.mViewportChangeItems.mRect_width - this.mLeftArrow.mRect_width) / 2), (short)(this.mArrowsSuspect.mRect_top + (this.mArrowsSuspect.mRect_height - this.mLeftArrow.mRect_height) / 2));
                this.mRightArrow.SetTopLeft((short)((this.mViewportChangeItems.mRect_width - this.mRightArrow.mRect_width) / 2), (short)(this.mArrowsSuspect.mRect_top + (this.mArrowsSuspect.mRect_height - this.mRightArrow.mRect_height) / 2));
            }
        }
    }

    public final void SelectAnnotations(boolean bl) {
        if (this.mItemSelection != 0) {
            int n = 0;
            int n2 = -1;
            int n3 = this.mItemSelection == 2 ? 9 : 6;
            if (bl) {
                n3 = this.mItemSelection == 2 ? 9 : 6;
                n = n3;
                n2 = 1;
                n3 = 0;
            }
            if (this.mItemSelection == 1) {
                if (this.mSelectorSuspect.mCurrentSelectionIndex != n) {
                    this.mSelectorSuspect.SetSingleSelection(this.mSelectorSuspect.mCurrentSelectionIndex + n2);
                } else {
                    this.mSelectorSuspect.SetSingleSelection(n3);
                }
                this.mCurrentSuspect = this.mSelectorSuspect.mCurrentSelectionIndex;
                if (!GameApp.Get().GetScenarioContext().IsSuspectExist(this.GetSuspect()) && this.GetSuspect() != -1) {
                    this.SelectAnnotations(bl);
                    return;
                }
            } else if (this.mItemSelection == 2) {
                if (this.mSelectorWeapon.mCurrentSelectionIndex != n) {
                    this.mSelectorWeapon.SetSingleSelection(this.mSelectorWeapon.mCurrentSelectionIndex + n2);
                } else {
                    this.mSelectorWeapon.SetSingleSelection(n3);
                }
                this.mCurrentWeapon = this.mSelectorWeapon.mCurrentSelectionIndex;
                if (!GameApp.Get().GetScenarioContext().IsWeaponExist(this.GetWeapon()) && this.GetWeapon() != -1) {
                    this.SelectAnnotations(bl);
                }
            }
        }
    }

    public final int GetSuspect() {
        return this.mCurrentSuspect - 1;
    }

    public final int GetWeapon() {
        return this.mCurrentWeapon - 1;
    }

    public final void SetAnnotations(int n, int n2) {
        if (n >= 6) {
            n = -1;
        }
        if (n2 >= 9) {
            n2 = -1;
        }
        this.mCurrentSuspect = n + 1;
        this.mCurrentWeapon = n2 + 1;
    }

    public final boolean IsAnimationFinished() {
        return !this.mAnimationProgress;
    }

    public final void OnTime(int n, int n2) {
        this.UpdateAnimation(n2);
    }

    public final void SetTitle(FlString flString) {
        if (this.mTitle == null) {
            int n = this.mTextFont.GetLineWidth(flString);
            short s = (short)Constants.geCrimeMapMarginWidthFct();
            this.mTitleShape = new Shape();
            this.mTitleShape.SetViewport(this.mComponentViewport);
            this.mTitleShape.SetColor(Color888.c_init_iii(0, 0, 0));
            this.mTitleShape.SetTopLeft(s, (short)(this.mComponentViewport.mRect_height - (this.mTextFont.GetLineHeight() + Constants.geCrimeMapTextMarginBottomFct())));
            this.mTitleShape.SetSize((short)(this.mComponentViewport.mRect_width - 2 * Constants.geCrimeMapMarginWidthFct()), (short)this.mTextFont.GetLineHeight());
            this.mTitle = new Text();
            this.mTitle.SetFont(this.mTextFont);
            this.mTitle.SetCaption(flString);
            this.mTitle.SetViewport(this.mComponentViewport);
            this.mTitle.SetTopLeft((short)(s + (this.mComponentViewport.mRect_width - 2 * Constants.geCrimeMapMarginWidthFct() - n) / 2), (short)(this.mComponentViewport.mRect_height - (this.mTextFont.GetLineHeight() + Constants.geCrimeMapTextMarginBottomFct())));
            this.mTitle.SetSize(this.mComponentViewport.mRect_width, (short)this.mTextFont.GetLineHeight());
            this.SetAnimationTitle(flString);
        }
    }

    public final void BringToFront() {
        this.mComponentViewport.BringToFront();
        this.mTitleShape.BringToFront();
        this.mTitle.BringToFront();
        this.UpdateChangeAnnotations();
    }

    private void SetAnimationTitle(FlString flString) {
        this.mShapeAnimTransition = new Shape();
        this.mShapeAnimTransition.SetViewport(this.mComponentViewport.m_pViewport);
        this.mShapeAnimTransition.SetVisible(false);
        this.mShapeAnimTransition.SetColor(Color888.c_init_iii(0, 0, 0));
        this.mShapeAnimTransition.SetTopLeft((short)(this.mComponentViewport.mRect_left + this.mTitleShape.mRect_left), (short)(this.mComponentViewport.mRect_top + this.mTitleShape.mRect_top));
        this.mShapeAnimTransition.SetSize(this.mTitleShape.mRect_width, this.mTitleShape.mRect_height);
        this.mTextAnimTransition = new Text();
        this.mTextAnimTransition.SetFont(this.mTextFont);
        this.mTextAnimTransition.SetCaption(flString);
        this.mTextAnimTransition.SetViewport(this.mComponentViewport.m_pViewport);
        this.mTextAnimTransition.SetVisible(false);
        this.mTextAnimTransition.SetTopLeft((short)(this.mComponentViewport.mRect_left + this.mTitle.mRect_left), (short)(this.mComponentViewport.mRect_top - this.mTitle.mRect_top));
        this.mTextAnimTransition.SetSize(this.mTitle.mRect_width, this.mTitle.GetLineHeight());
    }

    private void SetLeftRightArrowsState(boolean bl) {
        if (this.mLeftArrow.m_pViewport == this.mViewportChangeItems && this.mRightArrow.m_pViewport == this.mViewportChangeItems) {
            Sprite sprite = this.mRightArrow;
            boolean bl2 = bl && this.mItemSelection == 1;
            sprite.SetVisible(bl2);
            Sprite sprite2 = this.mLeftArrow;
            boolean bl3 = bl && this.mItemSelection == 2;
            sprite2.SetVisible(bl3);
        }
    }

    private void SetSuspectSelectionEnabled(boolean bl) {
        this.mArrowsSuspect.SetVisible(bl);
        this.mShapeSuspect.SetVisible(bl);
    }

    private void SetWeaponSelectionEnabled(boolean bl) {
        this.mArrowsWeapon.SetVisible(bl);
        this.mShapeWeapon.SetVisible(bl);
    }

    public GE_CrimeRoomContents(BaseScene baseScene) {
        super(baseScene);
    }

    public final void Init(Viewport viewport) {
        super.Init(viewport);
        this.mComponentViewport.mClipChildren = true;
        if (this.mItemSelection != 0) {
            this.mViewportChangeItems.SetViewport(viewport);
        }
        this.mActive = true;
        this.mSelectorSuspect.SetSingleSelection(this.mCurrentSuspect);
        this.mSelectorWeapon.SetSingleSelection(this.mCurrentWeapon);
        this.mLeftArrow.SetViewport(this.mViewportChangeItems);
        this.mRightArrow.SetViewport(this.mViewportChangeItems);
        this.SetLeftRightArrowsState(false);
        this.mArrowsSuspect.mPassThrough = false;
        this.mArrowsWeapon.mPassThrough = false;
        this.SetWeaponSelectionEnabled(false);
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        this.mTextFont = FlFont.Cast$be01453(this.mPackage.mPackage.GetEntryPoint(2));
        this.mViewportChangeItems = Viewport.Cast$7c352e71(this.mCrimePackage.mPackage.GetEntryPoint(3));
        this.mShapeSuspect = Shape.Cast$2392dbe5(this.mCrimePackage.mPackage.GetEntryPoint(4));
        this.mShapeWeapon = Shape.Cast$2392dbe5(this.mCrimePackage.mPackage.GetEntryPoint(5));
        this.mArrowsSuspect = Viewport.Cast$7c352e71(this.mCrimePackage.mPackage.GetEntryPoint(6));
        this.mArrowsWeapon = Viewport.Cast$7c352e71(this.mCrimePackage.mPackage.GetEntryPoint(7));
        this.mSelectorSuspect = Selector.Cast$10974a41(this.mCrimePackage.mPackage.GetEntryPoint(8));
        this.mSelectorWeapon = Selector.Cast$10974a41(this.mCrimePackage.mPackage.GetEntryPoint(9));
        this.mTextRoomSelection = Text.Cast$21bacd23(this.mCrimePackage.mPackage.GetEntryPoint(10));
        this.mLeftArrow = Sprite.Cast$46e644cd(this.mPackageSmallArrows.mPackage.GetEntryPoint(2));
        this.mRightArrow = Sprite.Cast$46e644cd(this.mPackageSmallArrows.mPackage.GetEntryPoint(3));
    }

    private void UpdateAnnotationPosition(int n, Sprite sprite) {
        int n2 = 1;
        int n3 = 1;
        if (n == 2) {
            n2 = -1;
            n3 = 3;
        }
        n = Utilities.Max(this.mComponentViewport.mRect_height - Constants.geCrimeMapItemHeightFct(), Constants.crimeSceneSelectorOffsetYFct() + this.mComponentViewport.mRect_height - sprite.mRect_height);
        if (this.mItemSelection == 0) {
            sprite.SetTopLeft((short)((n3 * this.mComponentViewport.mRect_width / 2 - sprite.mRect_width) / 2 + n2 * Constants.geCrimeMapMarginWidthFct() / 2), (short)n);
            return;
        }
        sprite.SetTopLeft((short)((this.mComponentViewport.mRect_width - n2 * this.mViewportChangeItems.mRect_width / 2 - sprite.mRect_width) / 2), (short)n);
    }

    private void StartOpenAnimation(int n) {
        if (n == 0) {
            this.mShapeAnimTransition.SetTopLeft((short)(this.mComponentViewport.mRect_left + this.mTitleShape.mRect_left), (short)(this.mComponentViewport.mRect_top + this.mTitleShape.mRect_top));
            this.mShapeAnimTransition.SetSize(this.mTitleShape.mRect_width, this.mTitleShape.mRect_height);
            this.mOriginBoxOffsetX = this.mShapeAnimTransition.mRect_left;
            this.mOriginBoxOffsetY = this.mShapeAnimTransition.mRect_top;
            this.mOriginBoxWidth = this.mShapeAnimTransition.mRect_width;
            this.mOriginBoxHeight = this.mShapeAnimTransition.mRect_height;
            this.mProjectedBoxOffsetX = this.mViewportChangeItems.mRect_left;
            this.mProjectedBoxOffsetY = (short)(this.mViewportChangeItems.mRect_top + Constants.crimeSceneBlackShapeOffsetYFct());
            this.mProjectedBoxWidth = this.mViewportChangeItems.mRect_width;
            this.mProjectedBoxHeight = (short)(this.mViewportChangeItems.mRect_height - Constants.crimeSceneBlackShapeOffsetYFct());
            this.mProjectedSuspectOffsetX = (short)((this.mComponentViewport.mRect_width - this.mViewportChangeItems.mRect_width / 2 - this.mSpriteCharacter.mRect_width) / 2);
            this.mProjectedWeaponOffsetX = (short)((this.mComponentViewport.mRect_width + this.mViewportChangeItems.mRect_width / 2 - this.mSpriteWeapon.mRect_width) / 2);
            this.InitStartAnimation();
        }
    }

    private void StartCloseAnimation() {
        this.mProjectedBoxOffsetX = (short)(this.mComponentViewport.mRect_left + this.mTitleShape.mRect_left);
        this.mProjectedBoxOffsetY = (short)(this.mComponentViewport.mRect_top + this.mTitleShape.mRect_top);
        this.mProjectedBoxWidth = this.mTitleShape.mRect_width;
        this.mProjectedBoxHeight = this.mTitleShape.mRect_height;
        this.mShapeAnimTransition.SetTopLeft(this.mOriginBoxOffsetX, this.mOriginBoxOffsetY);
        this.mShapeAnimTransition.SetSize(this.mOriginBoxWidth, this.mOriginBoxHeight);
        this.mOriginBoxOffsetX = this.mViewportChangeItems.mRect_left;
        this.mOriginBoxOffsetY = (short)(this.mViewportChangeItems.mRect_top + Constants.crimeSceneBlackShapeOffsetYFct());
        this.mOriginBoxWidth = this.mViewportChangeItems.mRect_width;
        this.mOriginBoxHeight = (short)(this.mViewportChangeItems.mRect_height - Constants.crimeSceneBlackShapeOffsetYFct());
        this.mProjectedSuspectOffsetX = (short)((this.mComponentViewport.mRect_width / 2 - this.mSpriteCharacter.mRect_width) / 2 + Constants.geCrimeMapMarginWidthFct() / 2);
        this.mProjectedWeaponOffsetX = (short)((3 * this.mComponentViewport.mRect_width / 2 - this.mSpriteWeapon.mRect_width) / 2 - Constants.geCrimeMapMarginWidthFct() / 2);
        this.InitStartAnimation();
    }

    private void InitStartAnimation() {
        this.mOriginSuspectOffsetX = this.mSpriteCharacter.mRect_left;
        this.mOriginWeaponOffsetX = this.mSpriteWeapon.mRect_left;
        this.mAnimationProgress = true;
        this.mViewportChangeItems.SetVisible(false);
        this.mShapeAnimTransition.SetVisible(true);
        this.mTextAnimTransition.SetVisible(true);
        this.mShapeAnimTransition.BringToFront();
        this.mTextAnimTransition.BringToFront();
        this.mCurrentTimeAnim = 0;
        this.RegisterInGlobalTime();
    }

    private void InitFinishAnimation() {
        if (this.mItemSelection == 0) {
            this.mViewportChangeItems.SetViewport(null);
            this.mTitle.SetVisible(true);
            this.mTitleShape.SetVisible(true);
            this.SetLeftRightArrowsState(false);
            this.mTitleShape.BringToFront();
            this.mTitle.BringToFront();
            this.mShapeAnimTransition.SetVisible(false);
            this.mTextAnimTransition.SetVisible(false);
        } else {
            this.mViewportChangeItems.SetVisible(true);
            this.mShapeAnimTransition.SetVisible(false);
            this.mTextAnimTransition.SetVisible(false);
        }
        this.mAnimationProgress = false;
        this.UnRegisterInGlobalTime();
    }

    private void UpdateAnimation(int n) {
        if (this.mCurrentTimeAnim + n < Constants.geCrimeMapTimeToOpenRoomFct()) {
            this.mCurrentTimeAnim += n;
        } else {
            this.mCurrentTimeAnim = Constants.geCrimeMapTimeToOpenRoomFct();
            this.InitFinishAnimation();
        }
        this.mSpriteCharacter.SetTopLeft((short)(this.mOriginSuspectOffsetX - (this.mOriginSuspectOffsetX - this.mProjectedSuspectOffsetX) * this.mCurrentTimeAnim / Constants.geCrimeMapTimeToOpenRoomFct()), (short)Utilities.Max(this.mComponentViewport.mRect_height - Constants.geCrimeMapItemHeightFct(), Constants.crimeSceneSelectorOffsetYFct() + this.mComponentViewport.mRect_height - this.mSpriteCharacter.mRect_height));
        this.mSpriteWeapon.SetTopLeft((short)(this.mOriginWeaponOffsetX - (this.mOriginWeaponOffsetX - this.mProjectedWeaponOffsetX) * this.mCurrentTimeAnim / Constants.geCrimeMapTimeToOpenRoomFct()), (short)Utilities.Max(this.mComponentViewport.mRect_height - Constants.geCrimeMapItemHeightFct(), Constants.crimeSceneSelectorOffsetYFct() + this.mComponentViewport.mRect_height - this.mSpriteWeapon.mRect_height));
        this.mShapeAnimTransition.SetTopLeft((short)(this.mOriginBoxOffsetX - (this.mOriginBoxOffsetX - this.mProjectedBoxOffsetX) * this.mCurrentTimeAnim / Constants.geCrimeMapTimeToOpenRoomFct()), (short)(this.mOriginBoxOffsetY - (this.mOriginBoxOffsetY - this.mProjectedBoxOffsetY) * this.mCurrentTimeAnim / Constants.geCrimeMapTimeToOpenRoomFct()));
        this.mShapeAnimTransition.SetSize((short)(this.mOriginBoxWidth - (this.mOriginBoxWidth - this.mProjectedBoxWidth) * this.mCurrentTimeAnim / Constants.geCrimeMapTimeToOpenRoomFct()), (short)(this.mOriginBoxHeight - (this.mOriginBoxHeight - this.mProjectedBoxHeight) * this.mCurrentTimeAnim / Constants.geCrimeMapTimeToOpenRoomFct()));
        this.mTextAnimTransition.SetTopLeft(this.mTextAnimTransition.mRect_left, (short)(this.mOriginBoxOffsetY - (this.mOriginBoxOffsetY - this.mProjectedBoxOffsetY) * this.mCurrentTimeAnim / Constants.geCrimeMapTimeToOpenRoomFct() + this.mShapeAnimTransition.mRect_height - this.mTextAnimTransition.mRect_height));
    }

    private void UpdateSelectionText(Selector object, int n, boolean bl, int n2) {
        Text text = (Text)((Selector)object).GetSelectionAt(n).GetChild(0);
        object = FlString.Cast$50263e8f(this.mCrimePackage.mPackage.GetEntryPoint(22 + n2));
        if (bl) {
            object = FlString.Cast$50263e8f(this.mCrimePackage.mPackage.GetEntryPoint(20 + n2));
        }
        text.SetCaption((FlString)object);
    }
}

