/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.GE_GameEntity;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Shape;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Viewport;

public final class GE_ActionWheel
extends GE_GameEntity {
    public int mActionWheelState = 0;
    public boolean[] mLockedDirection = null;
    public TimeSystem mActionWheelTimeSystem;

    public final void Load() {
        super.Load();
        this.mPackage = GameLibrary.GetPackage(163845);
        this.mLockedDirection = new boolean[4];
        for (int i = 0; i < this.mLockedDirection.length; ++i) {
            this.mLockedDirection[i] = false;
        }
    }

    public final boolean IsVisible() {
        return this.mActionWheelState == 2;
    }

    public final void Unload() {
        Utilities.StopTimeSystem(this.mActionWheelTimeSystem);
        this.UnRegisterInGlobalTime();
        this.mLockedDirection = null;
        super.Unload();
        GameLibrary.ReleasePackage(this.mPackage);
    }

    public final boolean IsLoaded() {
        return this.mPackage.IsLoaded();
    }

    public GE_ActionWheel(BaseScene baseScene) {
        super(baseScene);
    }

    public final void Init(Viewport viewport) {
        super.Init(viewport);
        this.UpdateVisibility();
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        this.mComponentViewport = Viewport.Cast$7c352e71(this.mPackage.mPackage.GetEntryPoint(0));
        this.mActionWheelTimeSystem = TimeSystem.Cast$3b277f7b(this.mPackage.mPackage.GetEntryPoint(1));
    }

    public final void StartOpeningAnims() {
        if (this.mActionWheelState == 0) {
            GameApp.Get().GetMediaPlayer().PlayMusic(15);
            this.Update();
            this.RegisterInGlobalTime();
            Utilities.StartTimeSystem(this.mActionWheelTimeSystem);
            this.mActionWheelState = 1;
            this.UpdateVisibility();
        }
    }

    public final void StartClosingAnims() {
        if (this.mActionWheelState == 2) {
            GameApp.Get().GetMediaPlayer().PlayMusic(16);
            this.RegisterInGlobalTime();
            Utilities.StartTimeSystemInverse(this.mActionWheelTimeSystem, 708);
            this.mActionWheelState = 3;
            this.UpdateVisibility();
        }
    }

    public final void Unlock(int n) {
        this.mLockedDirection[n] = false;
    }

    public final boolean IsAnimsEnded() {
        return !this.mActionWheelTimeSystem.IsRegisteredInGlobalTime();
    }

    public final boolean OnKeyUp(int n) {
        if (this.IsVisible()) {
            int n2 = -1;
            switch (n) {
                case 3: {
                    n2 = 8;
                    break;
                }
                case 4: {
                    n2 = 4;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 6;
                }
            }
            if (n2 != -1) {
                Selection selection = Selection.Cast$2754fb85(this.mPackage.mPackage.GetEntryPoint(n2));
                if (selection.mEnabled) {
                    return this.mBaseScene.OnCommand(selection.mCommand);
                }
            }
        }
        return false;
    }

    public final boolean IsInvisible() {
        return this.mActionWheelState == 0;
    }

    public final void UpdateVisibility() {
        Viewport viewport = this.mComponentViewport;
        boolean bl = this.mActionWheelState != 0;
        viewport.SetVisible(bl);
    }

    public final void LockAccess() {
        for (int i = 0; i < this.mLockedDirection.length; ++i) {
            this.mLockedDirection[i] = true;
        }
    }

    public final void OnTime(int n, int n2) {
        if (this.mActionWheelState == 1) {
            if (this.mActionWheelTimeSystem.mTotalTime > 708) {
                Utilities.StopTimeSystem(this.mActionWheelTimeSystem);
                this.mActionWheelState = 2;
                this.UnRegisterInGlobalTime();
                return;
            }
        } else if (this.mActionWheelState == 3 && this.mActionWheelTimeSystem.mTotalTime <= 0) {
            Utilities.StopTimeSystem(this.mActionWheelTimeSystem);
            this.mActionWheelState = 0;
            this.UpdateVisibility();
            this.UnRegisterInGlobalTime();
        }
    }

    private void Update() {
        Shape shape = Shape.Cast$2392dbe5(this.mPackage.mPackage.GetEntryPoint(10));
        Shape shape2 = Shape.Cast$2392dbe5(this.mPackage.mPackage.GetEntryPoint(11));
        Shape shape3 = Shape.Cast$2392dbe5(this.mPackage.mPackage.GetEntryPoint(12));
        Shape shape4 = Shape.Cast$2392dbe5(this.mPackage.mPackage.GetEntryPoint(13));
        Selection selection = Selection.Cast$2754fb85(this.mPackage.mPackage.GetEntryPoint(4));
        Selection selection2 = Selection.Cast$2754fb85(this.mPackage.mPackage.GetEntryPoint(5));
        boolean bl = GameApp.Get().GetScenarioContext().CanConfront() && !this.mLockedDirection[1];
        boolean bl2 = bl;
        bl = GameApp.Get().GetScenarioContext().CanTalk() && !this.mLockedDirection[1];
        boolean bl3 = bl;
        bl = !this.mLockedDirection[2];
        boolean bl4 = bl;
        bl = !this.mLockedDirection[3];
        boolean bl5 = bl;
        bl = !this.mLockedDirection[0];
        boolean bl6 = bl2 || bl3;
        shape.SetVisible(bl6);
        shape2.SetVisible(bl4);
        shape3.SetVisible(bl5);
        shape4.SetVisible(bl);
        if (bl2) {
            selection.mCommand = (short)12;
            selection2.mCommand = (short)12;
        } else if (bl3) {
            selection.mCommand = (short)9;
            selection2.mCommand = (short)9;
        }
        bl6 = bl3 || bl2;
        this.UpdateOption(4, 5, bl6);
        this.UpdateOption(8, 9, bl5);
        this.UpdateOption(6, 7, bl4);
        this.UpdateOption(2, 3, bl);
    }

    private void UpdateOption(int n, int n2, boolean bl) {
        Selection.Cast$2754fb85(this.mPackage.mPackage.GetEntryPoint(n)).SetEnabledState(bl);
        Selection selection = Selection.Cast$2754fb85(this.mPackage.mPackage.GetEntryPoint(n2));
        selection.SetVisible(bl);
        selection.SetEnabledState(bl);
    }
}

