/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.CO_SpeechGroup;
import ca.jamdat.flight.CO_Suspect;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.FileSegmentStream;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GameApp;

public final class Suspect {
    public CO_Suspect mSuspect;
    public CO_SpeechGroup mGroup;

    public final int GetConfrontChoice(int n) {
        return this.mSuspect.GetConfrontChoice(n);
    }

    public Suspect(CO_SpeechGroup cO_SpeechGroup, CO_Suspect cO_Suspect) {
        this.mGroup = cO_SpeechGroup;
        this.mSuspect = cO_Suspect;
    }

    public final FlString GetGossipString() {
        return this.Replace(new FlString(ClueUtils.GetScenarioString(this.GetGossipStringId(this.mSuspect.mGossipSpeech))));
    }

    public final int GetGossipStringId(int n) {
        if (n == 2) {
            n = this.mSuspect.mConfrontSpeech == 6 ? 1 : 0;
        } else if (n == 3) {
            n = 2;
        } else if (n == 4) {
            n = 4;
        } else if (n == 5) {
            n = 6;
        } else {
            return this.mSuspect.GetStringId(1);
        }
        return this.mGroup.GetGossip(this.mSuspect.mGossipGroupId).GetEntryPoint(n);
    }

    public final int GetGossipSuspect() {
        return this.GetGossipSuspect(this.mSuspect.mGossipSpeech);
    }

    private int GetGossipSuspect(int n) {
        return this.mGroup.GetGossipSuspect((int)this.mSuspect.mSuspectId, (int)n).mSuspectId;
    }

    public final FlString GetConfrontString(int n) {
        if (n == 7) {
            ClueUtils.AddClue(this.mSuspect.mSuspectId, this.mGroup.GetConfront(this.mSuspect.mConfrontGroupId).Get(n));
        }
        return this.Replace(new FlString(ClueUtils.GetScenarioString(this.mGroup.GetConfront(this.mSuspect.mConfrontGroupId).Get(n))));
    }

    public final FlString Replace(FlString flString) {
        FlString flString2 = new FlString(FlString.FromChar((byte)-73));
        this.Replace(flString, new FlString(FlString.FromChar((byte)-74)), 0);
        this.Replace(flString, flString2, 1);
        return flString;
    }

    public final boolean HasMoreSpeech() {
        return GameApp.Get().GetSpeechStrategy(this.mGroup.GetStrategyType()).HasNext(this.mSuspect, this.mGroup);
    }

    public final void NextSpeech() {
        GameApp.Get().GetSpeechStrategy(this.mGroup.GetStrategyType()).NextSpeechState(this.mSuspect, this.mGroup);
    }

    public final void UnlockIntroClue() {
        ClueUtils.AddClue(this.mSuspect.mSuspectId, this.mSuspect.GetStringId(3));
    }

    public final void UnlockConfrontClue() {
        if (this.mSuspect.mConfrontGroupId != -1) {
            ClueUtils.AddClue(this.mSuspect.mSuspectId, this.mGroup.GetConfront(this.mSuspect.mConfrontGroupId).Get(7));
        }
    }

    private void Replace(FlString flString, FlString flString2, int n) {
        int n2 = flString.FindSubstring(flString2);
        if (n2 != -1) {
            flString.ReplaceStringAt(n2, ClueUtils.GetStringForSuspect(this.mGroup.GetSuspectWith((int)n).mSuspectId), flString2.GetLength());
        }
    }

    public final FlString GetString() {
        int n;
        if (this.mSuspect.mSpeechState == 0) {
            if (this.mSuspect.mIntroSpeech == 0) {
                n = 0;
            } else if (this.mSuspect.mIntroSpeech == 1) {
                n = 3;
                ClueUtils.AddClue(this.mSuspect.mSuspectId, this.mSuspect.GetStringId(3));
            } else {
                n = 1;
            }
        } else {
            n = 2;
        }
        return ClueUtils.GetScenarioString(this.mSuspect.GetStringId(n));
    }

    public final void Read(FileSegmentStream fileSegmentStream) {
        this.mSuspect.Read(fileSegmentStream);
    }

    public final void Write(FileSegmentStream fileSegmentStream) {
        this.mSuspect.Write(fileSegmentStream);
    }

    public final int GetSuspectId() {
        return this.mSuspect.mSuspectId;
    }

    public final int GetSpeechState() {
        return this.mSuspect.mSpeechState;
    }

    public final int GetIntroSpeech() {
        return this.mSuspect.mIntroSpeech;
    }

    public final int GetGossipSpeech() {
        return this.mSuspect.mGossipSpeech;
    }

    public final int GetConfrontSpeech() {
        return this.mSuspect.mConfrontSpeech;
    }

    public final int GetAnswer() {
        return this.mSuspect.mLastAnswer;
    }

    public final void SetAnswer(int n) {
        this.mSuspect.SetAnswer(n);
    }

    public final boolean IsAnswerUsed(int n) {
        return this.mSuspect.IsAnswerUsed(n);
    }
}

