/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.FlBitmap;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.Menu;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Selector;
import ca.jamdat.flight.Shape;
import ca.jamdat.flight.Sprite;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Viewport;

public class SelectorMenu
extends Menu {
    public MetaPackage mPackageFaceSuspect;
    public int mFocusedSelectionIndex;
    public Shape mSelectionTopShape;
    public Sprite mFaceSprite;
    public Viewport mFaceAnimationViewport;
    public Text mNameText;
    public TimeSystem mFaceAnimationTimeSystem;
    public int mRandomCharacterId = -1;
    public Selector mSelector;
    public boolean mUseAnimations;

    public void Initialize() {
        super.Initialize();
        if (this.mUseAnimations) {
            Sprite sprite = Sprite.Cast$46e644cd(this.mPackageFaceSuspect.mPackage.GetEntryPoint(0));
            this.mFaceAnimationViewport.SetViewport(this.mViewport);
            Sprite sprite2 = this.mFaceSprite;
            Object object = sprite.mBitmap;
            sprite2.SetBitmap((FlBitmap)object);
            Utilities.PositionComponentInParent(this.mFaceSprite, 8);
            object = new FlString(ClueUtils.GetStringForSuspect(this.mRandomCharacterId));
            Utilities.ToUpper((FlString)object);
            this.mNameText.SetCaption((FlString)object);
        }
        this.mSelector.BringToFront();
    }

    public SelectorMenu(int n, int n2, boolean bl) {
        super(n, n2);
        this.mUseAnimations = bl;
    }

    public void Load() {
        super.Load();
        if (this.mUseAnimations) {
            this.mRandomCharacterId = FlMath.Random(0, 5);
            this.mPackageFaceSuspect = GameLibrary.GetPackage(ClueUtils.GetCharacterPackageID(this.mRandomCharacterId, 0));
        }
    }

    public void Unload() {
        if (this.mSelector != null) {
            this.mFocusedSelectionIndex = this.mSelector.mCurrentSelectionIndex;
            this.mSelector = null;
        }
        if (this.mFaceAnimationViewport != null) {
            Utilities.StopTimeSystem(this.mFaceAnimationTimeSystem);
        }
        if (this.mFaceSprite != null) {
            this.mFaceSprite.SetBitmap(null);
            this.mFaceSprite = null;
        }
        if (this.mFaceAnimationViewport != null) {
            this.mFaceAnimationViewport.SetViewport(null);
            this.mFaceAnimationViewport = null;
        }
        if (this.mPackageFaceSuspect != null) {
            GameLibrary.ReleasePackage(this.mPackageFaceSuspect);
        }
        super.Unload();
    }

    public boolean OnCommand(int n) {
        boolean bl = true;
        switch (n) {
            case 102: {
                this.mSelector.OnDefaultMsg(this.mSelector, -119, 1);
                break;
            }
            case 103: {
                this.mSelector.OnDefaultMsg(this.mSelector, -119, 2);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl || super.OnCommand(this.GetCommandFromCurrentSelection(n));
    }

    public SelectorMenu(int n, int n2) {
        this(n, n2, false);
    }

    public void GetEntryPoints() {
        super.GetEntryPoints();
        this.mSelector = Selector.Cast$10974a41(this.mPackage.GetEntryPoint(-1));
        this.mSelectionTopShape = Shape.Cast$2392dbe5(this.mCommonPackage.mPackage.GetEntryPoint(15));
        if (this.mUseAnimations) {
            Package package_ = this.mCommonPackage.mPackage;
            this.mFaceSprite = Sprite.Cast$46e644cd(package_.GetEntryPoint(20));
            this.mNameText = Text.Cast$21bacd23(package_.GetEntryPoint(23));
            this.mFaceAnimationViewport = Viewport.Cast$7c352e71(package_.GetEntryPoint(21));
            this.mFaceAnimationTimeSystem = TimeSystem.Cast$3b277f7b(package_.GetEntryPoint(22));
        }
    }

    public final void StartOpeningAnims() {
        super.StartOpeningAnims();
        if (this.mUseAnimations) {
            Utilities.StartTimeSystem(this.mFaceAnimationTimeSystem);
        }
    }

    public final boolean IsOpeningAnimsEnded() {
        return (!this.mUseAnimations || this.mFaceAnimationTimeSystem.mTotalTime >= 750) && super.IsOpeningAnimsEnded();
    }

    public void ReceiveFocus() {
        super.ReceiveFocus();
        this.mSelector.GetSelectionAt(this.mFocusedSelectionIndex).TakeFocus();
        this.mSelector.SetSingleSelection(this.mFocusedSelectionIndex, true);
        this.mSelector.SetVisible(true);
        this.mSelectionTopShape.SetVisible(true);
    }

    public final void StartClosingAnims() {
        super.StartClosingAnims();
        if (this.mUseAnimations) {
            this.mSelectionTopShape.SetVisible(false);
            this.mSelector.SetVisible(false);
            Utilities.StartTimeSystemInverse(this.mFaceAnimationTimeSystem, 750);
        }
    }

    public final boolean IsClosingAnimsEnded() {
        return (!this.mUseAnimations || this.mFaceAnimationTimeSystem.mTotalTime <= 0) && super.IsClosingAnimsEnded();
    }

    public int GetCommandFromCurrentSelection(int n) {
        int n2 = n;
        if (n == -2) {
            n2 = this.mSelector.GetSelectionAt((int)this.mSelector.mCurrentSelectionIndex).mCommand;
        }
        return n2;
    }
}

