/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseController;
import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.Controllable;
import ca.jamdat.flight.FlPenManager;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.Settings;
import ca.jamdat.flight.SharedResourcesHandler;

public final class SceneTransitionController
extends BaseController {
    public BaseScene mUnloadingScene;
    public BaseScene mLoadingScene;
    public SharedResourcesHandler mSharedResourcesHandler;
    public BaseScene mLoadedScene;
    public Controllable mTimeControlled = new Controllable();
    public BaseScene mPendingTransitionScene;
    public int mPreviousSceneID = 0;
    public boolean mTerminated;

    private boolean HasPendingTransition() {
        return this.mPendingTransitionScene != null;
    }

    public SceneTransitionController() {
        this.mSharedResourcesHandler = new SharedResourcesHandler();
        this.mTimeControlled.mController = this;
    }

    private void UnloadScene(BaseScene baseScene) {
        SceneTransitionController.DetachScene(baseScene);
        if (baseScene.mTransitionState != 0) {
            baseScene.Unload();
        }
        baseScene.mTransitionState = 0;
    }

    private boolean IsUnloading() {
        return this.mUnloadingScene != null;
    }

    private static void AttachScene(BaseScene baseScene) {
        baseScene.AttachScene();
    }

    private static void DetachScene(BaseScene baseScene) {
        baseScene.SetViewport(null);
    }

    private boolean IsLoading() {
        return this.mLoadingScene != null;
    }

    public final void EnqueueTransition(BaseScene baseScene) {
        if (!this.mTerminated) {
            if (!this.IsTransiting()) {
                this.StartTransition(baseScene, this.mLoadedScene);
                return;
            }
            if (this.HasPendingTransition()) {
                this.mPendingTransitionScene = baseScene;
                return;
            }
            this.mPendingTransitionScene = baseScene;
        }
    }

    public final void OnTime$255f295(int n) {
        Object object;
        GameApp gameApp = GameApp.Get();
        if (this.IsUnloading()) {
            object = this.mUnloadingScene;
            if (((BaseScene)object).mTransitionState == 5) {
                ((BaseScene)object).StartClosingAnims();
                ((BaseScene)object).mTransitionState = 6;
            }
            if (((BaseScene)object).mTransitionState == 6 && ((BaseScene)object).IsClosingAnimsEnded()) {
                BaseScene.OnStartUnloading();
                ((BaseScene)object).mTransitionState = 7;
                this.mPreviousSceneID = ((BaseScene)object).mId;
            } else if (((BaseScene)object).mTransitionState == 7) {
                ((BaseScene)object).mTransitionState = 2;
            }
            if (((BaseScene)object).mTransitionState == 2 && ((BaseScene)object).SaveFiles(1)) {
                ((BaseScene)object).mTransitionState = 8;
            }
            if (((BaseScene)object).mTransitionState == 8) {
                this.UnloadScene(this.mUnloadingScene);
                this.mUnloadingScene = null;
                object = null;
            }
            if (object == null && this.HasPendingTransition()) {
                this.mLoadingScene = this.mPendingTransitionScene;
                this.mPendingTransitionScene = null;
            }
        }
        if (this.IsLoading() && !this.IsUnloading()) {
            BaseScene baseScene = this.mLoadingScene;
            if (baseScene.mTransitionState == 0) {
                object = gameApp.GetLibrary();
                boolean bl = ((GameLibrary)object).SetImmediateLoadModeEnabled(true);
                int n2 = 0;
                short s = Settings.GetApplicationLanguage();
                if (this.mSharedResourcesHandler.mLanguage != s) {
                    n2 = 1;
                    this.mSharedResourcesHandler.mLanguage = s;
                }
                if (n2 > 0) {
                    this.mSharedResourcesHandler.UnloadMenuSharedPackages();
                    this.mSharedResourcesHandler.UnloadAppSharedPackages();
                }
                this.mSharedResourcesHandler.LoadAppSharedPackages();
                if (baseScene.IsTypeOf(4)) {
                    this.mSharedResourcesHandler.UnloadMenuSharedPackages();
                } else {
                    this.mSharedResourcesHandler.LoadMenuSharedPackages();
                }
                baseScene.Load();
                baseScene.mTransitionState = 1;
                ((GameLibrary)object).SetImmediateLoadModeEnabled(bl);
            }
            if (baseScene.mTransitionState == 1 && baseScene.IsLoaded()) {
                baseScene.mTransitionState = 2;
            }
            if (baseScene.mTransitionState == 2 && baseScene.SaveFiles(0)) {
                baseScene.mTransitionState = 3;
            } else if (baseScene.mTransitionState == 3) {
                baseScene.SetRect(gameApp.mRect_left, gameApp.mRect_top, gameApp.mRect_width, gameApp.mRect_height);
                baseScene.GetEntryPoints();
                SceneTransitionController.AttachScene(baseScene);
                baseScene.Initialize();
                BaseScene.OnInitialized();
                baseScene.mTransitionState = 4;
                baseScene.StartOpeningAnims();
            } else if (baseScene.mTransitionState == 4 && baseScene.IsOpeningAnimsEnded()) {
                gameApp.ResetDownKeys();
                this.mLoadedScene = baseScene;
                this.mLoadingScene = null;
                baseScene.mTransitionState = 5;
                if (this.HasPendingTransition()) {
                    this.StartTransition(this.mPendingTransitionScene, baseScene);
                    this.mPendingTransitionScene = null;
                } else {
                    baseScene.ReceiveFocus();
                }
            }
        }
        if (!this.IsTransiting()) {
            this.mTimeControlled.UnRegisterInGlobalTime();
        }
    }

    private boolean IsTransiting() {
        return this.mLoadedScene == null && (this.IsLoading() || this.IsUnloading());
    }

    private void StartTransition(BaseScene baseScene, BaseScene baseScene2) {
        GameApp.Get().TakeFocus();
        this.mLoadingScene = baseScene;
        this.mUnloadingScene = baseScene2;
        this.mLoadedScene = null;
        this.mTimeControlled.RegisterInGlobalTime();
        if (baseScene2 != null) {
            baseScene2.SerializeObjects();
        }
        FlPenManager.Get().Deactivate();
    }
}

