/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_DialogBox;
import ca.jamdat.flight.GE_NavTab;
import ca.jamdat.flight.GE_Room;
import ca.jamdat.flight.GE_Ticker;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.RTActionScene;
import ca.jamdat.flight.RTActionSceneState;
import ca.jamdat.flight.ScenarioContext;
import ca.jamdat.flight.Suspect;

public final class RTA_TalkingState
extends RTActionSceneState {
    private void OnExit() {
        GameApp.Get().GetScenarioContext().GetSuspect().NextSpeech();
        this.StartClosingAnims(4);
    }

    public RTA_TalkingState(RTActionScene rTActionScene, GE_DialogBox gE_DialogBox, GE_Room gE_Room, GE_Ticker gE_Ticker, GE_NavTab gE_NavTab) {
        super(rTActionScene, gE_DialogBox, gE_Room, gE_Ticker, gE_NavTab);
        GameApp.Get().GetScenarioContext().OnEvent(29, GameApp.Get().GetScenarioContext().GetSuspect().GetSuspectId());
        this.mRoom.SetState(5);
    }

    public final void OnDelete() {
        super.OnDelete();
    }

    public final void Init() {
        FlString flString = new FlString(RTActionSceneState.GetStringFromRTActionScenePackage(13));
        ClueUtils.ReplaceAllSuspectIDInString(flString, GameApp.Get().GetScenarioContext().GetCurrentRoom().mSuspectId);
        this.mTicker.SetTickerMessage(flString);
        super.Init();
    }

    public final boolean HasOpeningAnims() {
        return !this.mRoom.IsTransitionFinished();
    }

    private void Talk() {
        Suspect suspect = GameApp.Get().GetScenarioContext().GetSuspect();
        FlString flString = new FlString(suspect.GetString());
        if (suspect.GetIntroSpeech() == 1) {
            GameApp.Get().GetMediaPlayer().PlayMusic(20);
            ClueUtils.ReplaceClueGiverInString(flString, suspect.GetSuspectId());
        }
        this.mDialogBox.Show(flString, 1, suspect.GetSuspectId());
        this.SetDefaultSoftkeys();
    }

    public final void StartClosingAnims(int n) {
        super.StartClosingAnims(n);
    }

    public final boolean OnCommand(int n) {
        boolean bl = true;
        ScenarioContext scenarioContext = GameApp.Get().GetScenarioContext();
        if (n == 11) {
            scenarioContext.OnEvent(28, scenarioContext.GetSuspect().GetSuspectId());
            scenarioContext.GetSuspect().NextSpeech();
            this.OnExit();
        } else if (n == 27) {
            scenarioContext.GetSuspect().NextSpeech();
            if (scenarioContext.GetSuspect().GetSpeechState() == 1 && scenarioContext.GetSuspect().GetGossipSpeech() == 2) {
                scenarioContext.OnEvent(28, scenarioContext.GetSuspect().GetSuspectId());
                this.StartClosingAnims(5);
            } else {
                this.Talk();
            }
        } else {
            bl = false;
        }
        return bl || super.OnCommand(n);
    }

    public final boolean HasClosingAnims() {
        return false;
    }

    public final void Leave() {
        this.mDialogBox.Hide();
        super.Leave();
    }

    public final void Execute() {
        super.Execute();
        this.Talk();
    }

    public final void SetDefaultSoftkeys() {
        if (GameApp.Get().GetScenarioContext().GetSuspect().HasMoreSpeech()) {
            this.UpdateSoftkeys(7, 27, 8, -14);
            return;
        }
        this.UpdateSoftkeys(7, 11, 8, -14);
    }
}

