/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.CO_Item;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_DialogBox;
import ca.jamdat.flight.GE_NavTab;
import ca.jamdat.flight.GE_Room;
import ca.jamdat.flight.GE_Ticker;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.RTActionScene;
import ca.jamdat.flight.RTActionSceneState;

public final class RTA_SearchingState
extends RTActionSceneState {
    private void OnExit() {
        this.mTicker.StopTicker();
        this.mRoom.SetState(1);
        this.mRoom.MoveTo(5);
        this.StartClosingAnims(4);
    }

    public RTA_SearchingState(RTActionScene rTActionScene, GE_DialogBox gE_DialogBox, GE_Room gE_Room, GE_Ticker gE_Ticker, GE_NavTab gE_NavTab) {
        super(rTActionScene, gE_DialogBox, gE_Room, gE_Ticker, gE_NavTab);
        this.mRoom.SetState(3);
        GameApp.Get().GetScenarioContext().OnEvent(23, GameApp.Get().GetScenarioContext().GetCurrentRoom().mRoomId);
    }

    public final void OnDelete() {
        super.OnDelete();
    }

    public final void Init() {
        super.Init();
        this.UpdateTicker();
    }

    public final void OnNavTabAccess() {
        if (this.IsSearching()) {
            this.OnSearched();
        }
    }

    private void OnSearch() {
        int n = this.mRoom.GetSearchedItem();
        CO_Item cO_Item = GameApp.Get().GetScenarioContext().GetCurrentRoom().GetItem(n);
        if (!cO_Item.mSearched) {
            if (cO_Item.mClueItem) {
                GameApp.Get().GetMediaPlayer().PlayMusic(20);
            }
            this.UpdateSoftkeys(7, 17, 8, -14);
            this.mDialogBox.Show(cO_Item.GetString());
            this.mRoom.SetPassThroughTouchShields(true);
            return;
        }
        this.mRoom.StartNoEntryAnims();
    }

    private void OnSearched() {
        GameApp.Get().GetScenarioContext().OnEvent(22, this.mRoom.GetSearchedItem());
        this.mDialogBox.Hide();
        this.mRoom.SetPassThroughTouchShields(false);
        this.OnExit();
    }

    private boolean IsSearching() {
        return this.mDialogBox.mDialogBoxType == 2;
    }

    public final boolean OnCommand(int n) {
        boolean bl = true;
        switch (n) {
            case 11: {
                this.OnExit();
                break;
            }
            case 35: {
                this.OnKeyUp(3);
                break;
            }
            case 36: {
                this.OnKeyUp(4);
                break;
            }
            case 16: {
                this.OnSearch();
                break;
            }
            case 17: {
                this.OnSearched();
                break;
            }
            case 6: {
                if (!this.IsSearching()) break;
                this.OnSearched();
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl || super.OnCommand(n);
    }

    public final void SetDefaultSoftkeys() {
        this.UpdateSoftkeys(7, 16, 1, 11);
    }

    private void UpdateTicker() {
        int n = this.mRoom.GetSearchedItem();
        if (GameApp.Get().GetScenarioContext().GetCurrentRoom().GetItem((int)n).mSearched) {
            FlString flString = new FlString(RTActionSceneState.GetStringFromRTActionScenePackage(15));
            ClueUtils.ReplaceItemIDInString(flString, n);
            this.mTicker.SetTickerMessage(flString);
            return;
        }
        FlString flString = new FlString(RTActionSceneState.GetStringFromRTActionScenePackage(14));
        ClueUtils.ReplaceItemIDInString(flString, n);
        this.mTicker.SetTickerMessage(flString);
    }

    public final boolean OnKeyUp(int n) {
        if (!this.IsSearching() && !this.mDialogBox.mIsActive) {
            switch (n) {
                case 3: 
                case 4: {
                    this.mRoom.StopNoEntryAnims();
                    GE_Room gE_Room = this.mRoom;
                    n = n == 4 ? 0 : 1;
                    gE_Room.SelectClue(n);
                    this.UpdateTicker();
                    return true;
                }
            }
        }
        return super.OnKeyUp(n);
    }

    public final boolean OnPenUp(byte by, short[] sArray) {
        return this.mRoom.OnPenUp(by, sArray) || super.OnPenUp(by, sArray);
    }
}

