/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.Color888;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_DialogBox;
import ca.jamdat.flight.GE_NavTab;
import ca.jamdat.flight.GE_Room;
import ca.jamdat.flight.GE_Ticker;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.RTActionScene;
import ca.jamdat.flight.RTActionSceneState;
import ca.jamdat.flight.ScenarioContext;
import ca.jamdat.flight.Shape;
import ca.jamdat.flight.Suspect;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Viewport;

public final class RTA_GossipState
extends RTActionSceneState {
    public MetaPackage mGossipAnimationPackage;
    public Viewport mGossipAnimationViewport;
    public TimeSystem mGossipAnimationTimeSystem;
    public boolean mLoadingResourcesForGossip;

    private void OnExit() {
        ScenarioContext scenarioContext = GameApp.Get().GetScenarioContext();
        if (scenarioContext.GetSuspect().GetGossipSpeech() == 6) {
            scenarioContext.OnEvent(28, scenarioContext.GetSuspect().GetSuspectId());
        }
        scenarioContext.GetSuspect().NextSpeech();
        this.mNavTab.SetVisible(true);
        this.StartClosingAnims(4);
    }

    private void OnSuspectLoaded() {
        this.mLoadingResourcesForGossip = false;
        GameApp.Get().GetHourglass().SetVisible(false);
        this.mRoom.UpdateCharacter();
        if (this.mSubState == 3) {
            Suspect suspect = GameApp.Get().GetScenarioContext().GetSuspect();
            if (suspect.GetGossipSpeech() == 3) {
                FlString flString = suspect.GetGossipString();
                this.mDialogBox.Show(flString, 4, suspect.GetGossipSuspect());
                this.mNavTab.SetVisible(false);
                this.mGossipAnimationViewport.SetVisible(false);
            } else if (suspect.GetGossipSpeech() == 5) {
                FlString flString = suspect.GetGossipString();
                this.mDialogBox.Show(flString, 1, suspect.GetSuspectId());
            }
            this.UnRegisterInGlobalTime();
            this.SetDefaultSoftkeys();
        }
    }

    public RTA_GossipState(RTActionScene rTActionScene, GE_DialogBox gE_DialogBox, GE_Room gE_Room, GE_Ticker gE_Ticker, GE_NavTab gE_NavTab) {
        super(rTActionScene, gE_DialogBox, gE_Room, gE_Ticker, gE_NavTab);
        GameApp.Get().GetScenarioContext().OnEvent(15);
        this.mRoom.SetState(5);
        this.mGossipAnimationPackage = GameLibrary.GetPackage(3080286);
        this.mGossipAnimationTimeSystem = TimeSystem.Cast$3b277f7b(this.mGossipAnimationPackage.mPackage.GetEntryPoint(24));
        this.mGossipAnimationViewport = Viewport.Cast$7c352e71(this.mGossipAnimationPackage.mPackage.GetEntryPoint(23));
    }

    public final void OnDelete() {
        Utilities.StopTimeSystem(this.mGossipAnimationTimeSystem);
        this.mGossipAnimationTimeSystem = null;
        this.mGossipAnimationTimeSystem = null;
        this.mGossipAnimationViewport = null;
        GameLibrary.ReleasePackage(this.mGossipAnimationPackage);
        this.mGossipAnimationPackage = null;
        super.OnDelete();
    }

    public final void Init() {
        this.mLoadingResourcesForGossip = false;
        this.SetTickerString();
        this.mSubState = 3;
        this.Execute();
    }

    private void SetTickerString() {
        FlString flString = new FlString(RTActionSceneState.GetStringFromRTActionScenePackage(13));
        ClueUtils.ReplaceAllSuspectIDInString(flString, GameApp.Get().GetScenarioContext().GetCurrentRoom().mSuspectId);
        this.mTicker.SetTickerMessage(flString);
    }

    public final boolean HasOpeningAnims() {
        return !this.mRoom.IsTransitionFinished();
    }

    public final void StartClosingAnims(int n) {
        this.mRoom.SetState(1);
        this.StartLoadingSuspect(GameApp.Get().GetScenarioContext().GetCurrentRoom().mSuspectId);
        super.StartClosingAnims(n);
    }

    public final void EndClosingAnims() {
        super.EndClosingAnims();
        this.OnSuspectLoaded();
    }

    public final boolean OnCommand(int n) {
        boolean bl = true;
        if (n == 27) {
            if (GameApp.Get().GetScenarioContext().GetSuspect().GetGossipSpeech() == 2) {
                this.RegisterInGlobalTime();
            } else {
                GameApp.Get().GetScenarioContext().GetSuspect().NextSpeech();
                this.Gossip();
            }
        } else if (n == 32) {
            this.OnExit();
        } else {
            bl = false;
        }
        return bl || super.OnCommand(n);
    }

    public final boolean HasClosingAnims() {
        return true;
    }

    public final void Leave() {
        this.mDialogBox.Hide();
        super.Leave();
    }

    public final void Execute() {
        super.Execute();
        this.Gossip();
    }

    public final void SetDefaultSoftkeys() {
        if (this.mLoadingResourcesForGossip) {
            this.UpdateSoftkeys(4, 0, 8, -14);
            return;
        }
        if (GameApp.Get().GetScenarioContext().GetSuspect().HasMoreSpeech()) {
            this.UpdateSoftkeys(7, 27, 8, -14);
            return;
        }
        this.UpdateSoftkeys(7, 32, 8, -14);
    }

    public final boolean IsOpeningAnimsEnded() {
        return this.mRoom.IsTransitionFinished();
    }

    public final boolean IsClosingAnimsEnded() {
        return this.IsSuspectLoaded();
    }

    public final void OnTime(int n, int n2) {
        Object object = GameApp.Get().GetScenarioContext().GetSuspect();
        if (((Suspect)object).GetGossipSpeech() == 2) {
            if (!this.mGossipAnimationTimeSystem.IsRegisteredInGlobalTime()) {
                this.mGossipAnimationViewport.SetVisible(true);
                this.mGossipAnimationViewport.BringToFront();
                short[] sArray = Color888.Cast$4e210a13(this.mGossipAnimationPackage.mPackage.GetEntryPoint(25));
                object = (Viewport)this.mGossipAnimationViewport.GetChild(1);
                for (n2 = 0; n2 < ((Viewport)object).GetChildCount(); ++n2) {
                    ((Shape)((Viewport)object).GetChild(n2)).SetColor(sArray);
                }
                GameApp.Get().GetMediaPlayer().PlayMusic(14);
                Utilities.StartTimeSystem(this.mGossipAnimationTimeSystem);
                return;
            }
            if (this.mGossipAnimationTimeSystem.mTotalTime >= 958) {
                Utilities.StopTimeSystem(this.mGossipAnimationTimeSystem);
                ((Suspect)object).NextSpeech();
                this.Gossip();
                return;
            }
        } else if (this.mLoadingResourcesForGossip) {
            if (this.IsSuspectLoaded()) {
                this.OnSuspectLoaded();
                return;
            }
        } else {
            super.OnTime(n, n2);
        }
    }

    private void Gossip() {
        Suspect suspect = GameApp.Get().GetScenarioContext().GetSuspect();
        if (suspect.GetGossipSpeech() == 2 || suspect.GetGossipSpeech() == 6) {
            FlString flString = suspect.GetGossipString();
            this.mDialogBox.Show(flString, 1, suspect.GetSuspectId());
            this.mNavTab.SetVisible(true);
        } else if (suspect.GetGossipSpeech() == 3) {
            this.mNavTab.SetActive(false);
            this.mRoom.SetState(6);
            this.mTicker.StopTicker();
            int n = suspect.GetGossipSuspect();
            ClueUtils.AddGossip(n, suspect.GetGossipStringId(3));
            this.StartLoadingSuspect(n);
        } else if (suspect.GetGossipSpeech() == 4) {
            GameApp.Get().GetMediaPlayer().PlayMusic(14);
            this.mRoom.SetState(7);
            FlString flString = suspect.GetGossipString();
            this.mDialogBox.Show(flString, 5, suspect.GetGossipSuspect());
            int n = suspect.GetGossipSuspect();
            ClueUtils.AddGossip(n, suspect.GetGossipStringId(4));
            this.StartLoadingSuspect(n);
        } else if (suspect.GetGossipSpeech() == 5) {
            this.mRoom.SetState(5);
            this.StartLoadingSuspect(suspect.GetSuspectId());
            this.mNavTab.SetVisible(true);
            this.SetTickerString();
        }
        this.SetDefaultSoftkeys();
    }

    private void StartLoadingSuspect(int n) {
        GameApp.Get().GetHourglass().SetVisible(true);
        this.mRoom.LoadCharacter(n);
        this.mLoadingResourcesForGossip = true;
        this.RegisterInGlobalTime();
    }

    private boolean IsSuspectLoaded() {
        return this.mRoom.IsCharacterLoaded();
    }
}

