/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ClueBaseScene;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_Clock;
import ca.jamdat.flight.GE_Editor;
import ca.jamdat.flight.GE_MapSelection;
import ca.jamdat.flight.GameApp;

public final class PublishScene
extends ClueBaseScene {
    public GE_Clock mClock;
    public int mCurrentState = 2;
    public GE_MapSelection mMap;
    public GE_Editor mEditor;

    public PublishScene() {
        super(34, 3047517);
        this.AddType(4);
        GameApp.Get().GetScenarioContext().OnEvent(19);
    }

    public final void Load() {
        super.Load();
        this.mClock = new GE_Clock(this);
        this.mClock.Load();
        this.mEditor = new GE_Editor(this);
        this.mEditor.Load();
        this.mMap = new GE_MapSelection(this, GameApp.Get().GetScenarioContext().GetMansion());
        this.mMap.Load();
    }

    public final void Unload() {
        this.mClock.Unload();
        this.mClock = null;
        this.mMap.Unload();
        this.mMap = null;
        this.mEditor.Unload();
        this.mEditor = null;
        super.Unload();
    }

    public final boolean IsLoaded() {
        return super.IsLoaded() && this.mClock.IsLoaded() && this.mEditor.IsLoaded() && this.mMap.IsLoaded();
    }

    public final void SetDefaultSoftkeys() {
        if (this.mDialogBox.mIsActive) {
            if (!GameApp.Get().GetScenarioContext().HasMoreTime()) {
                this.UpdateSoftkeys(7, 85, 8, -14);
                return;
            }
            this.UpdateSoftkeys(7, 85, 1, -13);
            return;
        }
        if (GameApp.Get().GetScenarioContext().HasMoreTime()) {
            this.UpdateSoftkeys(10, 86, 1, -13);
            return;
        }
        this.UpdateSoftkeys(10, 86, 8, -14);
    }

    private void TryToPublish() {
        if (this.mMap.mRoomLocked) {
            if (GameApp.Get().GetScenarioContext().IsTutorial()) {
                this.TutorialPublish();
            } else {
                this.Publish();
            }
        } else {
            this.LockOnRoom(this.mMap.GetSuspectIDSelected());
        }
        this.UpdateTicker(ClueUtils.GetGameString(99));
    }

    private void Publish() {
        int n = this.mMap.GetSuspectIDSelected();
        int n2 = this.mMap.GetWeaponIDSelected();
        int n3 = this.mMap.mCurrentSelectedRoom;
        if (n != -1 && n2 != -1) {
            this.mEditor.SetVisible(true);
            this.mCurrentState = 0;
            GameApp.Get().GetScenarioContext().SetAccusations(n2, n3, n);
            FlString flString = new FlString(ClueUtils.GetGameString(47));
            ClueUtils.ReplaceAllRoomIDInString(flString, n3);
            ClueUtils.ReplaceAllWeaponIDInString(flString, n2);
            ClueUtils.ReplaceAllSuspectIDInString(flString, n);
            this.mMap.BringToFrontShadow();
            this.mDialogBox.Show(flString, 7);
            this.UpdateSoftkeys(11, 83, 12, 88);
            return;
        }
        GE_MapSelection gE_MapSelection = this.mMap;
        n3 = n == -1 ? 1 : 2;
        gE_MapSelection.SetActiveCurrentRoom(n3);
        this.DrawDialogBox(48);
        this.UpdateSoftkeys(7, 85, 1, 85);
    }

    private void TutorialPublish() {
        int n;
        int n2;
        int n3 = this.mMap.GetSuspectIDSelected();
        if (GameApp.Get().GetScenarioContext().mTutorialSteps.IsCorrectAccusation(n3, n2 = this.mMap.GetWeaponIDSelected(), n = this.mMap.mCurrentSelectedRoom)) {
            GameApp.Get().GetScenarioContext().SetAccusations(n2, n, n3);
            GameApp.Get().GetScenarioProcess().Step(11);
            this.OnCommand(4);
            return;
        }
        this.ResetSuspicions();
        this.DrawDialogBox(GameApp.Get().GetScenarioContext().mTutorialSteps.GetAccusationStringId());
        this.UpdateSoftkeys(7, 85, 1, 85);
    }

    private void DrawDialogBox(int n) {
        this.mMap.BringToFrontShadow();
        this.mEditor.SetVisible(true);
        FlString flString = ClueUtils.GetGameString(n);
        this.mDialogBox.Show(flString, 7);
    }

    private void CloseDialogBox() {
        this.mDialogBox.Hide();
        if (this.mMap.mRoomLocked) {
            this.mEditor.SetVisible(false);
            this.UpdateSoftkeys(7, 81, 3, 87);
            return;
        }
        if (this.mCurrentState != 2) {
            this.mEditor.SetVisible(true);
        }
        this.mCurrentState = 1;
        this.SetDefaultSoftkeys();
    }

    private void UpdateTicker(FlString flString) {
        this.mTicker.SetTickerMessage(flString);
    }

    private void ResetSuspicions() {
        this.mMap.mLoadingFromSaveGame = true;
        this.mMap.LockCurrentRoom(false);
        this.mMap.mLoadingFromSaveGame = false;
    }

    private void LockOnRoom(int n) {
        this.mEditor.SetVisible(false);
        this.mCurrentState = 1;
        this.mMap.LockCurrentRoom(true);
        GE_MapSelection gE_MapSelection = this.mMap;
        n = n == -1 ? 1 : 2;
        gE_MapSelection.SetActiveCurrentRoom(n);
        this.UpdateSoftkeys(7, 81, 3, 87);
    }

    public final boolean OnPenUp(byte by, short[] sArray) {
        boolean bl = false;
        if (!this.mDialogBox.mIsActive && this.mMap.IsRoomContentsAnimationFinished()) {
            bl = this.mMap.OnPenUp(by, sArray);
        }
        return bl || super.OnPenUp(by, sArray);
    }

    public final boolean OnPenDown(byte by, short[] sArray) {
        boolean bl = false;
        if (!this.mDialogBox.mIsActive) {
            bl = this.mMap.OnPenDown(by, sArray);
        }
        return bl || super.OnPenDown(by, sArray);
    }

    public final void Initialize() {
        super.Initialize();
        this.mTicker.Init(this.mViewport);
        this.UpdateTicker(ClueUtils.GetGameString(99));
        this.mMap.Init(this.mViewport);
        this.mMap.SetVisible(true);
        this.mMap.SelectRoom(GameApp.Get().GetScenarioContext().GetCurrentRoom().mRoomId);
        this.mMap.mLoadingFromSaveGame = false;
        this.mMap.UpdateAllSuspicions(true);
        this.mEditor.Init(this.mViewport);
        this.mEditor.mAnimationEnabled = true;
        this.mDialogBox.Init(this.mViewport);
        this.mClock.Init(this.mViewport);
        this.mNavTab.Init(this.mViewport, 4);
        int n = 46;
        if (GameApp.Get().GetScenarioContext().IsTutorial()) {
            n = GameApp.Get().GetScenarioContext().mTutorialSteps.GetAccusationStringId();
            this.Refresh();
        }
        this.DrawDialogBox(n);
    }

    public final boolean OnCommand(int n) {
        boolean bl = false;
        if (n == 83) {
            GameApp.Get().GetScenarioProcess().Step(10);
            n = 4;
        } else if (n == 88) {
            this.mCurrentState = 1;
            this.mEditor.SetVisible(false);
            this.mDialogBox.Hide();
            this.mMap.UpdateAllSuspicions(true);
            this.UpdateSoftkeys(7, 81, 3, 87);
            bl = true;
        } else if (n == 86 || n == 81) {
            this.TryToPublish();
            bl = true;
        } else if (n == 85) {
            this.CloseDialogBox();
            this.mMap.UpdateAllSuspicions(true);
            bl = true;
        } else if (n == 87) {
            this.mEditor.SetVisible(true);
            this.mDialogBox.Hide();
            this.ResetSuspicions();
            this.SetDefaultSoftkeys();
            this.UpdateTicker(ClueUtils.GetGameString(99));
        } else if (n == 18 || n == 19 || n == 20) {
            this.mSceneAnimType = 1;
            int n2 = 4;
            if (n == 18) {
                n2 = 0;
            } else if (n == 19) {
                n2 = 1;
            } else if (n == 20) {
                n2 = 2;
            }
            this.mNavTab.SelectNavTab(n2);
        } else if (n == 80 && !this.mDialogBox.mIsActive) {
            this.mEditor.SetVisible(false);
            this.mMap.LockCurrentRoom(true);
            this.UpdateSoftkeys(7, 81, 3, 87);
            bl = true;
            this.TakeFocus();
        } else if (n == -83 && !this.mDialogBox.mIsActive) {
            this.mMap.SetAnnotation(1);
            this.TakeFocus();
        } else if (n == -84 && !this.mDialogBox.mIsActive) {
            this.mMap.SetAnnotation(2);
            this.TakeFocus();
        } else if (n == 101 && !this.mDialogBox.mIsActive) {
            this.OnKeyDownOrRepeat(1);
            this.TakeFocus();
        }
        return bl || super.OnCommand(n);
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        this.mClock.GetEntryPoints();
        this.mEditor.GetEntryPoints();
        this.mMap.GetEntryPoints();
    }

    public final void StartOpeningAnims() {
        int n = GameApp.Get().GetPreviousSceneID() == 30 ? 1 : 0;
        int n2 = n;
        n = GameApp.Get().GetPreviousSceneID() == 31 ? 1 : 0;
        int n3 = n;
        n = GameApp.Get().GetPreviousSceneID() == 37 ? 1 : 0;
        int n4 = n;
        if (n2 != 0 || n3 != 0 || n != 0) {
            super.StartOpeningAnims();
            this.mSceneAnimType = 2;
            n = 3;
            if (n2 != 0) {
                n = 0;
            } else if (n3 != 0) {
                n = 1;
            } else if (n4 != 0) {
                n = 2;
            }
            this.mNavTab.SelectNavTab(n);
            this.mNavTab.StartMinimizingAnimation();
        }
    }

    public final void StartClosingAnims() {
        if (this.mSceneAnimType == 1) {
            super.StartClosingAnims();
            this.mNavTab.StartMaximizingAnimation();
        }
    }

    public final boolean OnKeyDownOrRepeat(int n) {
        boolean bl = false;
        if (!this.mMap.mRoomLocked && !this.mDialogBox.mIsActive && this.mMap.IsRoomContentsAnimationFinished()) {
            switch (n) {
                case 4: {
                    this.mMap.Move(3);
                    bl = true;
                    break;
                }
                case 3: {
                    this.mMap.Move(2);
                    bl = true;
                    break;
                }
                case 1: {
                    this.mMap.Move(0);
                    bl = true;
                    break;
                }
                case 2: {
                    this.mMap.Move(1);
                    bl = true;
                }
            }
        }
        if (!bl && this.mCurrentState == 1 && !this.mDialogBox.mIsActive) {
            bl = this.mMap.OnKeyDownOrRepeat(n);
        }
        return bl || super.OnKeyDownOrRepeat(n);
    }
}

