/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FileSegmentStream;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.I_Listener;
import ca.jamdat.flight.I_Notifier;

public final class NotificationMediator
extends I_Listener {
    public I_Notifier[] mNotifiers = new I_Notifier[3];
    public int mCurrentNotifier = -1;

    public NotificationMediator() {
        for (int i = 0; i < this.mNotifiers.length; ++i) {
            this.mNotifiers[i] = null;
        }
    }

    public final int GetNotifierId() {
        int n = this.GetAvailableNotifier();
        if (n == -1) {
            return -1;
        }
        return this.mNotifiers[n].GetId();
    }

    public final void OnDelete() {
        this.mNotifiers = null;
    }

    public final void Add(int n, I_Notifier i_Notifier) {
        this.mNotifiers[n] = i_Notifier;
    }

    public final FlString GetNotification() {
        this.mCurrentNotifier = this.GetAvailableNotifier();
        return this.mNotifiers[this.mCurrentNotifier].GetNotification();
    }

    public final void OnEvent(int n, int n2, int n3) {
        if (n == 18) {
            this.OnDisplayed();
            return;
        }
        for (int i = 0; i < 3; ++i) {
            this.mNotifiers[i].OnEvent(n, n2, n3);
        }
    }

    private int GetAvailableNotifier() {
        int n = -1;
        for (int i = 0; i < 3; ++i) {
            if (!this.mNotifiers[i].HasNotification()) continue;
            n = i;
            break;
        }
        return n;
    }

    private void OnDisplayed() {
        this.mNotifiers[this.mCurrentNotifier].OnDisplayed();
        this.mCurrentNotifier = -1;
    }

    public final void Read(FileSegmentStream fileSegmentStream) {
        this.mCurrentNotifier = fileSegmentStream.ReadByte();
    }

    public final void Write(FileSegmentStream fileSegmentStream) {
        fileSegmentStream.WriteByte((byte)this.mCurrentNotifier);
    }
}

