/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.MMAPISoundImp;
import ca.jamdat.flight.SoundManager;
import ca.jamdat.flight.SpecConstants;

public final class MMAPISoundManagerImp {
    public MMAPISoundImp[] mPrefetchedSounds = new MMAPISoundImp[mMaxPrefetchedSounds];
    public static short mMaxPrefetchedSounds = MMAPISoundManagerImp.GetMaxPrefetchedSound();
    public int[] mPrefetchedSoundsAge = new int[mMaxPrefetchedSounds];
    public int mLastPrefetchedSoundAge;

    public static void SetMuted(boolean bl) {
        SoundManager.Get().mIsMuted = bl;
        if (bl) {
            SoundManager.Get().StopAllSoundPlayers();
        }
    }

    public static boolean IsMuted() {
        return SoundManager.Get().mIsMuted;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void RegisterAsPrefetchedSound(MMAPISoundImp mMAPISoundImp, int n) {
        synchronized (this) {
            this.mPrefetchedSounds[n] = mMAPISoundImp;
            int n2 = n;
            int n3 = this.mLastPrefetchedSoundAge;
            this.mLastPrefetchedSoundAge = n = n3 + 1;
            this.mPrefetchedSoundsAge[n2] = n3;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void UnRegisterAsPrefetchedSound(MMAPISoundImp mMAPISoundImp) {
        synchronized (this) {
            for (int i = 0; i < mMaxPrefetchedSounds; ++i) {
                if (this.mPrefetchedSounds[i] != mMAPISoundImp) continue;
                this.mPrefetchedSounds[i] = null;
                break;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int DeallocateOldestPrefetchedSound(boolean bl, String string) {
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        boolean bl2 = false;
        MMAPISoundImp[] mMAPISoundImpArray = this.mPrefetchedSounds;
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        int n5 = 0;
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            int n6;
            for (n6 = 0; n6 < mMaxPrefetchedSounds; ++n6) {
                if (mMAPISoundImpArray[n6] == null) {
                    if (bl && !bl2) {
                        return n6;
                    }
                } else if (mMAPISoundImpArray[n6].mSoundFormat == string) {
                    n5 = (short)(n5 + 1);
                }
                if (string.equals("audio/midi")) {
                    if (n5 == SpecConstants.GetMaxPrefetchedSoundsShortMid()) {
                        bl2 = true;
                    }
                } else if (string.equals("audio/x-wav")) {
                    if (n5 == SpecConstants.GetMaxPrefetchedSoundsShortWav()) {
                        bl2 = true;
                    }
                } else if (string.equals("audio/amr") && n5 == SpecConstants.GetMaxPrefetchedSoundsShortAmr()) {
                    bl2 = true;
                }
                if (mMAPISoundImpArray[n6] != null && mMAPISoundImpArray[n6].mSoundFormat == string && this.mPrefetchedSoundsAge[n6] < n3) {
                    n3 = this.mPrefetchedSoundsAge[n6];
                    n4 = n6;
                }
                if (this.mPrefetchedSoundsAge[n6] >= n || bl2 || mMAPISoundImpArray[n6] == null) continue;
                n = this.mPrefetchedSoundsAge[n6];
                n2 = n6;
            }
            if (bl2) {
                n2 = n4;
            }
            if (n2 == -1) return n2;
            MMAPISoundImp mMAPISoundImp = mMAPISoundImpArray[n2];
            n6 = 0;
            while (true) {
                if (n6 >= 1) {
                    mMAPISoundImp.Close();
                    return n2;
                }
                if (SoundManager.Get().mChannels[n6].GetSound().mImplementor == mMAPISoundImp) {
                    mMAPISoundImp.Deallocate();
                    return n2;
                }
                ++n6;
            }
        }
    }

    private static short GetMaxPrefetchedSound() {
        return (short)Math.max(Math.max(Math.max(SpecConstants.GetMaxPrefetchedSoundsShortMid(), SpecConstants.GetMaxPrefetchedSoundsShortWav()), SpecConstants.GetMaxPrefetchedSoundsShortAmr()), 1);
    }
}

