/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.DisplayManager;
import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FlKeyManager;
import ca.jamdat.flight.FlRect;
import ca.jamdat.flight.MIDPDisplayContextImp;
import ca.jamdat.flight.SpecConstants;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public final class J2MEScene
extends Canvas {
    public static clue mApp;
    public boolean mScreenRectInitialized;
    public short mScreenRect_top;
    public int mLastGameTime;
    public short mScreenRect_left;
    private MIDPDisplayContextImp mDisplayContextImp;
    public static boolean repaintScene;
    public short mScreenRect_height;
    public short mScreenRect_width;

    public J2MEScene() {
        this.setFullScreenMode(true);
        this.mDisplayContextImp = (MIDPDisplayContextImp)DisplayManager.GetMainDisplayContext();
    }

    public final void hideNotify() {
        mApp.pause();
        J2MEScene.mApp.mResumeNextIsShown = true;
    }

    public final void showNotify() {
        mApp.start();
        mApp.AddEvent((short)7);
    }

    public final void sizeChanged(int n, int n2) {
    }

    public final void pointerDragged(int n, int n2) {
        mApp.AddEvent((short)10, (short)n, (short)n2);
    }

    public final void pointerPressed(int n, int n2) {
        mApp.AddEvent((short)9, (short)n, (short)n2);
    }

    public final void pointerReleased(int n, int n2) {
        mApp.AddEvent((short)11, (short)n, (short)n2);
    }

    public final void keyPressed(int n) {
        mApp.AddEvent((short)1, n);
    }

    public final void keyReleased(int n) {
        mApp.AddEvent((short)2, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void paint(Graphics graphics) {
        Object object = clue.paintLock;
        synchronized (object) {
            this.onDraw(graphics);
        }
        repaintScene = false;
        if (J2MEScene.mApp.mDoublePaint) {
            repaintScene = true;
            clue.mFrameworkGlobals.application.Invalidate();
            J2MEScene.mApp.mDoublePaint = false;
        }
    }

    public static void OnFlightKeyPressed(int n) {
        if (clue.mApplication.mLastKeyDown != n) {
            clue.mApplication.OnKeyFromOS(n, false);
        }
    }

    public static void OnFlightKeyReleased(int n) {
        clue.mApplication.OnKeyFromOS(n, true);
    }

    public final void OnKeyPressed(int n) {
        J2MEScene.OnFlightKeyPressed(J2MEScene.TranslateKey(n, false));
    }

    public final void OnKeyReleased(int n) {
        J2MEScene.OnFlightKeyReleased(J2MEScene.TranslateKey(n, true));
    }

    private void onDraw(Graphics graphics) {
        if (!this.mScreenRectInitialized) {
            short[] sArray = DisplayManager.GetVideoModeRect();
            this.mScreenRect_left = FlRect.GetLeft_(sArray);
            this.mScreenRect_top = FlRect.GetTop_(sArray);
            this.mScreenRect_width = FlRect.GetWidth_(sArray);
            this.mScreenRect_height = FlRect.GetHeight_(sArray);
            this.mScreenRectInitialized = true;
        }
        this.mDisplayContextImp.SetClippingRect(this.mScreenRect_left, this.mScreenRect_top, this.mScreenRect_width, this.mScreenRect_height);
        this.mDisplayContextImp.mGraphics = graphics;
        DisplayManager.RenderApplication();
    }

    public final void onTime(int n) {
        FlApplication.GetInstance().Iteration(n, n - this.mLastGameTime);
        this.mLastGameTime = n;
        repaintScene = true;
    }

    private static int TranslateKey(int n, boolean bl) {
        if (n == SpecConstants.GetKeyCodeUp()) {
            return 1;
        }
        if (n == SpecConstants.GetKeyCodeDown()) {
            return 2;
        }
        if (n == SpecConstants.GetKeyCodeLeft()) {
            return 3;
        }
        if (n == SpecConstants.GetKeyCodeRight()) {
            return 4;
        }
        if (n == SpecConstants.GetKeyCodeBack()) {
            return 9;
        }
        if (n == SpecConstants.GetKeyCodeBackspace()) {
            return 10;
        }
        if (n == SpecConstants.GetKeyCodeStar()) {
            return 42;
        }
        if (n == SpecConstants.GetKeyCodePound()) {
            return 35;
        }
        if (n == SpecConstants.GetFlightKeyCodeFire()) {
            return 7;
        }
        if (n == SpecConstants.GetKeyCodeAccept()) {
            return 13;
        }
        if (n == SpecConstants.GetKeyCodeDecline()) {
            return 14;
        }
        int n2 = FlKeyManager.GetInstance().ToFlightKey(n, bl);
        if (n2 != 0) {
            return n2;
        }
        if (n == SpecConstants.GetKeyCodeSend()) {
            return 0;
        }
        if (n == SpecConstants.GetKeyCodeEnd()) {
            return 0;
        }
        if (n == SpecConstants.GetKeyCodeVolumeUp()) {
            return 0;
        }
        if (n == SpecConstants.GetKeyCodeVolumeDown()) {
            return 0;
        }
        if (n == SpecConstants.GetKeyCodeMediaPlayer()) {
            return 0;
        }
        if (n == SpecConstants.GetKeyCodeUnused1()) {
            return 0;
        }
        return 0;
    }

    static {
        repaintScene = true;
    }
}

