/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.StringUtils;

public final class FlLang {
    public static short mBestLangCache;
    public static short[] mSupportedLang;

    public static short GetBestLang() {
        if (mBestLangCache != 0) {
            return mBestLangCache;
        }
        FlString flString = new FlString(FlApplication.GetPropertyValue(StringUtils.CreateString("Force-Locale")));
        mBestLangCache = FlLang.StrToFlLang(flString);
        if (mBestLangCache == 2) {
            return mBestLangCache;
        }
        if (mBestLangCache == 1) {
            mBestLangCache = FlLang.GetOSLang();
        }
        if ((mBestLangCache = FlLang.Localize(mBestLangCache)) == 1 && flString.Substring(0, 5).Equals(StringUtils.CreateString("auto-"))) {
            mBestLangCache = FlLang.Localize(FlLang.StrToFlLang(flString.Substring(5, -1)));
        }
        if (mBestLangCache == 1) {
            mBestLangCache = (short)2;
        }
        return mBestLangCache;
    }

    private static short GetOSLang() {
        String string = "NULL";
        try {
            string = System.getProperty("microedition.locale");
        }
        catch (Exception exception) {}
        if (string == null) {
            string = "NULL";
        }
        return FlLang.StrToFlLang(StringUtils.CreateString(string));
    }

    private static short GetNbSupportedLang() {
        return 6;
    }

    private static short StrToFlLang(FlString flString) {
        if (flString.GetLength() < 2) {
            return 1;
        }
        flString.ToLower();
        byte[] byArray = new byte[]{32, 95, 45};
        for (int i = 0; i < 3; ++i) {
            int n = flString.FindChar(byArray[i]);
            if (n == -1) continue;
            flString.RemoveCharAt(n, 1);
        }
        if (flString.Equals(StringUtils.CreateString("menu"))) {
            return 2;
        }
        if (flString.Equals(StringUtils.CreateString("deat"))) {
            return 4105;
        }
        if (flString.Equals(StringUtils.CreateString("dede"))) {
            return 8201;
        }
        if (flString.Equals(StringUtils.CreateString("enau"))) {
            return 4107;
        }
        if (flString.Equals(StringUtils.CreateString("enca"))) {
            return 8203;
        }
        if (flString.Equals(StringUtils.CreateString("engb"))) {
            return 12299;
        }
        if (flString.Equals(StringUtils.CreateString("enus"))) {
            return 16395;
        }
        if (flString.Equals(StringUtils.CreateString("esco"))) {
            return 4108;
        }
        if (flString.Equals(StringUtils.CreateString("eses"))) {
            return 8204;
        }
        if (flString.Equals(StringUtils.CreateString("ptbr"))) {
            return 4125;
        }
        if (flString.Equals(StringUtils.CreateString("ptpt"))) {
            return 8221;
        }
        flString.Assign(flString.Substring(0, 2));
        if (flString.Equals(StringUtils.CreateString("de"))) {
            return 9;
        }
        if (flString.Equals(StringUtils.CreateString("en"))) {
            return 11;
        }
        if (flString.Equals(StringUtils.CreateString("es"))) {
            return 12;
        }
        if (flString.Equals(StringUtils.CreateString("fr"))) {
            return 14;
        }
        if (flString.Equals(StringUtils.CreateString("it"))) {
            return 19;
        }
        if (flString.Equals(StringUtils.CreateString("pt"))) {
            return 29;
        }
        return 1;
    }

    private static short Localize(short s) {
        short s2 = 1;
        for (int i = 0; i < FlLang.GetNbSupportedLang(); ++i) {
            if (s == mSupportedLang[i]) {
                return mSupportedLang[i];
            }
            if ((s & 0xFFF) != (mSupportedLang[i] & 0xFFF)) continue;
            s2 = mSupportedLang[i];
        }
        return s2;
    }

    static {
        short[] sArray = new short[]{9, 11, 12, 14, 19, 29, 1};
        mSupportedLang = sArray;
        mBestLangCache = 0;
    }
}

