/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FileStream;

public final class FileSegmentStream {
    public boolean mModified;
    public byte[] mByteArray = null;
    public boolean mValidData;
    public int mPosition;
    public int mByteArrayCapacity;

    public final void SetValidDataFlag(boolean bl) {
        boolean bl2 = this.mValidData != bl || this.mModified;
        this.mModified = bl2;
        this.mValidData = bl;
    }

    public final void FillSegmentToCapacity() {
        this.mPosition = this.mByteArrayCapacity;
    }

    public final void WriteByte(byte by) {
        int n = this.mPosition;
        if (this.mByteArray[n] != by) {
            this.mByteArray[n] = by;
            this.mModified = true;
        }
        this.mPosition = n + 1;
    }

    public final void WriteBoolean(boolean bl) {
        if (bl) {
            this.WriteByte((byte)1);
            return;
        }
        this.WriteByte((byte)0);
    }

    public final void WriteShort(short s) {
        this.WriteByte((byte)(s >> 8));
        this.WriteByte((byte)(s & 0xFF));
    }

    public final void WriteLong(int n) {
        this.WriteShort((short)(n >> 16));
        this.WriteShort((short)(n & 0xFFFF));
    }

    public final boolean ReadBoolean() {
        return this.ReadByte() == 1;
    }

    public final short ReadShort() {
        return (short)(this.ReadByte() << 8 | this.ReadByte() & 0xFF);
    }

    public FileSegmentStream(int n) {
        this.mByteArrayCapacity = n;
        this.mByteArray = new byte[n];
    }

    public final void SetMode$13462e() {
        this.mPosition = 0;
    }

    public final int GetSize() {
        return 4 + this.mByteArrayCapacity;
    }

    public final void Read(FileStream fileStream) {
        this.SetMode$13462e();
        boolean bl = fileStream.ReadLong() == 1;
        this.SetValidDataFlag(bl);
        fileStream.Read(this.mByteArray, this.mByteArrayCapacity);
        this.mModified = false;
    }

    public final byte ReadByte() {
        int n;
        int n2 = this.mPosition;
        this.mPosition = n = n2 + 1;
        return this.mByteArray[n2];
    }

    public final int ReadLong() {
        return this.ReadShort() << 16 | this.ReadShort() & 0xFFFF;
    }

    public final void Write(FileStream fileStream) {
        this.SetMode$13462e();
        int n = this.mValidData ? 1 : 0;
        fileStream.WriteLong(n);
        fileStream.Write(this.mByteArray, this.mByteArrayCapacity);
        this.mModified = false;
    }
}

