/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_DialogBox;
import ca.jamdat.flight.GE_NavTab;
import ca.jamdat.flight.GE_Ticker;
import ca.jamdat.flight.GE_TutorialTicker;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.TutorialController;

public abstract class ClueBaseScene
extends BaseScene {
    public TutorialController mTutorialController;
    public GE_DialogBox mDialogBox;
    public GE_Ticker mTicker;
    public GE_NavTab mNavTab;

    public void Load() {
        super.Load();
        this.mNavTab = new GE_NavTab(this);
        this.mNavTab.Load();
        if (GameApp.Get().GetScenarioContext() != null && GameApp.Get().GetScenarioContext().IsTutorial()) {
            this.mTicker = new GE_TutorialTicker(this);
            this.mTutorialController = new TutorialController(this, (GE_TutorialTicker)this.mTicker);
        } else {
            this.mTicker = new GE_Ticker(this);
        }
        this.mTicker.Load();
        this.mDialogBox = new GE_DialogBox(this);
        this.mDialogBox.Load();
        if (GameApp.Get().GetScenarioContext() != null && GameApp.Get().GetScenarioContext().mState != 6) {
            GameApp.Get().GetScenarioContext().OnEvent(25);
        }
    }

    public ClueBaseScene(int n, int n2) {
        super(n, n2);
    }

    public void Unload() {
        if (GameApp.Get().GetScenarioContext() != null && GameApp.Get().GetScenarioContext().mState != 6) {
            GameApp.Get().GetScenarioContext().OnEvent(26);
        }
        this.mTutorialController = null;
        this.mNavTab.Unload();
        this.mNavTab = null;
        this.mTicker.Unload();
        this.mTicker = null;
        this.mDialogBox.Unload();
        this.mDialogBox = null;
        super.Unload();
    }

    public boolean IsLoaded() {
        return this.mDialogBox.IsLoaded() && this.mNavTab.IsLoaded() && this.mTicker.IsLoaded() && super.IsLoaded();
    }

    public abstract void SetDefaultSoftkeys();

    public final void EndOpeningAnims() {
        if (this.mSceneAnimType == 2) {
            this.mNavTab.SelectNavTab(4);
        }
        this.SetDefaultSoftkeys();
    }

    public final boolean IsAnimsEnded() {
        return this.IsOpeningAnimsEnded() && this.IsClosingAnimsEnded();
    }

    public boolean CanShowNotification(int n) {
        return true;
    }

    public final void ShowNotification(int n) {
        if (this.CanShowNotification(n) && this.IsAnimsEnded()) {
            this.UpdateSoftkeys(7, 39, 8, -14);
            this.ShowDialogBox(new FlString(GameApp.Get().GetScenarioContext().GetNotification()), n);
            this.mDialogBox.BringToFront();
            this.mNavTab.SetActive(false);
            this.OnShowNotification();
        }
        this.ConfigureSceneFor(n);
    }

    public final void RefreshNotifier() {
        if (this.mTutorialController != null) {
            this.mTutorialController.UpdateNotifier();
        }
    }

    public void ShowDialogBox(FlString flString, int n) {
        this.mDialogBox.Show(flString, ClueUtils.GetDialogBoxTypeFrom(n));
    }

    public void Unlock(int n, int n2) {
        if (n == 10) {
            this.mNavTab.SetTabLock(n2, false);
        }
    }

    public void LockAccess() {
        this.mNavTab.LockAccess();
    }

    public void ConfigureSceneFor(int n) {
    }

    public void OnHideNotification() {
        this.SetDefaultSoftkeys();
    }

    public final void Refresh() {
        if (this.mTutorialController != null) {
            this.mTutorialController.Update();
        }
    }

    public boolean OnPenUp(byte by, short[] sArray) {
        boolean bl = false;
        if (this.mDialogBox.mIsActive) {
            bl = this.mDialogBox.OnPenUp(by, sArray);
        }
        return bl || super.OnPenUp(by, sArray);
    }

    public boolean OnPenMove(byte by, short[] sArray, short[] sArray2) {
        return this.mDialogBox.OnPenMove(by, this.mPenDownCoord, sArray, sArray2) || super.OnPenMove(by, sArray, sArray2);
    }

    public boolean OnPenDown(byte by, short[] sArray) {
        boolean bl = false;
        if (this.mDialogBox.mIsActive) {
            bl = true;
        }
        return bl || super.OnPenDown(by, sArray);
    }

    public final void HideNotification() {
        this.mDialogBox.Hide();
        GameApp.Get().GetScenarioContext().OnEvent(18);
        this.Refresh();
        this.mNavTab.SetActive(true);
        this.OnHideNotification();
    }

    public void Suspend() {
        super.Suspend();
        if (GameApp.Get().GetScenarioContext() != null && GameApp.Get().GetScenarioContext().mState != 6) {
            GameApp.Get().GetScenarioContext().OnEvent(26);
        }
    }

    public final void Resume() {
        super.Resume();
        if (GameApp.Get().GetScenarioContext() != null && GameApp.Get().GetScenarioContext().mState != 6) {
            GameApp.Get().GetScenarioContext().OnEvent(25);
        }
    }

    public boolean OnCommand(int n) {
        boolean bl = false;
        if (n == -60) {
            if (this.mDialogBox.mIsActive) {
                this.HideNotification();
            }
        } else if (n == 39) {
            this.HideNotification();
            bl = true;
        } else if (n == 100) {
            bl = this.OnCommand(this.mSelectSoftKey.GetCommand());
        }
        return bl || super.OnCommand(n);
    }

    public void GetEntryPoints() {
        super.GetEntryPoints();
        this.mNavTab.GetEntryPoints();
        this.mTicker.GetEntryPoints();
        this.mDialogBox.GetEntryPoints();
    }

    public void StartOpeningAnims() {
        super.StartOpeningAnims();
        this.UpdateSoftkeys(4, 0, 4, 0);
    }

    public boolean IsOpeningAnimsEnded() {
        boolean bl = true;
        if (this.mSceneAnimType == 2 && !this.mNavTab.IsMinimizingAnimationEnded()) {
            bl = false;
        }
        return bl && super.IsOpeningAnimsEnded();
    }

    public void ReceiveFocus() {
        super.ReceiveFocus();
        this.EndOpeningAnims();
        this.SetDefaultSoftkeys();
    }

    public void StartClosingAnims() {
        this.UpdateSoftkeys(4, 0, 4, 0);
        super.StartClosingAnims();
    }

    public boolean IsClosingAnimsEnded() {
        boolean bl = true;
        if (this.mSceneAnimType == 1) {
            bl = this.mNavTab.IsMaximizingAnimationEnded() && super.IsClosingAnimsEnded();
        }
        return bl && super.IsClosingAnimsEnded();
    }

    public final boolean SaveFiles(int n) {
        return super.SaveFiles(n);
    }

    public void SerializeObjects() {
        GameApp.Get().GetScenarioProcess().OnSerialize();
    }

    public boolean OnKeyDown(int n) {
        boolean bl = false;
        if (this.IsAnimsEnded()) {
            bl = this.mDialogBox.OnKeyDown(n) || this.mNavTab.OnKeyDown(n);
        }
        return bl || super.OnKeyDown(n);
    }

    public boolean OnKeyUp(int n) {
        boolean bl = false;
        if (this.IsAnimsEnded()) {
            bl = this.mDialogBox.OnKeyUp(n) || this.mNavTab.OnKeyUp(n);
        }
        return bl || super.OnKeyUp(n);
    }

    public boolean OnKeyDownOrRepeat(int n) {
        boolean bl = false;
        if (this.IsAnimsEnded()) {
            bl = this.mDialogBox.OnKeyDownOrRepeat(n) || this.mNavTab.OnKeyDownOrRepeat(n);
        }
        return bl || super.OnKeyDownOrRepeat(n);
    }

    public void OnShowNotification() {
    }
}

