/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Scroller;
import ca.jamdat.flight.Selection;

public final class Selector
extends Scroller {
    public int mCurrentSelectionIndex = -1;
    public int mLastUpdatedSelectionIndex = -1;
    public byte mFlags = 1;

    public final int GetNumSelections() {
        return this.mNumElements;
    }

    public Selector() {
        this.mIsVertical = false;
    }

    private boolean GetLooping() {
        return (this.mFlags & 2) != 0;
    }

    private boolean GetSkipDisabledSelection() {
        return (this.mFlags & 1) != 0;
    }

    private boolean GetTakeFocusOnSync() {
        return (this.mFlags & 4) != 0;
    }

    public final void UpdateArrowsEnabledState() {
        if (this.mNextArrow != null) {
            if (!this.GetLooping()) {
                int n = this.mCurrentSelectionIndex;
                int n2 = this.mNumElements - 1;
                int n3 = -1;
                int n4 = -1;
                for (int i = 0; i < this.mNumElements; ++i) {
                    if (n4 == -1 && ((Selection)this.mElements[i]).mEnabled) {
                        n4 = i;
                    }
                    if (n3 == -1 && ((Selection)this.mElements[n2 - i]).mEnabled) {
                        n3 = n2 - i;
                    }
                    if ((n4 | n3) != -1) break;
                }
                Selection selection = this.mNextArrow;
                n3 = n < n3 ? 1 : 0;
                selection.SetEnabledState(n3 != 0);
                selection = this.mPreviousArrow;
                n4 = n > n4 ? 1 : 0;
                selection.SetEnabledState(n4 != 0);
                return;
            }
            this.mNextArrow.SetEnabledState(true);
            this.mPreviousArrow.SetEnabledState(true);
        }
    }

    public final void OnScrollEvent(int n, boolean bl) {
        int n2;
        if (this.mSmoothScrolling > 0) {
            super.OnScrollEvent(n, bl);
            return;
        }
        int n3 = n2 = this.mCurrentSelectionIndex;
        int n4 = this.mNumElements;
        boolean bl2 = this.GetLooping();
        boolean bl3 = this.GetSkipDisabledSelection();
        do {
            int n5 = n3 += n;
            if (n3 < 0) {
                n3 = n4 - 1;
            }
            if (n3 >= n4) {
                n3 = 0;
            }
            if (bl2) {
                if (n3 != n2) continue;
                break;
            }
            if (n3 == n5) continue;
            n3 = n5 - n;
            if (!bl3 || ((Selection)this.mElements[n3]).mEnabled) break;
            n3 = this.mCurrentSelectionIndex;
            break;
        } while (bl3 && !((Selection)this.mElements[n3]).mEnabled);
        if (bl) {
            if (this.mLastUpdatedSelectionIndex != this.mCurrentSelectionIndex) {
                this.mCurrentSelectionIndex = this.mLastUpdatedSelectionIndex;
            }
            this.SetSingleSelection(n3, true, true, false);
            return;
        }
        this.mCurrentSelectionIndex = n3;
    }

    public final boolean IsAppropriateHotkey(int n, int n2) {
        boolean bl = this.GetSkipDisabledSelection();
        for (int i = 0; i < this.mNumElements; i += 1) {
            Selection selection = (Selection)this.mElements[i];
            if (!selection.mEnabled && bl || n2 != selection.mHotKey) continue;
            this.SetSingleSelection(i, true, true, true);
            i = n != -121 ? 1 : 0;
            selection.SetPushedState(i != 0);
            return true;
        }
        return false;
    }

    private void SetSingleSelection(int n, boolean bl, boolean bl2, boolean bl3) {
        int n2 = this.mCurrentSelectionIndex;
        this.mCurrentSelectionIndex = n;
        if (n2 >= 0 && n2 != n && n2 < this.mNumElements) {
            ((Selection)this.mElements[n2]).SetSelectedState(false);
        }
        Selection selection = (Selection)this.mElements[n];
        this.mScrollerViewport.ChangeOffsetToShow(selection, false);
        selection.SetSelectedState(true, bl2, bl3);
        this.UpdateArrowsEnabledState();
        if (bl) {
            selection.TakeFocus();
        }
        this.mLastUpdatedSelectionIndex = this.mCurrentSelectionIndex;
    }

    public final void SetSingleSelection(int n) {
        this.SetSingleSelection(n, false);
    }

    public final void SetSingleSelection(int n, boolean bl) {
        this.SetSingleSelection(n, bl, false);
    }

    public final void OnScrollEvent(int n) {
        this.OnScrollEvent(n, true);
    }

    public final void OnSerialize(Package package_) {
        super.OnSerialize(package_);
        int n = 0;
        if (Package.IsReading()) {
            n = package_.SerializeIntrinsic$134621();
        } else {
            this.mCurrentSelectionIndex = package_.SerializeIntrinsic$134621();
        }
        this.mFlags = package_.SerializeIntrinsic$132bd3();
        if (Package.IsReading() && n >= 0) {
            this.SetSingleSelection(n);
        }
    }

    public final Component ForwardFocus() {
        if (this.mCurrentSelectionIndex == -1) {
            return this;
        }
        return this.GetElementAt(this.mCurrentSelectionIndex).ForwardFocus();
    }

    public final boolean OnDefaultMsg(Component component, int n, int n2) {
        if (-124 == n) {
            for (int i = 0; i < this.mNumElements; ++i) {
                if (!this.GetSelectionAt(i).IsSelfOrAncestorOf(component)) continue;
                this.SetSingleSelection(i, this.GetTakeFocusOnSync());
                this.SendMsg(this, -105, n2);
                i = this.mNumElements;
            }
        }
        return super.OnDefaultMsg(component, n, n2);
    }

    public static Selector Cast$10974a41(Object object) {
        return (Selector)object;
    }

    public final Selection GetSelectionAt(int n) {
        return (Selection)super.GetElementAt(n);
    }

    private void SetSingleSelection(int n, boolean bl, boolean bl2) {
        this.SetSingleSelection(n, bl, bl2, true);
    }

    public final void SetNumSelections(int n) {
        this.mNumElements = n;
    }
}

