/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FileSegmentStream;

public final class ScenarioProgress {
    public int[] mStatus = new int[12];

    public static int GetNextTier(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return -1;
    }

    public ScenarioProgress() {
        this.Reset();
    }

    public static int GetRequiredStars(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 16;
            }
            case 3: {
                return 26;
            }
            case 4: {
                return 38;
            }
        }
        return -1;
    }

    private void Clear() {
        for (int i = 0; i < 12; ++i) {
            this.mStatus[i] = 1;
        }
    }

    private void ChangeStatus(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 0: {
                n3 = 0;
                n4 = 2;
                break;
            }
            case 1: {
                n3 = 2;
                n4 = 5;
                break;
            }
            case 2: {
                n3 = 5;
                n4 = 8;
                break;
            }
            case 3: {
                n3 = 8;
                n4 = 11;
                break;
            }
            case 4: {
                n3 = 11;
                n4 = 12;
            }
        }
        while (n3 < n4) {
            this.mStatus[n3] = n2;
            ++n3;
        }
    }

    public final void Read(FileSegmentStream fileSegmentStream) {
        for (int i = 0; i < 12; ++i) {
            this.mStatus[i] = fileSegmentStream.ReadByte();
        }
    }

    public final void Write(FileSegmentStream fileSegmentStream) {
        for (int i = 0; i < 12; ++i) {
            fileSegmentStream.WriteByte((byte)this.mStatus[i]);
        }
    }

    public final void Unlock(int n) {
        this.ChangeStatus(n, 0);
    }

    private void Reset() {
        this.Clear();
        this.Unlock(0);
    }

    public final int GetStatus(int n) {
        return this.mStatus[n];
    }

    public final int GetCurrentTier() {
        int n = 4;
        for (int i = 0; i < 12; ++i) {
            if (this.mStatus[i] == 0) continue;
            n = ScenarioProgress.GetTier(i - 1);
            break;
        }
        return n;
    }

    public final int GetNextTier() {
        return ScenarioProgress.GetNextTier(this.GetCurrentTier());
    }

    public static int GetTier(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: 
            case 3: 
            case 4: {
                return 1;
            }
            case 5: 
            case 6: 
            case 7: {
                return 2;
            }
            case 8: 
            case 9: 
            case 10: {
                return 3;
            }
            case 11: {
                return 4;
            }
        }
        return -1;
    }
}

