/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.FileSegmentStream;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.ScenarioProgress;
import ca.jamdat.flight.ScenarioStarReward;

public final class ScenarioMediator {
    public int mVariation;
    public int mCurrentId;
    public ScenarioProgress mProgress;
    public ScenarioStarReward mStarReward;
    public int[] mLastVariation = null;

    public final int UpdateStars(int n) {
        this.mStarReward.SetStars(this.mCurrentId, n);
        n = this.mProgress.GetNextTier();
        int n2 = -1;
        if (this.mStarReward.GetTotalStars() >= ScenarioProgress.GetRequiredStars(n)) {
            this.mProgress.Unlock(n);
            n2 = n;
        }
        return n2;
    }

    public final int GetScenarioTier() {
        return ScenarioProgress.GetTier(this.mCurrentId);
    }

    public final boolean IsStagePlayedCompletely(int n) {
        for (int i = 0; i < 12; ++i) {
            if (n != ScenarioProgress.GetTier(i)) continue;
            int n2 = GameApp.Get().GetScenarioContext().GetOutcome();
            if ((this.mStarReward.GetStars(i) != 0 || i == this.mCurrentId) && (i != this.mCurrentId || ClueUtils.GetStarsFromOutcome(n2) != 0)) continue;
            return false;
        }
        return true;
    }

    public final void OnDelete() {
        this.mLastVariation = null;
    }

    public final void OnCancel() {
        this.mCurrentId = -1;
        this.mVariation = -1;
    }

    private void OnCompleted$1385ff() {
        this.mCurrentId = -1;
        this.mVariation = -1;
    }

    public final void UnlockLevel(int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            this.mStarReward.SetStars(n2, 4);
        }
        int n3 = 0;
        n2 = ScenarioProgress.GetTier(n);
        while (n3 <= n2 && n3 != -1) {
            this.mProgress.Unlock(n3);
            n3 = ScenarioProgress.GetNextTier(n3);
        }
    }

    public final void OnCompleted() {
        this.OnCompleted$1385ff();
    }

    public final void Read(FileSegmentStream fileSegmentStream) {
        this.mCurrentId = fileSegmentStream.ReadByte();
        for (int i = 0; i < 12; ++i) {
            this.mLastVariation[i] = fileSegmentStream.ReadByte();
        }
        if (this.mCurrentId != -1) {
            this.mVariation = this.mLastVariation[this.mCurrentId];
            return;
        }
        this.mVariation = -1;
    }

    public final void Write(FileSegmentStream fileSegmentStream) {
        fileSegmentStream.WriteByte((byte)this.mCurrentId);
        for (int i = 0; i < 12; ++i) {
            fileSegmentStream.WriteByte((byte)this.mLastVariation[i]);
        }
    }

    public final int GetVariation() {
        if (this.mCurrentId == 0 || this.mCurrentId == 1) {
            this.mLastVariation[this.mCurrentId] = this.mVariation = 0;
        } else if (this.mVariation == -1) {
            if (this.mLastVariation[this.mCurrentId] == -1) {
                this.mVariation = 0;
            } else {
                this.mVariation = this.mLastVariation[this.mCurrentId] + 1;
                if (this.mVariation >= 3) {
                    this.mVariation = 0;
                }
            }
            this.mLastVariation[this.mCurrentId] = this.mVariation;
        }
        return this.mVariation;
    }

    public final void OnNewGame() {
        int n = this.mCurrentId == -1 ? 2 : this.mCurrentId;
        this.mCurrentId = n;
        this.mVariation = -1;
    }

    public ScenarioMediator(ScenarioProgress scenarioProgress, ScenarioStarReward scenarioStarReward) {
        this.mProgress = scenarioProgress;
        this.mStarReward = scenarioStarReward;
        this.mCurrentId = -1;
        this.mVariation = -1;
        this.mLastVariation = new int[12];
        for (int i = 0; i < this.mLastVariation.length; ++i) {
            this.mLastVariation[i] = -1;
        }
    }

    public final int SetCurrentElement(int n) {
        if (n >= 0 && n < 12) {
            this.mCurrentId = n;
        }
        return this.mCurrentId;
    }

    public final boolean IsLocked() {
        return this.mProgress.GetStatus(this.mCurrentId) == 1;
    }

    public final int GetTotalStars() {
        return this.mStarReward.GetTotalStars();
    }

    public final int GetScenarioStars() {
        return this.mStarReward.GetStars(this.mCurrentId);
    }
}

