/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Achievements;
import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_DialogBox;
import ca.jamdat.flight.GE_Editor;
import ca.jamdat.flight.GE_Ticker;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.MediaPlayer;
import ca.jamdat.flight.ScenarioContext;
import ca.jamdat.flight.ScenarioMediator;
import ca.jamdat.flight.ScenarioProgress;

public final class ProgressionScene
extends BaseScene {
    public GE_DialogBox mDialogBox;
    public GE_Ticker mTicker;
    public GE_Editor mEditor;
    public int mStateDialog = 0;

    public ProgressionScene() {
        super(33, 3014748);
        this.AddType(4);
    }

    public final void Initialize() {
        super.Initialize();
        --this.mStateDialog;
        if (this.mStateDialog == -1) {
            this.mStateDialog = 0;
        }
        this.mTicker.Init(this.mViewport);
        this.mEditor.Init(this.mViewport);
        this.mEditor.SetVisible(true);
        this.mDialogBox.Init(this.mViewport);
        this.mDialogBox.Show(this.GetEditorTextInProgression(), 7);
        ++this.mStateDialog;
    }

    public final void Load() {
        super.Load();
        this.mEditor = new GE_Editor(this);
        this.mEditor.Load();
        this.mTicker = new GE_Ticker(this);
        this.mTicker.Load();
        this.mDialogBox = new GE_DialogBox(this);
        this.mDialogBox.Load();
    }

    public final boolean OnCommand(int n) {
        boolean bl = false;
        if (n == 96) {
            if (this.mStateDialog >= 2) {
                ScenarioMediator scenarioMediator = GameApp.Get().GetScenarioProcess().mMediator;
                n = ClueUtils.GetStarsFromOutcome(GameApp.Get().GetScenarioContext().GetOutcome());
                scenarioMediator.UpdateStars(n);
                this.UpdateAchievements();
                Achievements achievements = GameApp.Get().GetAchievements();
                for (int i = 0; i < 13; ++i) {
                    if (!achievements.IsReadyToUnlock(i)) continue;
                    achievements.Unlock(i);
                }
                GameApp.Get().GetScenarioProcess().Step(7);
                n = -12;
                if (GameApp.Get().GetSettings().IncreasePublishCount() == 5 && GameApp.Get().GetMoreGames().IsEnabled()) {
                    n = -35;
                }
            } else {
                FlString flString = this.GetEditorTextInProgression();
                this.mDialogBox.Show(flString, 7);
                ++this.mStateDialog;
                bl = true;
            }
        } else if (n == 100) {
            bl = this.OnCommand(this.mSelectSoftKey.GetCommand());
        }
        return bl || super.OnCommand(n);
    }

    public final void Unload() {
        this.mEditor.Unload();
        this.mEditor = null;
        this.mTicker.Unload();
        this.mTicker = null;
        this.mDialogBox.Unload();
        this.mDialogBox = null;
        super.Unload();
        GameApp.Get().GetMediaPlayer().Terminate();
    }

    public final boolean IsLoaded() {
        return super.IsLoaded() && this.mEditor.IsLoaded() && this.mTicker.IsLoaded() && this.mDialogBox.IsLoaded();
    }

    private void UpdateAchievements() {
        Achievements achievements = GameApp.Get().GetAchievements();
        ScenarioContext scenarioContext = GameApp.Get().GetScenarioContext();
        int n = GameApp.Get().GetScenarioProcess().mMediator.mCurrentId;
        boolean bl = !scenarioContext.HasMoreClues();
        achievements.SetFoundEveryClue(n, bl);
        if (!(scenarioContext.IsCorrectSuspect() || scenarioContext.IsCorrectRoom() || scenarioContext.IsCorrectWeapon())) {
            achievements.SetPublishWrongTrio(n, true);
        }
        if (!scenarioContext.IsWithinTime()) {
            achievements.SetTrespassedRegularTimeEnd(n, true);
            if (!scenarioContext.IsInOverTime()) {
                achievements.SetTrespassedExtendedTimeEnd(n, true);
            }
        }
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        this.mEditor.GetEntryPoints();
        this.mTicker.GetEntryPoints();
        this.mDialogBox.GetEntryPoints();
    }

    private FlString GetEditorTextInProgression() {
        FlString flString = null;
        int n = GameApp.Get().GetScenarioContext().GetOutcome();
        switch (((ProgressionScene)((Object)scenarioMediator)).mStateDialog) {
            case 0: {
                int n2 = GameApp.Get().GetScenarioContext().IsTutorial() ? GameApp.Get().GetScenarioContext().mTutorialSteps.GetProgressionDialogIntroStringId() : (n == 6 ? 124 : 119 + n);
                flString = ClueUtils.GetGameString(n2);
                MediaPlayer mediaPlayer = GameApp.Get().GetMediaPlayer();
                int n3 = n >= 5 ? 12 : 13;
                mediaPlayer.PlayMusic(n3);
                break;
            }
            case 1: {
                int n4 = -1;
                ScenarioMediator scenarioMediator = GameApp.Get().GetScenarioProcess().mMediator;
                ScenarioProgress scenarioProgress = GameApp.Get().GetSettings().mProgress;
                int n5 = scenarioProgress.GetNextTier();
                if (scenarioMediator.GetTotalStars() - scenarioMediator.GetScenarioStars() + ClueUtils.GetStarsFromOutcome(n) >= ScenarioProgress.GetRequiredStars(n5)) {
                    n4 = n5;
                }
                flString = ClueUtils.GetGameString(126);
                if (GameApp.Get().GetScenarioContext().IsTutorial()) {
                    flString = ClueUtils.GetGameString(GameApp.Get().GetScenarioContext().mTutorialSteps.GetProgressionDialogConclusionStringId());
                    break;
                }
                if (n4 != -1) {
                    FlString flString2;
                    GameApp.Get().GetMediaPlayer().PlayMusic(10);
                    flString = flString2 = new FlString(ClueUtils.GetGameString(125));
                    ClueUtils.ReplaceJobTitleStringInString(flString2, ClueUtils.GetCommonString(17 + n4 - 1));
                    break;
                }
                GameApp.Get().GetMediaPlayer().PlayMusic(11);
                if (!scenarioMediator.IsStagePlayedCompletely(scenarioProgress.GetCurrentTier()) && n5 != -1) {
                    flString = ClueUtils.GetStringNumberOfStars(ScenarioProgress.GetRequiredStars(n5));
                    break;
                }
                if (!GameApp.Get().GetAchievements().IsUnlocked(3)) break;
                flString = ClueUtils.GetGameString(127);
            }
        }
        return flString;
    }

    public final boolean OnKeyDown(int n) {
        boolean bl = this.mDialogBox.mIsActive && this.mDialogBox.OnKeyDown(n);
        return bl || super.OnKeyDown(n);
    }

    public final boolean OnKeyUp(int n) {
        boolean bl = this.mDialogBox.mIsActive && this.mDialogBox.OnKeyUp(n);
        return bl || super.OnKeyUp(n);
    }

    public final boolean OnKeyDownOrRepeat(int n) {
        boolean bl = this.mDialogBox.mIsActive && this.mDialogBox.OnKeyDownOrRepeat(n);
        return bl || super.OnKeyDownOrRepeat(n);
    }

    public final boolean OnPenUp(byte by, short[] sArray) {
        boolean bl = false;
        if (this.mDialogBox.mIsActive) {
            bl = this.mDialogBox.OnPenUp(by, sArray);
        }
        return bl || super.OnPenUp(by, sArray);
    }

    public final boolean OnPenMove(byte by, short[] sArray, short[] sArray2) {
        return this.mDialogBox.OnPenMove(by, this.mPenDownCoord, sArray, sArray2) || super.OnPenMove(by, sArray, sArray2);
    }

    public final boolean OnPenDown(byte by, short[] sArray) {
        boolean bl = false;
        if (this.mDialogBox.mIsActive) {
            bl = true;
        }
        return bl || super.OnPenDown(by, sArray);
    }
}

