/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FlBrowser;
import ca.jamdat.flight.FlMoreGames;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.Tokenizer;
import ca.jamdat.flight.Utilities;

public final class MoreGames15 {
    public MetaPackage mPackage;
    public int mImpl = 0;
    public FlString[] mConfiguredProductIds = null;
    public FlString mSelectedProductId;
    public int mRealConfiguredProductCount;
    public int mCatUriConfigCheatStatus;
    public int mConfiguredProductCount;
    public FlString[] mEmbeddedProductIds = null;
    public int mBuyUriConfigCheatStatus;
    public int mEmbeddedProductCount;
    public FlMoreGames mFlMoreGames = new FlMoreGames();

    private void InitializeConfiguredProducts() {
        Object object;
        FlString flString = new FlString(FlApplication.GetPropertyValue(StringUtils.CreateString("MG_PRODUCTS")));
        int n = 0;
        if (MoreGames15.IsPropertySet(flString)) {
            FlString flString2 = new FlString(StringUtils.CreateString(","));
            object = new Tokenizer(flString, flString2);
            n = ((Tokenizer)object).CountTokens();
            this.mConfiguredProductIds = this.Tokenize((Tokenizer)object, n);
        }
        if (this.mImpl == 2) {
            object = new FlString[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                object[i] = null;
                object[n2++] = this.mConfiguredProductIds[i];
            }
            this.mConfiguredProductIds = null;
            this.mConfiguredProductIds = object;
            n = n2;
        }
        this.mConfiguredProductCount = n;
        this.mRealConfiguredProductCount = n;
    }

    public MoreGames15() {
        this.mSelectedProductId = new FlString();
    }

    private void InitializeEmbeddedProducts() {
        FlString flString = FlString.Cast$50263e8f(this.mPackage.mPackage.GetEntryPoint(0));
        FlString flString2 = new FlString(StringUtils.CreateString(","));
        Tokenizer tokenizer = new Tokenizer(flString, flString2);
        this.mEmbeddedProductCount = tokenizer.CountTokens();
        this.mEmbeddedProductIds = this.Tokenize(tokenizer, this.mEmbeddedProductCount);
    }

    private boolean HasValidConfiguration() {
        if (this.mConfiguredProductCount > 0) {
            for (int i = 0; i < this.mEmbeddedProductCount; ++i) {
                FlString flString = this.mEmbeddedProductIds[i];
                for (int j = 0; j < this.mConfiguredProductCount; ++j) {
                    if (!flString.Equals(this.mConfiguredProductIds[j])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private FlString[] Tokenize(Tokenizer tokenizer, int n) {
        FlString[] flStringArray = null;
        if (n > 0) {
            flStringArray = new FlString[n];
            n = 0;
            while (tokenizer.HasMoreToken()) {
                FlString flString = new FlString(tokenizer.NextToken());
                Utilities.TrimString(flString);
                flStringArray[n++] = new FlString(flString);
            }
        }
        return flStringArray;
    }

    private static boolean IsWapSupported() {
        return true;
    }

    private boolean IsWapEnabled() {
        return MoreGames15.IsWapSupported() && (this.mImpl == 2 || this.mImpl == 3);
    }

    public final void Load() {
        this.mPackage = GameLibrary.GetPackage(32769);
    }

    private void Initialize(int n) {
        this.mImpl = n;
        if (this.IsEnabled()) {
            if (this.mConfiguredProductIds == null) {
                this.InitializeConfiguredProducts();
            }
            if (this.mEmbeddedProductIds == null) {
                this.InitializeEmbeddedProducts();
            }
            if (!this.HasValidConfiguration()) {
                this.mImpl = 0;
            }
        }
    }

    private static boolean IsPropertySet(FlString flString) {
        return flString.GetLength() > 0 && !flString.Equals(StringUtils.CreateString("NULL")) && !flString.Equals(StringUtils.CreateString("null"));
    }

    public final boolean IsLoaded() {
        return GameLibrary.IsPackageLoaded(this.mPackage);
    }

    public final boolean IsEnabled() {
        return this.mImpl != 0;
    }

    public final void Initialize() {
        this.Initialize(this.mFlMoreGames.GetImplementation());
    }

    public static boolean IsWapBrowserExitApp() {
        FlBrowser.GetInstance();
        return FlBrowser.LaunchURIWillExit$138603_$549da86c();
    }

    public final int GetBuyCommand(FlString flString) {
        int n = 0;
        if (this.IsEnabled() && this.IsWapEnabled() && this.IsBuyAttributeConfigured(flString)) {
            n = MoreGames15.IsWapBrowserExitApp() ? -38 : -40;
        }
        return n;
    }

    public final int GetCatCommand(FlString flString) {
        int n = 0;
        if (this.IsEnabled()) {
            n = this.IsWapEnabled() && this.IsCatAttributeConfigured(flString) ? (MoreGames15.IsWapBrowserExitApp() ? -39 : -41) : (this.mImpl == 2 ? 0 : -34);
        }
        return n;
    }

    private boolean IsBuyAttributeConfigured(FlString flString) {
        boolean bl = MoreGames15.IsPropertySet(FlApplication.GetPropertyValue(MoreGames15.GetBuyUriAttributeName(flString)));
        if (this.mBuyUriConfigCheatStatus == 2) {
            bl = false;
        }
        return bl;
    }

    public static FlString GetBuyUriAttributeName(FlString flString) {
        return StringUtils.CreateString("MG_BUYURI_").AddAssign(flString);
    }

    private boolean IsCatAttributeConfigured(FlString flString) {
        boolean bl = MoreGames15.IsPropertySet(FlApplication.GetPropertyValue(MoreGames15.GetCatUriAttributeName(flString)));
        if (this.mCatUriConfigCheatStatus == 2) {
            bl = false;
        }
        return bl;
    }

    public static FlString GetCatUriAttributeName(FlString flString) {
        return StringUtils.CreateString("MG_CATURI_").AddAssign(flString);
    }

    public final void SetSelectedProductId(FlString flString) {
        this.mSelectedProductId.Assign(flString);
    }

    public final void SetImplementation(int n) {
        if ((n == 0 || n == 1 || n == 2 || n == 3) && this.mImpl != n) {
            this.Initialize(n);
        }
    }

    public final void SetBuyUriConfiguration(int n) {
        if (n == 0 || n == 1 || n == 2) {
            this.mBuyUriConfigCheatStatus = n;
        }
    }

    public final void SetCatUriConfiguration(int n) {
        if (n == 0 || n == 1 || n == 2) {
            this.mCatUriConfigCheatStatus = n;
        }
    }

    public final void SetConfiguredProductCount(int n) {
        this.mConfiguredProductCount = n < 0 ? 0 : (n > this.mRealConfiguredProductCount ? this.mRealConfiguredProductCount : n);
        this.Initialize();
    }

    public final void SwapConfiguredProductPosition() {
        int n = this.mConfiguredProductCount - 1;
        for (int i = 0; i < n; ++i) {
            FlString flString = this.mConfiguredProductIds[i];
            this.mConfiguredProductIds[i] = this.mConfiguredProductIds[i + 1];
            this.mConfiguredProductIds[i + 1] = flString;
        }
    }
}

