/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FrameworkGlobals;
import ca.jamdat.flight.MMAPISoundImp;
import ca.jamdat.flight.Sound;
import ca.jamdat.flight.SoundManager;
import javax.microedition.media.control.VolumeControl;

public final class MMAPISoundPlayerImp {
    public short mVolume = (short)255;
    public boolean mIsMuted;
    public int mPlayAgain;
    public Sound mSound;
    public boolean mIsLooping;
    public boolean mIsPaused;
    public MMAPISoundImp mSoundImp;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void Stop() {
        MMAPISoundImp mMAPISoundImp = this.mSoundImp;
        if (mMAPISoundImp == null || mMAPISoundImp.mPlayer == null) {
            return;
        }
        if (mMAPISoundImp.EvaluateSoundFormatSpec((byte)0)) {
            SoundManager soundManager = SoundManager.Get();
            synchronized (soundManager) {
                if (!this.IsPlaying() && !this.IsPaused()) {
                    return;
                }
                if (mMAPISoundImp.EvaluateSoundFormatSpec((byte)1)) {
                    this.Reset(true);
                } else {
                    mMAPISoundImp.Deallocate();
                    this.mIsPaused = false;
                }
                return;
            }
        }
        this.Pause();
        try {
            SoundManager soundManager = SoundManager.Get();
            synchronized (soundManager) {
                this.mIsPaused = false;
                mMAPISoundImp.mPlayer.setMediaTime(0L);
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean IsPaused() {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            return this.mIsPaused;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void SetSound(Sound object) {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            if (this.mSoundImp != null) {
                if (this.IsPlaying() || this.IsPaused() && !FrameworkGlobals.GetInstance().application.mIsSuspended) {
                    this.Stop();
                }
                if (this.mSound == object && this.mSoundImp.mPlayer != null) {
                    return;
                }
                if (this.mSoundImp.GetPlayerState() != 300 && this.mSoundImp.mPlayer != null) {
                    this.mSoundImp.Close();
                }
            }
            this.mSound = object;
            this.mPlayAgain = 0;
            if (this.mSound != null) {
                this.mSoundImp = object = ((Sound)object).mImplementor;
                if (((MMAPISoundImp)object).mPlayer == null) {
                    ((MMAPISoundImp)object).CreatePlayer();
                }
                this.SetLooping(this.mIsLooping);
            } else {
                this.mSoundImp = null;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void Play() {
        MMAPISoundImp mMAPISoundImp = this.mSoundImp;
        if (mMAPISoundImp.GetPlayerState() == 200) {
            mMAPISoundImp.Prefetch();
        }
        try {
            SoundManager soundManager = SoundManager.Get();
            synchronized (soundManager) {
                if (mMAPISoundImp.GetPlayerState() == 300 && !this.mIsMuted && !SoundManager.Get().IsMuted()) {
                    this.SetNativeVolume();
                    if (this.mIsPaused) {
                        this.mIsPaused = false;
                    }
                    mMAPISoundImp.mPlayer.start();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            if (this.mPlayAgain < 20) {
                ++this.mPlayAgain;
                this.Play();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void Pause() {
        try {
            SoundManager soundManager = SoundManager.Get();
            synchronized (soundManager) {
                if (!this.IsPlaying()) {
                    return;
                }
                this.mSoundImp.mPlayer.stop();
                this.mIsPaused = true;
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final short GetVolume() {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            return this.mVolume;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void SetLooping(boolean bl) {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            mMAPISoundPlayerImp.mIsLooping = bl;
            if (mMAPISoundPlayerImp.mSoundImp != null && mMAPISoundPlayerImp.mSoundImp.mPlayer != null) {
                try {
                    MMAPISoundPlayerImp mMAPISoundPlayerImp = mMAPISoundPlayerImp.mSoundImp.mPlayer;
                    bl = bl ? -1 : true;
                    mMAPISoundPlayerImp.setLoopCount(bl ? 1 : 0);
                }
                catch (Exception exception) {}
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void SetNativeVolume() {
        try {
            SoundManager soundManager = SoundManager.Get();
            synchronized (soundManager) {
                VolumeControl volumeControl;
                if (this.mSoundImp != null && (volumeControl = (VolumeControl)this.mSoundImp.mPlayer.getControl("VolumeControl")) != null) {
                    SoundManager.Get();
                    volumeControl.setLevel(SoundManager.CalculateNativePlayerVolume(this.mVolume));
                }
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean IsPlaying() {
        MMAPISoundImp mMAPISoundImp = ((MMAPISoundPlayerImp)((Object)mMAPISoundImp)).mSoundImp;
        if (mMAPISoundImp == null) return false;
        if (mMAPISoundImp.mPlayer == null) {
            return false;
        }
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            if (mMAPISoundImp == null) return false;
            if (mMAPISoundImp.GetPlayerState() != 400) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void Reset(boolean bl) {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            if (bl) {
                this.mIsPaused = false;
            }
            this.mSoundImp.ResetSoundPlayer();
            this.SetNativeVolume();
            this.SetLooping(this.mIsLooping);
            return;
        }
    }
}

