/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Stream;
import ca.jamdat.flight.StringUtils;
import java.io.IOException;
import java.io.InputStream;

public final class LibraryStream
extends Stream {
    public InputStream mInputStream;
    public int mPositionInSegment;
    public int mLibrarySize;
    public int mSegmentSize;
    public byte[] mBuffer = new byte[4];
    public FlString mFileName = new FlString();
    public int mSizeOfCurrentSegment;
    public int mCurrentSegment;

    private static InputStream GetResourceAsStream(String string) {
        return System.out.getClass().getResourceAsStream(string);
    }

    public final int Read(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n2;
        n += n2;
        do {
            if ((n3 = this.mSizeOfCurrentSegment - this.mPositionInSegment) <= 0) {
                this.CloseSegment();
                ++this.mCurrentSegment;
                this.OpenSegment(this.mCurrentSegment);
                n3 = this.mSizeOfCurrentSegment;
            }
            n3 = FlMath.Minimum(n4, n3);
            try {
                int n5 = 0;
                while ((n5 += this.mInputStream.read(byArray, n - n4 + n5, n3 - n5)) != n3) {
                    if (n5 >= 0) continue;
                    throw new IOException();
                }
            }
            catch (Exception exception) {}
            this.mPositionInSegment += n3;
        } while ((n4 -= n3) > 0);
        return n2;
    }

    public final void SetPosition(int n) {
        int n2;
        int n3 = this.mLibrarySize;
        int n4 = this.mSegmentSize;
        if (n >= n3) {
            n2 = (n3 - 1) / n4;
            n = n3 - n2 * n4;
        } else {
            n2 = n / n4;
            n %= n4;
        }
        if (n2 == this.mCurrentSegment && n >= this.mPositionInSegment) {
            n -= this.mPositionInSegment;
        } else {
            this.mCurrentSegment = n2;
            this.CloseSegment();
            this.OpenSegment(this.mCurrentSegment);
        }
        n3 = -1;
        try {
            for (n4 = 0; n4 < n && n3 != 0; n4 += n3) {
                n3 = (int)this.mInputStream.skip(n - n4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mPositionInSegment += n4;
    }

    private boolean IsOpen() {
        return this.mInputStream != null;
    }

    private void Create(FlString flString) {
        this.mFileName.Assign(FlString.FromChar((byte)47).Add(flString).Add(FlString.FromChar((byte)46)));
        this.OpenSegment(0);
        if (this.IsOpen()) {
            this.mSizeOfCurrentSegment = this.mLibrarySize = 4096;
            int n = this.ReadLong();
            int n2 = this.ReadLong();
            this.mPositionInSegment += 8;
            if (n == 0 || n2 < n) {
                n = n2;
            }
            this.mSizeOfCurrentSegment = n;
            this.mLibrarySize = n2;
            this.mSegmentSize = n;
            this.SetPosition(0);
        }
    }

    private void CloseSegment() {
        try {
            this.mInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mInputStream = null;
    }

    private void OpenSegment(int n) {
        int n2 = this.mSegmentSize;
        if (n2 > 0) {
            int n3 = this.mLibrarySize / n2;
            n3 = n < n3 ? n2 : this.mLibrarySize - n3 * n2;
            this.mSizeOfCurrentSegment = n3;
        }
        this.mPositionInSegment = 0;
        InputStream inputStream = this.GetInputStreamOnSegment(n);
        if (inputStream == null) {
            this.mInputStream = null;
            return;
        }
        this.mInputStream = inputStream;
    }

    private InputStream GetInputStreamOnSegment(int n) {
        return LibraryStream.GetResourceAsStream(StringUtils.CreateJavaString(this.mFileName.Add(new FlString(n))));
    }

    public final byte ReadByte() {
        if (this.mPositionInSegment >= this.mSizeOfCurrentSegment) {
            this.CloseSegment();
            ++this.mCurrentSegment;
            this.OpenSegment(this.mCurrentSegment);
        }
        byte[] byArray = this.mBuffer;
        try {
            int n;
            while ((n = this.mInputStream.read(byArray, 0, 1)) < 1) {
                if (n >= 0) continue;
                throw new IOException();
            }
        }
        catch (Exception exception) {}
        ++this.mPositionInSegment;
        return byArray[0];
    }

    public final int ReadLong() {
        byte[] byArray = this.mBuffer;
        this.Read(byArray, 0, 4);
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public LibraryStream(FlString flString) {
        this.Create(flString);
    }
}

