/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BitField;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.Library;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Settings;
import ca.jamdat.flight.StringUtils;

public final class GameLibrary {
    public boolean mSynchronousLoadEnabled;
    public MetaPackage[] mPackages = null;
    public Library mLibrary = new Library(FlApplication.GetDir().Add(StringUtils.CreateString("gamelib")));

    private void ReleasePackageImpl(MetaPackage object) {
        int n = ((MetaPackage)object).mLanguage;
        ((MetaPackage)object).RemoveRef();
        int n2 = ((MetaPackage)object).mId;
        if (((MetaPackage)object).mRefCount == 0) {
            ((MetaPackage)object).ReleasePackage();
        }
        object = new int[15];
        n2 = this.GetPackageDependencies$187b7f10(n2, (int[])object, (short)n);
        for (n = 0; n < n2; ++n) {
            GameLibrary.ReleasePackage(this.GetPackageFromArray$236df7a7((int)object[n]));
        }
    }

    public GameLibrary() {
        this.mPackages = new MetaPackage[182];
        this.RefreshConstants();
    }

    private static int GetLocalizedFontDependency$136bab() {
        return 1966140;
    }

    private MetaPackage GetPackage(int n, short s, int n2) {
        Package package_;
        int[] nArray = new int[15];
        int n3 = this.GetPackageDependencies$187b7f10(n, nArray, s);
        MetaPackage metaPackage = this.GetPackageFromArray$236df7a7(n);
        boolean bl = metaPackage != null && metaPackage.IsValid();
        boolean bl2 = bl;
        if (!bl) {
            package_ = this.mLibrary.NewPackage(this.GetPackageLibraryIndex$486d5eb7(n, s));
            package_.SetNumDependencies(n3);
        } else {
            package_ = metaPackage.mPackage;
        }
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            MetaPackage metaPackage2 = this.GetPackage(nArray[i], s, n2);
            if (!bl2) {
                package_.SetDependency(i, metaPackage2.mPackage);
            }
            if (!metaPackage2.mLanguageDependant) continue;
            ++n4;
        }
        if (!package_.IsLoaded() && !package_.IsLoading()) {
            bl = !this.mSynchronousLoadEnabled;
            package_.Load(bl);
        }
        if (!bl2) {
            metaPackage = this.SetPackageInArray(package_, n, s, n2);
        }
        metaPackage.AddRef();
        if (n4 > 0) {
            metaPackage.MarkAsLanguageDependant();
        }
        return metaPackage;
    }

    private int GetPackageLibraryIndex$486d5eb7(int n, short s) {
        int n2 = BitField.GetValue(n, 1073709056, 15);
        int n3 = 0;
        if (GameLibrary.IsMultilingualPackage(n)) {
            n3 = GameApp.Get().GetLanguageManager().GetLanguageIndex(s);
        }
        return n2 + n3;
    }

    private MetaPackage SetPackageInArray(Package package_, int n, short s, int n2) {
        n2 = GameLibrary.GetPackageArrayIndex(n);
        MetaPackage metaPackage = this.mPackages[n2];
        if (metaPackage == null) {
            MetaPackage metaPackage2;
            metaPackage = metaPackage2 = new MetaPackage();
            this.mPackages[n2] = metaPackage2;
        }
        metaPackage.SetPackage$7f2c8659(package_, n, s);
        return metaPackage;
    }

    private MetaPackage GetPackageFromArray$236df7a7(int n) {
        return this.mPackages[GameLibrary.GetPackageArrayIndex(n)];
    }

    private static int GetPackageArrayIndex(int n) {
        return BitField.GetValue(n, Short.MAX_VALUE, 0);
    }

    public static MetaPackage GetPackage(int n) {
        short s = Settings.GetApplicationLanguage();
        return GameApp.Get().GetLibrary().GetPackage(n, s, 0);
    }

    public static void ReleasePackage(MetaPackage metaPackage) {
        GameApp.Get().GetLibrary().ReleasePackageImpl(metaPackage);
    }

    public static boolean IsPackageLoaded(MetaPackage metaPackage) {
        return metaPackage != null && metaPackage.IsLoaded();
    }

    public final boolean SetImmediateLoadModeEnabled(boolean bl) {
        this.mSynchronousLoadEnabled = bl;
        return this.mSynchronousLoadEnabled;
    }

    public static boolean IsMultilingualPackage(int n) {
        return BitField.IsBitOn(n, Integer.MIN_VALUE);
    }

    private void RefreshConstants() {
        GameApp gameApp = GameApp.Get();
        Constants constants = GameLibrary.InstantiateConstants(Settings.GetApplicationLanguage());
        gameApp.SetConstants(constants);
    }

    private static Constants InstantiateConstants(short s) {
        if (11 == s) {
            return new Constants();
        }
        if (14 == s) {
            return new Constants();
        }
        if (9 == s) {
            return new Constants();
        }
        if (19 == s) {
            return new Constants();
        }
        if (29 == s) {
            return new Constants();
        }
        if (12 == s) {
            return new Constants();
        }
        return null;
    }

    private int GetPackageDependencies$187b7f10(int n, int[] nArray, short s) {
        s = 0;
        switch (n) {
            case 5308578: {
                s = 1;
                nArray[0] = 524304;
            }
            case 2326599: 
            case 2359368: 
            case 2392137: 
            case 2424906: 
            case 2457675: 
            case 2490444: 
            case 2523213: 
            case 2555982: 
            case 2588751: 
            case 2621520: 
            case 2654289: 
            case 2687058: 
            case 2719827: 
            case 2752596: 
            case 2785365: 
            case 2818134: 
            case 2883672: {
                int n2 = s + 1;
                nArray[s] = 557073;
                s = (short)(n2 + 1);
                nArray[n2] = 5472423;
                int n3 = s + 1;
                nArray[s] = -2135195485;
                s = (short)(n3 + 1);
                nArray[n3] = -2134998876;
                int n4 = s + 1;
                nArray[s] = 65538;
                n = n4 + 1;
                nArray[n4] = 2850903;
                s = (short)(n + 1);
                nArray[n] = 458766;
                break;
            }
            case 163845: {
                nArray[0] = 5472423;
                nArray[1] = -2134802267;
                s = (short)3;
                nArray[2] = 524304;
                break;
            }
            case 294921: {
                nArray[0] = 131076;
                nArray[1] = 5472423;
                nArray[2] = 393228;
                nArray[3] = -2134802267;
                s = (short)5;
                nArray[4] = 65538;
                break;
            }
            case 327690: {
                s = 1;
                nArray[0] = 294921;
                break;
            }
            case 196614: {
                s = 1;
                nArray[0] = 5472423;
                break;
            }
            case 491535: {
                nArray[0] = -2135195485;
                s = (short)2;
                nArray[1] = 5472423;
                break;
            }
            case 229383: {
                nArray[0] = 5472423;
                s = (short)2;
                nArray[1] = -2134802267;
                break;
            }
            case 360459: {
                nArray[0] = 5472423;
                s = (short)2;
                nArray[1] = -2134802267;
                break;
            }
            case 65538: 
            case 425997: {
                nArray[0] = -2135195485;
                nArray[1] = 5472423;
                nArray[2] = 557073;
                s = (short)4;
                nArray[3] = 458766;
                break;
            }
            case 2850903: {
                nArray[0] = 5472423;
                s = (short)2;
                nArray[1] = -2134605658;
                break;
            }
            case 5472423: {
                s = 1;
                nArray[0] = GameLibrary.GetLocalizedFontDependency$136bab();
                break;
            }
            case 2916441: {
                s = 1;
                nArray[0] = 557073;
            }
            case 2981979: 
            case 3014748: 
            case 3047517: 
            case 3080286: 
            case 3113055: {
                int n5 = s + 1;
                nArray[s] = 5472423;
                s = (short)(n5 + 1);
                nArray[n5] = -2135195485;
                int n6 = s + 1;
                nArray[s] = -2134802267;
                s = (short)(n6 + 1);
                nArray[n6] = 2850903;
                break;
            }
            case 2293830: {
                nArray[0] = 557073;
                nArray[1] = 5472423;
                nArray[2] = -2135195485;
                nArray[3] = -2134998876;
                nArray[4] = 65538;
                nArray[5] = 2850903;
                nArray[6] = 458766;
                nArray[7] = ClueUtils.GetWeaponPackageID(GameApp.Get().GetSettings().GetRandomWeapon(0));
                nArray[8] = ClueUtils.GetWeaponPackageID(GameApp.Get().GetSettings().GetRandomWeapon(1));
                nArray[9] = ClueUtils.GetWeaponPackageID(GameApp.Get().GetSettings().GetRandomWeapon(2));
                nArray[10] = ClueUtils.GetCharacterPackageID(GameApp.Get().GetSettings().GetRandomCharacter(0), 0);
                nArray[11] = ClueUtils.GetCharacterPackageID(GameApp.Get().GetSettings().GetRandomCharacter(1), 0);
                nArray[12] = ClueUtils.GetCharacterPackageID(GameApp.Get().GetSettings().GetRandomCharacter(2), 0);
                s = (short)14;
                nArray[13] = ClueUtils.GetRoomGraphicPackageID(GameApp.Get().GetSettings().mRandomRoomID);
                break;
            }
            case 3178593: {
                nArray[0] = 5472423;
                nArray[1] = -2135195485;
                nArray[2] = -2134802267;
                nArray[3] = 2850903;
                nArray[4] = -2131853131;
                nArray[5] = 1998909;
                nArray[6] = ClueUtils.GetCharacterPackageID(GameApp.Get().GetScenarioContext().mAccusations.GetSuspectId(), 1);
                nArray[7] = ClueUtils.GetWeaponPackageID(GameApp.Get().GetScenarioContext().mAccusations.GetWeaponId());
                s = (short)9;
                nArray[8] = ClueUtils.GetRoomGraphicPackageID(GameApp.Get().GetScenarioContext().mAccusations.GetRoomId());
                break;
            }
            case 2949210: {
                nArray[0] = 131076;
                nArray[1] = 5472423;
                nArray[2] = -2135195485;
                nArray[3] = -2134802267;
                nArray[4] = 2850903;
                nArray[5] = 557073;
                nArray[6] = 524304;
                s = (short)8;
                nArray[7] = 65538;
                break;
            }
            case 0x300060: {
                nArray[0] = 557073;
                nArray[1] = 5472423;
                nArray[2] = -2135195485;
                nArray[3] = -2134802267;
                nArray[4] = 2850903;
                nArray[5] = 458766;
                s = (short)7;
                nArray[6] = 65538;
                break;
            }
            case -2135195485: {
                s = 1;
                nArray[0] = -2134605658;
                break;
            }
            case -2134998876: 
            case -2134802267: {
                s = 1;
                nArray[0] = -2135195485;
                break;
            }
            case 1605681: {
                nArray[0] = 524304;
                s = (short)2;
                nArray[1] = 393228;
                break;
            }
            case 1638450: {
                nArray[0] = 1671219;
                nArray[1] = 1703988;
                nArray[2] = 1736757;
                nArray[3] = 1769526;
                nArray[4] = 1802295;
                nArray[5] = 1835064;
                nArray[6] = 1867833;
                nArray[7] = 1900602;
                s = (short)9;
                nArray[8] = 1933371;
                break;
            }
            case 786456: {
                nArray[0] = 819225;
                nArray[1] = 851994;
                nArray[2] = 884763;
                nArray[3] = 917532;
                nArray[4] = 950301;
                s = (short)6;
                nArray[5] = 983070;
                break;
            }
            case 819225: 
            case 851994: 
            case 884763: 
            case 917532: 
            case 950301: 
            case 983070: {
                s = 1;
                nArray[0] = 131076;
                break;
            }
            case 3211362: {
                s = 1;
                nArray[0] = -2141487005;
                break;
            }
            case 3276900: {
                s = 1;
                nArray[0] = -2141290395;
                break;
            }
            case 0x330066: {
                s = 1;
                nArray[0] = -2141093785;
                break;
            }
            case 3407976: {
                s = 1;
                nArray[0] = -2140897175;
                break;
            }
            case 3473514: {
                s = 1;
                nArray[0] = -2140700565;
                break;
            }
            case 3539052: {
                s = 1;
                nArray[0] = -2140503955;
                break;
            }
            case 3604590: {
                s = 1;
                nArray[0] = -2140307345;
                break;
            }
            case 3670128: {
                s = 1;
                nArray[0] = -2140110735;
                break;
            }
            case 3735666: {
                s = 1;
                nArray[0] = -2139914125;
                break;
            }
            case 3801204: {
                s = 1;
                nArray[0] = -2139717515;
                break;
            }
            case 3866742: {
                s = 1;
                nArray[0] = -2139520905;
                break;
            }
            case 3932280: {
                s = 1;
                nArray[0] = -2139324295;
                break;
            }
            case 3997818: {
                s = 1;
                nArray[0] = -2139127685;
                break;
            }
            case 4063356: {
                s = 1;
                nArray[0] = -2138931075;
                break;
            }
            case 4128894: {
                s = 1;
                nArray[0] = -2138734465;
                break;
            }
            case 0x400080: {
                s = 1;
                nArray[0] = -2138537855;
                break;
            }
            case 4259970: {
                s = 1;
                nArray[0] = -2138341245;
                break;
            }
            case 4325508: {
                s = 1;
                nArray[0] = -2138144635;
                break;
            }
            case 4391046: {
                s = 1;
                nArray[0] = -2137948025;
                break;
            }
            case 0x440088: {
                s = 1;
                nArray[0] = -2137751415;
                break;
            }
            case 4522122: {
                s = 1;
                nArray[0] = -2137554805;
                break;
            }
            case 4587660: {
                s = 1;
                nArray[0] = -2137358195;
                break;
            }
            case 4653198: {
                s = 1;
                nArray[0] = -2137161585;
                break;
            }
            case 4718736: {
                s = 1;
                nArray[0] = -2136964975;
                break;
            }
            case 4784274: {
                s = 1;
                nArray[0] = -2136768365;
                break;
            }
            case 4849812: {
                s = 1;
                nArray[0] = -2136571755;
                break;
            }
            case 4915350: {
                s = 1;
                nArray[0] = -2136375145;
                break;
            }
            case 4980888: {
                s = 1;
                nArray[0] = -2136178535;
                break;
            }
            case 5046426: {
                s = 1;
                nArray[0] = -2135981925;
                break;
            }
            case 5111964: {
                s = 1;
                nArray[0] = -2135785315;
                break;
            }
            case 5177502: {
                s = 1;
                nArray[0] = -2135588705;
                break;
            }
            case 0x5000A0: {
                s = 1;
                nArray[0] = -2135392095;
                break;
            }
            case -2141487005: {
                nArray[0] = -2134409048;
                s = (short)2;
                nArray[1] = -2134212439;
                break;
            }
            case -2141290395: {
                nArray[0] = -2134409048;
                s = (short)2;
                nArray[1] = -2134015830;
                break;
            }
            case -2141093785: 
            case -2140897175: 
            case -2140700565: {
                nArray[0] = -2134409048;
                s = (short)2;
                nArray[1] = -2133819221;
                break;
            }
            case -2140503955: 
            case -2140307345: 
            case -2140110735: {
                nArray[0] = -2134409048;
                s = (short)2;
                nArray[1] = -2133622612;
                break;
            }
            case -2139914125: 
            case -2139717515: 
            case -2139520905: {
                nArray[0] = -2134409048;
                s = (short)2;
                nArray[1] = -2133426003;
                break;
            }
            case -2139324295: 
            case -2139127685: 
            case -2138931075: {
                nArray[0] = -2134409048;
                s = (short)2;
                nArray[1] = -2133229394;
                break;
            }
            case -2138734465: 
            case -2138537855: 
            case -2138341245: {
                nArray[0] = -2134409048;
                s = (short)2;
                nArray[1] = -2133032785;
                break;
            }
            case -2138144635: 
            case -2137948025: 
            case -2137751415: {
                nArray[0] = -2134409048;
                s = (short)2;
                nArray[1] = -2132836176;
                break;
            }
            case -2137554805: 
            case -2137358195: 
            case -2137161585: {
                nArray[0] = -2134409048;
                s = (short)2;
                nArray[1] = -2132639567;
                break;
            }
            case -2136964975: 
            case -2136768365: 
            case -2136571755: {
                nArray[0] = -2134409048;
                s = (short)2;
                nArray[1] = -2132442958;
                break;
            }
            case -2136375145: 
            case -2136178535: 
            case -2135981925: {
                nArray[0] = -2134409048;
                s = (short)2;
                nArray[1] = -2132246349;
                break;
            }
            case -2135785315: 
            case -2135588705: 
            case -2135392095: {
                nArray[0] = -2134409048;
                s = (short)2;
                nArray[1] = -2132049740;
                break;
            }
            case 1081377: {
                nArray[0] = 131076;
                nArray[1] = 0x110022;
                s = (short)3;
                nArray[2] = 2031678;
                break;
            }
            case 1146915: {
                nArray[0] = 131076;
                nArray[1] = 1179684;
                s = (short)3;
                nArray[2] = 2064447;
                break;
            }
            case 1212453: {
                nArray[0] = 131076;
                nArray[1] = 1245222;
                s = (short)3;
                nArray[2] = 0x200040;
                break;
            }
            case 1277991: {
                nArray[0] = 131076;
                nArray[1] = 1310760;
                s = (short)3;
                nArray[2] = 2129985;
                break;
            }
            case 1343529: {
                nArray[0] = 131076;
                nArray[1] = 1376298;
                s = (short)3;
                nArray[2] = 2162754;
                break;
            }
            case 1409067: {
                nArray[0] = 131076;
                nArray[1] = 1441836;
                s = (short)3;
                nArray[2] = 2195523;
                break;
            }
            case 1474605: {
                nArray[0] = 131076;
                nArray[1] = 1507374;
                s = (short)3;
                nArray[2] = 0x220044;
                break;
            }
            case 1540143: {
                nArray[0] = 131076;
                nArray[1] = 1572912;
                s = (short)3;
                nArray[2] = 2261061;
            }
        }
        return s;
    }
}

