/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_GameEntity;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Viewport;

public class GE_Ticker
extends GE_GameEntity {
    public int mAcumulatedTime;
    public boolean mNeedsReposition;
    public int mStateCurrentText = 0;
    public Viewport mCurrentViewport;
    public short mCurrentPositionX;
    public Text mCurrentText;

    public final void Load() {
        super.Load();
        this.mPackage = GameLibrary.GetPackage(491535);
    }

    public final void Unload() {
        this.UnRegisterInGlobalTime();
        this.mStateCurrentText = 0;
        this.mCurrentText = null;
        super.Unload();
        GameLibrary.ReleasePackage(this.mPackage);
    }

    public void StopTicker() {
        this.UnRegisterInGlobalTime();
        this.SetTickerVisibility(false);
    }

    public final void UpdatePosition(short s) {
        this.mCurrentPositionX = s;
        this.mCurrentText.SetTopLeft(this.mCurrentPositionX, this.mCurrentText.mRect_top);
        if (this.mCurrentPositionX < -GE_Ticker.GetCaptionWidth(this.mCurrentText)) {
            this.mAcumulatedTime = 2000;
            this.mNeedsReposition = true;
        }
    }

    public final boolean IsLoaded() {
        return this.mPackage.IsLoaded();
    }

    public void SetTickerMessage(FlString flString) {
        this.mNeedsReposition = false;
        Utilities.SetCaption(this.mCurrentText, flString);
        this.mCurrentText.SetSize(GE_Ticker.GetCaptionWidth(this.mCurrentText), (short)this.mCurrentText.mFont.GetLineHeight());
        int n = GE_Ticker.GetCaptionWidth(this.mCurrentText) > this.mCurrentViewport.mRect_width ? 2 : 1;
        this.mStateCurrentText = n;
        if (this.mStateCurrentText == 2) {
            this.mAcumulatedTime = 0;
            this.RegisterInGlobalTime();
        } else {
            this.UpdatePosition((short)((this.mCurrentViewport.mRect_width - GE_Ticker.GetCaptionWidth(this.mCurrentText)) / 2));
        }
        this.SetTickerVisibility(true);
    }

    public GE_Ticker(BaseScene baseScene) {
        super(baseScene);
    }

    public final void Init(Viewport viewport) {
        super.Init(viewport);
        this.mComponentViewport.SetViewport(viewport);
        this.mAcumulatedTime = 0;
        this.mCurrentViewport.SetTopLeft((short)0, (short)(Constants.screenHeightFct() - this.mCurrentViewport.mRect_height - Constants.softkeyHeightFct()));
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        this.mCurrentViewport = this.mComponentViewport = Viewport.Cast$7c352e71(this.mPackage.mPackage.GetEntryPoint(0));
        this.mCurrentText = (Text)this.mCurrentViewport.GetChild(1);
    }

    public static short GetCaptionWidth(Text text) {
        return (short)text.mFont.GetLineWidth(text.GetCaption());
    }

    /*
     * WARNING - void declaration
     */
    public final void SetTickerVisibility(boolean bl) {
        if (bl) {
            void var1_5;
            if (GE_Ticker.GetCaptionWidth(this.mCurrentText) > this.mCurrentViewport.mRect_width) {
                int text = 2;
            } else {
                boolean bl2 = true;
            }
            this.mStateCurrentText = var1_5;
        } else {
            this.mStateCurrentText = 0;
        }
        Text text = this.mCurrentText;
        boolean bl2 = this.mStateCurrentText != 0;
        text.SetVisible(bl2);
    }

    public final void OnTime(int n, int n2) {
        super.OnTime(n, n2);
        if (this.mStateCurrentText == 2) {
            n = 2;
            this.mAcumulatedTime += n2;
            if (this.mAcumulatedTime >= 2000) {
                n2 = (short)Constants.geTickerInitialPositionFct();
                if (this.mNeedsReposition) {
                    n2 = this.mCurrentViewport.mRect_width;
                }
                n = (short)(n2 - (this.mAcumulatedTime - 2000) * this.mCurrentViewport.mRect_width / 12800);
            }
            this.UpdatePosition((short)n);
            this.mCurrentViewport.Invalidate();
        }
    }
}

