/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BaseScene;
import ca.jamdat.flight.CharacterFace;
import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.Color888;
import ca.jamdat.flight.Constants;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.GE_GameEntity;
import ca.jamdat.flight.GE_Search;
import ca.jamdat.flight.GE_Shadow;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.Palette;
import ca.jamdat.flight.Shape;
import ca.jamdat.flight.Sprite;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Viewport;

public final class GE_Room
extends GE_GameEntity {
    public short mProjectedPositionX;
    public short mPreviousSearchWidth;
    public int mBackgroundID;
    public Sprite mSpriteLeftArrow;
    public short mEndSuspectPosition;
    public short mSearchWidth;
    public int mMoveDirection;
    public CharacterFace mCharacterFace;
    public short mCurrentPositionX;
    public GE_Shadow mShadow;
    public short mSearchHeight;
    public Sprite mSpriteRightPushedArrow;
    public Sprite mSpriteLeftPushedArrow;
    public int mTimeAnimSearch;
    public short mStartSuspectPosition;
    public Viewport[] mCurrentClues = null;
    public int mSelectedClue;
    public Shape mShapeBlack;
    public short mSearchY;
    public int mRoomCurrentState;
    public MetaPackage mPackageArrows;
    public int mAnimSearchClue;
    public int mCurrentCluesNumber;
    public short mSearchX;
    public int mTimeAnimPulseSearch;
    public int mTimeCount;
    public TimeSystem mTimeRightArrow;
    public Sprite mCurrentSpriteSuspect;
    public GE_Search mSearch;
    public Sprite mSpriteRightArrow;
    public short mPreviousSearchX;
    public MetaPackage mPackageFullSuspect;
    public short mPreviousSearchY;
    public short mPreviousSearchHeight;
    public int mSuspectID;
    public TimeSystem mTimeLeftArrow;
    public Sprite mCurrentSpriteBackground;
    public BaseScene mScene;
    public Shape mBackgroundShape;

    public final void SetPassThroughTouchShields(boolean bl) {
        if (this.mRoomCurrentState == 3) {
            this.mSearch.SetPassThroughTouchShields(bl);
        }
    }

    public GE_Room(BaseScene baseScene, int n, int n2) {
        super(baseScene);
        this.mBackgroundID = n;
        this.mSuspectID = n2;
        this.mRoomCurrentState = 0;
        this.mScene = baseScene;
        this.mAnimSearchClue = -1;
        this.mMoveDirection = 0;
    }

    public final void SetState(int n) {
        if (this.mRoomCurrentState != n) {
            switch (this.mRoomCurrentState) {
                case 0: {
                    this.mComponentViewport.SetVisible(true);
                    this.mShapeBlack.SendToBack();
                    break;
                }
                case 5: {
                    this.mCharacterFace.Hide();
                }
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    this.SetShadow(false);
                    break;
                }
                case 1: {
                    this.SetArrowVisibility(false);
                }
            }
        }
        switch (n) {
            case 0: {
                this.mComponentViewport.SetVisible(false);
                this.mShapeBlack.BringToFront();
                break;
            }
            case 1: {
                this.SetArrowVisibility(true);
            }
            case 2: {
                this.mSearch.SetState(0);
                break;
            }
            case 3: {
                this.mSearch.SetState(1);
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                this.SetShadow(true);
            }
        }
        this.mRoomCurrentState = n;
    }

    public final void MoveTo(int n) {
        if (this.mCurrentSpriteBackground.mRect_width > this.mComponentViewport.mRect_width) {
            switch (n) {
                case 0: {
                    this.mMoveDirection = 0;
                    return;
                }
                case 1: {
                    this.mMoveDirection = -1;
                    return;
                }
                case 2: {
                    this.mMoveDirection = 1;
                    return;
                }
                case 4: {
                    this.mProjectedPositionX = 0;
                    return;
                }
                case 5: {
                    this.mProjectedPositionX = (short)(this.mCurrentSpriteBackground.mRect_width - this.mComponentViewport.mRect_width);
                }
            }
        }
    }

    public final boolean IsTransitionFinished() {
        return this.mProjectedPositionX == this.mCurrentPositionX;
    }

    public final void SelectClue(int n) {
        switch (n) {
            case 0: {
                ++this.mSelectedClue;
                if (this.mSelectedClue < this.mCurrentCluesNumber) break;
                this.mSelectedClue = this.mCurrentCluesNumber - 1;
                return;
            }
            case 1: {
                --this.mSelectedClue;
                if (this.mSelectedClue >= 0) break;
                this.mSelectedClue = 0;
            }
        }
    }

    public final void LoadCharacter(int n) {
        if (this.mCurrentSpriteSuspect != null) {
            this.mCurrentSpriteSuspect.SetViewport(null);
            this.mCurrentSpriteSuspect = null;
        }
        if (n < 6 && n != -1) {
            if (this.mSuspectID != n) {
                GameLibrary.ReleasePackage(this.mPackageFullSuspect);
                this.mPackageFullSuspect = GameLibrary.GetPackage(ClueUtils.GetCharacterPackageID(n, 1));
            } else {
                this.UpdateCharacter();
            }
        }
        this.mSuspectID = n;
    }

    public final void UpdateCharacter() {
        this.mCurrentSpriteSuspect = Sprite.Cast$46e644cd(this.mPackageFullSuspect.mPackage.GetEntryPoint(0));
        boolean bl = this.mRoomCurrentState == 6 || this.mRoomCurrentState == 7;
        int n = this.mRoomCurrentState == 6 ? 1 : 0;
        this.mCurrentSpriteSuspect.SetFlipX(n != 0);
        n = bl ? 2 : 1;
        byte[] byArray = Palette.Cast$2ce84be5(this.mPackageFullSuspect.mPackage.GetEntryPoint(n));
        this.mCurrentSpriteSuspect.mBitmap.SetPalette(byArray);
        this.mCurrentSpriteSuspect.SetViewport(this.mComponentViewport);
        this.ExecuteTransition();
    }

    public final boolean IsCharacterLoaded() {
        return this.mPackageFullSuspect.IsLoaded();
    }

    public final void SetCharacterVisible(boolean bl) {
        if (this.mSuspectID != 6) {
            this.mCurrentSpriteSuspect.SetVisible(bl);
        }
    }

    public final int GetSearchedItem() {
        return this.mCurrentClues[this.mSelectedClue].mSubtype - 1;
    }

    public final void SetCurrentPositionX(short s) {
        this.mCurrentPositionX = (short)Utilities.MinMaxLimit(s, 0, (short)(this.mCurrentSpriteBackground.mRect_width - this.mComponentViewport.mRect_width));
    }

    private void SetShadow(boolean bl) {
        this.mShadow.SetVisible(bl);
    }

    public final void ActiveSetVisibleShadow(boolean bl) {
        this.mShadow.ActiveSetVisible(bl);
    }

    public final void StartNoEntryAnims() {
        this.mSearch.StartNoEntryAnims();
    }

    public final void StopNoEntryAnims() {
        this.mSearch.StopNoEntryAnims();
    }

    public final void Move(int n) {
        this.mProjectedPositionX = (short)(this.mProjectedPositionX + n);
        this.Move();
    }

    private void ExecuteTransition(int n) {
        if (n <= 0) {
            n = 1;
        }
        this.mTimeCount += n;
        n = this.mTimeCount / Constants.roomLargeTransitionTimeTickFct();
        this.mTimeCount %= Constants.roomLargeTransitionTimeTickFct();
        if (this.mRoomCurrentState == 1) {
            this.mProjectedPositionX = (short)Utilities.MinMaxLimit(this.mProjectedPositionX + n * this.mMoveDirection, 0, this.GetDiffBetweenRoomSpriteAndViewport());
        }
        this.UpdateCurrentPosition(n);
        this.Move();
    }

    private void UpdateZoneSearch(int n) {
        if (this.mSearchWidth != this.mCurrentClues[this.mSelectedClue].mRect_width || this.mSearchHeight != this.mCurrentClues[this.mSelectedClue].mRect_height || this.mSearchX != this.mCurrentClues[this.mSelectedClue].mRect_left || this.mSearchY != this.mCurrentClues[this.mSelectedClue].mRect_top || this.mAnimSearchClue != this.mSelectedClue) {
            if (this.mAnimSearchClue != this.mSelectedClue) {
                this.mAnimSearchClue = this.mSelectedClue;
                this.mTimeAnimSearch = 0;
                this.mSearch.SetVisibilityDecoration(false);
                if (this.mSearchWidth == 0 && this.mSearchHeight == 0) {
                    this.mPreviousSearchWidth = 0;
                    this.mPreviousSearchHeight = 0;
                    this.mPreviousSearchX = (short)(this.mCurrentClues[this.mSelectedClue].mRect_left + (this.mCurrentClues[this.mSelectedClue].mRect_width - this.mPreviousSearchWidth) / 2);
                    this.mPreviousSearchY = (short)(this.mCurrentClues[this.mSelectedClue].mRect_top + (this.mCurrentClues[this.mSelectedClue].mRect_height - this.mPreviousSearchHeight) / 2);
                } else {
                    this.mPreviousSearchX = this.mSearchX;
                    this.mPreviousSearchY = this.mSearchY;
                    this.mPreviousSearchWidth = this.mSearchWidth;
                    this.mPreviousSearchHeight = this.mSearchHeight;
                }
            } else {
                if (this.mTimeAnimSearch + n < Constants.searchTimeToOpenFct()) {
                    this.mTimeAnimSearch += n;
                    this.mSearch.SetVisibilityDecoration(false);
                } else {
                    this.mTimeAnimSearch = Constants.searchTimeToOpenFct();
                    this.mSearch.SetVisibilityDecoration(true);
                }
                this.mSearchWidth = (short)((this.mCurrentClues[this.mSelectedClue].mRect_width - this.mPreviousSearchWidth) * this.mTimeAnimSearch / Constants.searchTimeToOpenFct() + this.mPreviousSearchWidth);
                this.mSearchHeight = (short)((this.mCurrentClues[this.mSelectedClue].mRect_height - this.mPreviousSearchHeight) * this.mTimeAnimSearch / Constants.searchTimeToOpenFct() + this.mPreviousSearchHeight);
                this.mSearchX = (short)((this.mCurrentClues[this.mSelectedClue].mRect_left - this.mPreviousSearchX) * this.mTimeAnimSearch / Constants.searchTimeToOpenFct() + this.mPreviousSearchX);
                this.mSearchY = (short)((this.mCurrentClues[this.mSelectedClue].mRect_top - this.mPreviousSearchY) * this.mTimeAnimSearch / Constants.searchTimeToOpenFct() + this.mPreviousSearchY);
            }
        }
        int n2 = 0;
        if (!this.Exist(1)) {
            n2 = 2;
        }
        if (!this.Exist(0)) {
            n2 = 1;
        }
        boolean bl = GameApp.Get().GetScenarioContext().GetCurrentRoom().GetItem((int)this.GetSearchedItem()).mSearched;
        this.mTimeAnimPulseSearch = (this.mTimeAnimPulseSearch + n) % Constants.searchTimeToPulseFct();
        if (bl) {
            this.mTimeAnimPulseSearch = 0;
        }
        n = FlMath.Absolute(Constants.searchMaxSizeToPulseFct() / 2 - this.mTimeAnimPulseSearch * Constants.searchMaxSizeToPulseFct() / Constants.searchTimeToPulseFct());
        GE_Search gE_Search = this.mSearch;
        boolean bl2 = this.mCurrentClues[this.mSelectedClue].mRect_left == this.mSearchX && this.mCurrentClues[this.mSelectedClue].mRect_top == this.mSearchY && this.mCurrentClues[this.mSelectedClue].mRect_width == this.mSearchWidth && this.mCurrentClues[this.mSelectedClue].mRect_height == this.mSearchHeight;
        gE_Search.mNoEntryVisibility = bl2;
        this.UpdateShadow((short)(this.mSearchX - this.mCurrentPositionX - n - Constants.searchMaxSizeToPulseFct()), (short)(this.mSearchY + this.mCurrentSpriteBackground.mRect_top - n - Constants.searchMaxSizeToPulseFct()), (short)(this.mSearchWidth + 2 * (Constants.searchMaxSizeToPulseFct() + n)), (short)(this.mSearchHeight + 2 * (Constants.searchMaxSizeToPulseFct() + n)));
        this.mSearch.UpdateZoom((short)(this.mSearchX - this.mCurrentPositionX - n), (short)(this.mSearchY + this.mCurrentSpriteBackground.mRect_top - n), (short)(this.mSearchWidth + 2 * n), (short)(this.mSearchHeight + 2 * n), n2, bl);
    }

    private void UpdateCurrentPosition(int n) {
        if (this.mCurrentPositionX != this.mProjectedPositionX) {
            int n2 = this.mProjectedPositionX < this.mCurrentPositionX ? -1 : 1;
            n2 = (short)n2;
            this.mCurrentPositionX = (short)(this.mCurrentPositionX + n2 * n);
            if (n2 > 0 && this.mCurrentPositionX > this.mProjectedPositionX || n2 < 0 && this.mCurrentPositionX < this.mProjectedPositionX) {
                this.mCurrentPositionX = this.mProjectedPositionX;
            }
        }
        this.mCurrentPositionX = (short)Utilities.MinMaxLimit(this.mCurrentPositionX, 0, this.GetDiffBetweenRoomSpriteAndViewport());
    }

    private void Move() {
        this.mCurrentSpriteBackground.SetTopLeft(-this.mCurrentPositionX, this.mCurrentSpriteBackground.mRect_top);
        boolean bl = this.mRoomCurrentState == 6 || this.mRoomCurrentState == 7;
        boolean bl2 = bl;
        this.mBackgroundShape.SetVisible(bl);
        if (this.mCurrentSpriteSuspect != null) {
            if (this.mRoomCurrentState == 1 || this.mRoomCurrentState == 2) {
                this.mCurrentSpriteSuspect.SetTopLeft(this.GetLeftSuspectCoord(), (short)(this.mComponentViewport.mRect_height - this.mCurrentSpriteSuspect.mRect_height));
            } else if (this.mRoomCurrentState == 6) {
                this.mCurrentSpriteSuspect.SetTopLeft((short)(this.GetFlashbackOffsetX() - this.mCurrentSpriteSuspect.mRect_width + this.GetDialogFlashBackSuspectOffsetX()), (short)(this.mComponentViewport.mRect_height - this.mCurrentSpriteSuspect.mRect_height));
            } else if (this.mRoomCurrentState == 7) {
                this.mCurrentSpriteSuspect.SetTopLeft((short)(Constants.screenWidthFct() - this.GetFlashbackOffsetX() - this.GetDialogFlashBackSuspectOffsetX()), (short)(this.mComponentViewport.mRect_height - this.mCurrentSpriteSuspect.mRect_height));
            }
            Sprite sprite = this.mCurrentSpriteSuspect;
            boolean bl3 = this.mRoomCurrentState == 1 || bl2 || this.mRoomCurrentState == 2;
            sprite.SetVisible(bl3);
            if (bl2) {
                this.UpdateBackgroundColor();
            }
        }
        if (this.MustUpdateShadow()) {
            this.UpdateSimpleShadow();
        }
        if (this.HasSuspect()) {
            this.UpdateFacePosition();
            if (this.MustShowFace()) {
                this.mCharacterFace.Show();
            } else {
                this.mCharacterFace.Hide();
            }
        }
        this.mComponentViewport.Invalidate();
    }

    private void Search(int n) {
        this.mProjectedPositionX = (short)Utilities.MinMaxLimit(this.mCurrentClues[this.mSelectedClue].mRect_left - (Constants.screenWidthFct() - this.mCurrentClues[this.mSelectedClue].mRect_width) / 2, 0, this.mCurrentSpriteBackground.mRect_width - this.mComponentViewport.mRect_width);
        this.UpdateZoneSearch(n);
        if (this.mSearch.IsNoEntryAnimsEnded()) {
            this.mSearch.StopNoEntryAnims();
        }
    }

    private int GetDiffBetweenRoomSpriteAndViewport() {
        return (short)(this.mCurrentSpriteBackground.mRect_width - this.mComponentViewport.mRect_width);
    }

    private static int GetRoomPackageID(int n) {
        int n2 = 182;
        switch (n) {
            case 1: {
                n2 = 1146915;
                break;
            }
            case 2: {
                n2 = 1212453;
                break;
            }
            case 4: {
                n2 = 1343529;
                break;
            }
            case 6: {
                n2 = 1474605;
                break;
            }
            case 0: {
                n2 = 1081377;
                break;
            }
            case 3: {
                n2 = 1277991;
                break;
            }
            case 7: {
                n2 = 1540143;
                break;
            }
            case 5: {
                n2 = 1409067;
            }
        }
        return n2;
    }

    private boolean Exist(int n) {
        switch (n) {
            case 0: {
                if (this.mSelectedClue >= this.mCurrentCluesNumber - 1) break;
                return true;
            }
            case 1: {
                if (this.mSelectedClue <= 0) break;
                return true;
            }
        }
        return false;
    }

    private short GetFlashbackOffsetX() {
        return (short)this.mPackageFullSuspect.mPackage.GetEntryPoint$487101af(4);
    }

    private void LoadArrows() {
        if (this.mPackageArrows != null) {
            this.mSpriteLeftArrow = Sprite.Cast$46e644cd(this.mPackageArrows.mPackage.GetEntryPoint(4));
            this.mSpriteRightArrow = Sprite.Cast$46e644cd(this.mPackageArrows.mPackage.GetEntryPoint(6));
            this.mSpriteLeftPushedArrow = Sprite.Cast$46e644cd(this.mPackageArrows.mPackage.GetEntryPoint(18));
            this.mSpriteRightPushedArrow = Sprite.Cast$46e644cd(this.mPackageArrows.mPackage.GetEntryPoint(19));
            this.mTimeLeftArrow = TimeSystem.Cast$3b277f7b(this.mPackageArrows.mPackage.GetEntryPoint(5));
            this.mTimeRightArrow = TimeSystem.Cast$3b277f7b(this.mPackageArrows.mPackage.GetEntryPoint(7));
        }
    }

    private void SetArrowVisibility(boolean bl) {
        boolean bl2 = bl && this.mCurrentPositionX != 0;
        if (!this.mSpriteLeftPushedArrow.mVisible) {
            this.mSpriteLeftArrow.BringToFront();
            this.mSpriteLeftArrow.SetVisible(bl2);
        } else {
            this.mSpriteLeftPushedArrow.BringToFront();
            this.mSpriteLeftPushedArrow.SetVisible(bl2);
        }
        bl2 = bl && this.mCurrentPositionX != (short)(this.mCurrentSpriteBackground.mRect_width - this.mComponentViewport.mRect_width);
        if (!this.mSpriteRightPushedArrow.mVisible) {
            this.mSpriteRightArrow.BringToFront();
            this.mSpriteRightArrow.SetVisible(bl2);
            return;
        }
        this.mSpriteRightPushedArrow.BringToFront();
        this.mSpriteRightPushedArrow.SetVisible(bl2);
    }

    private short GetLeftSuspectCoord() {
        int n = this.GetDiffBetweenRoomSpriteAndViewport();
        n = n == 0 ? (int)((short)((this.mEndSuspectPosition + this.mStartSuspectPosition) / 2 - this.mCurrentPositionX - this.mCurrentSpriteSuspect.mRect_width / 2)) : (int)(this.mEndSuspectPosition + (this.mStartSuspectPosition - this.mEndSuspectPosition) * (n - this.mCurrentPositionX) / n - this.mCurrentPositionX - this.mCurrentSpriteSuspect.mRect_width / 2);
        return (short)n;
    }

    private void LoadShadow() {
        this.mShadow.GetEntryPoints();
    }

    private void UpdateShadow(short s, short s2, short s3, short s4) {
        this.mShadow.UpdateShadow(s, s2, s3, s4);
    }

    private boolean MustUpdateShadow() {
        return this.mRoomCurrentState == 9 || this.mRoomCurrentState == 5 || this.mRoomCurrentState == 4 || this.mRoomCurrentState == 8;
    }

    private void UpdateSimpleShadow() {
        this.mShadow.UpdateSimpleShadow();
    }

    private void UpdateFacePosition() {
        Viewport viewport = this.mCharacterFace.mFaceViewport;
        short s = (short)(this.mComponentViewport.mRect_width - Constants.dialogFaceSuspectMaxWidthFct() + Constants.dialogFaceSuspectOffsetXFct());
        int n = this.mCurrentSpriteBackground.mRect_top + this.mComponentViewport.mRect_height - Constants.roomLargePositionYFromTheBottomFct() / 2;
        short s2 = viewport.mRect_height;
        viewport.SetTopLeft(s, (short)(n - s2 + Constants.dialogFaceSuspectOffsetYFct()));
    }

    private boolean MustShowFace() {
        return this.mRoomCurrentState == 5 || this.mRoomCurrentState == 8;
    }

    private boolean HasSuspect() {
        return this.mSuspectID < 6 && this.mSuspectID != -1;
    }

    private int GetDialogFlashBackSuspectOffsetX() {
        if (this.mSuspectID == 5) {
            return Constants.dialogFlashBackSuspectPlumOffsetXFct();
        }
        return Constants.dialogFlashBackSuspectOffsetXFct();
    }

    private void UpdateBackgroundColor() {
        short[] sArray = Color888.Cast$4e210a13(this.mPackage.mPackage.GetEntryPoint(6));
        this.mBackgroundShape.SetColor(sArray);
    }

    private void ExecuteTransition() {
        this.ExecuteTransition(0);
    }

    public final void Load() {
        super.Load();
        this.mPackage = GameLibrary.GetPackage(GE_Room.GetRoomPackageID(this.mBackgroundID));
        if (this.HasSuspect()) {
            this.mPackageFullSuspect = GameLibrary.GetPackage(ClueUtils.GetCharacterPackageID(this.mSuspectID, 1));
            this.mCharacterFace = new CharacterFace(this.mSuspectID);
            this.mCharacterFace.Load();
        }
        this.mPackageArrows = GameLibrary.GetPackage(524304);
        this.mSearch = new GE_Search(this.mScene);
        this.mSearch.Load();
        this.mShadow = new GE_Shadow(this.mScene);
        this.mShadow.Load();
    }

    public final void Unload() {
        Utilities.StopTimeSystem(this.mTimeRightArrow);
        Utilities.StopTimeSystem(this.mTimeLeftArrow);
        if (this.mShapeBlack != null) {
            this.mShapeBlack.SetViewport(null);
            this.mShapeBlack = null;
        }
        if (this.mSpriteLeftArrow != null) {
            this.mSpriteLeftArrow.SetViewport(null);
            this.mSpriteLeftArrow = null;
        }
        if (this.mSpriteRightArrow != null) {
            this.mSpriteRightArrow.SetViewport(null);
            this.mSpriteRightArrow = null;
        }
        if (this.mSpriteLeftPushedArrow != null) {
            this.mSpriteLeftPushedArrow.SetViewport(null);
            this.mSpriteLeftPushedArrow = null;
        }
        if (this.mSpriteRightPushedArrow != null) {
            this.mSpriteRightPushedArrow.SetViewport(null);
            this.mSpriteRightPushedArrow = null;
        }
        if (this.mCharacterFace != null) {
            this.mCharacterFace.Unload();
            this.mCharacterFace = null;
        }
        this.UnRegisterInGlobalTime();
        this.mShadow.Unload();
        this.mShadow = null;
        this.mSearch.Unload();
        this.mSearch = null;
        if (this.mCurrentSpriteSuspect != null) {
            this.mCurrentSpriteSuspect.SetViewport(null);
            this.mCurrentSpriteSuspect = null;
        }
        if (this.mPackageFullSuspect != null) {
            GameLibrary.ReleasePackage(this.mPackageFullSuspect);
        }
        this.mCurrentClues = null;
        super.Unload();
        GameLibrary.ReleasePackage(this.mPackageArrows);
        GameLibrary.ReleasePackage(this.mPackage);
    }

    public final boolean IsLoaded() {
        return this.mPackage.IsLoaded() && this.mSearch.IsLoaded() && this.mShadow.IsLoaded();
    }

    public final boolean OnPenUp(byte by, short[] sArray) {
        by = 0;
        if (this.mSearch.Contains(sArray)) {
            this.mBaseScene.OnCommand(Constants.cmdSearchObjectFct());
        } else if (ClueUtils.Contains(this.mSpriteLeftArrow, sArray) || ClueUtils.Contains(this.mSpriteRightArrow, sArray)) {
            this.MoveTo(0);
            this.mSpriteLeftArrow.SetVisible(true);
            this.mSpriteRightArrow.SetVisible(true);
            this.mSpriteLeftPushedArrow.SetVisible(false);
            this.mSpriteRightPushedArrow.SetVisible(false);
            by = 1;
        }
        return by != 0;
    }

    public final boolean OnPenDown(byte by, short[] sArray) {
        by = 0;
        if (ClueUtils.Contains(this.mSpriteLeftArrow, sArray)) {
            this.MoveTo(1);
            if (this.mSpriteLeftArrow.mVisible) {
                this.mSpriteLeftArrow.SetVisible(false);
                this.mSpriteLeftPushedArrow.SetVisible(true);
            }
            by = 1;
        } else if (ClueUtils.Contains(this.mSpriteRightArrow, sArray)) {
            this.MoveTo(2);
            if (this.mSpriteRightArrow.mVisible) {
                this.mSpriteRightArrow.SetVisible(false);
                this.mSpriteRightPushedArrow.SetVisible(true);
            }
            by = 1;
        }
        return by != 0;
    }

    public final void OnTime(int n, int n2) {
        super.OnTime(n, n2);
        if (this.mRoomCurrentState == 3) {
            this.Search(n2);
        }
        if (this.mRoomCurrentState != 0) {
            this.ExecuteTransition(n2);
        }
        n2 = this.mRoomCurrentState == 1 ? 1 : 0;
        this.SetArrowVisibility(n2 != 0);
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        this.mComponentViewport = Viewport.Cast$7c352e71(this.mPackage.mPackage.GetEntryPoint(1));
        this.mCurrentSpriteBackground = Sprite.Cast$46e644cd(this.mPackage.mPackage.GetEntryPoint(2));
        this.mBackgroundShape = Shape.Cast$2392dbe5(this.mPackage.mPackage.GetEntryPoint(3));
        this.mStartSuspectPosition = (short)(this.mPackage.mPackage.GetEntryPoint$487101af(4) * this.mCurrentSpriteBackground.mRect_width / 100);
        this.mEndSuspectPosition = (short)(this.mPackage.mPackage.GetEntryPoint$487101af(5) * this.mCurrentSpriteBackground.mRect_width / 100);
        this.LoadShadow();
        this.mCurrentCluesNumber = this.mPackage.mPackage.GetEntryPoint$487101af(7);
        this.mCurrentClues = new Viewport[this.mCurrentCluesNumber];
        for (int i = 0; i < this.mCurrentCluesNumber; ++i) {
            this.mCurrentClues[i] = Viewport.Cast$7c352e71(this.mPackage.mPackage.GetEntryPoint(8 + i));
        }
        if (this.HasSuspect()) {
            this.mCharacterFace.GetEntryPoints();
        }
        if (this.mPackageFullSuspect != null) {
            this.UpdateCharacter();
        }
        this.LoadArrows();
        this.mSearch.GetEntryPoints();
    }

    public final void Init(Viewport viewport) {
        super.Init(viewport);
        this.mShapeBlack = new Shape();
        this.mShapeBlack.SetTopLeft((short)0, this.mComponentViewport.mRect_top);
        this.mShapeBlack.SetSize((short)Constants.screenWidthFct(), this.mComponentViewport.mRect_height);
        this.mShapeBlack.SetViewport(viewport);
        this.mShapeBlack.SetVisible(true);
        this.mProjectedPositionX = (short)(this.mCurrentSpriteBackground.mRect_width - this.mComponentViewport.mRect_width);
        this.mCurrentPositionX = 0;
        if (this.mCurrentSpriteSuspect != null) {
            short s = (short)(this.mStartSuspectPosition + this.mCurrentSpriteSuspect.mRect_width / 2);
            if (this.mCurrentSpriteBackground.mRect_width <= this.mComponentViewport.mRect_width) {
                s = (short)((this.mStartSuspectPosition + this.mEndSuspectPosition) / 2 + this.mCurrentSpriteSuspect.mRect_width / 2);
            }
            this.mCurrentSpriteSuspect.SetTopLeft(s, (short)(this.mComponentViewport.mRect_height - this.mCurrentSpriteSuspect.mRect_height));
        }
        if (this.HasSuspect()) {
            this.mCharacterFace.Init(this.mComponentViewport);
            this.UpdateFacePosition();
        }
        this.RegisterInGlobalTime();
        this.mSpriteLeftArrow.SetViewport(this.mComponentViewport);
        this.mSpriteLeftArrow.SetTopLeft((short)Constants.roomLargeArrowsOffsetXFct(), (short)(this.mCurrentSpriteBackground.mRect_height - (this.mSpriteLeftArrow.mRect_height - Constants.roomLargePositionYFromTheBottomFct() + Constants.roomLargeArrowsOffsetYFct())));
        this.mSpriteRightArrow.SetViewport(this.mComponentViewport);
        this.mSpriteRightArrow.SetTopLeft((short)(this.mComponentViewport.mRect_width - this.mSpriteRightArrow.mRect_width - Constants.roomLargeArrowsOffsetXFct()), (short)(this.mCurrentSpriteBackground.mRect_height - (this.mSpriteRightArrow.mRect_height - Constants.roomLargePositionYFromTheBottomFct() + Constants.roomLargeArrowsOffsetYFct())));
        this.mSpriteLeftPushedArrow.SetViewport(this.mComponentViewport);
        this.mSpriteLeftPushedArrow.SetVisible(false);
        this.mSpriteLeftPushedArrow.SetTopLeft((short)Constants.roomLargeArrowsOffsetXFct(), (short)(this.mCurrentSpriteBackground.mRect_height - (this.mSpriteLeftPushedArrow.mRect_height - Constants.roomLargePositionYFromTheBottomFct() + Constants.roomLargeArrowsOffsetYFct())));
        this.mSpriteRightPushedArrow.SetViewport(this.mComponentViewport);
        this.mSpriteRightPushedArrow.SetVisible(false);
        this.mSpriteRightPushedArrow.SetTopLeft((short)(this.mComponentViewport.mRect_width - this.mSpriteRightPushedArrow.mRect_width - Constants.roomLargeArrowsOffsetXFct()), (short)(this.mCurrentSpriteBackground.mRect_height - (this.mSpriteRightPushedArrow.mRect_height - Constants.roomLargePositionYFromTheBottomFct() + Constants.roomLargeArrowsOffsetYFct())));
        Utilities.StartTimeSystem(this.mTimeRightArrow);
        Utilities.StartTimeSystem(this.mTimeLeftArrow);
        this.mSearch.Init(this.mComponentViewport);
        this.mShadow.Init(this.mComponentViewport, 1);
    }
}

