/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ClueUtils;
import ca.jamdat.flight.Color888;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.FileComponent;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.GE_CharactersIcons;
import ca.jamdat.flight.GameApp;
import ca.jamdat.flight.GameLibrary;
import ca.jamdat.flight.MetaPackage;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Palette;
import ca.jamdat.flight.Scrollbar;
import ca.jamdat.flight.Scroller;
import ca.jamdat.flight.Selector;
import ca.jamdat.flight.Shape;
import ca.jamdat.flight.Sprite;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.ToolScene;
import ca.jamdat.flight.Utilities;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public final class FileScene
extends ToolScene {
    public int mScenarioSuspectCount = 6;
    public Scroller mScroller;
    public TimeSystem mFilesTimeSystem;
    public GE_CharactersIcons mCharactersIcons;
    public MetaPackage[] mPackageFullSuspect = null;
    public Selector mHorizontalSelector;
    public int mCurrentlySelectedSuspect = -1;
    public Sprite[] mSpriteGeneralInfoSuspect = null;
    public Text[] mFileClues = null;
    public Scrollbar mScrollbar;
    public Sprite[] mSpriteFullSuspect = null;
    public FileComponent[] mFileComponents = null;
    public int mCluesCount;

    private void UpdateCluesCount(int n) {
        if (GameApp.Get().GetScenarioContext().IsSuspectExist(n) || n == 7) {
            this.mCluesCount = GameApp.Get().GetScenarioContext().mClueInfo.GetClues((int)n).mSize;
        }
    }

    public FileScene() {
        super(31, 2949210);
        this.AddType(4);
        GameApp.Get().GetScenarioContext().OnEvent(11);
    }

    private void ResetScenarioSuspectCount() {
        int n;
        for (int i = 0; i < 6; ++i) {
            n = GameApp.Get().GetScenarioContext().IsSuspectExist(i) ? 1 : 0;
            if (n != 0) {
                ++this.mScenarioSuspectCount;
            }
            this.mHorizontalSelector.GetSelectionAt(i).SetEnabledState(n != 0);
        }
        n = GameApp.Get().GetScenarioContext().mCurrentNoteIndex;
        if (n == -1) {
            n = this.mHorizontalSelector.mNumElements - 1;
        }
        this.mHorizontalSelector.SetSingleSelection(n);
    }

    private void DeallocateFileComponent(int n) {
        this.mFileComponents[n].SetViewport(null);
        this.mFileComponents[n].Unload();
        this.mFileComponents[n] = null;
        this.mFileClues[n].SetViewport(null);
        this.mFileClues[n] = null;
    }

    private void UpdateTextFonts(Text text) {
        FlFont[] flFontArray = new FlFont[]{FlFont.Cast$be01453(this.mMetaPackage.mPackage.GetEntryPoint(32)), FlFont.Cast$be01453(this.mMetaPackage.mPackage.GetEntryPoint(33))};
        text.SetMultipleFonts(flFontArray, (short)2);
    }

    private FlString GetClueString(int n, int n2) {
        FlString flString;
        if (this.mCluesCount == 0) {
            FlString flString2;
            n2 = n == 7 ? 36 : 35;
            flString = flString2 = new FlString(FlString.Cast$50263e8f(this.mMetaPackage.mPackage.GetEntryPoint(n2)));
            ClueUtils.ReplaceAllSuspectIDInString(flString2, n);
        } else {
            FlString flString3;
            flString = flString3 = new FlString(GameApp.Get().GetScenarioContext().mClueInfo.GetClues(n).GetString(this.mCluesCount - n2 - 1));
            ClueUtils.ReplaceClueGiverInString(flString3, n);
            if (n != 7) {
                GameApp.Get().GetScenarioContext().GetSuspect(n).Replace(flString3);
            }
        }
        return flString;
    }

    private void SetGeneralInfoCharacterVisible(boolean bl) {
        for (int i = 0; i < 6; ++i) {
            Sprite sprite = this.mSpriteGeneralInfoSuspect[i];
            boolean bl2 = bl && GameApp.Get().GetScenarioContext().IsSuspectExist(i);
            sprite.SetVisible(bl2);
        }
    }

    public final void Load() {
        int n;
        super.Load();
        this.mCharactersIcons = new GE_CharactersIcons(this);
        this.mCharactersIcons.Load();
        this.mCurrentlySelectedSuspect = -1;
        this.mSpriteFullSuspect = new Sprite[6];
        for (n = 0; n < this.mSpriteFullSuspect.length; ++n) {
            this.mSpriteFullSuspect[n] = null;
        }
        this.mPackageFullSuspect = new MetaPackage[6];
        for (n = 0; n < this.mPackageFullSuspect.length; ++n) {
            this.mPackageFullSuspect[n] = null;
        }
        this.mSpriteGeneralInfoSuspect = new Sprite[6];
        for (n = 0; n < this.mSpriteGeneralInfoSuspect.length; ++n) {
            this.mSpriteGeneralInfoSuspect[n] = null;
        }
        for (n = 0; n < 6; ++n) {
            this.mPackageFullSuspect[n] = GameLibrary.GetPackage(ClueUtils.GetCharacterPackageID(n, 1));
        }
    }

    public final void Unload() {
        this.mCharactersIcons.Unload();
        this.mCharactersIcons = null;
        Utilities.StopTimeSystem(this.mFilesTimeSystem);
        for (int i = 0; i < 6; ++i) {
            if (this.mSpriteFullSuspect[i] != null) {
                this.mSpriteFullSuspect[i].SetViewport(null);
            }
            if (this.mSpriteGeneralInfoSuspect[i] != null) {
                this.mSpriteGeneralInfoSuspect[i].SetViewport(null);
                this.mSpriteGeneralInfoSuspect[i] = null;
            }
            GameLibrary.ReleasePackage(this.mPackageFullSuspect[i]);
        }
        this.mSpriteFullSuspect = null;
        this.mPackageFullSuspect = null;
        this.mSpriteGeneralInfoSuspect = null;
        this.DeallocateAllFileComponents();
        this.mScrollbar = null;
        super.Unload();
    }

    public final boolean IsLoaded() {
        boolean bl = true;
        for (int i = 0; bl && i < 6; bl &= this.mPackageFullSuspect[i].IsLoaded(), ++i) {
        }
        return bl && super.IsLoaded() && this.mCharactersIcons.IsLoaded();
    }

    public final void SetDefaultSoftkeys() {
        this.UpdateSoftkeys(4, 0, 1, -60);
    }

    public final boolean OnMsg(Component component, int n, int n2) {
        boolean bl = false;
        if (!this.mDialogBox.mIsActive) {
            this.mScroller.OnDefaultMsg(component, n, n2);
            if (n == -105) {
                if (component == this.mHorizontalSelector) {
                    this.UpdateCharacterFace();
                    this.UpdateCharacterClues(this.mHorizontalSelector.mCurrentSelectionIndex);
                    this.mScroller.ResetScroller();
                    this.UpdateTicker();
                    GameApp.Get().GetScenarioContext().mCurrentNoteIndex = (byte)this.mHorizontalSelector.mCurrentSelectionIndex;
                }
                this.mScrollbar.UpdateKnobPosition();
                bl = true;
            }
        }
        return bl || super.OnMsg(component, n, n2);
    }

    public final void OnHideNotification() {
        super.OnHideNotification();
        this.SetSelectionsPassThrough(false);
    }

    public final boolean OnPenMove(byte by, short[] sArray, short[] sArray2) {
        return ClueUtils.ScrollOnDrag(this.mScroller, this.mScroller.GetChild(0), sArray, sArray2) || super.OnPenMove(by, sArray, sArray2);
    }

    private void SetSelectionsPassThrough(boolean bl) {
        this.mHorizontalSelector.mPreviousArrow.mPassThrough = bl;
        this.mHorizontalSelector.mNextArrow.mPassThrough = bl;
        int n = this.mHorizontalSelector.GetNumSelections();
        for (int i = 0; i < n; ++i) {
            this.mHorizontalSelector.GetSelectionAt((int)i).mPassThrough = bl;
        }
    }

    public final void Initialize() {
        super.Initialize();
        this.mNavTab.Init(this.mViewport, 1);
        this.mTicker.Init(this.mViewport);
        this.ResetScenarioSuspectCount();
        this.UpdateCharacterFace();
        this.UpdateTicker();
        this.mScrollbar.SetScroller(this.mScroller);
        this.UpdateCharacterClues(this.mHorizontalSelector.mCurrentSelectionIndex);
        Viewport viewport = Viewport.Cast$7c352e71(this.mPackage.GetEntryPoint(20));
        this.mViewport.BringComponentToFront(viewport);
        Utilities.StartTimeSystem(this.mFilesTimeSystem);
        this.mDialogBox.Init(this.mViewport);
    }

    public final void GetEntryPoints() {
        super.GetEntryPoints();
        Viewport viewport = Viewport.Cast$7c352e71(this.mPackage.GetEntryPoint(21));
        this.mCharactersIcons.GetEntryPoints();
        for (int i = 0; i < 6; ++i) {
            Package package_ = this.mPackageFullSuspect[i].mPackage;
            Object object = this.mSpriteFullSuspect;
            Object object2 = Sprite.Cast$46e644cd(package_.GetEntryPoint(0));
            object[i] = object2;
            object2 = Palette.Cast$2ce84be5(package_.GetEntryPoint(2));
            this.mSpriteFullSuspect[i].mBitmap.SetPalette((byte[])object2);
            this.mSpriteFullSuspect[i].SetViewport(viewport);
            this.mSpriteFullSuspect[i].SetTopLeft((short)((viewport.mRect_width - this.mSpriteFullSuspect[i].mRect_width) / 2), (short)0);
            this.mSpriteFullSuspect[i].SetVisible(false);
            object = Viewport.Cast$7c352e71(this.mPackage.GetEntryPoint(14 + i));
            this.mSpriteGeneralInfoSuspect[i] = new Sprite();
            this.mSpriteGeneralInfoSuspect[i].SetBitmap(this.mCharactersIcons.GetCharacterBitmap(i, 0));
            this.mSpriteGeneralInfoSuspect[i].SetViewport((Viewport)object);
            Utilities.PositionComponentInParent(this.mSpriteGeneralInfoSuspect[i], 7);
        }
        this.mHorizontalSelector = Selector.Cast$10974a41(this.mPackage.GetEntryPoint(3));
        this.mScroller = Scroller.Cast$53993db7(this.mPackage.GetEntryPoint(4));
        this.mFilesTimeSystem = TimeSystem.Cast$3b277f7b(this.mPackage.GetEntryPoint(6));
        this.mScrollbar = new Scrollbar((Viewport)this.mScroller.GetChild(2));
        this.mScrollbar.GetEntryPoints();
    }

    public final void ReceiveFocus() {
        super.ReceiveFocus();
        if (!this.mDialogBox.mIsActive) {
            this.SetComponentFocus();
        }
    }

    public final void SetComponentFocus() {
        this.mHorizontalSelector.TakeFocus();
    }

    private void UpdateTicker() {
        int n = this.mHorizontalSelector.mCurrentSelectionIndex;
        this.mTicker.StopTicker();
        if (!this.mDialogBox.mIsActive) {
            if (this.mHorizontalSelector.GetSelectionAt((int)n).mSubtype != 7) {
                FlString flString = new FlString(FlString.Cast$50263e8f(this.mPackage.GetEntryPoint(30)));
                ClueUtils.ReplaceAllSuspectIDInString(flString, n);
                this.mTicker.SetTickerMessage(flString);
            } else {
                FlString flString = new FlString(FlString.Cast$50263e8f(this.mPackage.GetEntryPoint(31)));
                this.mTicker.SetTickerMessage(flString);
            }
            this.Refresh();
        }
    }

    public final void OnShowNotification() {
        super.OnShowNotification();
        this.SetSelectionsPassThrough(true);
    }

    private void DeallocateAllFileComponents() {
        if (this.mFileComponents != null) {
            int n = this.mCluesCount == 0 ? 1 : this.mCluesCount;
            int n2 = n;
            for (n = 0; n < n2; ++n) {
                this.DeallocateFileComponent(n);
            }
            this.mFileComponents = null;
            this.mFileClues = null;
        }
    }

    private void UpdateCharacterClues(int n) {
        this.DeallocateAllFileComponents();
        if (this.mHorizontalSelector.GetSelectionAt((int)n).mSubtype == 7) {
            n = 7;
        }
        this.UpdateCluesCount(n);
        boolean bl = false;
        short s = 0;
        Viewport viewport = (Viewport)this.mScroller.GetChild(0);
        Text text = Text.Cast$21bacd23(this.mMetaPackage.mPackage.GetEntryPoint(5));
        int n2 = this.mCluesCount == 0 ? 1 : this.mCluesCount;
        int n3 = n2;
        this.mScroller.SetMaxNumElements(n2);
        this.mScroller.mNumElements = n2;
        this.mFileComponents = new FileComponent[n2];
        for (n2 = 0; n2 < this.mFileComponents.length; ++n2) {
            this.mFileComponents[n2] = null;
        }
        this.mFileClues = new Text[n3];
        for (n2 = 0; n2 < this.mFileClues.length; ++n2) {
            this.mFileClues[n2] = null;
        }
        for (int i = 0; i < n3; ++i) {
            Object object = this.GetClueString(n, i);
            Text text2 = new Text();
            this.UpdateTextFonts(text2);
            text2.SetSize(Vector2_short.GetX_(text.GetSize()), Vector2_short.GetY_(text.GetSize()));
            text2.SetMultiline(true);
            text2.SetCaption((FlString)object);
            this.mScroller.SetElementAt(i, text2);
            this.mFileClues[i] = text2;
            this.mFileComponents[i] = object = new FileComponent(text2.mLineCount, s, bl);
            ((FileComponent)object).Load();
            ((FileComponent)object).Initialize();
            ((Component)object).SetTopLeft((short)0, s);
            ((Component)object).SetViewport(viewport);
            text2.SetViewport(viewport);
            text2.SetTopLeft(((FileComponent)object).getXOffsetForText(), s);
            boolean bl2 = !bl;
            bl = bl2;
            s = (short)(s + ((Component)object).mRect_height);
        }
        this.mScroller.UpdateScroller();
        this.mScrollbar.UpdateBar();
    }

    private void UpdateCharacterFace() {
        int n = this.mHorizontalSelector.mCurrentSelectionIndex;
        if (n != this.mCurrentlySelectedSuspect) {
            if (this.mCurrentlySelectedSuspect != -1 && this.mCurrentlySelectedSuspect != 6) {
                this.mSpriteFullSuspect[this.mCurrentlySelectedSuspect].SetVisible(false);
            }
            this.mCurrentlySelectedSuspect = n;
            if (this.mCurrentlySelectedSuspect != 6) {
                this.mSpriteFullSuspect[this.mCurrentlySelectedSuspect].SetVisible(true);
            }
            int n2 = this.mCurrentlySelectedSuspect == 6 ? 1 : 0;
            this.SetGeneralInfoCharacterVisible(n2 != 0);
            n2 = 13;
            if (n != -1) {
                n2 = 7 + n;
            }
            short[] sArray = Color888.Cast$4e210a13(this.mPackage.GetEntryPoint(n2));
            n2 = this.mPackage.GetEntryPoint$487101af(22);
            for (n = 0; n < n2; ++n) {
                Shape.Cast$2392dbe5(this.mPackage.GetEntryPoint(23 + n)).SetColor(sArray);
            }
        }
    }
}

